/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: ligne.c,v 1.4 1995/07/24 13:42:41 pierre Exp $";

/*
 * fonctions de traitement de la ligne MODEM
 */

#include "xtel.h"
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

#ifdef NO_NETWORK
#include <sys/socket.h>
#include <sys/un.h>
#endif /* NO_NETWORK */

static XtInputId input_id;
static char erreur, compte_erreur, message_erreur[80];
static int indice_attente;
static char buf[256];

/* Pour quitter... */
void ce_n_est_qu_un_au_revoir ()
{
  if (mode_emulation != MODE_VIDEOTEX)
    zigouille_xterm_teleinfo ();

  XFlush (XtDisplay(ecran_minitel));
  printf ("Bye...\n");
  exit (0);
}

/*
 * fonction de lecture de la ligne
 */

/* ARGSUSED */
void fonction_lecture_ligne(client_data, fid, id)
XtPointer client_data;	/* non utilise */
int *fid;
XtInputId *id;
{
    unsigned char c;
    Boolean flag_connexion;
    int ret;

    XtVaGetValues (ecran_minitel, XtNconnecte, &flag_connexion, NULL);
    
    ret = read (*fid, &c, 1);
    if (ret <= 0)
	c = VALEUR_REPONSE_DECONNEXION;

	if (c < 128 && flag_connexion) {
	    if (chat_courant != NULL) {
		/* Test trigger */
		if (c == *(chat_courant->attente+indice_attente)) {
		    indice_attente++;
		    if (*(chat_courant->attente+indice_attente) == 0) {
#ifdef DEBUG
			printf ("trouve ! ==> emet %s\n",chat_courant->emission );
#endif
			write (socket_xteld, chat_courant->emission, strlen(chat_courant->emission));
			chat_courant = chat_courant->suivant;
			indice_attente = 0;
#ifdef DEBUG
			if (chat_courant)
			    printf ("attend %s\n", chat_courant->attente);
#endif
		    }
		}
	    }
	    else
		indice_attente = 0;

	    if (flag_enregistrement) {
		/*
		 * Si il ne reste plue de place dans la zone 
		 * d'enregistrement, alloue 1000 octets de +
		 */
		if (cpt_buffer && !(cpt_buffer % 1000)) {
		    taille_zone_enregistrement += 1000;
		    zone_enregistrement = realloc (zone_enregistrement, taille_zone_enregistrement);
		}

		*(zone_enregistrement+cpt_buffer) = c;
		cpt_buffer++;
	    }

	    videotexEffaceTelephone (ecran_minitel);

	    /* decodage */
	    if (mode_emulation != MODE_VIDEOTEX)
		write (fd_teleinfo, &c, 1);
	    else
		videotexDecode (ecran_minitel, c);
	} 
	else { 
	    if (erreur) {
		if (c == VALEUR_REPONSE_FIN_ERREUR) {

		    erreur = 0;

		    if (!flag_connexion) {
			/* efface le petit telephone */
			videotexEffaceTelephone (ecran_minitel);

			/* valide la composition et le lecteur */
			composition_valide (True);
			if (nom_fichier_charge[0] != 0)
			    lecteur_valide (True);

			XtVaSetValues (ecran_minitel, XtNfdConnexion, -1, NULL);
			XtRemoveInput (input_id);	
			close (socket_xteld);	    
		    }

		    affiche_erreur (message_erreur, message_erreur[compte_erreur-1]);
		}
		else
		    message_erreur[compte_erreur++] = c;
	    }
	    else {
		
		if (c == VALEUR_REPONSE_CONNEXION) {
		    XtVaSetValues (ecran_minitel, XtNconnecte, True, NULL); 
		    flag_connexion = True;
	    
		    /* valide les boutons MINITEL*/
		    clavier_minitel_valide (True);
	    
		    XFlush (XtDisplay(ecran_minitel));
		}
		else if (c == VALEUR_REPONSE_DECONNEXION) {
		    XtVaSetValues (ecran_minitel, XtNconnecte, False, NULL); 
		    flag_connexion = False;
		    chat_courant = NULL;
		    indice_attente = 0;
	    
		    /* invalide les boutons */
		    clavier_minitel_valide (False);
	    
		    /* valide la composition et le lecteur */
		    composition_valide (True);

		    if (nom_fichier_charge[0] != 0)
			lecteur_valide (True);
	    
		    XFlush (XtDisplay(ecran_minitel));

		    XtVaSetValues (ecran_minitel, XtNfdConnexion, -1, NULL);
		    XtRemoveInput (input_id);
		    close (socket_xteld);

		    if (sortie_violente)
			ce_n_est_qu_un_au_revoir ();
		}
		else if (c == VALEUR_REPONSE_DEBUT_ERREUR) {
		    erreur = 1;
		    compte_erreur = 0;
		}
	    }
	}
}

/* 
 * Connexion a un service 
 */

void connexion_service (service)
char *service;
{
    char l;
    struct passwd *pw;

#ifdef DEBUG
    printf ("connexion au service %s\n", service);
#endif

    /* affiche le petit telephone */
    videotexAfficheTelephone (ecran_minitel);

    /* invalide la composition et le lecteur */
    composition_valide (False);
    lecteur_valide (False);


    /* Ouvre la socket serveur */
#ifdef NO_NETWORK
    if ((socket_xteld = socket (AF_UNIX, SOCK_STREAM, 0))  < 0) {
	perror ("socket");
	exit (1);
    }

    if (connect (socket_xteld, (struct sockaddr *)&unaddr, sizeof(unaddr)) < 0) {
	perror ("connect");
	exit (1);
    }
#else
    if ((socket_xteld = c_clientbyname(rsc_xtel.serveur, rsc_xtel.nomService)) < 0) {
	fprintf (stderr, "Erreur de connexion au serveur XTEL...\n");
	return;
    }
#endif /* NO_NETWORK */

    /* Transmet le nom d'utilisateur */
    if ((pw = getpwuid(getuid())) == NULL) {
	perror ("getpwuid");
	return;
    }

    l = strlen (pw->pw_name);
    write (socket_xteld, &l, 1);
    write (socket_xteld, pw->pw_name, l);

    /* nouvelle entree = socket XTELD */
    XtVaSetValues (ecran_minitel, XtNfdConnexion, socket_xteld, NULL);
    input_id = XtAppAddInput(app_context, socket_xteld, (XtPointer)XtInputReadMask, (XtInputCallbackProc)fonction_lecture_ligne, NULL);

    /* commande de connexion a XTELD */
    if (!service) {
	write (socket_xteld, CHAINE_COMMANDE_CONNEXION_M1, 1);
    }
    else {
	write (socket_xteld, CHAINE_COMMANDE_DEMANDE_CONNEXION, 1);
	l = strlen (service);
	write (socket_xteld, &l, 1);
	write (socket_xteld, service, l);
    }
}



