/* $Id: usdate.cc,v 1.3 1997/03/31 23:39:41 dps Exp $ */
/* Date formatter for the UK */
#include <time.h>
#include <string.h>
#define __EXCLUDE_READER_CLASSES
#include "lib.h"

char *us_date(time_t when)
{
    static const char *months[]=
    {
	"Janurary", "Februrary", "March", "April",
	"May", "June", "July", "August",
	"September", "October", "November", "December",
    };

    struct tm *tim;
    char date_buf[200];
    const char *postfix;
    
    tim=localtime(&when);
    switch (tim->tm_mday % 10)
    {
    case 1:
	postfix="st";
	break;

    case 2:
	postfix="nd";
	break;

    case 3:
	postfix="rd";
	break;

    default:
	postfix="th";
	break;
    }

    sprintf(date_buf, "%s %d%s, %d", months[tim->tm_mon],
	    tim->tm_mday, postfix, 1900+tim->tm_year);
    
    return strdup(date_buf);
}


    
