/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Module handling routines
 */

#include "conf.h"

static xaset_t *installed_modules = NULL;
static array_header *mconfarr;			/* masterconf array */
static array_header *mcmdarr;			/* mastercmd array */

conftable *m_conftable; 			/* Master conf table */
cmdtable *m_cmdtable;				/* Master cmd table */

module *curmodule = NULL;			/* Current running module */

extern module *static_modules[];

void *call_module_cmd(module *m, char *(*func)(cmd_rec*), cmd_rec *cmd)
{
  void *res;
  module *prev_module = curmodule;

  if(!cmd->tmp_pool)
    cmd->tmp_pool = make_sub_pool(cmd->pool);

  curmodule = m;
  res = func(cmd);
  curmodule = prev_module;

  return res;
}

void *call_module(module *m, char *(*func)(cmd_rec*), cmd_rec *cmd)
{
  void *res;
  module *prev_module = curmodule;

  if(!cmd->tmp_pool)
    cmd->tmp_pool = make_sub_pool(cmd->pool);
  
  curmodule = m;
  res = func(cmd);
  curmodule = prev_module;

  /* Note that we don't clear the pool here because the function may
   * return data which resides in this pool.
   */
  return res;
}

/* Called after forking in order to inform/initialize modules
 * need to know we are a child and have a connection.
 */

int init_child_modules()
{
  module *prev_module = curmodule;
  module *m;

  for(m = (module*)installed_modules->xas_list; m; m=m->next)
    if(m && m->module_init_child) {
      curmodule = m;
      m->module_init_child();
    }
  
  curmodule = prev_module;
  return 0;
}

int init_modules()
{
  int i,numconf = 0,numcmd = 0;
  module *m;
  conftable *c,*wrk;
  cmdtable *cmd,*cmdwrk;

  installed_modules = xaset_create(permanent_pool,NULL);

  for(i = 0; static_modules[i]; i++)
  {
    m = static_modules[i];

    if(!m->module_init ||
       (m->module_init() != -1)) {
      xaset_insert(installed_modules,(xasetmember_t*)m);

      if(m->conftable)
        for(c = m->conftable; c->directive; c++)
          ++numconf;
      if(m->cmdtable)
        for(cmd = m->cmdtable; cmd->command; cmd++)
          ++numcmd;
    }
  }

  /* Allow for an empty entry */
  ++numconf;
  ++numcmd;

  /* Create an array to store the master conf dispatch table */
  mconfarr = make_array(permanent_pool,numconf,sizeof(conftable));
  mcmdarr = make_array(permanent_pool,numcmd,sizeof(cmdtable));
  
  for(m = (module*)installed_modules->xas_list; m; m=m->next) {

    for(c = m->conftable; c && c->directive; c++) {
      wrk = (conftable*)push_array(mconfarr);
      memcpy(wrk,c,sizeof(conftable));
      wrk->m = m;
    }

    for(cmd = m->cmdtable; cmd && cmd->command; cmd++) {
      cmdwrk = (cmdtable*)push_array(mcmdarr);
      memcpy(cmdwrk,cmd,sizeof(cmdtable));
      cmd->m = m;
    }

  }
 
  /* add a null entry (pcalloc zeros the memory for us) */
  push_array(mconfarr);  
  push_array(mcmdarr);

  m_conftable = (conftable*)mconfarr->elts;
  m_cmdtable = (cmdtable*)mcmdarr->elts;
  return 0;
}
