/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: sets.h,v 1.4 1997/06/05 16:57:40 flood Exp $
 */

#ifndef __SETS_H
#define __SETS_H

#include "pool.h"

typedef struct XAsetmember xasetmember_t;
typedef struct XAset xaset_t;
typedef int (*XASET_COMPARE)(xasetmember_t *v1,xasetmember_t *v2);
typedef xasetmember_t* (*XASET_MCOPY)(xasetmember_t *mem);

struct XAsetmember {
  xasetmember_t	*next,*prev;
};

struct XAset {
  xasetmember_t *xas_list;
  
  pool		*mempool;
  XASET_COMPARE xas_compare;
};

/* Prototypes */
xaset_t *xaset_create(pool *pool,XASET_COMPARE compf);
xaset_t *xaset_copy(pool *pool,xaset_t *set, size_t msize,
                    XASET_MCOPY copyf);
xaset_t *xaset_subtract(pool *pool, xaset_t *set1, xaset_t *set2, 
                        size_t msize,
                        XASET_MCOPY copyf);
xaset_t *xaset_union(pool *pool, xaset_t *set1, xaset_t *set2,
                     size_t msize,
	             XASET_MCOPY copyf);

int xaset_insert(xaset_t *set, xasetmember_t *member);
int xaset_insert_end(xaset_t *set, xasetmember_t *member);
int xaset_remove(xaset_t *set, xasetmember_t *member);
int xaset_insert_sort(xaset_t *set, xasetmember_t *member, int dupes_allowed);

#endif /* __SETS_H */
