/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: privs.h,v 1.6 1997/12/29 20:21:57 flood Exp $
 */

#ifndef __PRIVS_H
#define __PRIVS_H

/* Macros for manipulating saved, real and effective uid for easy 
 * switching from/to root
 */

/* Porters, please put the most reasonable and secure method of
 * doing this in here:
 */

#ifndef LINUX
 
/* The _default_ is to do NOTHING... Very insecure.
 */

#define PRIVS_SETUP(u,g)	session.ouid = session.uid = (int)getuid(); \
				session.gid = (int)getgid();

#define PRIVS_ROOT		; /* Nothing */
#define PRIVS_RELINQUISH	; /* Nothing */

#else /* LINUX */

/* Set the saved uid/gid by calling setregid/uid with 0,0 (non -1
 * realuid under linux forces the saveduid to be set to the current
 * euid.  We can then use this later to get root back..  Go linux!
 * Then by calling set with ruid -1, the saved doesn't get touched
 * (cuz we're just setting effective to the real)
 * Note: If we aren't running as root, we store the current uid,gid
 * and ouid (original uid).  Thus, testing ouid will tell us if it's
 * ok to try uid/gid swapping.  We also setregid(),setreuid()
 * if not running as root to prevent accidental setuid from accomplishing
 * anything useful.
 */

#define PRIVS_SETUP(u,g)	if(getuid()) { \
                                  session.ouid = session.uid = (int)getuid(); \
                                  session.gid = (int)getgid(); \
				  setregid(session.gid,session.gid); \
                                  setreuid(session.uid,session.uid); \
                                } else { \
                                  session.uid = (u); session.gid = (g); \
                                  setregid((g),0); setreuid((u),0); \
                                  setregid(-1,(g)); setreuid(-1,(u)); \
                                }


/* Switch back to root */

#define PRIVS_ROOT		if(!session.ouid) { setreuid(-1,0); setregid(-1,0); }


/* Relinquish privs granted by PRIVS_ROOT */

#define PRIVS_RELINQUISH	if(!session.ouid) { setregid(-1,session.gid); \
             			setreuid(-1,session.uid); }

#endif /* LINUX */

#endif /* __PRIVS_H */
