/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Connection streams, ring-buffers and other goodies related to 
 * non-blocking I/O 
 * $Id: io.h,v 1.4 1997/06/05 16:57:38 flood Exp $
 */

#ifndef __IO_H
#define __IO_H

#define IO_READ		0
#define IO_WRITE	1

#define IOR_REMOVE	(1 << 0)	/* Request scheduled for removal */
#define IOR_CLOSED	(1 << 1)	/* File is closed */
#define IOR_ERROR	(1 << 2)	/* Request resulted in error */
#define IOR_REMOVE_FILE (1 << 3)	/* Destroy associated file */

typedef struct IO_File IOFILE;
typedef struct IO_Request IOREQ;

struct IO_File {
  pool *pool;				/* Each one has it's own pool */
  int  fd;				/* File descriptor */
  int  mode;				/* 0 == read, 1 == write */
  int  xerrno;				/* errno if applicable */

  IOREQ *req;				/* Request buffer */
  int  bufsize;				/* Default size of request buffer */
};

/* cl_read can be used during write operations to asyncronously gather
 * data from a function.  If cl_read returns -1, an error is assumed,
 * otherwise 0 == EOF (write completed)
 */

struct IO_Request {
  IOREQ *next,*prev;

  pool *pool;

  int req_type;				/* Read or Write */
  int req_flags;			/* Request flags */
  IOFILE *file;

  char *buf;
  char *bp,*bufnext;
  int bufsize;				/* Buffer size */

  char *cl_buf,*cl_bp;			/* Client buffer, and head pointer */
  int cl_bytes;				/* Bytes remaining in client buffer */
  int (*cl_io)(IOREQ*,char*,int);	/* Client io function (for async operations) */
  void (*cl_err)(IOREQ*,int);		/* Error occured */
  void (*cl_close)(IOREQ*);		/* Remote side closed */
};

/* Prototypes */

void init_io();
IOFILE *io_open(pool*,int,int);
IOFILE *io_reopen(IOFILE*,int,int);
int io_close(IOFILE*,int);
int io_setbuf(IOFILE*,int);
void io_kill_req(IOREQ*);
IOREQ *io_post_req(IOFILE*,int,
		   int (*cl_io)(IOREQ*,char*,int),
                   void (*cl_err)(IOREQ*,int),
                   void (*cl_close)(IOREQ*));
IOREQ *io_repost_req(IOREQ*);
void io_set_req_errno(IOREQ*,int);
IOREQ *io_read_async(IOFILE*,char*,int,
                  int (*cl_io)(IOREQ*,char*,int),
                  void (*cl_err)(IOREQ*,int),
                  void (*cl_close)(IOREQ*));
IOREQ *io_write_async(IOFILE*,char*,int,
                  int (*cl_io)(IOREQ*,char*,int),
                  void (*cl_err)(IOREQ*,int),
                  void (*cl_close)(IOREQ*));
int io_write(IOFILE*,char*,int);
int io_read(IOFILE*,char*,int,int);
void io_yield(int);
int io_printf(IOFILE*,char*,...);
int io_printf_raw(IOFILE*,char*,...);
char *io_gets(char*,int,IOFILE*);

#endif /* __IO_H */
