'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) after.n 1.17 95/06/21 15:16:21
'\" 
.so man.macros
.TH after n 4.0 Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
after \- Execute a command after a time delay
.SH SYNOPSIS
\fI$widget->\fR\fBafter\fR(\fIms\fR)
.br
\fI$id\fR = \fI$widget->\fR\fBafter\fR(\fIms\fR,\fIcallback\fR)
.br
.VS
\fI$widget\fR->\fBafterCancel\fR(\fIid\fR)
.br
\fI$id\fR = \fI$widget->\fR\fBrepeat\fR(\fIms\fR,\fIcallback\fR)
.br
\fI$id\fR = \fI$widget->\fR\fBafterIdle\fR(\fIcallback\fR)
.br
\fI$id\fR->cancel\fR
.br
.VE
.BE

.SH DESCRIPTION
.PP
These methods are used to delay execution of the program or to execute
a callback in background after a delay.  
Specifying \fI$widget\fP as above is necessary as core Tk associates
the pending actions with a \fbMainWindow\fP and perl/Tk can support 
multiple \fbMainWindow\fPs. 
.PP
As of Tk-b10 after is implemented as a perl layer on the core Tk::after
mechanism. The returned \fI$id\fP is now a perl object. This object 
is associated with \fI$widget\fR and is automatically cancelled when 
\fI$widget\fR is destroyed.
.PP
The methods take the following forms:
.TP
\fI$widget->\fR\fBafter\fR(\fIms\fR)
\fIMs\fR must be an integer giving a time in milliseconds.
The command sleeps for \fIms\fR milliseconds and then returns.
While the command is sleeping the application does not respond to
X events or any other events.
.TP
\fI$id\fR = \fI$widget->\fR\fBafter\fR(\fIms\fR,\fIcallback\fR)
In this form the command returns immediately, but it arranges
for \fIcallback\fP be executed \fIms\fR milliseconds later as a
background event handler.
If an error occurs while executing the delayed command then the
\fBTk::Error\fR mechanism is used to report the error.
The \fBafter\fR command returns an identifier that can be used
to cancel the delayed command using \fBafterCancel\fR.
.TP
\fI$id\fR = \fI$widget->\fR\fBrepeat\fR(\fIms\fR,\fIcallback\fR)
This form is new as of Tk-b10 and is implemented in the 
perl wrapper on the core Tk::after command.
The callback is executed \fIms\fR milliseconds later,
and then repeats every \fIms\fR milliseconds until cancelled.
If an error occurs while executing the delayed command then the
\fBTk::Error\fR mechanism is used to report the error.
The \fBrepeat\fR command returns an identifier that can be used
to cancel the delayed command using \fBafterCancel\fR.
.TP
\fI$widget->\fR\fBafterCancel\fR(\fIid\fR)
.VS
Cancels the execution of a delayed command that
was previously scheduled.
\fIId\fR indicates which command should be canceled;  it must have
been the return value from a previous \fBafter\fR command.
If the command given by \fIid\fR has already been executed then
the \fBafterCancel\fR command has no effect.
.TP
\fI$id\fR->\fBcancel\fR
A method of the underlying class used to implement the wrapper.
While the class design is subject to change this method is likely
to remain. Behaviour is as for afterCancel.

.TP
\fI$id\fR = \fI$widget->\fR\fBafterIdle\fR(\fcallback\fR)
Arranges for \fIcallback\fP evaluated later as an idle handler
(the script runs the next time the Tk event loop is entered
and there are no events to process).
The command returns an identifier that can be used
to cancel the delayed command using \fBafterCancel\fR.
If an error occurs while executing the script then the
\fBTk::Error\fR mechanism is used to report the error.
.VE
.SH "SEE ALSO"
Tk::Error
callbacks

.SH KEYWORDS
cancel, delay, sleep, time
