#!@PERL@
####
# The configuration file for the DBI/DBD tests on different databases ....
# You will need the DBD module for the database you are running.
# Monty made this bench script and I (Luuk de Boer) rewrote it to DBI/DBD.
# Monty rewrote this again to use packages.
#
# Each database has a different package that has 3 functions:
# new		Creates a object with some standard slot
# version	Version number of the server
# create	Generates commands to create a table
#

#
# First some global functions that help use the packages:
#

sub get_server
{
  my ($name)=@_;
  return new db_MySQL if ($name =~ /mysql/i);
  return new db_Pg if ($name =~ /pg/i);
  return new db_mSQL if ($name =~ /msql/i);
  return new db_Solid if ($name =~ /solid/i);
  return new db_Empress if ($name =~ /Empress/i);
  return new db_Oracle if ($name =~ /Oracle/i);
  die "Unknown sql server name used: $name\nUse one of: mSQL, MySQL, Pg, Solid, or Oracle";
}


#############################################################################
#	     First the configuration for MySQL off course :-)
#############################################################################

package db_MySQL;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "mysql";
  $self->{'data_source'}	= "DBI:mysql:$main::opt_database";
  $self->{'limits'}		= \%limits;
  $self->{'tpcd'}		= \%tpcd;
  $self->{'blob'}		= "blob";
  $self->{'double_quotes'}	= 1; # Can handle:  'Walker''s'

  $limits{'max_conditions'}	= 9999; # (Actually not a limit)
  $limits{'max_columns'}	= 2000;	# Max number of columns in table
  $limits{'max_text_size'}	= 65000; # Max size with default buffers.
  $limits{'query_size'}		= 65525; # Max size with default buffers.
  $limits{'max_index'}		= 16; # Max number of keys
  $limits{'max_index_parts'}	= 16; # Max segments/key
  $limits{'max_column_name'}	= 32; # max table and column name

  $limits{'join_optimizer'}	= 1; # Can optimize FROM tables
  $limits{'load_data_infile'}	= 1; # Has load data infile
  $limits{'lock_tables'}	= 1; # Has lock tables
  $limits{'functions'}		= 1; # Has simple functions (+/-)
  $limits{'group_functions'}	= 1; # Have group functions
  $limits{'select_without_from'}= 1; # Can do 'select 1';
  $limits{'multi_drop'}		= 1; # Drop table can take many tables
  $limits{'subqueries'}		= 0; # Doesn't support sub-queries.
  $limits{'left_outer_join'}	= 1; # Doesn't support left outer joins
  $limits{'table_wildcard'}	= 1; # Has SELECT table_name.*
  $limits{'having_with_alias'}  = 1; # Can use aliases in HAVING
  $limits{'having_with_group'}	= 0; # Can't use group functions in HAVING 
  $limits{'like_with_column'}	= 1; # Can use column1 LIKE column2
  $limits{'order_by_position'}  = 1; # Can use 'ORDER BY 1'

  $limits{'group_func_extra_std'}		= 1; # Have group function std().

  $limits{'func_odbc_mod'}		= 1; # Have function mod.
  $limits{'func_extra_%'}			= 1; # Has % as alias for mod()
  $limits{'func_odbc_floor'}		= 1; # Has func_odbc_floor function
  $limits{'func_extra_if'}			= 1; # Have function if.
  $limits{'column_alias'}			= 1; # Alias for fields in select statement.
  $limits{'NEG'}		= 1; # Supports -id
  $limits{'func_extra_in_num'}			= 1; # Has function in

  $tpcd{'time'}			= 1;
  $tpcd{'q1'} 	= 'b';		# with time not supp by mysql ('')
  $tpcd{'q2'} 	= 'b';
  $tpcd{'q3'} 	= 'b';		# with time ('')
  $tpcd{'q4'} 	= 'c';		# with time not supp by mysql (d)
  $tpcd{'q5'} 	= 'b';		# with time not supp by mysql ('')
  $tpcd{'q6'} 	= 'c';		# with time not supp by mysql ('')
  $tpcd{'q7'} 	= 'c';
  $tpcd{'q8'} 	= 'f';
  $tpcd{'q9'} 	= 'c';
  $tpcd{'q10'} 	= 'b';
  $tpcd{'q11'} 	= 'b';
  $tpcd{'q12'} 	= 'd';
  $tpcd{'q13'} 	= 'c';
  $tpcd{'q14'} 	= 'd';
  $tpcd{'q15'} 	= 'd';
  $tpcd{'q16'} 	= 'a';
  $tpcd{'q17'} 	= 'c';

  return $self;
}

#
# Get the version number of the database
#

sub version
{
  my ($self)=@_;
  my ($dbh,$sth,$version,@row);
 
  $dbh=DBI->connect($self->{'data_source'},$main::opt_user,$main::opt_password) || die $DBI::errstr;
  $sth = $dbh->prepare("select VERSION()") or die $DBI::errstr;
  $version="MySQL 3.20.?";
  if ($sth->execute && (@row = $sth->fetchrow_array))
  {
    $version="MySQL $row[0]";
  }
  $sth->finish;
  $dbh->disconnect;
  return $version;
}

#
# Returns a list of statements to create a table
# The field types are in ANSI SQL format.
#
# If one uses $main::opt_fast then one is allowed to use
# non standard types to get better speed.
#

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    $field =~ s/ decimal/ double(10,2)/i;
    $field =~ s/ big_decimal/ double(10,2)/i;
    $field =~ s/ date/ int/i;		# Because of tcp ?
    $query.= $field . ',';
  }
  foreach $index (@$index)
  {
    $query.= $index . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  return @queries;
}

sub insert_file {
  my ($self,$dbname, $file, $dbh) = @_;
  my ($command, $sth);
  
  $command = "load data infile '$file' into table $dbname columns optionally enclosed by '\\'' terminated by ','";
#  print "$command\n";
  $sth = $dbh->do($command) or die $DBI::errstr;
  return $sth;			# Contains number of rows
}

#
# Do any conversions to the ANSI SQL query so that the database can handle it
#

sub query {
  my($self,$sql) = @_;
  return $sql;
}

#
# Abort if the server has crashed
# return: 0 if ok
#	  1 question should be retried
#

sub abort_if_fatal_error
{
  return 0;
}

#############################################################################
#		     Definitions for mSQL
#############################################################################

package db_mSQL;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "msql";
  $self->{'data_source'}	= "DBI:mSQL:$main::opt_database:localhost";
  $self->{'limits'}		= \%limits;
  $self->{'double_quotes'}	= 0;

  $limits{'max_conditions'}	= 74;
  $limits{'max_columns'}	= 75;
  $limits{'max_text_size'}	= 32000;
  $limits{'query_size'}		= 65535;
  $limits{'max_index'}		= 5;
  $limits{'max_index_parts'}	= 10;
  $limits{'max_column_name'} = 35;

  $limits{'join_optimizer'}	= 0;		# Can't optimize FROM tables
  $limits{'load_data_infile'}	= 0;
  $limits{'lock_tables'}	= 0;
  $limits{'functions'}		= 0;
  $limits{'group_functions'}	= 0;
  $limits{'multi_drop'}		= 0;
  $limits{'select_without_from'}= 0;
  $limits{'subqueries'}		= 0;
  $limits{'left_outer_join'}	= 0;
  $limits{'table_wildcard'}	= 0;
  $limits{'having_with_alias'}  = 0;
  $limits{'having_with_group'}	= 0;
  $limits{'like_with_column'}	= 1;
  $limits{'order_by_position'}  = 1;

  $limits{'group_func_extra_std'}		= 0;

  $limits{'func_odbc_mod'}		= 0;
  $limits{'func_extra_%'}			= 0;
  $limits{'func_odbc_floor'}		= 0;
  $limits{'func_extra_if'}			= 0;
  $limits{'column_alias'}			= 0;
  $limits{'NEG'}		= 0;
  $limits{'func_extra_in_num'}			= 0;

  $self->{'blob'}		= "text(" . $limits{'max_text_size'} .")";
  return $self;
}

#
# Get the version number of the database
#

sub version
{
  my ($tmp,$dir);
  foreach $dir ("/usr/local/Hughes", "/usr/local/mSQL","/my/local/mSQL",
		"/usr/local")
  {
    if (-x "$dir/bin/msqladmin")
    {
      $tmp=`$dir/bin/msqladmin version | grep server`;
      if ($tmp =~ /^\s*(.*\w)\s*$/)
      {				# Strip pre- and endspace
	$tmp=$1;
	$tmp =~ s/\s+/ /g;	# Remove unnecessary spaces
	return $tmp;
      }
    }
  }
  return "mSQL version ???";
}

#
# Can't handle many field types, so we map everything to int and real.
#

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries,$name,$nr);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    $field =~ s/varchar/char/i;		# mSQL doesn't have VARCHAR()
    # mSQL can't handle more than the real basic int types
    $field =~ s/tinyint|smallint|mediumint|integer/int/i;
    # mSQL can't handle different visual lengths
    $field =~ s/int\(\d*\)/int/i;
    # mSQL dosen't have float, change it to real
    $field =~ s/float(\(\d*,\d*\)){0,1}/real/i;
    $field =~ s/double(\(\d*,\d*\)){0,1}/real/i;
    # mSQL doesn't have blob, it has text instead
    if ($field =~ / blob/i)
    {
      $name=$self->{'blob'};
      $field =~ s/ blob/ $name/;
    }
    $query.= $field . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  $nr=0;

  # Prepend table_name to index name because the the name may clash with
  # a field name. (Should be diffent name space, but this is mSQL...)

  foreach $index (@$index)
  {
    # Primary key is unique index in mSQL
    $index =~ s/primary key/unique index primary/i;
    if ($index =~ /^unique\s*\(([^\(]*)\)$/i)
    {
      $nr++;
      push(@queries,"create unique index ${table_name}_$nr on $table_name ($1)");
    }
    else
    {
      if (!($index =~ /^(.*index)\s+(\w*)\s+(\(.*\))$/i))
      {
	die "Can't parse index information in '$index'\n";
      }
      push(@queries,"create $1 ${table_name}_$2 on $table_name $3");
    }
  }
  return @queries;
}


sub insert_file {
  my($self,$dbname, $file) = @_;
  print "insert an ascii file isn't supported by mSQL\n"; 
  return 0;
}


sub query {
  my($self,$sql) = @_;
  return $sql;
}

sub abort_if_fatal_error
{
  return 0;
}

#############################################################################
#		     Definitions for PostgreSQL				    #
#############################################################################

package db_Pg;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "pg";
  $self->{'data_source'}	= "DBI:Pg:test:localhost";
  $self->{'limits'}		= \%limits;
  $self->{'tpcd'}		= \%tpcd;
  $self->{'blob'}		= "text";
  $self->{'double_quotes'}	= 1;

  $limits{'max_conditions'}	= 9;		# This makes Pg real slow
  $limits{'max_columns'}	= 500;
  $limits{'max_text_size'}	= 8000;
  $limits{'query_size'}		= 8191;
  $limits{'max_index'}		= 7;		# Is this true ?
  $limits{'max_index_parts'}	= 16;		# Is this true ?
  $limits{'max_column_name'} = 32;		# Is this true

  $limits{'join_optimizer'}	= 1;		# Can't optimize FROM tables
  $limits{'load_data_infile'}	= 0;		# Is this true ?
  $limits{'lock_tables'}	= 0;		# Is this true ?
  $limits{'functions'}		= 1;
  $limits{'group_functions'}	= 1;
  $limits{'multi_drop'}		= 1;
  $limits{'select_without_from'}= 1;
  $limits{'subqueries'}		= 0;
  $limits{'left_outer_join'}	= 0;
  $limits{'table_wildcard'}	= 1;
  $limits{'having_with_alias'}  = 1;
  $limits{'having_with_group'}	= 1;
  $limits{'like_with_column'}	= 0;
  $limits{'order_by_position'}  = 1;

  $limits{'group_func_extra_std'}		= 0;

  $limits{'func_odbc_mod'}		= 2;		# Has %
  $limits{'func_extra_%'}			= 1;
  $limits{'func_odbc_floor'}		= 0;
  $limits{'func_extra_if'}			= 0;
  $limits{'column_alias'}			= 1;
  $limits{'NEG'}		= 0;		# Can't handle -id
  $limits{'func_extra_in_num'}			= 0;

  # the different cases per query ...
  $tpcd{'q1'} 	= 'b'; # with time 
  $tpcd{'q2'} 	= 'b';
  $tpcd{'q3'} 	= 'b'; # with time 
  $tpcd{'q4'} 	= 'c'; # with time 
  $tpcd{'q5'} 	= 'b'; # with time 
  $tpcd{'q6'} 	= 'c'; # strange error ....
  $tpcd{'q7'} 	= 'c';
  $tpcd{'q8'} 	= 'f'; # needs 128M to execute - can't do insert ...group by
  $tpcd{'q9'} 	= 'c';
  $tpcd{'q10'} 	= 'b';
  $tpcd{'q11'} 	= 'b'; # can't do float8 * int4 - create operator
  $tpcd{'q12'} 	= 'd'; # strange error???
  $tpcd{'q13'} 	= 'c';
  $tpcd{'q14'} 	= 'd'; # strange error???
  $tpcd{'q15'} 	= 'd'; # strange error???
  $tpcd{'q16'} 	= 'a';
  $tpcd{'q17'} 	= 'c';
  $tpcd{'time'} = 1;    # the use of the time table -> 1 is on.
			# when 0 then the date field must be a 
			# date field not a int field!!!
  return $self;
}

# couldn't find the option to get the version number

sub version
{
  my ($version,$dir);
  foreach $dir ($ENV{'PGDATA'},"/usr/local/pgsql/data", "/my/local/pgsql/data")
  {
    if ($dir && -e "$dir/PG_VERSION")
    {
      $version= `cat $dir/PG_VERSION`;
      if ($? == 0)
      {
	chomp($version);
	return "PostgreSQL $version";
      }
    }
  }
  return "PostgreSQL version ???";
}

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries,$name,$in,$indfield,$table);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    if ($main::opt_fast)
    {
      # Allow use of char2, char4, char8 or char16
      $field =~ s/char(2|4|8|16)/char$1/;
    }
    # Pg can't handle more than the real basic int types
    $field =~ s/tinyint|smallint|mediumint|integer/int/;
    # Pg can't handle different visual lengths
    $field =~ s/int\(\d*\)/int/;
    $field =~ s/float\(\d*,\d*\)/float/;
    $field =~ s/ double/ float/;
    $field =~ s/ decimal/ float/i;
    $field =~ s/ big_decimal/ float/i;
    $field =~ s/ date/ int/i;
    # Pg doesn't have blob, it has text instead
    $field =~ s/ blob/ text/;
    $query.= $field . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  foreach $index (@$index)
  {
    $index =~ s/primary key/unique index primary_key/i;
    if ($index =~ /^unique.*\(([^\(]*)\)$/i)
    {
      $indfield="using btree (" .$1.")";
      $in="unique index";
      $table="index_$nr"; $nr++;
    }
    elsif ($index =~ /^(.*index)\s+(\w*)\s+(\(.*\))$/i)
    {
      $indfield="using btree " .$3;
      $in="index";
      $table="index_$nr"; $nr++;
    }
    else
    {
      die "Can't parse index information in '$index'\n";
    }
    push(@queries,"create $in ${table_name}_$table on $table_name $indfield");
  }
  $queries[0]=$query;
  return @queries;
}

sub insert_file {
  my ($self,$dbname, $file, $dbh) = @_;
  my ($command, $sth);

# Syntax:
# copy [binary] <class_name> [with oids]
#      {to|from} {<filename>|stdin|stdout} [using delimiters <delim>]
  print "The ascii files aren't correct for postgres ....!!!\n";
  $command = "copy $dbname from '$file' using delimiters ','";
  print "$command\n";
  $sth = $dbh->do($command) or die $DBI::errstr;
  return $sth;
}

#
# As postgreSQL wants A % B instead of standard mod(A,B) we have to map
# This will not handle all cases, but as the benchmarks doesn't use functions
# inside MOD() the following should work
#
# PostgreSQL cant handle count(*) or even count(1), but it can handle
# count(1+1) sometimes.
#

sub query {
  my($self,$sql) = @_;
  my(@select,$change);
  $sql =~ s/mod\(([^,]*),([^\)]*)\)/\($1 % $2\)/gi;
  if ($sql =~ /count\(\*\)/i)
  {
    if ($sql =~ /select\s+(.*)\s+from/i)
    {
      @select = split(/,/,$1);
      if ($select[0] =~ /(.*)\s+as\s+\w+$/i)
      {
 	$change = $1;
      }
      else
      {
	$change = $select[0];
      }
    }
    if (($change =~ /count/i) || ($change eq "")) {
      $change = "1+1";
    }
    $sql =~ s/count\(\*\)/count($change)/gi;
  }
  return $sql;
}

sub abort_if_fatal_error
{
  return 1 if ($DBI::errstr =~ /sent to backend, but backend closed/i);
  return 0;
}


sub vacuum
{
  my ($self,$dbh)=@_;
  my ($loop_time,$end_time);
  $loop_time=new Benchmark;
  $dbh->do("vacuum") || die "Got error: $DBI::errstr when executing 'vacuum'\n";
  $end_time=new Benchmark;
  print "Time for book-keeping (1): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";
}


#############################################################################
#		     Definitions for Solid
#############################################################################

package db_Solid;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "solid";
  $self->{'data_source'}	= "DBI:Solid:";
  $self->{'limits'}		= \%limits;
  $self->{'tpcd'}		= \%tpcd;
  $self->{'blob'}		= "long varchar";
  $self->{'double_quotes'}	= 1;

  $limits{'max_conditions'}	= 9999;		# Probably big enough
  $limits{'max_columns'}	= 1000;
  $limits{'max_text_size'}	= 65492;	# According to tests
  $limits{'query_size'}		= 65535;	# Probably a limit
  $limits{'max_index'}		= 64;		# Probably big enough
  $limits{'max_index_parts'}	= 64;
  $limits{'max_column_name'} = 80;

  $limits{'join_optimizer'}	= 1;
  $limits{'load_data_infile'}	= 0;
  $limits{'lock_tables'}	= 0;
  $limits{'functions'}		= 1;
  $limits{'group_functions'}	= 1;
  $limits{'select_without_from'}= 0;		# Can do 'select 1' ?;
  $limits{'multi_drop'}		= 0;
  $limits{'subqueries'}		= 1;
  $limits{'left_outer_join'}	= 1;
  $limits{'table_wildcard'}	= 1;
  $limits{'having_with_alias'}  = 0;
  $limits{'having_with_group'}	= 1;
  $limits{'like_with_column'}	= 1;
  $limits{'order_by_position'}  = 0;		# 2.30.0018 can this

  $limits{'group_func_extra_std'}	= 0;	# Have group function std().

  $limits{'func_odbc_mod'}		= 1;
  $limits{'func_extra_%'}		= 0;
  $limits{'func_odbc_floor'}		= 1;
  $limits{'column_alias'}		= 1;
  $limits{'NEG'}			= 1;
  $limits{'func_extra_in_num'}		= 1;

  # for the tpcd small benchmark test ....
  # the different cases per query ...
  $tpcd{'q1'} 	= 'a'; 
  $tpcd{'q2'} 	= '';
  $tpcd{'q3'} 	= 'b'; #doesn't work -> strange error about column -fixed
  $tpcd{'q4'} 	= 'a'; 
  $tpcd{'q5'} 	= 'b';
  $tpcd{'q6'} 	= 'c'; 
  $tpcd{'q7'} 	= 'b';
  $tpcd{'q8'} 	= 'f'; 
  $tpcd{'q9'} 	= 'b';
  $tpcd{'q10'} 	= 'b';
  $tpcd{'q11'} 	= '';
  $tpcd{'q12'} 	= 'd';
  $tpcd{'q13'} 	= 'b';
  $tpcd{'q14'} 	= 'd';
  $tpcd{'q15'} 	= 'd';
  $tpcd{'q16'} 	= '';
  $tpcd{'q17'} 	= '';
  $tpcd{'time'} = 1;    # the use of the time table -> 1 is on.
			# when 0 then the date field must be a 
			# date field not a int field!!!
  return $self;
}

#
# Get the version number of the database
#

sub version
{
  my ($version,$dir);
  foreach $dir ($ENV{'SOLIDDIR'},"/usr/local/solid", "/my/local/solid")
  {
    if ($dir && -e "$dir/bin/solcon")
    {
      $version=`$dir/bin/solcon -e"ver" $main::opt_user $main::opt_password | grep Server | head -1`;
      if ($? == 0)
      {
	chomp($version);
	return $version;
      }
    }
  }
  return "Solid version ???";
}


#
# Returns a list of statements to create a table
# The field types are in ANSI SQL format.
#

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    $field =~ s/mediumint/integer/i;
    $field =~ s/ double/ float/i;
    # Solid doesn't have blob, it has long varchar
    $field =~ s/ blob/ long varchar/;
    $field =~ s/ decimal/ float/i;
    $field =~ s/ big_decimal/ float/i;
    $field =~ s/ date/ int/i;
    $query.= $field . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  foreach $index (@$index)
  {
    if ($index =~ /^primary key/i || $index =~ /^unique/i)
    {					# Add to create statement
      substr($queries[0],-1,0)="," . $index;
    }
    else
    {
      $index =~ /^(.*)\s+(\(.*\))$/;
      push(@queries,"create ${1}$nr on $table_name $2");
      $nr++;
    }
  }
  return @queries;
}

# there is no sql statement in solid which can do the load from
# an ascii file in the db ... but there is the speedloader program
# an external program which can load the ascii file in the db ...
# the server must be down before using speedloader !!!!
# (in the standalone version)
# it works also with a control file ... that one must be made ....
sub insert_file {
  my ($self, $dbname, $file) = @_;
  my ($speedcmd);
  $speedcmd = '/usr/local/solid/bin/solload';
  print "At this moment not supported - solid server must go down \n";
  return 0;
}

# solid can't handle an alias in a having statement so 
# select test as foo from tmp group by foo having foor > 2
# becomes
# select test as foo from tmp group by foo having test > 2
#
sub query {
  my($self,$sql) = @_;
  my(@select,$tmp,$newhaving,$key,%change);

  if ($sql =~ /having\s+/i)
  {
    if ($sql =~ /select (.*) from/i)
    {
      (@select) = split(/,\s*/, $1);
      foreach $tmp (@select)
      {
	if ($tmp =~ /(.*)\s+as\s+(\w+)/)
	{
	  $change{$2} = $1;
	}
      }
    }
    if ($sql =~ /having\s+(\w+)/i)
    {
      $newhaving = $1;
      foreach $key (sort {$a cmp $b} keys %change)
      {
	if ($newhaving eq $key)
	{
	  $newhaving =~ s/$key/$change{$key}/g;
	}
      }
    }
    $sql =~ s/(having)\s+(\w+)/$1 $newhaving/i;
  }
  return $sql;
}

sub abort_if_fatal_error
{
  return 0;
}

#############################################################################
#		     Definitions for Empress
#
# at this moment DBI:Empress can only handle 200 prepare statements ...
# so Empress can't be tested with the benchmark test :(
#############################################################################

package db_Empress;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "empress";
  $self->{'data_source'}        = "DBI:EmpressNet:SERVER=localhost;Database=/usr/local/empress/rdbms/bin/$main::opt_database";
  $self->{'limits'}		= \%limits;
  $self->{'tpcd'}		= \%tpcd;
  $self->{'blob'}		= "text";
  $self->{'double_quotes'}	= 1; # Can handle:  'Walker''s'

  $limits{'max_conditions'}	= 4092;
  $limits{'max_columns'}	= 2419;
  $limits{'max_text_size'}	= 65535;	# Not a limit, big enough
  $limits{'query_size'}		= 65535;	# Not a limit, big enough
  $limits{'max_index'}		= 64;		# Big enough
  $limits{'max_index_parts'}	= 64;		# Big enough
  $limits{'max_column_name'} = 32;

  $limits{'join_optimizer'}	= 1;
  $limits{'load_data_infile'}	= 0;
  $limits{'lock_tables'}	= 0;
  $limits{'functions'}		= 1;
  $limits{'group_functions'}	= 1;
  $limits{'select_without_from'}= 0;
  $limits{'multi_drop'}		= 0;
  $limits{'subqueries'}		= 1;
  $limits{'table_wildcard'}	= 0;
  $limits{'having_with_alias'}  = 1;
  $limits{'having_with_group'}	= 1;
  $limits{'like_with_column'}	= 1;
  $limits{'order_by_position'}  = 0;

  $limits{'group_func_extra_std'}		= 0;	# Have group function std().

  $limits{'func_odbc_mod'}	= 0;
  $limits{'func_extra_%'}	= 1;
  $limits{'func_odbc_floor'}		= 1;
  $limits{'func_extra_if'}			= 0;
  $limits{'column_alias'}	= 0;
  $limits{'NEG'}		= 1;
  $limits{'func_extra_in_num'}	= 0;

  # for the tpcd small benchmark test ....
  # the different cases per query ... EMPRESS
  $tpcd{'q1'} 	= 'a'; 
  $tpcd{'q2'} 	= '';
  $tpcd{'q3'} 	= 'a';
  $tpcd{'q4'} 	= 'a'; 
  $tpcd{'q5'} 	= 'a'; 
  $tpcd{'q6'} 	= 'a';
  $tpcd{'q7'} 	= 'b';
  $tpcd{'q8'} 	= 'd'; 
  $tpcd{'q9'} 	= 'b';
  $tpcd{'q10'} 	= 'a'; 
  $tpcd{'q11'} 	= '';
  $tpcd{'q12'} 	= 'd';
  $tpcd{'q13'} 	= 'b';
  $tpcd{'q14'} 	= 'b';
  $tpcd{'q15'} 	= 'a';
  $tpcd{'q16'} 	= '';
  $tpcd{'q17'} 	= '';
  $tpcd{'time'} = 1;    # the use of the time table -> 1 is on.
			# when 0 then the date field must be a 
			# date field not a int field!!!
  return $self;
}

#
# Get the version number of the database
#

sub version
{
  my ($self,$dbh)=@_;
  my ($version);
  $version="";
  if (-x "/usr/local/empress/rdbms/bin/empvers")
  {
    $version=`/usr/local/empress/rdbms/bin/empvers | grep Version`;
  }
  if ($version)
  {
    chomp($version);
  }
  else
  {
    $version="Empress version ???";
  }
  return $version;
}


sub insert_file {
  my($self,$dbname, $file) = @_;
  my($command,$sth);
  $command = "insert into $dbname from '$file'";
  print "$command\n" if ($opt_debug);
  $sth = $dbh->do($command) or die $DBI::errstr;
 
  return $sth;
}

#
# Returns a list of statements to create a table
# The field types are in ANSI SQL format.
#

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    $field =~ s/mediumint/int/i;
    $field =~ s/tinyint/int/i;
    $field =~ s/smallint/int/i;
    $field =~ s/integer/int/i;
    $field =~ s/ double/ longfloat/i;
    # Solid doesn't have blob, it has long varchar
#    $field =~ s/ blob/ text(65535,65535,65535,65535)/;
    $field =~ s/ blob/ text/;
    $field =~ s/ varchar\((\d+)\)/ char($1,2)/;
    $field =~ s/ char\((\d+)\)/ char($1,2)/;
    $field =~ s/ decimal/ float/i;
    $field =~ s/ big_decimal/ longfloat/i;
    $field =~ s/ date/ int/i;
    $field =~ s/ float(.*)/ float/i;
    if ($field =~/ int\((\d+)\)/) {
      if ($1 > 4) {
        $field =~ s/ int\(\d+\)/ longinteger/i;
      } else {
        $field =~ s/ int\(\d+\)/ int/i;
      }
    }
    $query.= $field . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  foreach $index (@$index)
  {
    # Primary key is unique index in Empress
    $index =~ s/primary key/unique index/i;
    if ($index =~ /^unique.*\(([^\(]*)\)$/i)
    {
      $nr++;
      push(@queries,"create unique index ${table_name}_$nr on $table_name ($1)");
    }
    else
    {
      if (!($index =~ /^(.*index)\s+(\w*)\s+(\(.*\))$/i))
      {
	die "Can't parse index information in '$index'\n";
      }
      push(@queries,"create $1 ${table_name}_$2 on $table_name $3");
    }
  }
  return @queries;
}

# empress can't handle an alias and but can handle the number of the 
# columname - so 
# select test as foo from tmp order by foo
# becomes
# select test from tmp order by 1
#
sub query {
  my($self,$sql) = @_;
  my(@select,$i,$tmp,$newselect,$neworder,@order,$key,%change);
  my($tmp1,$otmp,$tmp2);

  if ($sql =~ /\s+as\s+/i)
  {
    if ($sql =~ /select\s+(.*)\s+from/i) {
      $newselect = $1;
      (@select) = split(/,\s*/, $1);
      $i = 1;
      foreach $tmp (@select) {
	if ($tmp =~ /\s+as\s+(\w+)/) {
	  $change{$1} = $i;
	}
	$i++;
      }
    }
    $newselect =~ s/\s+as\s+(\w+)//gi;
    $tmp2 = 0;
    if ($sql =~ /order\s+by\s+(.*)$/i) {
      (@order) = split(/,\s*/, $1);
      foreach $otmp (@order) {
	foreach $key (sort {$a cmp $b} keys %change) {
	  if ($otmp eq $key) {
	    $neworder .= "$tmp1"."$change{$key}";
	    $tmp1 = ", ";
	    $tmp2 = 1;
	  } elsif ($otmp =~ /(\w+)\s+(.+)$/) {
	    if ($key eq $1) {
	      $neworder .= "$tmp1"."$change{$key} $2";
	      $tmp2 = 1;
	    }
	  }
	}
	if ($tmp2 == 0) {
	  $neworder .= "$tmp1"."$otmp";
	}
	$tmp2 = 0;
	$tmp1 = ", ";
      }
    }
    $sql =~ s/(select)\s+(.*)\s+(from)/$1 $newselect $3/i;
    $sql =~ s/(order\s+by)\s+(.*)$/$1 $neworder/i;
  }
  return $sql;
}

# This is a because of the 200 statement problem with DBI-Empress 

sub abort_if_fatal_error
{
  if ($DBI::errstr =~ /Overflow of table of prepared statements/i)
  {
    print "Overflow of prepared statements ... killing the process\n";
    exit 1;
  }
  return 0;
}


#############################################################################
#	                 Definitions for Oracle
#############################################################################

package db_Oracle;

sub new
{
  my $self= {};
  my %limits;
  bless $self;

  $self->{'cmp_name'}		= "Oracle";
  $self->{'data_source'}	= "DBI:Oracle:$main::opt_database";
  $self->{'limits'}		= \%limits;
  $self->{'tpcd'}		= \%tpcd;
  $self->{'blob'}		= "blob";
  $self->{'double_quotes'}	= 1; # Can handle:  'Walker''s'

  $limits{'max_conditions'}	= 9999; # (Actually not a limit)
  $limits{'max_columns'}	= 254;	# Max number of columns in table
  $limits{'max_text_size'}	= 65000; # Max size with default buffers.
  $limits{'query_size'}		= 65525; # Max size with default buffers.
  $limits{'max_index'}		= 16; # Max number of keys
  $limits{'max_index_parts'}	= 16; # Max segments/key
  $limits{'max_column_name'} = 32; # max table and column name

  $limits{'join_optimizer'}	= 1; # Can optimize FROM tables
  $limits{'load_data_infile'}	= 0; # Has load data infile
  $limits{'lock_tables'}	= 0; # Has lock tables
  $limits{'functions'}		= 1; # Has simple functions (+/-)
  $limits{'group_functions'}	= 1; # Have group functions
  $limits{'select_without_from'}= 0;
  $limits{'multi_drop'}		= 0;
  $limits{'subqueries'}		= 1;
  $limits{'left_outer_join'}	= 0; # This may be fixed in the query module
  $limits{'table_wildcard'}	= 1; # Has SELECT table_name.*
  $limits{'having_with_alias'}  = 0; # Can use aliases in HAVING
  $limits{'having_with_group'}	= 1; # Can't use group functions in HAVING 
  $limits{'like_with_column'}	= 1; # Can use column1 LIKE column2
  $limits{'order_by_position'}  = 1; # Can use 'ORDER BY 1'

  $limits{'group_func_extra_std'}		= 0; # Have group function std().

  $limits{'func_odbc_mod'}		= 1; # Have function mod.
  $limits{'func_extra_%'}			= 0; # Has % as alias for mod()
  $limits{'func_odbc_floor'}		= 1; # Has func_odbc_floor function
  $limits{'func_extra_if'}			= 0; # Have function if.
  $limits{'column_alias'}			= 1; # Alias for fields in select statement.
  $limits{'NEG'}		= 1; # Supports -id
  $limits{'func_extra_in_num'}			= 1; # Has function in

  $tpcd{'time'}			= 1;
  $tpcd{'q1'} 	= 'b';		# with time not supp by mysql ('')
  $tpcd{'q2'} 	= 'b';
  $tpcd{'q3'} 	= 'b';		# with time ('')
  $tpcd{'q4'} 	= 'c';		# with time not supp by mysql (d)
  $tpcd{'q5'} 	= 'b';		# with time not supp by mysql ('')
  $tpcd{'q6'} 	= 'c';		# with time not supp by mysql ('')
  $tpcd{'q7'} 	= 'c';
  $tpcd{'q8'} 	= 'f';
  $tpcd{'q9'} 	= 'c';
  $tpcd{'q10'} 	= 'b';
  $tpcd{'q11'} 	= 'b';
  $tpcd{'q12'} 	= 'd';
  $tpcd{'q13'} 	= 'c';
  $tpcd{'q14'} 	= 'd';
  $tpcd{'q15'} 	= 'd';
  $tpcd{'q16'} 	= 'a';
  $tpcd{'q17'} 	= 'c';

  return $self;
}

#
# Get the version number of the database
#

sub version
{
  my ($self)=@_;
  my ($dbh,$sth,$version,@row);
 
  $dbh=DBI->connect($self->{'data_source'},$main::opt_user,$main::opt_password) or die $DBI::errstr;
  $sth = $dbh->prepare("select VERSION from product_component_version WHERE PRODUCT like 'Oracle%Server%'") or die $DBI::errstr;
  $version="Oracle 7.x";
  if ($sth->execute && (@row = $sth->fetchrow_array))
  {
    $version="Oracle $row[0]";
  }
  $sth->finish;
  $dbh->disconnect;
  return $version;
}

#
# Returns a list of statements to create a table
# The field types are in ANSI SQL format.
#
# If one uses $main::opt_fast then one is allowed to use
# non standard types to get better speed.
#

sub create
{
  my($self,$table_name,$fields,$index) = @_;
  my($query,@queries);

  $query="create table $table_name (";
  foreach $field (@$fields)
  {
    $field =~ s/character(1)/char(1)/i;
    $field =~ s/character varying(1)/varchar(1)/i;
    $field =~ s/char varying(1)/varchar(1)/i;
    $field =~ s/integer/number(38)/i;
    $field =~ s/int/number(38)/i;
    $field =~ s/smallint/number/i;
    $field =~ s/numeric(9,2)/number(9,2)/i;
    $field =~ s/decimal(6,2)/number(6,2)/i;
    $field =~ s/dec(6,2)/number(6,2)/i;
    $field =~ s/float/number/;
    $field =~ s/real/number/;
    $field =~ s/double precision/number/;
    $query.= $field . ',';
  }
  foreach $index (@$index)
  {
    $query.= $index . ',';
  }
  substr($query,-1)=")";		# Remove last ',';
  push(@queries,$query);
  return @queries;
}

sub insert_file {
  my($self,$dbname, $file) = @_;
  print "insert an ascii file isn't supported by Oracle (?)\n"; 
  return 0;
}

#
# Do any conversions to the ANSI SQL query so that the database can handle it
#

sub query {
  my($self,$sql) = @_;
  return $sql;
}

#
# Abort if the server has crashed
# return: 0 if ok
#	  1 question should be retried
#

sub abort_if_fatal_error
{
  return 0;
}

1;
