#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <utmp.h>
#include <sys/stat.h>

#include "who.h"
#include "arbitrary.h"

int who_alarm_on;
char **who_list;
char **tty_list;
int who_tty_list_size;
int who_tty_list_number;

#if 0
int main (void)
    {
    int i;
/*
 * int in,i;
 * signal_handle(SIGALRM,who);
 * while(1)
 *     {
 * who(0);
 * in = getc(stdin);
 * if (in == 'q')
 * exit(0); 
 * else if (in == 'a')
 *     {
 * if (who_alarm_on == 1)
 *     {
 * alarm(3);
 * who_alarm_on=0;
 *     }
 * else
 *     {
 * alarm(0);
 * who_alarm_on=1; 
 *     }
 *     }
 * 
 *     }
 * 
 */

    who (0);
    for (i = 0; i < who_tty_list_number; i++)
        fprintf (stderr, "user %s, on %s\n", who_list[i], tty_list[i]);
    return (0);
    }
#endif



/*
 * intended to be a continually called who that only updates on a change
 * from the previous call
 */
int who (void)
    {
    static int lock;            /*
                                 * maybe i need this to stop the annoying crashes
                                 */
    static time_t last_check;
    struct utmp tmp;
    struct stat tmp2;
    int fd;                        /*
                                 * File Descriptor for UTMP 
                                 */
    int who_changed = 0;
    static char *tempstr;

    if (!lock)
        {
        lock = 1;

        /*
         * on the first cycle allocate some memory
         */
        if (last_check == (time_t) 0)
            {
            tempstr = getenv ("USER");


            who_list = (char **) malloc (WHO_LIST_INC * sizeof (char *));
            tty_list = (char **) malloc (WHO_LIST_INC * sizeof (char *));

            if ((who_list == NULL) || (tty_list == NULL))
                {
                fprintf (stderr, "xitalk: Memory Allocation Failed\n");
                exit (-1);
                }

            for (fd = 0; fd < WHO_LIST_INC; fd++)
                {
                who_list[fd] = (char *) malloc ((USRNAMLEN + 1) * sizeof (char));
                tty_list[fd] = (char *) malloc ((USRNAMLEN + 1 + 2) * sizeof (char));
                }

            who_tty_list_size = WHO_LIST_INC;
            fd = -1;            /*
                                 * im just messing here, dont mind me, 4:09
                                 */
            }

        /*
         * read the utmp entries
         */
        if ((fd = open (UTMP_FILENAME, O_RDONLY)) >= 0)
            {
            fstat (fd, &tmp2);
            if (tmp2.st_mtime > last_check)
                {
                who_changed = 1;
                last_check = tmp2.st_mtime;
                who_tty_list_number = 0;    /*
                                             * overwrite who list
                                             */
                while (read (fd, (char *) &tmp, sizeof (tmp)) == sizeof (tmp))
#ifdef USE_SYSV_UTMP
                    if ((tmp.ut_type == USER_PROCESS) && (tmp.ut_name[0] != '\0'))
                        add_who_tty (tmp.ut_user, tmp.ut_line);
#else
                    if (tmp.ut_name[0] != '\0')
                        add_who_tty (tmp.ut_name, tmp.ut_line);
#endif
                }
            }
        else
			{
            fprintf (stderr, "cant open UTMP file %s\n", UTMP_FILENAME);
			if (errno == EMFILE)
            	fprintf (stderr, "too many files open");
			}
        close (fd);
        lock = 0;
        }
    return (who_changed);
    }


void add_who_tty (char *user, char *tty)
    {
    int i;
    struct stat tmp;

    if (who_tty_list_number == who_tty_list_size)
        {
        i = who_tty_list_size + WHO_LIST_INC;
        who_list = Increase (who_list, char *, i);
        tty_list = Increase (tty_list, char *, i);
        if ((who_list == NULL) || (tty_list == NULL))
            {
            fprintf (stderr, "xitalk: Memory Allocation Failed\n");
            exit (-1);
            }

        for ( /*who_tty_list_size*/ ; who_tty_list_size < i; who_tty_list_size++)
            {
            who_list[who_tty_list_size] = (char *) malloc ((USRNAMLEN + 1) * sizeof (char));
            tty_list[who_tty_list_size] = (char *) malloc ((USRNAMLEN + 1 + 2) * sizeof (char));
            }

        }

    istrncpy (who_list[who_tty_list_number], user, USRNAMLEN);
    istrncpy (tty_list[who_tty_list_number], tty, USRNAMLEN);
    who_tty_list_number++;
    }
