/*
 * (c) Copyright 1992, 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */


#ifndef __STR_H
#define __STR_H

/*
 * $Id: str.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#include <stdarg.h>

#ifdef __GNUC__
#define PRINTF_FORMAT(n, m) \
   __attribute__ ((format (printf, n, m)))
#else
#define PRINTF_FORMAT(n, m)
#endif

/*
 * strprint(3) functions
 */
char *strx_sprint ( char *buf, int len, const char *fmt, ... ) 
   PRINTF_FORMAT(3, 4);
int strx_nprint ( char *buf, int len, const char *fmt, ... ) 
   PRINTF_FORMAT(3, 4);
void strx_print ( int *count, char *buf, int len, const char *fmt, ... )
   PRINTF_FORMAT(4, 5);

int strx_nprintv ( char *buf, int len, const char *fmt, va_list )
   PRINTF_FORMAT(3, 0);
void strx_printv ( int *cnt, char *buf, int len, const char *fmt, va_list ) 
   PRINTF_FORMAT(4, 0);
 

/*
 * strparse(3) functions
 */

/*
 * Return values
 */
#define STR_OK					0
#define STR_ERR					(-1)


/* 
 * Flags for the string parsing functions
 */
#define STR_NOFLAGS			0x0
#define STR_RETURN_ERROR		0x1
#define STR_NULL_START			0x2
#define STR_NULL_END			0x4
#define STR_MALLOC			0x8

/*
 * Error values
 */
#define STR_ENULLSEPAR			1
#define STR_ENULLSTRING			2
#define STR_ENOMEM			3

typedef void *str_h ;

char *new_string(const char *) ;
str_h str_parse ( char *str, char *separ, int flags, int *errnop ) ;
void str_endparse ( str_h handle ) ;
char *str_component ( str_h handle ) ;
int str_setstr ( str_h handle, char *newstr ) ;

/*
 * For backwards compatibility
 */
#define str_process( s, sep, flags )	str_parse( s, sep, flags, (int *)0 )
#define str_endprocess( handle )	str_endparse( handle )


/*
 * strutil(3) functions
 */
char *str_find ( const char *s1, const char *s2 ) ;
char *str_casefind ( const char *s1, const char *s2 ) ;
void str_fill ( char *s, char c ) ;


/*
 * strsearch(3) functions
 */

/*
 * Methods
 */
#define STRS_BF		0		/* brute force		*/
#define STRS_RK		1		/* Rabin-Karp		*/
#define STRS_KMP	2		/* Knuth-Morris-Pratt	*/
#define STRS_SBM	3		/* Simple Boyer-Moore	*/
#define STRS_BMH	4		/* Boyer-Moore-Horspool */
#define STRS_SO		5		/* Shift-Or		*/

#define __STRS_METHOD_BITS	5
#define STRS_METHODS_MAX	( 1 << __STRS_METHOD_BITS )

/*
 * Flags
 */
#define __STRS_MAKEFLAG( v )	( (v) << __STRS_METHOD_BITS )
#define STRS_IGNCASE		__STRS_MAKEFLAG( 0x1 )
#define STRS_NOMALLOC		__STRS_MAKEFLAG( 0x2 )
#define STRS_NOSWITCH		__STRS_MAKEFLAG( 0x4 )
#define STRS_PATLEN		__STRS_MAKEFLAG( 0x8 )


//typedef void *strs_h ;

#endif 	/* __STR_H */

