.\"
.\" $XFree86$
.\"
.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $Xorg: XGrabDev.man,v 1.3 2000/08/17 19:41:56 cpqbld Exp $
.ds xL Programming With Xlib
.TH XGrabDevice 3X11 __xorgversion__ "X FUNCTIONS"
.SH NAME
XGrabDevice, XUngrabDevice \- grab/release the specified extension device
.SH SYNTAX
.nf
\fB
int XGrabDevice\^(\^\fIdisplay\fP, \fIdevice\fP\^, \fIgrab_window\fP\^, \fIowner_events\fP\^, \fIevent_count\fP\^, \fIevent_list\fP\^,
\fIthis_device_mode\fP\^, \fIother_devices_mode\fP\^, \fItime\fP\^)
      Display *\fIdisplay\fP\^;
      XDevice *\fIdevice\fP\^;
      Window \fIgrab_window\fP\^;
      Bool \fIowner_events\fP\^;
      int \fIevent_count\fP\^;
      XEventClass *\fIevent_list\fP\^;
      int \fIthis_device_mode\fP\^, \fIother_devices_mode\fP\^;
      Time \fItime\fP\^;

XUngrabDevice\^(\^\fIdisplay\fP, \fIdevice\fP\^, \fItime\fP\^)
      Display *\fIdisplay\fP\^;
      XDevice *\fIdevice\fP\^;
      Time \fItime\fP\^;
.fi
\fP
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device to be grabbed or released.
.TP 12
.I grab_window
Specifies the id of a window to be associated with the device.
.TP 12
.I owner_events
Specifies a Boolean value that indicates whether the 
events from the device 
are to be reported as usual or reported with respect to the grab window 
if selected by the event list.
.TP 12
.I event_count
Specifies the number of elements in the event_list array.
.TP 12
.I event_list
Specifies a pointer to a list of event classes that indicates which events
the client wishes to receive.  These event classes must have been
obtained specifying the device being grabbed.
.TP 12
.I this_device_mode
Specifies further processing of events from this device.
You can pass 
\fIGrabModeSync\fP
or
\fIGrabModeAsync\fP.
.TP 12
.I other_devices_mode
Specifies further processing of events from other devices.
You can pass 
\fIGrabModeSync\fP 
or
\fIGrabModeAsync\fP.
.TP 12
.I time
Specifies the time.
You can pass either a timestamp or
\fICurrentTime\fP.
.SH DESCRIPTION
The
\fIXGrabDevice\fP
request actively grabs control of the device and generates
\fIDeviceFocusIn\fP
and
\fIDeviceFocusOut\fP
events.
Further device events are reported only to the
grabbing client.
\fIXGrabDevice\fP
overrides any active device grab by this client.
event_list is a pointer to a list of event classes.  This list indicates
which events the client wishes to receive while the grab is active.
If owner_events is 
\fIFalse\fP , 
all generated device events are reported with
respect to grab_window if selected.
If owner_events is 
\fITrue\fP  
and if a generated
device event would normally be reported to this client, it is reported
normally; otherwise, the event is reported with respect to the
grab_window, and is only reported if specified in the event_list.
.LP
If the this_device_mode argument is 
\fIGrabModeAsync\fP ,
device event processing continues
as usual. 
If the device is currently frozen by this client, 
then processing of device events is resumed.
If the this_device_mode  argument is
\fIGrabModeSync\fP ,
the state of the device (as seen by client applications) appears to freeze,
and the X server generates no further device events until the
grabbing client issues a releasing 
\fIXAllowDeviceEvents\fP 
call or until the device grab is released.
Actual device changes are not lost while the device is frozen; 
they are simply queued in the server for later processing.
.LP
If other_devices_mode is 
\fIGrabModeAsync\fP ,
processing of events from other devices is unaffected
by activation of the grab.  
If other_devices_mode is 
\fIGrabModeSync\fP,
the state of all devices except the grabbed device
 (as seen by client applications) appears to freeze, 
and the X server generates no further events from those devices
until the grabbing client issues a releasing 
\fIXAllowDeviceEvents\fP 
call or until the device grab is released.
Actual events are not lost while the devices are frozen; 
they are simply queued in the server for later processing.
.LP
If the device is actively grabbed by some other client,
\fIXGrabDevice\fP
fails and returns
\fIAlreadyGrabbed\fP.
If grab_window is not viewable,
it fails and returns
\fIGrabNotViewable\fP.
If the device is frozen by an active grab of another client,
it fails and returns
\fIGrabFrozen\fP.
If the specified time is earlier than the last-device-grab time 
or later than the current X server time,
it fails and returns
\fIGrabInvalidTime\fP.
Otherwise, the last-device-grab time is set to the specified time
\fI( CurrentTime\fP 
is replaced by the current X server time).
.LP
If a grabbed device is closed by a client while an active grab by that
client is in effect, the active grab is released.  If the device is
frozen only by an active grab of the requesting client, it is thawed.
.LP
\fIXGrabDevice\fP
can generate
\fIBadClass\fP, \fIBadDevice\fP, \fIBadValue\fP, and \fIBadWindow\fP 
errors.
.LP
The
\fIXUngrabDevice\fP
request
releases the device and any queued events if this client has it actively 
grabbed from either
\fIXGrabDevice\fP
or
\fIXGrabDeviceKey\fP.
If other devices are frozen by the grab, \fIXUngrabDevice\fP thaws them.
\fIXUngrabDevice\fP
does not release the device and any queued events
if the specified time is earlier than
the last-device-grab time or is later than the current X server time.
It also generates
\fIDeviceFocusIn\fP 
and 
\fIDeviceFocusOut\fP 
events.
The X server automatically performs an 
\fIUngrabDevice\fP 
request if the event window for an
active device grab becomes not viewable.
.LP
\fIXUngrabDevice\fP
can generate a \fIBadDevice\fP error.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if the specified device is the X keyboard or X pointer device.
.TP 12
\fIBadValue\fP
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 12
\fIBadWindow\fP
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllowDeviceEvents(3X),
XGrabDeviceButton(3X),
XGrabDeviceKey(3X),
.br
\fI\*(xL\fP
