#!/usr/local/bin/perl
# save_title.cgi
# Save a boot menu option

require './grub-lib.pl';
&ReadParse();
$conf = &get_menu_config();
if (!$in{'new'}) {
	$old = $title = $conf->[$in{'idx'}];
	}
&error_setup($text{'title_err'});

if ($in{'delete'}) {
	# Just delete the title
	&save_directive($conf, $title, undef);
	}
else {
	# validate inputs
	$in{'title'} =~ /\S/ || &error($text{'title_etitle'});
	$in{'root_mode'} != 1 || $in{'other'} =~ /^\S+$/ ||
		&error($text{'title_eroot'});
	$in{'boot_mode'} != 2 || $in{'kernel'} =~ /^\S+$/ ||
		&error($text{'title_ekernel'});
	$in{'boot_mode'} != 1 || $in{'chain_def'} || $in{'chain'} =~ /^\S+$/ ||
		&error($text{'title_echain'});

	# store inputs in title structure
	$title->{'name'} = 'title';
	$title->{'value'} = $in{'title'};
	if ($in{'root_mode'} == 0) {
		delete($title->{'root'});
		}
	elsif ($in{'root_mode'} == 1) {
		$title->{'root'} = $in{'other'};
		}
	else {
		if ($in{'root'} =~ /\/dev\/hd([a-d])$/) {
			$title->{'root'} = "(hd".(ord($1)-97).")";
			}
		elsif ($in{'root'} =~ /\/dev\/hd([a-d])([1-8])$/) {
			$title->{'root'} = "(hd".(ord($1)-97).",".($2-1).")";
			}
		elsif ($in{'root'} =~ /\/dev\/fd([0-4])$/) {
			$title->{'root'} = "(fd$1)";
			}
		else {
			&error(&text('title_edev', $in{'root'}));
			}
		}
	delete($title->{'kernel'});
	delete($title->{'chainloader'});
	if ($in{'boot_mode'} == 2) {
		$title->{'kernel'} = $in{'kernel'};
		$title->{'kernel'} .= " $in{'args'}" if ($in{'args'});
		}
	elsif ($in{'boot_mode'} == 1) {
		$title->{'chainloader'} = $in{'chain_def'} ? '+1'
							   : $in{'chain'};
		}
	if ($in{'makeactive'}) {
		$title->{'makeactive'} = "";
		}
	else {
		delete($title->{'makeactive'});
		}

	# create or update the title
	&save_directive($conf, $old, $title);
	}

&flush_file_lines();
&redirect("");

