/*
 * buflog.cpp - buffer-based log format classes implementation
 * $Id: buflog.cpp,v 1.3 2004/06/05 15:15:17 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "buflog.h"
#include <string.h> // memcpy()

/*** LineBufDataLog class implementation ***/
void LineBufDataLog::SetBuffer (LineBuf *st, char *buf, size_t len)
{
	st->buf = buf;
	st->tsize = len;
	st->usize = 0;
}


int LineBufDataLog::WriteData (LineBuf* st, const void *data, int len, int oob)
{
	if ((st->buf == NULL) || oob)
		return (st == &svb)
			? WriteServerLine ((const char *)data, len, oob)
			: WriteClientLine ((const char *)data, len, oob);


	for (size_t i = 0, max = st->tsize; i < (size_t)len; i++)
	{
		char c = ((const char *)data)[i];

		switch (c)
		{
			case '\n':
			case '\0':
			{
				int us = st->usize;
				st->buf[us] = 0;

				int check = ((st == &svb)
					? WriteServerLine (svb.buf, us)
					: WriteClientLine (clb.buf, us)) !=us;
				st->usize = 0;
				if (check)
					return 0; // error!!
			}
			case '\r':
				break;

			default:
				st->buf[st->usize++] = c;
				if (max == (st->usize + 1))
				{
					int us = st->usize;

					st->buf[us] = 0;
					int check = ((st == &svb)
						? WriteServerLine (svb.buf, us)
						: WriteClientLine (clb.buf, us)
							) != us;
					st->usize = 0;
					if (check)
						return 0; // error!
				}
				break;
		}
	}

	return len;
}



int LineBufDataLog::WriteServerData (const void *data, int length,
					int oob)
{
	return WriteData (&svb, data, length, oob);
}


int LineBufDataLog::WriteClientData (const void *data, int length,
					int oob)
{
	return WriteData (&clb, data, length, oob);
}
