CHANGELOG for 2.8.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.8 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.8.0...v2.8.1

* 2.8.7 (2016-06-06)

 * bug #18908 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #18893 [DependencyInjection] Skip deep reference check for 'service_container' (RobertMe)
 * bug #18812 Catch \Throwable (fprochazka)
 * bug #18821 [Form] Removed UTC specification with timestamp (francisbesset)
 * bug #18861 Fix for #18843 (inso)
 * bug #18889 [Console] SymfonyStyle: Fix alignment/prefixing of multi-line comments (chalasr)
 * bug #18907 [Routing] Fix the annotation loader taking a class constant as a beginning of a class name (jakzal, nicolas-grekas)
 * bug #18879 [Console] SymfonyStyle: Align multi-line/very-long-line blocks (chalasr)
 * bug #18864 [Console][DX] Fixed ambiguous error message when using a duplicate option shortcut (peterrehm)
 * bug #18883 Fix js comment in profiler (linnaea)
 * bug #18844 [Yaml] fix exception contexts (xabbuh)
 * bug #18840 [Yaml] properly handle unindented collections (xabbuh)
 * bug #18765 Catch \Throwable (fprochazka)
 * bug #18813 Catch \Throwable (fprochazka)
 * bug #18839 People - person singularization (Keeo)
 * bug #18828 [Yaml] chomp newlines only at the end of YAML documents (xabbuh)
 * bug #18814 Fixed server status command when port has been omitted (peterrehm)
 * bug #18799 Use levenshtein level for better Bundle matching (j0k3r)
 * bug #18413 [WebProfilerBundle] Fix CORS ajax security issues (romainneutron)
 * bug #18774 [console][table] adjust width of colspanned cell. (aitboudad)
 * bug #18507 [BUG] Delete class 'control-group' in bootstrap 3 (Philippe Degeeter)
 * bug #18747  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18635 [Console] Prevent fatal error when calling Command::getHelper without helperSet (chalasr)
 * bug #18686 [console][table] adjust width of colspanned cell. (aitboudad)
 * bug #18761  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18737 [Debug] Fix fatal error handlers on PHP 7 (nicolas-grekas)

* 2.8.6 (2016-05-09)

 * security #18736 Fixed issue with blank password with Ldap (csarrazi)
 * security #18733 limited the maximum length of a submitted username (fabpot)
 * bug #18730 [FrameworkBundle] prevent calling get() for service_container service (xabbuh)
 * bug #18705 added a conflict between Monolog bridge 2.8 and HTTP Kernel 3.0+ (fabpot)
 * bug #18709 [DependencyInjection] top-level anonymous services must be public (xabbuh)
 * bug #18388 [EventDispatcher] check for method to exist (xabbuh)
 * bug #18699 [DependencyInjection] Use the priority of service decoration on service with parent (hason)
 * bug #18692 add @Event annotation for KernelEvents (Haehnchen)
 * bug #18246 [DependencyInjection] fix ambiguous services schema (backbone87)

* 2.8.5 (2016-04-29)

 * bug #18180 [Form] fixed BC break with pre selection of choices with `ChoiceType` and its children (HeahDude)
 * bug #18645 [Console] Fix wrong exceptions being thrown (JhonnyL)
 * bug #18562 [WebProfilerBunde] Give an absolute url in case the request occured from another domain (romainneutron)
 * bug #18600 [DI] Fix AutowirePass fatal error with classes that have non-existing parents (hason, nicolas-grekas)
 * bug #18603 [PropertyAccess] ->getValue() should be read-only (nicolas-grekas)
 * bug #18593 [VarDumper] Fix dumping type hints for non-existing parent classes (nicolas-grekas)
 * bug #18596 [DI] Fix internal caching in AutowirePass (nicolas-grekas)
 * bug #18581 [Console] [TableHelper] make it work with SymfonyStyle. (aitboudad)
 * bug #18280 [Routing] add query param if value is different from default (Tobion)
 * bug #18540 Replace iconv_*() uses by mb_*(), add mbstring polyfill when required (nicolas-grekas)
 * bug #18496 [Console] use ANSI escape sequences in ProgressBar overwrite method (alekitto)
 * bug #18490 [LDAP] Free the search result after a search to free memory (hiddewie)
 * bug #18491 [DependencyInjection] anonymous services are always private (xabbuh)
 * bug #18515 [Filesystem] Better error handling in remove() (nicolas-grekas)
 * bug #18360 [PropertyInfo] Extract nullable and collection key type for Doctrine associations (teohhanhui)
 * bug #18449 [PropertyAccess] Fix regression (nicolas-grekas)
 * bug #18429 [Console] Correct time formatting. (camporter)
 * bug #18457 [WebProfilerBundle] Fixed error from unset twig variable (simonsargeant)
 * bug #18467 [DependencyInjection] Resolve aliases before removing abstract services + add tests (nicolas-grekas)
 * bug #18469 Force profiler toolbar svg display (pyrech)
 * bug #18460 [DomCrawler] Fix select option with empty value (Matt Wells)
 * bug #18425 [Security] Fixed SwitchUserListener when exiting an impersonation with AnonymousToken (lyrixx)
 * bug #18317 [Form] fix "prototype" not required when parent form is not required (HeahDude)
 * bug #18439 [Logging] Add support for Firefox (43+) in ChromePhpHandler (arjenm)
 * bug #18385 Detect CLI color support for Windows 10 build 10586 (mlocati)
 * bug #18426 [EventDispatcher] Try first if the event is Stopped (lyrixx)
 * bug #18407 Fixed the "hover" state of the profiler sidebar menu (javiereguiluz)
 * bug #18394 [FrameworkBundle] Return the invokable service if its name is the class name (dunglas)
 * bug #18347 Fixed the styles of the Symfony icon in the web debug toolbar (javiereguiluz)
 * bug #18265 Optimize ReplaceAliasByActualDefinitionPass (ajb-in)
 * bug #18349 [Process] Fix stream_select priority when writing to stdin (nicolas-grekas)
 * bug #18358 [Form] NumberToLocalizedStringTransformer should return floats when possible (nicolas-grekas)
 * bug #17926 [DependencyInjection] Enable alias for service_container (hason)
 * bug #18352 [Debug] Fix case sensitivity checks (nicolas-grekas)
 * bug #18336 [Debug] Fix handling of php7 throwables (nicolas-grekas)
 * bug #18354 [FrameworkBundle][TwigBridge] fix high deps tests (xabbuh)
 * bug #18312 [ClassLoader] Fix storing not-found classes in APC cache (nicolas-grekas)

* 2.8.4 (2016-03-27)

 * bug #18298 [Validator] do not treat payload as callback (xabbuh)
 * bug #18275 [Form] Fix BC break introduced in #14403 (HeahDude)
 * bug #18271 [FileSystem] Google app engine filesystem (swordbeta)
 * bug #18255 [HttpFoundation] Fix support of custom mime types with parameters (Ener-Getick)
 * bug #18272 [Bridge\PhpUnit] Workaround old phpunit bug, no colors in weak mode, add tests (nicolas-grekas)
 * bug #18259 [PropertyAccess] Backport fixes from 2.7 (nicolas-grekas)
 * bug #18261 [PropertyAccess] Fix isPropertyWritable not using the reflection cache (nicolas-grekas)
 * bug #18224 [PropertyAccess] Remove most ref mismatches to improve perf (nicolas-grekas)
 * bug #18237 [WebProfilerBundle] Added table-layout property to AJAX toolbar css (kevintweber)
 * bug #18209 [PropertyInfo] Support Doctrine custom mapping type in DoctrineExtractor (teohhanhui)
 * bug #18210 [PropertyAccess] Throw an UnexpectedTypeException when the type do not match (dunglas, nicolas-grekas)
 * bug #18216 [Intl] Fix invalid numeric literal on PHP 7 (nicolas-grekas)
 * bug #18147 [Validator] EmailValidator cannot extract hostname if email contains multiple @ symbols (natechicago)
 * bug #18023 [Process] getIncrementalOutput should work without calling getOutput (romainneutron)
 * bug #18175 [Translation] Add support for fuzzy tags in PoFileLoader (nud)
 * bug #18179 [Form] Fix NumberToLocalizedStringTransformer::reverseTransform with big integers (ovrflo, nicolas-grekas)
 * bug #18164 [HttpKernel] set s-maxage only if all responses are cacheable (xabbuh)
 * bug #18150 [Process] Wait a bit less on Windows (nicolas-grekas)
 * bug #18130 [Debug] Replaced logic for detecting filesystem case sensitivity (Dan Blows)
 * bug #18137 Autowiring the concrete class too - consistent with behavior of other services (weaverryan)
 * bug #18087 [WebProfiler] Sidebar button padding (rvanlaak)
 * bug #18080 [HttpFoundation] Set the Content-Range header if the requested Range is unsatisfied (jakzal)
 * bug #18084 [HttpFoundation] Avoid warnings when checking malicious IPs (jakzal)
 * bug #18066 [Process] Fix pipes handling (nicolas-grekas)
 * bug #18078 [Console] Fix an autocompletion question helper issue with non-sequentially indexed choices (jakzal)
 * bug #18048 [HttpKernel] Fix mem usage when stripping the prod container (nicolas-grekas)
 * bug #18065 [Finder] Partially revert #17134 to fix a regression (jakzal)
 * bug #18018 [HttpFoundation] exception when registering bags for started sessions (xabbuh)
 * bug #18054 [Filesystem] Fix false positive in ->remove() (nicolas-grekas)
 * bug #18049 [Validator] Fix the locale validator so it treats a locale alias as a valid locale (jakzal)
 * bug #18019 [Intl] Update ICU to version 55 (jakzal)
 * bug #18015 [Process] Fix memory issue when using large input streams (romainneutron)
 * bug #16656 [HttpFoundation] automatically generate safe fallback filename (xabbuh)
 * bug #15794 [Console] default to stderr in the console helpers (alcohol)
 * bug #17984 Allow to normalize \Traversable when serializing xml (Ener-Getick)
 * bug #17434 Improved the error message when a template is not found (rvanginneken, javiereguiluz)
 * bug #17687 Improved the error message when using "@" in a decorated service (javiereguiluz)
 * bug #17744 Improve error reporting in router panel of web profiler (javiereguiluz)
 * bug #17894 [FrameworkBundle] Fix a regression in handling absolute template paths (jakzal)
 * bug #17990 [DoctrineBridge][Form] Fix performance regression in EntityType (kimlai)
 * bug #17595 [HttpKernel] Remove _path from query parameters when fragment is a subrequest (cmenning)
 * bug #17986 [DomCrawler] Dont use LIBXML_PARSEHUGE by default (nicolas-grekas)
 * bug #17668 add 'guid' to list of exception to filter out (garak)
 * bug #17615 Ensure backend slashes for symlinks on Windows systems (cpsitgmbh)
 * bug #17626 Try to delete broken symlinks (IchHabRecht)
 * bug #17978 [Yaml] ensure dump indentation to be greather than zero (xabbuh)
 * bug #16886 [Form] [ChoiceType] Prefer placeholder to empty_value (boite)
 * bug #17976 [WebProfilerBundle] fix debug toolbar rendering by removing inadvertently added links (craue)
 * bug #17971 Variadic controller params (NiR-, fabpot)
 * bug #17876 [DependencyInjection] Fixing autowiring bug when some args are set (weaverryan)
 * bug #17568 Improved Bootstrap form theme for hidden fields (javiereguiluz)
 * bug #17561 [WebProfilerBundle] Fix design issue in profiler when having errors in forms (Pierstoval)
 * bug #17925 [Bridge] The WebProcessor now forwards the client IP (magnetik)

* 2.8.3 (2016-02-28)

 * bug #17947 Fix - #17676 (backport #17919 to 2.3) (Ocramius)
 * bug #17942 Fix bug when using an private aliased factory service (WouterJ)
 * bug #17798  [Form] Fix BC break by allowing 'choice_label' option to be 'false' in ChoiceType (HeahDude)
 * bug #17542 ChoiceFormField of type "select" could be "disabled" (bouland)
 * bug #17602 [HttpFoundation] Fix BinaryFileResponse incorrect behavior with if-range header (bburnichon)
 * bug #17760  [Form] fix choice value "false" in ChoiceType (HeahDude)
 * bug #17914 [Console] Fix escaping of trailing backslashes (nicolas-grekas)
 * bug #17074 Fix constraint validator alias being required (Triiistan)
 * bug #17866 [DependencyInjection] replace alias in factories (xabbuh)
 * bug #17867 [DependencyInjection] replace alias in factory services (xabbuh)
 * bug #17860 Fixed the antialiasing of the toolbar text (javiereguiluz)
 * bug #17569 [FrameworkBundle] read commands from bundles when accessing list (havvg)
 * bug #16987 [FileSystem] Windows fix (flip111)
 * bug #17787 [Form] Fix choice placeholder edge cases (Tobion)
 * bug #17835 [Yaml] fix default timezone to be UTC (xabbuh)
 * bug #17823 [DependencyInjection] fix dumped YAML string (xabbuh)
 * bug #17818 [Console] InvalidArgumentException is thrown under wrong condition (robinkanters)
 * bug #17819 [HttpKernel] Prevent a fatal error when DebugHandlersListener is used with a kernel with no terminateWithException() method (jakzal)
 * bug #17814 [DependencyInjection] fix dumped YAML snytax (xabbuh)
 * bug #17099 [Form] Fixed violation mapping if multiple forms are using the same (or part of the same) property path (alekitto)
 * bug #17694  [DoctrineBridge] [Form] fix choice_value in EntityType (HeahDude)
 * bug #17790 [Config] Fix EnumNodeDefinition to allow building enum nodes with one element (ogizanagi)
 * bug #17729 [Yaml] properly parse lists in object maps (xabbuh)
 * bug #17719 [DependencyInjection] fixed exceptions thrown by get method of ContainerBuilder (lukaszmakuch)
 * bug #17742 [DependencyInjection] Fix #16461 Container::set() replace aliases (mnapoli)
 * bug #17745 Added more exceptions to singularify method (javiereguiluz)
 * bug #17691 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17766 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17757 [HttpFoundation] BinaryFileResponse sendContent return as parent. (2.3) (SpacePossum)
 * bug #17748 [DomCrawler] Remove the overridden getHash() method to prevent problems when cloning the crawler (jakzal)
 * bug #17725 [WebProfilerBundle] Add width attribute on SVG - Fix toolbar profiler on microsoft edge (AlexandrePavy)
 * bug #17703 [FrameworkBundle] Support autowiring for TranslationInterface (dunglas)
 * bug #17613 [WebProfiler] Fixed logo and menu profiler for Microsoft Edge (WhiteEagle88)
 * bug #17702 [TwigBridge] forward compatibility with Yaml 3.1 (xabbuh)
 * bug #17673 [Routing] add files used in FileResource objects (xabbuh)
 * bug #17672 [DependencyInjection][Routing] add files used in FileResource objects (xabbuh)
 * bug #17669 [Console] remove readline support (xabbuh)
 * bug #17600 Fixed the Bootstrap form theme for inlined checkbox/radio (javiereguiluz)
 * bug #17596 [Translation] Add resources from fallback locale to parent catalogue (c960657)
 * bug #17605 [FrameworkBundle] remove default null value for asset version (xabbuh)
 * bug #17606 [DependencyInjection] pass triggerDeprecationError arg to parent class (xabbuh)
 * bug #16956 [DependencyInjection] XmlFileLoader: enforce tags to have a name (xabbuh)
 * bug #16265 [BrowserKit] Corrected HTTP_HOST logic (Naktibalda)
 * bug #17559 [SecurityBundle] Fix HTTP Digest auth not being passed user checker (SamFleming)
 * bug #17554 [DependencyInjection] resolve aliases in factories (xabbuh)
 * bug #17555 [DependencyInjection] resolve aliases in factory services (xabbuh)
 * bug #17511 [Form] ArrayChoiceList can now deal with a null in choices (issei-m)
 * bug #17430 [Serializer] Ensure that groups are strings (dunglas)
 * bug #15272 [FrameworkBundle] Fix template location for PHP templates (jakzal)
 * bug #11232 [Routing] Fixes fatal errors with object resources in AnnotationDirectoryLoader::supports (Tischoi)
 * bug #17526 Escape the delimiter in Glob::toRegex (javiereguiluz)
 * bug #17527 fixed undefined variable (fabpot)
 * bug #15706 [framework-bundle] Added support for the `0.0.0.0/0` trusted proxy (zerkms)
 * bug #16274 [HttpKernel] Lookup the response even if the lock was released after two second wait (jakzal)
 * bug #16954 [TranslationUpdateCommand] fixed undefined resultMessage var. (aitboudad)
 * bug #17355 [DoctrineBridge][Validator] >= 2.3 Pass association instead of ID as argument (xavismeh)
 * bug #17330 Limit the max height/width of icons in the profiler menu (javiereguiluz)
 * bug #17454 Allow absolute URLs to be displayed in the debug toolbar (javiereguiluz)
 * bug #16736 [Request] Ignore invalid IP addresses sent by proxies (GromNaN)
 * bug #17459 [EventDispatcher] TraceableEventDispatcher resets event listener priorities (c960657)
 * bug #17486 [FrameworkBundle] Throw for missing container extensions (kix)
 * bug #16961 Overriding profiler position in CSS breaks JS positioning (aschempp)
 * bug #16873 Able to load big xml files with DomCrawler (zorn-v)
 * bug #16897 [Form] Fix constraints could be null if not set (DZunke)
 * bug #16912 [Translation][Writer] avoid calling setBackup if the dumper is not FileDumper (aitboudad)
 * bug #17505 sort bundles in config:dump-reference command (xabbuh)
 * bug #17514 [Asset] Add defaultNull to version configuration (ewgRa)
 * bug #16511 [Asset] Ability to set empty version strategy in packages (ewgRa)
 * bug #17457 Display Ajax requests from newest to oldest in the toolbar (javiereguiluz)
 * bug #17503 [Asset] CLI: use request context to generate absolute URLs (xabbuh)
 * bug #17478 [HttpFoundation] Do not overwrite the Authorization header if it is already set (jakzal)
 * bug #17461 [Yaml] tag for dumped PHP objects must be a local one (xabbuh)
 * bug #16822 [FrameworkBundle][Validator] Fix apc cache service deprecation (ogizanagi)
 * bug #17463 [Form] make tests compatible with Symfony 2.8 and 3.0 (xabbuh)
 * bug #17456 [DX] Remove default match from AbstractConfigCommand::findExtension (kix)
 * bug #17424 [Process] Update in 2.7 for stream-based output storage (romainneutron)
 * bug #17417 Fixed the form profiler when using long form types (javiereguiluz)
 * bug #17423 [Process] Use stream based storage to avoid memory issues (romainneutron)
 * bug #17406 [Form] ChoiceType: Fix a notice when 'choices' normalizer is replaced (paradajozsef)
 * bug #17433 [FrameworkBundle] Don't log twice with the error handler (nicolas-grekas)
 * bug #17418 Fixed Bootstrap form theme form "reset" buttons (javiereguiluz)
 * bug #17416 [PropertyInfo] PhpDocExtractor: Fix a notice when the property doesn'… (dunglas)
 * bug #17404 fix merge 2.3 into 2.7 for SecureRandom dependency (Tobion)
 * bug #17373 [SecurityBundle] fix SecureRandom service constructor args (Tobion)
 * bug #17382 [TwigBridge] Use label_format option for checkbox and radio labels (enumag)
 * bug #17380 [TwigBridge] Use label_format option for checkbox and radio labels (enumag)
 * bug #17377 Fix performance (PHP5) and memory (PHP7) issues when using token_get_all (nicolas-grekas, peteward)
 * bug #17389 [Routing] Fixed correct class name in thrown exception (fixes #17388) (robinvdvleuten)
 * bug #17358 [ClassLoader] Use symfony/polyfill-apcu (nicolas-grekas)
 * bug #17370 [HttpFoundation][Cookie] Cookie DateTimeInterface fix (wildewouter)

* 2.8.2 (2016-01-14)

 * security #17359 do not ship with a custom rng implementation (xabbuh, fabpot)
 * bug #17253 [Console] HHVM read input stream bug (mbutkereit)
 * bug #17314 Fix max width for multibyte keys in choice question (mheki)
 * bug #17326 [Console] Display console application name even when no version set (polc)
 * bug #17328 [Serializer] Allow to use proxies in object_to_populate (dunglas)
 * bug #17202 [FrameworkBundle] Don't log twice with the error handler (nicolas-grekas)
 * bug #17347  Workaround https://bugs.php.net/63206 (nicolas-grekas)
 * bug #17199 [Serializer] Allow context to contain not serializable data (dunglas, nicolas-grekas)
 * bug #17334 [WebProfiler] Fixed sf-minitoolbar height (yceruto)
 * bug #17140 [Serializer] Remove normalizer cache in Serializer class (jvasseur)
 * bug #17320 [Debug] Fixed erroneous deprecation notice for extended Interfaces (peterrehm)
 * bug #17307 [FrameworkBundle] Fix paths with % in it (like urlencoded) (scaytrase)
 * bug #17078 [Bridge] [Doctrine] [Validator] Added support \IteratorAggregate for UniqueEntityValidator (Disparity)
 * bug #17298 [FrameworkBundle] Use proper class to fetch $versionStrategy property (dosten)
 * bug #17287 [HttpKernel] Forcing string comparison on query parameters sort in UriSigner (Tim van Densen)
 * bug #17279 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17278 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17283 [WebProfilerBundle] Remove loading status from AJAX toolbar after error (kucharovic)
 * bug #17275 [PhpUnitBridge] Re-enable the garbage collector (nicolas-grekas)
 * bug #17276 [Process] Fix potential race condition (nicolas-grekas)
 * bug #17261 [FrameworkBundle] Allow to autowire service_container (dunglas)
 * bug #17183 [FrameworkBundle] Set the kernel.name properly after a cache warmup (jakzal)
 * bug #17197 [Yaml] cast arrays to objects after parsing has finished (xabbuh)
 * bug #17247 Fix toolbar display when nvd3 is loaded on page (Seldaek)
 * bug #17159 [Yaml] recognize when a block scalar is left (xabbuh)
 * bug #17195 bug #14246 [Filesystem] dumpFile() non atomic (Hidde Boomsma)
 * feature #16747 [Form] Improved performance of ChoiceType and its subtypes (webmozart)
 * bug #17179 [WebProfiler] Removed an object as route generator argument (iltar)
 * bug #17177 [Process] Fix potential race condition leading to transient tests (nicolas-grekas)
 * bug #17163 [Form] fix Catchable Fatal Error if choices is not an array (Gladhon, nicolas-grekas)
 * bug #17152 [DoctrineBridge] [PropertyInfo] Catch Doctrine\ORM\Mapping\MappingException (dunglas)
 * bug #17119 [Form] improve deprecation message for "empty_value" and "choice_list" options. (hhamon)
 * bug #17156 [HttpFoundation] add missing symfony/polyfill-php55 dependency (xabbuh)
 * bug #17162 [Form] Fix regression on Collection type (hason)

* 2.8.1 (2015-12-26)

 * bug #16864 [Yaml] fix indented line handling in folded blocks (xabbuh)
 * bug #17052  Fixed flatten exception recursion with errors (GrahamCampbell)
 * bug #16826 Embedded identifier support (mihai-stancu)
 * bug #17079 Also transform inline mappings to objects (WouterJ)
 * bug #17129 [Config] Fix array sort on normalization in edge case (romainneutron)
 * feature #17035 [DomCrawler] Revert previous restriction, allow selection of every DOMNode object  (EdgarPE)
 * bug #17094 [Process] More robustness and deterministic tests (nicolas-grekas)
 * bug #17112 [PropertyAccess] Reorder elements array after PropertyPathBuilder::replace (alekitto)
 * bug #17109 Improved the design of the web debug toolbar (javiereguiluz)
 * bug #16797 [Filesystem] Recursivly widen non-executable directories (Slamdunk)
 * bug #16926 [DependencyInjection] fixed definition loosing property shared when decorated by a parent definition (wahler)
 * bug #17040 [Console] Avoid extra blank lines when rendering exceptions (ogizanagi)
 * bug #17044 [Form] fix BC break introduced with prototype_data option (memphys)
 * bug #17055 [Security] Verify if a password encoded with bcrypt is no longer than 72 characters (jakzal)
 * bug #16959 [Form] fix #15544 when a collection type attribute "required" is false, "prototype" should too (HeahDude)
 * bug #16806 [Validator] BicValidator - fixed raising violations to a maximum of one (mvhirsch)
 * bug #16842 [Ldap] Escape carriage returns in LDAP DNs. (ChadSikorra)
 * bug #16860 [Yaml] do not remove "comments" in scalar blocks (xabbuh)
 * bug #17002 [Console][Table] fixed render row that contains multiple cells. (aitboudad)
 * bug #16964 CSS min-height and min-width should not be "auto" (aschempp)
 * bug #16971 [HttpFoundation] Added the ability of using BinaryFileResponse with stream wrappers (jakzal, Sander-Toonen)
 * bug #17048 Fix the logout path when not using the router (stof)
 * bug #17049 Fix the logout path when not using the router (stof)
 * bug #17057 [FrameworkBundle][HttpKernel] the finder is required to discover bundle commands (xabbuh)
 * bug #17059 [HttpFoundation] fix error level for deprecation (xabbuh)
 * bug #17006 [Form] Fix casting regression in DoctrineChoiceLoader (bendavies)
 * bug #16911 [PropertyInfo] Update List Information from ReflectionExtractor (zanderbaldwin)
 * bug #16955 [FrameworkBundle] ContainerDebugCommand: pass the right object to the descriptors (xabbuh)
 * feature #16760 Show silenced errors in separate tab (peterrehm)
 * feature #16937 [PhpUnitBridge] Replace "weak-verbose" by "deprecations upper bound" mode (nicolas-grekas)
 * bug #16915 [Process] Enhance compatiblity with --enable-sigchild (nicolas-grekas)
 * bug #16829 [FrameworkBundle] prevent cache:clear creating too long paths (Tobion)
 * bug #16922 [FrameworkBundle] [Bug] Fixes new InputStyle bug #16920 (AlmogBaku)
 * bug #16921 Fix short array syntax for php 5.3 (ewgRa)
 * bug #16450 [Serializer] Fixed `array_unique` on array of objects in `getAllowedAttributes`. (CornyPhoenix)
 * bug #16757 [FrameworkBundle] [Translation] Fixed translations not written when no translations directory in update command (jeremyFreeAgent)
 * bug #16902 [Security] Fix a Polyfill import statement in StringUtils (magnetik)
 * bug #16871 [FrameworkBundle] Disable built-in server commands when Process component is missing (gnugat, xabbuh)
 * bug #16870 [FrameworkBundle] Disable the server:run command when Process component is missing (gnugat, xabbuh)
 * feature #16789 [PhpUnitBridge] Add weak-verbose mode and match against message instead of test name (nicolas-grekas)
 * bug #16796 [Form] Fix choices defined as Traversable (nicolas-grekas)
 * bug #16742 [Console][ProgressBar] redrawFrequency should never be 0 (dritter)
 * bug #16846 [MonologBridge] Monolog Bridge 2.8 is incompatible with HttpKernel 3.0 (derrabus)
 * bug #16799 Improve error message for undefined DIC aliases (mpdude)
 * bug #16825 [VarDumper] fix .sf-dump z-index (debug bar conflict) (Antoine LA)
 * bug #16772 Refactoring EntityUserProvider::__construct() to not do work, cause cache warm error (weaverryan)

* 2.8.0 (2015-11-30)

 * bug #16758 Fix BC for the default root form name (stof)
 * bug #16753 [Process] Fix signaling/stopping logic on Windows (nicolas-grekas)
 * feature #16755 [Security] add subject variable to expression context (xabbuh)
 * bug #16642 [DI][autowiring] throw exception when many services use the same class. (aitboudad)
 * bug #16745 [Yaml] look for colon in parsed inline string (xabbuh)
 * bug #16733 [Console] do not encode backslashes in console default description (Tobion)
 * feature #16735 [WIP] [Ldap] Marked the Ldap component as internal (csarrazi)
 * bug #16734 Make sure security.role_hierarchy.roles always exists (WouterJ)
 * feature #16722 [Security][SecurityBundle] Use csrf_token_id instead of deprecated intention (jakzal)
 * bug #16312 [HttpKernel] clearstatcache() so the Cache sees when a .lck file has been released (mpdude)
 * bug #16351 [WIP] [Form] [TwigBridge] Bootstrap horizontal theme missing tests (pieter2627)
 * bug #16685 [Form] Fixed: Duplicate choice labels are remembered when using "choices_as_values" = false (webmozart)
 * feature #16709 [Bridge\PhpUnit] Display the stack trace of a deprecation on-demand (nicolas-grekas)
 * bug #16704 [Form+SecurityBundle] Trigger deprecation for csrf_provider+intention options (nicolas-grekas)
 * feature #16706 [HttpFoundation] Deprecate $deep parameter on ParameterBag (nicolas-grekas)
 * bug #16705 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * feature #16690 [Form] Deprecated ArrayKeyChoiceList (webmozart)
 * feature #16687 [Form] Deprecated TimezoneType::getTimezones() (webmozart)
 * bug #16681 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * bug #16695 [SecurityBundle] disable the init:acl command if ACL is not used (Tobion)
 * bug #16677 [Form] Fixed wrong usages of the "text" type (webmozart)
 * bug #16679 [Form] Disabled view data validation if "data_class" is set to null (webmozart)
 * bug #16621 [Console] Fix bug with $output overloading (WouterJ)
 * feature #16601 [Security] Deprecate "AbstractVoter" in favor of "Voter" (nicolas-grekas, lyrixx)
 * bug #16676 [HttpFoundation] Workaround HHVM rewriting HTTP response line (nicolas-grekas)
 * bug #16668 [ClassLoader] Fix parsing namespace when token_get_all() is missing (nicolas-grekas)
 * bug #16386 Bug #16343 [Router] Too many Routes ? (jelte)
 * bug #16498 fix unused variable warning (eventhorizonpl)
 * feature #16031 [Translation][Form] Do not translate form labels and placeholders when 'translation_domain' is false (Restless-ET)
 * bug #16651 [Debug] Ensure class declarations are loaded only once (nicolas-grekas)
 * security #16631 CVE-2015-8124: Session Fixation in the "Remember Me" Login Feature (xabbuh)
 * security #16630 CVE-2015-8125: Potential Remote Timing Attack Vulnerability in Security Remember-Me Service (xabbuh)
 * bug #16633 [Filesystem] Fixed failing test due to tempdir symlink (toretto460)
 * bug #16609 [HttpKernel] Don't reset on shutdown but in FrameworkBundle/Test/KernelTestCase (nicolas-grekas)
 * bug #16477 [Routing] Changing RouteCollectionBuilder::import() behavior to add to the builder (weaverryan)
 * bug #16588 Sent out a status text for unknown HTTP headers. (dawehner)
 * bug #16295 [DependencyInjection] Unescape parameters for all types of injection (Nicofuma)
 * bug #16377 [WebProfilerBundle] Fix minitoolbar height (rvanlaak)
 * bug #16585 Add support for HTTP status code 418 back (dawehner)
 * bug #16574 [Process] Fix PhpProcess with phpdbg runtime (nicolas-grekas)
 * bug #16581 Fix call to undefined function json_last_error_message (dawehner)
 * bug #16573 [FrameworkBundle] Fix PropertyInfo extractor namespace in framework bundle (jvasseur)
 * bug #16578 [Console] Fix bug in windows detection (kbond)
 * bug #16546 [Serializer] ObjectNormalizer: don't serialize static methods and props (dunglas)
 * bug #16352 Fix the server variables in the router_*.php files (leofeyer)
 * bug #16537 [Validator] Allow an empty path with a non empty fragment or a query (jakzal)
 * bug #16528 [Translation] Add support for Armenian pluralization. (marcosdsanchez)
 * bug #16510 [Process] fix Proccess run with pts enabled (ewgRa)

* 2.8.0-BETA1 (2015-11-16)

 * feature #16156 [Filesystem] Changed dumpFile to allow dumping to streams (markchalloner, pierredup)
 * feature #16502 [Bridge\PhpUnit] Add extra clock-mocked namespaces in phpunit.xml.dist (nicolas-grekas)
 * feature #16464 [DependencyInjection] Fix some edge cases with autowiring (dunglas)
 * feature #16433 [Yaml] deprecate unquoted indicator characters (xabbuh)
 * feature #16419 [FrameworkBundle][Form] Better exception message for private form tagged services (ogizanagi)
 * feature #15990 added a micro kernel (fabpot)
 * feature #16459 [Security\Core] Deprecate passing $salt to BCryptPasswordEncoder::encodePassword() (nicolas-grekas)
 * feature #16409 [Console] Add progress indicator helper (kbond)
 * feature #16423 [VarDumper] Deprecate VarDumperTestCase in favor of the trait (nicolas-grekas)
 * feature #16424 [DI] Deprecate ContainerAware in favor of ContainerAwareTrait (nicolas-grekas)
 * feature #16430 [HttpKernel] PostResponseEvent should extend the KernelEvent (jakzal)
 * feature #16325 [VarDumper] Casters for Generator, ReflectionGenerator and ReflectionType (nicolas-grekas)
 * feature #16395 checkCredentials() force it to be an affirmative yes! (weaverryan)
 * feature #16344 [WebProfilerBundle] Filter links in search results (Rvanlaak)
 * feature #16285 [Yaml] deprecated usage of @ and ` at the beginning of an unquoted string (fabpot)
 * feature #16317 Rely on iconv and symfony/polyfill-* (nicolas-grekas)
 * feature #15966 [FrameworkBundle] PropertyInfo support (dunglas)
 * feature #16161 [Validator] Add expressionLanguage to ExpressionValidator constructor (enumag)
 * feature #16263 [FrameworkBundle] Add a new ClassCache cache warmer (tucksaun)
 * feature #16271 [TwigBundle] added a Twig templates warmer when templating is disabled (fabpot)
 * feature #16276 Unify URL generator reference type + make linking in php templates consistent with twig (Tobion)
 * feature #15947 Added UserLoaderInterface for loading users through Doctrine. (mtrojanowski)
 * feature #16194 [PhpUnit] Mock clock on @group time-sensitive annotations (nicolas-grekas)
 * feature #16201 [Yaml] deprecated non-escaped \ in double-quoted strings when parsing (fabpot)
 * feature #16198 [EventDispatcher] added EventDispatcher::getListenerPriority() (fabpot)
 * feature #15025 [2.8] [Form] Rename CollectionType options for entries (WouterJ)
 * feature #16189 [PhpUnitBridge] Add SkippedTestsListener to collect and replay skipped tests (nicolas-grekas)
 * feature #15879 Deprecate the SecureRandom class (pierredup)
 * feature #16001 [DI] Warn when a definition relies on a deprecated class in ContainerBuilder::createService() (nicolas-grekas)
 * feature #14044 [Console] [Helper] [Table] Columns styles (MAXakaWIZARD)
 * feature #14908 Include working directory in ProcessFailedException (Rvanlaak)
 * feature #16102 Simplify AbstractVoter (Koc)
 * feature #15613 [DependencyInjection] Add autowiring capabilities (dunglas)
 * feature #14721 [Security] Configuring a user checker per firewall (iltar)
 * feature #16069 [WebProfilerBundle] Move AjaxCollector to HttpKernel for use with Silex (glaubinix, fabpot)
 * feature #16063 [VarDumper] Add $this->getDump($var) when using VarDumperTestTrait (nicolas-grekas)
 * feature #16058 Prevent adding non-DOMElement elements in DomCrawler (stof)
 * feature #16057 Deprecate loading multiple documents in the same crawler (stof)
 * feature #15742 Using a service as a router resource (weaverryan)
 * feature #15778 Fluid interface for building routes in PHP (weaverryan)
 * feature #16029 [FrameworkBundle][TwigBridge] do not render empty form action attributes (xabbuh)
 * feature #15938 [Console] Bind input before executing the COMMAND event (WouterJ)
 * feature #15503 UI & CSS improvement to new toolbar (WouterJ)
 * feature #15838 [VarDumper] Dump PHP+Twig code excerpts in backtraces (nicolas-grekas)
 * feature #16011 [FrameworkBundle] Tag deprecated services (nicolas-grekas)
 * feature #15944 Remove profiler storages (javiereguiluz)
 * feature #16007 [HttpFoundation] deprecate finding deep items in request parameters (xabbuh)
 * feature #15978 Updated the styles of the cache commands (javiereguiluz)
 * feature #15972 [Console] Updated the styles of the server commands (javiereguiluz)
 * feature #15964 Symfony Console Style tweaks (javiereguiluz)
 * feature #15919 [Form] Guess currency field based on validator constraint (enumag)
 * feature #15934 Add a non-static API for the CssSelector component (stof)
 * feature #14235 [FrameworkBundle] Refactored assets:install command and apply Symfony styles (1ed)
 * feature #15963 added logging of unused tags (Marmelatze, fabpot)
 * feature #15970 [TwigBundle] removed usage of Templating classes (fabpot)
 * feature #14132 Applied the new styles to the router: commands (javiereguiluz)
 * feature #15356 [WebProfilerBundle] Profiler View Latest should preserve all the current query parameters (jbafford)
 * feature #15953 [TwigBridge] is_granted no longer raise an exception if the token storage is empty (lyrixx)
 * feature #14602 [2.8] [Ldap] Added support for LDAP (New Component + integration in the Security Component). (csarrazi, lyrixx)
 * feature #15939 Removed the "Delete profiles" action from the web profiler sidebar (javiereguiluz)
 * feature #15962 [Finder] simplified code (fabpot)
 * feature #15882 Easier Custom Authentication errors (weaverryan)
 * feature #15907 [DomCrawler] Deprecate methods inherited from SplObjectStorage (stof)
 * feature #15301 [Form][Type Date/Time] added choice_translation_domain option. (aitboudad)
 * feature #15697 [BrowserKit] Added isFollowingRedirects and getMaxRedirects methods (Naktibalda)
 * feature #15719 Deprecate ResourceInterface::getResource() (mpdude)
 * feature #15818 [WebProfilerBundle] Add collapsed sidebar on small screens (hason)
 * feature #15858 [PropertyInfo] Import the component (dunglas)
 * feature #15892 deprecated the Shell Console class (fabpot)
 * feature #15519 [Validator] added BIC (SWIFT-BIC) validation constraint (mvhirsch)
 * feature #12587 [TwigBridge] Foundation form layout integration (totophe)
 * feature #15151 [Security] Deprecated supportsAttribute and supportsClass methods (WouterJ)
 * feature #15491 Add support for deprecated definitions (Taluu)
 * feature #14894 [Console] Add domain exceptions to replace generic exceptions (GromNaN)
 * feature #15738 Implement service-based Resource (cache) validation (mpdude)
 * feature #14673 New Guard Authentication System (e.g. putting the joy back into security) (weaverryan)
 * feature #15870 Updating AbstractVoter so that the method receives the TokenInterface (weaverryan)
 * feature #15786 [Translation][File dumper] allow get file content without writing in file. (aitboudad)
 * feature #15805 [Finder] Deprecate adapters and related classes (nicolas-grekas)
 * feature #15837 [VarDumper] Add EnumStub for dumping virtual collections with casters (nicolas-grekas)
 * feature #15699 [Translator][FileDumper] deprecated format method in favor of formatCatalogue. (aitboudad)
 * feature #15717 [Translator][Loader] added XLIFF 2.0 support. (xphere, aitboudad)
 * feature #15743 Validate the extended type for lazy-loaded type extensions (stof)
 * feature #13761 Automatically process extensions when they implement CompilerPassInterface (WouterJ)
 * feature #15787 [VarDumper] Add caster for OuterIterator objects (nicolas-grekas)
 * feature #13616 [HttpKernel] Add entry point to more easily create/configure the DI extension (egeloen)
 * feature #14378 [DX] Added a logout link in the security panel of the web debug toolbar (javiereguiluz)
 * feature #15620 [WIP] #15502 Make template shortcuts be usable without Templating component (Koc)
 * feature #15523 Redesigned the Symfony Profiler (javiereguiluz)
 * feature #15773 Make the exception output visible even in quiet mode, fixes #15680 (Seldaek)
 * feature #15772 Convert Output::write's type to an options arg where verbosity can be passed in as well (Seldaek)
 * feature #15756 [Translation] added option json_options to JsonFileDumper. (gepo)
 * feature #15724 [HttpKernel] Move required RequestStack args as first arguments (nicolas-grekas)
 * feature #15521 [Debug] Add BufferingLogger for errors that happen before a proper logger is configured (nicolas-grekas)
 * feature #15709 [WebProfilerBundle] deprecated import/export commands (fabpot)
 * feature #15710 added ExceptionHandler::getHtml() to expose the full HTML of an exception (fabpot)
 * feature #15562 [translation] Deprecated DiffOperation (zerustech)
 * feature #15635 [Config] Prototypes info (ogizanagi)
 * feature #15551 [Translation] added <tool> element metadata to XliffFileDumper (aitboudad)
 * feature #15555 [VarDumper] Add caster for pgsql resources (nicolas-grekas)
 * feature #15452 [Translator] [Xliff] Add support for target attributes. (marcosdsanchez)
 * feature #15416 [DependencyInjection] Added a way to define the priority of service decoration (dosten)
 * feature #15433 Allow to define Enum nodes with 1 single element (javiereguiluz)
 * feature #13990 [Form] Add flexibility for EntityType (raziel057)
 * feature #15382 [Console] Use readline for user input when available #DX (michaelperrin)
 * feature #15013 [Security] Removed security-acl from the core (iltar)
 * feature #15079 [Form] Deprecated FormTypeInterface::getName() and passing of type instances (webmozart)
 * feature #15418 [Debug] Deprecate ExceptionHandler::createResponse (nicolas-grekas)
 * feature #15123 [2.8][FrameworkBundle] Allow parameter use_cookies in session configuration (derrabus)
 * feature #14987 [FrameworkBundle] Configurable Serializer name converter (dunglas)
 * feature #15285 [Config] deprecate cannotBeEmpty() for boolean and numeric nodes (xabbuh)
 * feature #15372 [FrameworkBundle] Change the default value of cookie_httponly (jderusse)
 * feature #15160 Redesigned the web debug toolbar (javiereguiluz)
 * feature #15185 Implement resettable containers (stof)
 * feature #15131 [Security] Moved Simple{Form,Pre}AuthenticatorInterfaces to Security\Http (WouterJ)
 * feature #15290 [DependencyInjection] Forbid container cloning (jakzal)
 * feature #14264 [WebProfilerBundle] Add link to show profile of latest request (xelaris)
 * feature #15139 [Translation] Add parameters to DataCollectorTranslator (damienalexandre)
 * feature #15175 [VarDumper] Ingore PHPUnit and Prophecy object when they are nested (lyrixx)
 * feature #15141 [DX] [Security] Renamed Token#getKey() to getSecret() (WouterJ)
 * feature #15154 [Validator] Added missing error codes and turned codes into UUIDs (webmozart)
 * feature #15096 [DependencyInjection] Allow anonymous DefinitionDecorator resolving (nicolas-grekas)
 * feature #14764 [TwigBundle] Warmup twig templates in non-standard paths (kbond)
 * feature #15134 [FrameworkBundle] add option to force web server startup (xabbuh)
 * feature #14238 [config] added remove option to ignoreExtraKeys (twifty)
 * feature #15076 [Debug] Allow throwing from __toString() with `return trigger_error($e, E_USER_ERROR);` (nicolas-grekas)
 * feature #14984 [DependencyInjection] Deprecate scope concept (dosten)
 * feature #14429 [FrameworkBundle] Add a doctrine cache service definition for validator mapping (jakzal)
 * feature #14991 [Console][Table] allow multiple render() calls. (jaytaph)
 * feature #14660 [Form] moved data trimming logic of TrimListener into StringUtil (issei-m)
 * feature #15019 [Form] Deprecated "cascade_validation" (webmozart)
 * feature #12314 [Form] Add "prototype_data" option to collection type (kgilden)
 * feature #12067 [Form] Added the 'range' FormType (jaytaph)
 * feature #14993 [Profiler][Translation] added filter. (aitboudad)
 * feature #14912 [HttpFoundation] Postpone setting the date header on a Response (jakzal)
 * feature #14903 [profiler][request toolbar] Removed route name from the toolbar (MJBGO)
 * feature #14904 [toolbar] Merged colored icons in toolbar (MJBGO)
 * feature #14781 [TwigBundle] Reconfigure twig paths when they are updated (chbruyand)
 * feature #14700 [DependencyInjection] [Routing] [Config] Recursive directory loading (lavoiesl, nicolas-grekas)
 * feature #14733 [Security] Add setVoters() on AccessDecisionManager (nicolas-grekas)
 * feature #14756 [Serializer] Support for array denormalization (derrabus)
 * feature #14630 [Translator] Dump translation constants as tree instead of simple list (gepo)
 * feature #14403 [Form] deprecate read_only option (Tobion)
 * feature #13324 [WebProfilerBundle] Improved page for logs (hason)
 * feature #14561 [FrameworkBundle][DX] Add option to specify additional translation loading paths (Seldaek)
 * feature #14563 [FrameworkBundle][EventDispatcher] Add priorities to the debug:event-dispatcher command (Seldaek)
 * feature #14546 [Translator] deprecate getMessages in favor of getCatalogue. (aitboudad)
 * feature #14320 [Translation] added an --all option to the debug:translation command #14237 (sgehrig)
 * feature #14473 [DX] Minor improvement for the translation:debug output (nicolasdewez)
 * feature #14443 [VarDumper] Allow preserving a subset of cut arrays (nicolas-grekas)
 * feature #14431 [Console] Bind the closure (code) to the Command if possible (lyrixx)
 * feature #14424 [VarDumper] Added support for SplFileInfo (lyrixx)
 * feature #14359 [Translation] added FileLoader. (aitboudad)
 * feature #14383 [FrameworkBundle][Server Command] add address port number option. (aitboudad)
