//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ModTabPanel.h"
#pragma package(smart_init)
#include <swmgr.h>
#include "TextPanel.h"
#include "CommentPanel.h"
#include "LDPanel.h"
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TModTabPanel *)
{
	new TModTabPanel(NULL);
}
//---------------------------------------------------------------------------
__fastcall TModTabPanel::TModTabPanel(TComponent* Owner, SWMgr *mgr, char *modType)
	: TPanel(Owner)
{
	this->mgr = mgr;
	this->modType = modType;
}

void __fastcall TModTabPanel::CreateWnd() {
	TPanel::CreateWnd();
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	char *font;
	this->DragMode = dmAutomatic;
	this->DragKind = dkDock;
	this->UseDockManager = true;
	pageControl = new TPageControl(this);
	pageControl->Parent = this;
	pageControl->Align = alClient;
	pageControl->MultiLine = True;
	pageControl->ParentFont = False;
	pageControl->ParentShowHint = False;
	pageControl->ShowHint = True;
	pageControl->TabHeight = 14;
	pageControl->TabOrder = 0;
	pageControl->OnChange = PageControl1Change;
	for (it = mgr->Modules.begin(); it != mgr->Modules.end(); it++) {
		if ((!strcmp((*it).second->Type(), "Biblical Texts")) && (!strcmp(modType.c_str(), "Biblical Texts"))) {
			font = 0;
			if ((sit = mgr->config->Sections.find((*it).second->Name())) != mgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end()) {
					font = (char *)(*eit).second.c_str();
				}
			}
			TTabSheet *newtab = new TTabSheet(this);
			newtab->Caption = (*it).second->Name();
			newtab->Hint = (*it).second->Description();
			newtab->PageControl = pageControl;
			TTextPanel *panel = new TTextPanel(this, (*it).second, font);
			panel->Parent = newtab;
			panel->Align = alClient;
//			CreateTextPane((*it).second, font);
		}
		if ((!strcmp((*it).second->Type(), "Commentaries")) && (!strcmp(modType.c_str(), "Commentaries"))) {
			TTabSheet *newtab = new TTabSheet(this);
			newtab->Caption = (*it).second->Name();
			newtab->Hint = (*it).second->Description();
			newtab->PageControl = pageControl;
			TCommentPanel *panel = new TCommentPanel(this, (*it).second, mgr);
			panel->Parent = newtab;
			panel->Align = alClient;
//			CreateCommentPane((*it).second);
		}
		if ((!strcmp((*it).second->Type(), "Lexicons / Dictionaries")) && (!strcmp(modType.c_str(), "Lexicons / Dictionaries"))) {
			TTabSheet *newtab = new TTabSheet(this);
			newtab->Caption = (*it).second->Name();
			newtab->Hint = (*it).second->Description();
			newtab->PageControl = pageControl;
			TLDPanel *panel = new TLDPanel(this, (*it).second, mgr);
			panel->Parent = newtab;
			panel->Align = alClient;
//			CreateLDPane((*it).second);
		}
	}
}
//---------------------------------------------------------------------------
namespace Modtabpanel
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TModTabPanel)};
		RegisterComponents("Samples", classes, 0);
	}
}
//---------------------------------------------------------------------------
void __fastcall TModTabPanel::PageControl1Change(TObject *Sender)
{
	RefreshActiveSheet();
//	Form1->ActiveControl = PageControl1;
}


void TModTabPanel::RefreshActiveSheet()
{
	ModMap::iterator it;
	
	it = mgr->Modules.find(pageControl->ActivePage->Caption.c_str());
	if (it != mgr->Modules.end()) {
		(*it).second->Display();
//		if (logmodstate)
//			modstates.insert(modstates.begin(), new ModState(pc, pc->ActivePage, (*it).second->KeyText()));
	}
}
 