//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FontSel.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma resource "*.dfm"
TFontSelFrm *FontSelFrm;
//---------------------------------------------------------------------------
__fastcall TFontSelFrm::TFontSelFrm(TComponent* Owner)
	: TForm(Owner)
{
     Font = new TFont;
     FontComboBox->ItemIndex = FontComboBox->Items->IndexOf("Arial");
     SizeComboBox->ItemIndex = SizeComboBox->Items->IndexOf("10");
     BackColor = clWhite;
     Font->Color = clBlack;
     initialized = false;
}
//---------------------------------------------------------------------------


void __fastcall TFontSelFrm::FormShow(TObject *Sender)
{
     BackColorDlg->Color = BackColor;
     BGColorCmb->ColorValue = BackColor;
     ForeColorDlg->Color = Font->Color;
     FGColorCmb->ColorValue = Font->Color;
     FontComboBox->ItemIndex = FontComboBox->Items->IndexOf(Font->Name);
     SizeComboBox->ItemIndex = SizeComboBox->Items->IndexOf(Font->Size);
     UpdatePreview();
     initialized = true;
}

void TFontSelFrm::UpdatePreview()
{
     if(Font)
     {
      	SampleText->Font->Color = Font->Color;
      	SampleText->Color = BackColor;
     	SampleText->Font->Size = Font->Size;
     	SampleText->Font->Name = Font->Name;
     }
}

void __fastcall TFontSelFrm::ckShowFontClick(TObject *Sender)
{
	if(ckShowFont->Checked)
       	FontComboBox->UseFonts = true;
     else
       	FontComboBox->UseFonts = false;

}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::FontComboBoxChange(TObject *Sender)
{
     Font->Name = FontComboBox->Text;
  	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::SizeComboBoxChange(TObject *Sender)
{
     Font->Size = SizeComboBox->Text.ToInt();
	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::BGColorCmbChange(TObject *Sender)
{
	if(BGColorCmb->Items->Strings[BGColorCmb->ItemIndex] == "More..."){
     	BackColorDlg->Execute();
	     BGColorCmb->ColorValue = BackColorDlg->Color;
          BackColor = BackColorDlg->Color;
     }else if(initialized == true){
     	BackColorDlg->Color = BGColorCmb->ColorValue;
          BackColor = BGColorCmb->ColorValue;
     }

     UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::FGColorCmbChange(TObject *Sender)
{
	if(FGColorCmb->Items->Strings[FGColorCmb->ItemIndex] == "More..."){
     	ForeColorDlg->Execute();
          FGColorCmb->ColorValue = ForeColorDlg->Color;
          Font->Color = ForeColorDlg->Color;
     }else if(initialized == true){
	     ForeColorDlg->Color = FGColorCmb->ColorValue;
          Font->Color = FGColorCmb->ColorValue;
     }

     UpdatePreview();

}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::OKBtnClick(TObject *Sender)
{
	ModalResult = mrOk;
     initialized = false;
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::CancelBtnClick(TObject *Sender)
{
	ModalResult = mrCancel;
     initialized = false;
}
//---------------------------------------------------------------------------

