//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StatusFrm.h"
#include "MainFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TStatusForm *StatusForm;
//---------------------------------------------------------------------------
__fastcall TStatusForm::TStatusForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TStatusForm::FormShow(TObject *Sender)
{
	abort = false;
	ftpThread = new TFTPThread(ist, src.c_str(), dest.c_str(), dirTransfer, true);
	ftpThread->OnTerminate = Cleanup;
	ftpThread->Resume();
}
//---------------------------------------------------------------------------
__fastcall TStatusForm::TFTPThread::TFTPThread(InstallSourceTab *iist, const char *isrc, const char *idest, bool idirTransfer, bool CreateSuspended)
	: TThread(CreateSuspended)
{
	ist = iist;
	src = isrc;
	dest = idest;
	dirTransfer = idirTransfer;
	Priority = tpNormal;
	FreeOnTerminate = true;
	Synchronize((TThreadMethod)&CreateFTPObject);
}

__fastcall TStatusForm::TFTPThread::~TFTPThread()
{
	delete FTPLink;
}


void __fastcall TStatusForm::TFTPThread::Execute()
{
	Synchronize((TThreadMethod)&PreConnect);
	FTPLink->OnPacketRecvd = FTPLinkPacketRecvd;
	FTPLink->ParseList = true;
	FTPLink->Host = ist->Source.c_str();
	FTPLink->Port = 21;
	FTPLink->UserID = "ftp";
	FTPLink->Password = "installmgr@user.com";
	
	try {
		FTPLink->Connect();
		FTPLink->Mode(MODE_IMAGE);
		FTPLink->ChangeDir(ist->Directory.c_str());
	}
	catch(...) {
		StatusForm->Button1Click(0);	// abort thread
	}
	
	if (!Terminated) {
		if (dirTransfer) {
			FTPLink->ChangeDir(src.c_str());
			fileList.clear();
			FTPLink->List();
			int fileCount = FTPLink->FTPDirectoryList->name->Count;
			for (int i = 0; i < fileCount; i++) {
				if (FTPLink->FTPDirectoryList->Attribute->Strings[i].c_str()[0] != 'd') {
					buffer = dest + "/" + FTPLink->FTPDirectoryList->name->Strings[i].c_str();
					buffer2 = "Downloading (";
					buffer2 += IntToStr(i+1).c_str();
					buffer2 += " of ";
					buffer2 += IntToStr(fileCount).c_str();
					buffer2 += "): ";
					buffer2 += FTPLink->FTPDirectoryList->name->Strings[i].c_str();
	//				SWLog::systemlog->LogInformation("%s", buffer.c_str());
					TMainForm::createParent(buffer.c_str());	// make sure parent directory exists
					Synchronize((TThreadMethod)&PreDownload1);
					try {
					FTPLink->Download(FTPLink->FTPDirectoryList->name->Strings[i].c_str(), buffer.c_str());
					}
					catch(...) {}
					if (Terminated)
						break;
				}
			}
		
		}
		else {
			Synchronize((TThreadMethod)&PreDownload2);
			FTPLink->Download(src.c_str(), dest.c_str());
		}
		try {
		FTPLink->Disconnect();
		}
		catch(...){}
	}
}


void __fastcall TStatusForm::TFTPThread::FTPLinkPacketRecvd(TObject *Sender)
{
	Synchronize((TThreadMethod)&UpdateBytes);
}


void __fastcall TStatusForm::TFTPThread::UpdateBytes(void)
{
	StatusForm->statusBar->Caption = IntToStr(FTPLink->BytesRecvd) + " bytes out of " + IntToStr(FTPLink->BytesTotal) + " transferred (" + IntToStr((int)((float)(FTPLink->BytesRecvd + 1) / (float)(FTPLink->BytesTotal + 1) * 100)) + "%)";
	StatusForm->statusBar->Repaint();
}


void __fastcall TStatusForm::TFTPThread::CreateFTPObject(void)
{
	FTPLink = new TNMFTP(0);
}


void __fastcall TStatusForm::TFTPThread::PreConnect(void)
{
	buffer = "Connecting to server at ";
	buffer += ist->Source.c_str();
	buffer += "...";
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload1(void)
{
//	SWLog::systemlog->LogInformation("Creating parent dir: %s", buffer.c_str());
//	SWLog::systemlog->LogInformation("Return: %d", ret);
	StatusForm->actionBar->Caption = buffer2.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload2(void)
{
	buffer = "Downloading: ";
	buffer += src.c_str();
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
	MainForm->createParent(dest.c_str());	// make sure parent directory exists
}


void __fastcall TStatusForm::Cleanup(TObject *Sender)
//void __fastcall TStatusForm::TFTPThread::Cleanup()
{
	if (abort)
		StatusForm->ModalResult = mrCancel;
	else	StatusForm->ModalResult = mrOk;
//	StatusForm->Close();
}

void __fastcall TStatusForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	MainForm->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TStatusForm::Button1Click(TObject *Sender)
{
	abort = true;
	ftpThread->Terminate();
	ftpThread->FTPLink->Abort();
}
//---------------------------------------------------------------------------

