#include <dirent.h>

#include <io.h>



#ifdef _WIN32_WCE

#include <swordce.h>

#include <stdio.h>

#endif



DIR* opendir( const char *pSpec )

{

	DIR *pDir = (DIR*) malloc(sizeof(DIR));

#ifdef _WIN32_WCE

	pDir->hFind = FindFirstFile(strtowstr(strcmp(pSpec, ".") ? pSpec : "*"), &pDir->wfd);

#else

	pDir->hFind = FindFirstFile((strcmp(pSpec, ".") ? pSpec : "*"), &pDir->wfd);

#endif

	return pDir;

}



void closedir(DIR * pDir)

{

	FindClose( pDir->hFind );

    free(pDir);

}



struct dirent* readdir(DIR *pDir)

{

	if (pDir->hFind)

	{

#ifdef _WIN32_WCE

		strcpy(pDir->de.d_name, wstrtostr(pDir->wfd.cFileName));

#else

		strcpy(pDir->de.d_name, pDir->wfd.cFileName);

#endif

		

		if ( !FindNextFile(pDir->hFind, &pDir->wfd) )

			pDir->hFind = NULL;



		return &pDir->de;

	}

	return NULL;

}



void rewinddir( DIR* dir )

{

	lseek( (int) dir->hFind,0,SEEK_SET);

}



#define fclose(f)  { if (f!=NULL) fclose(f); }

