/* role.c */
/* Kevin Hugo, 1998 */

#include "hack.h"


#ifdef ROLE_PATCH


/* Table of roles */
const struct Role roles[] = {
{	{"Archeologist", 0}, {
	{"Digger",      0},
	{"Field Worker",0},
	{"Investigator",0},
	{"Exhumer",     0},
	{"Excavator",   0},
	{"Spelunker",   0},
	{"Speleologist",0},
	{"Collector",   0},
	{"Curator",     0} },
	"Quetzalcoatl", "Camaxtli", "Huhetotl", /* Central American */
	"Arc", "the College of Archeology", "the Tomb of the Toltec Kings",
	PM_ARCHEOLOGIST, 0, 0,
	PM_LORD_CARNARVON, PM_STUDENT, PM_MINION_OF_HUHETOTL,
	0, PM_HUMAN_MUMMY, S_SNAKE, S_MUMMY,
	ART_WEREBANE, ART_GRAYSWANDIR, ART_ORB_OF_DETECTION,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{  10, 10, 10, 10, 10, 12 },
	{   5,  8,  5,  5,  6,  5 },
	{  18, 19, 18, 19, 18, 19 },
	13,  8, 14,  2,
	9, 2, 2, 10, A_INT, SPE_MAGIC_MAPPING, -4
},
{	{"Barbarian", 0}, {
	{"Plunderer",   "Plunderess"},
	{"Pillager",    0},
	{"Bandit",      0},
	{"Brigand",     0},
	{"Raider",      0},
	{"Reaver",      0},
	{"Slayer",      0},
	{"Chieftain",   "Chieftainess"},
	{"Conqueror",   "Conqueress"} },
	"Mitra", "Crom", "Set", /* Hyborian */
	"Bar", "the Camp of the Duali Tribe", "the Duali Oasis",
	PM_BARBARIAN, 0, 0,
	PM_PELIAS, PM_CHIEFTAIN, PM_THOTH_AMON,
	PM_OGRE, PM_TROLL, S_OGRE, S_TROLL,
	ART_CLEAVER, ART_DEATHSWORD, ART_HEART_OF_AHRIMAN,
	ROLE_MALE|ROLE_FEMALE|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  15,  4,  4, 10, 15,  6 },
	{   5,  5,  5,  5,  3,  5 },
	{ 120, 12, 12, 18, 20, 12 },
	16, 8,  10,  3,
	17, 2, 0,  8, A_INT, SPE_HASTE_SELF,      -4
},
{	{"Caveman", "Cavewoman"}, {
	{"Troglodyte",  0},
	{"Aborigine",   0},
	{"Wanderer",    0},
	{"Vagrant",     0},
	{"Wayfarer",    0},
	{"Roamer",      0},
	{"Nomad",       0},
	{"Rover",       0},
	{"Pioneer",     0} },
	"Anu", "Ishtar", "Anshar", /* Babylonian */
	"Cav", "the Caves of the Ancestors", "the Dragon's Lair",
	PM_CAVEMAN, PM_CAVEWOMAN, PM_LITTLE_DOG,
	PM_SHAMAN_KARNOV, PM_NEANDERTHAL, PM_CHROMATIC_DRAGON,
	PM_BUGBEAR, PM_HILL_GIANT, S_HUMANOID, S_GIANT,
	ART_GIANTKILLER, ART_SKULLCRUSHER, ART_SCEPTRE_OF_MIGHT,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL,
	/* Str Int Wis Dex Con Cha */
	{  15,  5,  8, 10, 15,  6 },
	{   5,  6,  5,  5,  3,  7 },
	{ 120, 12, 13, 18, 20, 15 },
	16, 8,  10,  3,
	17, 2, 1,  8, A_INT, SPE_DIG,             -4
},
{	{"Doppelganger", 0}, {
	{"Copier",          0},
	{"Duplicator",      0}, /* Used to be Copier */
	{"Modifier",        0}, /* Used to be Copier */
	{"Shifter",         0},
	{"Clone",           0}, /* Used to be Shifter */
	{"Reshaper",        0}, /*WAC Used to be Changer*/
	{"Manipulator",     0}, 
	{"Adept Changer",   0}, /* Used to be Adept Changer */
	{"Master of Forms", 0} },/* WAC used to be Master Changer*/
	"Anu", "Ishtar", "Anshar", /* Babylonian */
	"Dop", "the Circle of Change", "the Transmuter's Cave",
	PM_DOPPELGANGER, 0, PM_CHAMELEON,
	PM_MASTER_SHIFTER, PM_SHIFTER, PM_TRANSMUTER,
	PM_CHAMELEON, PM_GUARDIAN_NAGA, S_LIZARD, S_NAGA,
	ART_TROLLSBANE, ART_DISRUPTER, ART_MEDALLION_OF_SHIFTERS,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  10, 10, 10, 10, 10, 10 },
	{   5,  5,  5,  5,  5,  5 },
	{ 118, 18, 18, 18, 18, 18 },
	12, 8, 11,  2,
	9, 2, 0, 10, A_INT, SPE_POLYMORPH,       -4
},
#ifdef DWARF
{	{"Dwarf", 0}, {
	{"Tinker", 0},
	{"Digger", 0},
	{"Miner", 0},
	{"Burrower", 0},
	{"Tunneler", 0},
	{"Smith", 0},
	{"Forger", 0},
	{"Master", 0},
	{"King", 0} },
	"Moradin", "Dumathoin", "Abbathor", /* AD&D */
	"Dwa", "the Laketown", "the Lonely Mountain",
	PM_DWARF, 0, PM_LITTLE_DOG,
	PM_THORIN, PM_DWARF_WARRIOR, PM_SMAUG,
	PM_ORC_CAPTAIN, PM_WARG, S_ORC, S_DOG,
	ART_ORCRIST, ART_AXE_OF_DURIN, ART_ARKENSTONE,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{  13,  7,  9, 10, 17,  6 },
	{  20,  6, 14, 25, 23, 12 },
	{ 118, 18, 18, 18, 18, 18 },
	15, 8, 10,  4,
	4, 0, 0, 10, A_WIS, SPE_IDENTIFY,        -4
},
#endif
{	{"Elf", 0}, {
	{"Edhel",       "Elleth"},
	{"Edhel",       "Elleth"},      /* elf-maid */
	{"Ohtar",       "Ohtie"},       /* warrior */
	{"Kano",                        /* commander (Q.) ['a] */
					"Kanie"}, /* educated guess, until further research- SAC */
	{"Arandur",						/* king's servant, minister (Q.) - guess */
					"Aranduriel"},			/* educated guess */
	{"Hir",         "Hiril"},       /* lord, lady (S.) ['ir] */
	{"Aredhel",     "Arwen"},       /* noble elf, maiden (S.) */
	{"Ernil",       "Elentariel"},  /* prince (S.), elf-maiden (Q.) */
	{"Elentar",     "Elentari"} },	/* Star-king, -queen (Q.) */
	"Solonor Thelandira", "Aerdrie Faenya", "Lolth", /* Elven */
	"Elf", "the great Circle of Earendil", "the Goblins' Cave",
	PM_ELF, 0, 0,
	PM_EARENDIL, PM_HIGH_ELF, PM_GOBLIN_KING,
	PM_URUK_HAI, PM_OGRE, S_ORC, S_OGRE,
	ART_ORCRIST, ART_QUICK_BLADE, ART_PALANTIR_OF_WESTERNESSE,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   7, 12,  7, 16,  6, 12 },
	{   8,  6, 11,  5,  8,  7 },
	{  68, 19, 16, 21, 18, 19 },
	15, 8, 11,  2,
	9, 2, 1, 10, A_INT, SPE_DETECT_UNSEEN,   -4
},
{	{"Flame Mage", 0}, {
	{"Spark",         0},   /* WAC was Igniter */
	{"Igniter",       0},
	{"Broiler",       0},   /* WAC was Igniter */
	{"Combuster",     0},   /* WAC was Torcher */
	{"Torcher",       0},
	{"Scorcher",      0},   /* WAC was Torcher */
	{"Incinerator",   0},
	{"Disintegrator", 0},   /* WAC was Incinerator */
	{"Flame-Master",  0} },
	"Earth", "Fire", "Ash", /* Special */
	"Fla", "the great Circle of Flame", "the Water Mage's Cave",
	PM_FLAME_MAGE, 0, PM_HELL_HOUND_PUP,
	PM_HIGH_FLAME_MAGE, PM_IGNITER, PM_WATER_MAGE,
	PM_WATER_ELEMENTAL, PM_RUST_MONSTER, S_ELEMENTAL, S_RUSTMONST,
	ART_FIREWALL, ART_FIRE_BRAND, ART_CANDLE_OF_ETERNAL_FLAME,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   6, 14, 10, 10,  6,  6 },
	{   4,  5,  5,  8, 12, 12 },
	{  68, 19, 17, 19, 18, 18 },
	14, 8, 11,  2,
	5, 2, 2, 10, A_INT, SPE_FIREBALL,        -4
},
{	{"Gnome", 0}, {
	{"Gnome",               0},
	{"Gnome",               0},
	{"Gnome Warrior",       0},
	{"Gnome Knight",        0},
	{"Gnome Lord","Gnome Lady"},
	{"Gnome Lord","Gnome Lady"},
	{"Gnome Noble",         0},
	{"Gnome Noble",           0},
	{"Gnome King","Gnome Queen"} },
	"Garl Glittergold", "Flandal Steelskin", "Urdlen", /* Gnomes */
	"Gno", "the Golden Mines", "the Undermines",
	PM_GNOME, 0, PM_GUARDIAN_NAGA_HATCHLING,
	PM_RUGGO_THE_GNOME_KING, PM_GNOME_WARRIOR, PM_LARETH,
	PM_DROW, PM_OGRE, S_ORC, S_OGRE,
	ART_OGRESMASHER, ART_LUCKBLADE, ART_PICK_OF_FLANDAL_STEELSKIN,
	ROLE_MALE|ROLE_FEMALE|/*ROLE_LAWFUL|*/ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{  10, 10, 10, 10, 10, 10 },
	{   5,  5,  5,  5,  5,  5 },
	{ 118, 15, 15, 20, 18, 13 },
	14, 8, 10,  3,
	11, 2, 2, 10, A_INT, SPE_CAUSE_FEAR,      -4
},
{	{"Healer", 0}, {
	{"Rhizotomist",  0},
	{"Empiric",     0},
	{"Embalmer",    0},
	{"Dresser",     0},
	{"Medici ossium",       0},
	{"Herbalist",   0},
	{"Magister",    0},
	{"Physician",   0},
	{"Chirurgeon",  0} },
	"Athena", "Hermes", "Poseidon", /* Greek */
	"Hea", "the Temple of Epidaurus", "the Temple of Coeus",
	PM_HEALER, 0, 0,
	PM_HIPPOCRATES, PM_ATTENDANT, PM_CYCLOPS,
	PM_GIANT_RAT, PM_SNAKE, S_RODENT, S_YETI,
	ART_DELUDER, ART_MIRRORBRIGHT, ART_STAFF_OF_AESCULAPIUS,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{   6, 12, 14, 12, 10, 10 },
	{   6,  8,  6,  6,  5,  5 },
	{  18, 19, 19, 19, 19, 18 },
	13, 8, 20,  2,
	7, -2, 2, 10, A_WIS, SPE_CURE_SICKNESS,   -4
},
{	{"Hobbit", 0}, {
	{"Halfling",     0},
	{"Stinging Fly", 0},
	{"Barrel Rider", 0},
	{"Clue Finder",  0},
	{"Ring Winner",  0},
	{"Luckwearer",   0},
	{"Web Cutter",   0},
	{"Eagle Rider",  0},
	{"Burglar",      0} },
	"Iluvatar", "Gilthoniel", "Morgoth", /* Middle-Earth */
	"Hob", "the Shire", "the Misty Mountains",
	PM_HOBBIT, 0, 0,
	PM_BILBO_BAGGINS, PM_PROUDFOOT, PM_GOLLUM,
	PM_GIANT_SPIDER, PM_NAZGUL, S_SPIDER, S_KOBOLD,
	ART_STING, ART_QUICK_BLADE, ART_ONE_RING,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{   8,  8,  8, 10, 12, 10 },
	{  15, 15, 15, 20, 20, 15 },
	{  18, 16, 18, 18, 20, 20 },
	15, 8, 10,  4,
	15, -2, 3, 12, A_WIS, SPE_DETECT_TREASURE,    -4
},
{	{"Ice Mage", 0}, {
	{"Cooler",        0},   /* WAC was Chiller */
	{"Condenser",     0},   /* WAC was Chiller */
	{"Chiller",       0},
	{"Froster",       0},
	{"Permafroster",  0},   /* WAC was Froster */
	{"Icer",          0},   /* WAC was Froster */
	{"Freezer",       0},
	{"Sublimer",      0},   /* WAC was Freezer */
	{"Ice-Master",    0} },
	"Air", "Frost", "Smoke", /* Special */
	"Ice", "the great Ring of Ice", "the Earth Mage's Cave",
	PM_ICE_MAGE, 0, PM_WINTER_WOLF_CUB,
	PM_HIGH_ICE_MAGE, PM_FROSTER, PM_EARTH_MAGE,
	PM_RUST_MONSTER, PM_XORN, S_RUSTMONST, S_XORN,
	ART_DEEP_FREEZE, ART_FROST_BRAND, ART_STORM_WHISTLE,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   6, 14, 10, 10,  6,  6 },
	{   4,  5,  5,  8, 12, 12 },
	{  68, 19, 17, 19, 18, 18 },
	14, 8, 11,  2,
	5, 2, 2, 10, A_INT, SPE_CONE_OF_COLD,    -4
},
{	{"Knight", 0}, {
	{"Gallant",     0},
	{"Esquire",     0},
	{"Bachelor",    0},
	{"Sergeant",    0},
	{"Knight",      0},
	{"Banneret",    0},
	{"Chevalier",   0},
	{"Seignieur",   0},
	{"Paladin",     0} },
	"Lugh", "Brigit", "Manannan Mac Lir", /* Celtic */
	"Kni", "Camelot Castle", "the Isle of Glass",
	PM_KNIGHT, 0, PM_PONY,
	PM_KING_ARTHUR, PM_PAGE, PM_IXOTH,
	PM_QUASIT, PM_OCHRE_JELLY, S_IMP, S_JELLY,
	ART_DRAGONBANE, ART_DEMONBANE, ART_MAGIC_MIRROR_OF_MERLIN,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL,
	/* Str Int Wis Dex Con Cha */
	{  15,  5, 13, 10, 15, 17 },
	{   5, 13,  5,  5,  3,  2 },
	{ 119, 17, 19, 18, 18, 19 },
	16, 8, 10,  3,
	13,-2, 0,  9, A_WIS, SPE_TURN_UNDEAD,     -4
},
{	{"Lycanthrope", 0}, {
	{"Infected",        0},
	{"Summoner",        0},
	{"Stalker",         0},
	{"Render",          0},
	{"Fiend",           0},
	{"Nightmare",       0},
	{"Devourer",        0},
	{"Greater Fiend",   0},
	{"Lycanthrope",     0} },
	"Eluvian", "Moon", "Lycanthus", /* Special */
	"Lyc", "the Nightmare Forest", "the Calerin Forest",
	PM_HUMAN_WEREWOLF, 0, PM_WOLF,
	PM_HIGH_LYCANTHROPE, PM_FIEND, PM_SIR_LORIMAR,
	PM_WOODLAND_ELF, PM_FOREST_CENTAUR, S_HUMAN, S_CENTAUR,
	ART_ELFRIST, ART_DOOMBLADE, ART_STAFF_OF_WITHERING,
	ROLE_MALE|ROLE_FEMALE|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  12,  8,  5, 10,  8,  3 },
	{   7,  5, 10,  8,  5,  5 },
	{ 120, 13, 13, 18, 18, 12 },
	15, 8, 11,  2,
	17, 2, 0, 10, A_INT, SPE_CREATE_FAMILIAR, -4
},
{	{"Monk", 0}, {
	{"Initiate",           0},
	{"Beginner",           0},
	{"Abbot",              0},
	{"Master of Flowers",  0}, 
	{"Master of Wind",     0},
	{"Master of Dragons",  0},
	{"Master of Elements", 0},
	{"Master of Spirits",  0},
	{"Grand Master",       0} },
	"Shan Lai Ching", "Chih Sung-tzu", "Huan Ti", /* Chinese */
	"Mon", "the Monastery of Chan-Sune", "the Monastery of the Earth-Lord",
	PM_MONK, 0, 0,
	PM_GRAND_MASTER, PM_ABBOT, PM_MASTER_KAEN,
	PM_LIZARD, PM_XORN, S_LIZARD, S_XORN,
	ART_GAUNTLETS_OF_DEFENSE, ART_WHISPERFEET, ART_MANTLE_OF_KNOWLEDGE,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   6, 10, 13, 16,  8,  8 },
	{  12,  8,  5,  4, 10, 10 },
	{  18, 20, 20, 18, 20, 18 },
	14, 8, 10,  2,
	9,-2, 2, 20, A_WIS, SPE_RESTORE_ABILITY, -4
},
{	{"Necromancer", 0}, {
	{"Gravedigger",  0},
	{"Embalmer", 0},
	{"Mortician", 0},
	{"Zombie Lord", 0},
	{"Ghoul Master",0},
	{"Necromancer", 0},
	{"Necromancer", 0},
	{"Undead Master", 0},
	{"Lich Lord", 0} },
	"Nharlotep", "Zugguthobal", "Gothuulbe", /* Assorted slimy things */
	"Nec", "the Tower of the Dark Lord", "the Lair of Maugneshaagar",
	PM_NECROMANCER, 0, PM_GHOUL,
	PM_THE_DARK_LORD, PM_EMBALMER, PM_MAUGNESHAAGAR,
	PM_NUPPERIBO, PM_MONGBAT, S_BAT, S_IMP,
	ART_SERPENT_S_TONGUE, ART_GRIMTOOTH, ART_GREAT_DAGGER_OF_GLAURGNAA,
	ROLE_MALE|ROLE_FEMALE|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   6, 14, 10, 10,  6,  4 },
	{   4,  5,  5,  8, 12,  8 },
	{  18, 20, 20, 19, 18, 18 },
	12, 8, 12,  1,
	5, 2, 2, 10, A_INT, SPE_SUMMON_UNDEAD,   -4
},
{	{"Priest", "Priestess"}, {
	{"Aspirant",    0},
	{"Acolyte",     0},
	{"Adept",       0},
	{"Priest",      "Priestess"},
	{"Curate",      0},
	{"Canon",       "Canoness"},
	{"Lama",        0},
	{"Patriarch",   "Matriarch"},
	{"High Priest", "High Priestess"} },
	"Shan Lai Ching", "Chih Sung-tzu", "Huan Ti", /* Chinese */
	"Pri", "the Great Temple", "the Temple of Nalzok",
	PM_PRIEST, PM_PRIESTESS, 0,
	PM_ARCH_PRIEST, PM_ACOLYTE, PM_NALZOK,
	PM_HUMAN_ZOMBIE, PM_WRAITH, S_ZOMBIE, S_WRAITH,
	ART_DISRUPTER, ART_SUNSWORD, ART_MITRE_OF_HOLINESS,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  10, 10, 14,  7, 10, 12 },
	{   8,  8,  5, 11,  5,  6 },
	{ 118, 17, 20, 18, 18, 18 },
	14, 8, 10,  2,
	7,-2, 2, 10, A_WIS, SPE_REMOVE_CURSE,    -4
},
{	{"Rogue", 0}, {
	{"Footpad",     0},
	{"Cutpurse",    0},
	{"Rogue",       0},
	{"Pilferer",    0},
	{"Robber",      0},
	{"Burglar",     0},
	{"Filcher",     0},
	{"Magsman",     "Magswoman"},
	{"Thief",       0} },
	"Issek", "Mog", "Kos", /* Nehwon */
	"Rog", "the Thieves' Guild Hall", "the Assassins' Guild Hall",
	PM_ROGUE, 0, 0,
	PM_MASTER_OF_THIEVES, PM_THUG, PM_MASTER_ASSASSIN,
	PM_LEPRECHAUN, PM_GUARDIAN_NAGA, S_NYMPH, S_NAGA,
	ART_DOOMBLADE, ART_BAT_FROM_HELL, ART_MASTER_KEY_OF_THIEVERY,
	ROLE_MALE|ROLE_FEMALE|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  10, 10,  5, 16,  7,  6 },
	{   8,  5, 12,  4, 10,  6 },
	{ 118, 17, 17, 20, 18, 16 },
	12, 8, 11,  2,
	13, 2, 2,  9, A_INT, SPE_DETECT_TREASURE, -4
},
{	{"Samurai", 0}, {
	{"Hatamoto",    0},  /* Banner Knight */
	{"Ronin",       0},  /* no allegiance */
	{"Samurai",     0},  /* knight */
	{"Joshu",       0},  /* heads a castle */
	{"Ryoshu",      0},  /* has a territory */
	{"Kokushu",     0},  /* heads a province */
	{"Daimyo",      0},  /* a samurai lord */
	{"Kuge",        0},  /* Noble of the Court */
	{"Shogun",      0} },/* supreme commander, warlord */
	"Amaterasu Omikami", "Raijin", "Susanowo", /* Japanese */
	"Sam", "the Castle of the Taro Clan", "the Shogun's Castle",
	PM_SAMURAI, 0, PM_LITTLE_DOG,
	PM_LORD_SATO, PM_ROSHI, PM_ASHIKAGA_TAKAUJI,
	PM_WOLF, PM_STALKER, S_DOG, S_STALKER,
	ART_SNICKERSNEE, ART_DRAGONBANE, ART_TSURUGI_OF_MURAMASA,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  12,  5,  5, 16, 13,  6 },
	{   6, 10, 10,  3,  5,  5 },
	{ 118, 15, 15, 20, 18, 18 },
	15, 8, 11,  2,
	17, 2, 0,  8, A_INT, SPE_CLAIRVOYANCE,    -4
},
#ifdef TOURIST
{	{"Tourist", 0}, {
	{"Rambler",     0},
	{"Sightseer",   0},
	{"Excursionist",0},
	{"Peregrinator","Peregrinatrix"},
	{"Traveler",    0},
	{"Journeyer",   0},
	{"Voyager",     0},
	{"Explorer",    0},
	{"Adventurer",  0} },
	"Blind Io", "The Lady", "Offler", /* Discworld */
	"Tou", "Ankh-Morpork", "the Thieves' Guild Hall",
	PM_TOURIST, 0, 0,
	PM_TWOFLOWER, PM_GUIDE, PM_MASTER_OF_THIEVES,
	PM_GIANT_SPIDER, PM_FOREST_CENTAUR, S_SPIDER, S_CENTAUR,
	ART_WHISPERFEET, ART_LUCKBLADE, ART_YENDORIAN_EXPRESS_CARD,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL,
	/* Str Int Wis Dex Con Cha */
	{   8,  5,  5,  5,  5,  5 },
	{  10, 10, 10, 10, 10, 10 },
	{  68, 19, 19, 18, 18, 19 },
	10, 8, 14,  1,
	9, 2, 2, 10, A_INT, SPE_CHARM_MONSTER,   -4
},
#endif
{	{"Undead Slayer", 0}, {
	{"Assistant",    0},
	{"Eliminator",   0},
	{"Eliminator",   0},
	{"Exterminator", 0},
	{"Exterminator", 0},
	{"Destroyer",   0},
	{"Vindicator",  0},
	{"Vindicator",  0},
	{"Undead Slayer", 0} },
	"Seeker", "Osiris", "Seth", /* Egyptian */
	"Und", "the Temple of Light", "the Crypt of Dracula",
	PM_UNDEAD_SLAYER, 0, 0,
	PM_VAN_HELSING, PM_EXTERMINATOR, PM_COUNT_DRACULA,
	PM_HUMAN_MUMMY, PM_VAMPIRE, S_MUMMY, S_VAMPIRE,
	ART_HOLY_SPEAR_OF_LIGHT, ART_SUNSWORD, ART_STAKE_OF_VAN_HELSING,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  15,  5, 13, 10, 15, 10 },
	{   5, 13,  5,  5,  3,  5 },
	{ 118, 17, 17, 18, 19, 18 },
	14, 8, 14,  1,
	13,-2, 0,  9, A_WIS, SPE_TURN_UNDEAD,     -4
},
{	{"Valkyrie", 0}, {
	{"Stripling",   0},
	{"Skirmisher",  0},
	{"Fighter",     0},
	{"Man-at-arms", "Woman-at-arms"},
	{"Warrior",     0},
	{"Swashbuckler",0},
	{"Hero",        "Heroine"},
	{"Champion",    0},
	{"Lord",        "Lady"} },
	"Tyr", "Odin", "Loki", /* Norse */
	"Val", "the Shrine of Destiny", "the cave of Surtur",
	PM_VALKYRIE, 0, PM_WINTER_WOLF_CUB,
	PM_NORN, PM_WARRIOR, PM_LORD_SURTUR,
	PM_FIRE_ANT, PM_FIRE_GIANT, S_ANT, S_GIANT,
	ART_MJOLLNIR, ART_FROST_BRAND, ART_ORB_OF_FATE,
	ROLE_FEMALE|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{  15,  5,  5, 10, 15, 10 },
	{   5, 10, 10,  5,  3,  5 },
	{ 120, 12, 17, 18, 20, 16 },
	16, 8, 10,  3,
	13,-2, 0,  9, A_WIS, SPE_LIGHTNING,    -4
},
{	{"Wizard", 0}, {
	{"Evoker",      0},
	{"Conjurer",    0},
	{"Thaumaturge", 0},
	{"Magician",    0},
	{"Warlock",     "Witch"},
	{"Enchanter",   "Enchantress"},
	{"Sorcerer",    "Sorceress"},
	{"Wizard",      0},
	{"Mage",        0} },
	"Ptah", "Thoth", "Anhur", /* Egyptian */
	"Wiz", "the Tower of the Balance", "the Tower of Darkness",
	PM_WIZARD, 0, PM_KITTEN,
	PM_WIZARD_OF_BALANCE, PM_APPRENTICE, PM_DARK_ONE,
	PM_VAMPIRE_BAT, PM_XORN, S_BAT, S_WRAITH,
	ART_MAGICBANE, ART_DELUDER, ART_EYE_OF_THE_AETHIOPICA,
	ROLE_MALE|ROLE_FEMALE|ROLE_LAWFUL|ROLE_NEUTRAL|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   6, 14, 10, 10,  6,  6 },
	{   4,  5,  5,  8, 12, 12 },
	{  18, 20, 20, 19, 18, 18 },
	12, 8, 12,  1,
	1, 0, 3, 10, A_INT, SPE_MAGIC_MISSILE,   -4
},
#ifdef YEOMAN
{	{"Yeoman", 0}, {
	/* Landowner titles, naval ranks and positions */
	/* We intentionally avoid Lieutenant and Captain */
	{"Usher",          0},
	{"Steward",        "Stewardess"},
	{"Keeper",         0},
	{"Marshal",        0},
	{"Master Steward", "Master Stewardess"},
	{"Chamberlain",    0},
	{"Constable",      0},
	{"Chancellor",     0},
	{"Regent",         0} },
	"His Majesty", "His Holiness", "The Commons", /* The three estates */
	"Yeo", "London", "the inner ward",
	PM_YEOMAN, 0, PM_PONY,
	PM_CHIEF_YEOMAN_WARDER, PM_YEOMAN_WARDER, PM_COLONEL_BLOOD,
	PM_RAVEN, PM_WEREWOLF, S_RODENT, S_DOG,
	ART_REAPER, ART_SWORD_OF_JUSTICE, ART_CROWN_OF_SAINT_EDWARD,
	ROLE_MALE|ROLE_LAWFUL,
	/* Str Int Wis Dex Con Cha */
	{  12,  9,  9, 12, 15,  7 },
	{  15, 15, 15, 15, 20, 10 },
	{ 119, 18, 18, 18, 20, 12 },
	16, 8, 10,  3,
	13,-2, 0,  9, A_WIS, SPE_KNOCK, -4
},
#endif
#ifdef ZOUTHERN
{	{"Zoutherner", 0}, {
	{"Mate", "Love"} },
	"Eburc", "Rylar", "Rawwick", /* Influential NetHackers from .au */
	"Zou", "", "",
	PM_ZOUTHERNER, 0, PM_DINGO_PUPPY,
	0, 0, 0,
	PM_CANE_TOAD, PM_RABBIT, S_ZOUTHERN, S_RODENT,
	0, 0, 0,
	ROLE_MALE|ROLE_FEMALE|ROLE_CHAOTIC,
	/* Str Int Wis Dex Con Cha */
	{   9,  9, 13,  9,  9, 13 },
	{  10, 10, 15, 10, 10, 15 },
	{ 118, 18, 20, 18, 18, 20 },
	10, 8, 14,  1
},
#endif
/* Array terminator */
{{0, 0}}};

/* The player's role, created at runtime from initial choices */
struct Role urole;



/*
 * The player's role, expressed as a single letter.
 * This should be in the same order as roles[].
 * Now OBSOLETE, but included for ports that haven't upgraded.
 * (was in decl.c)
 */
#ifdef ROLE_PATCH
const char NEARDATA pl_classes[] =
{	'A', 'B', 'C', 'D',
#ifdef DWARF
	'D',
#endif
	'E', 'F', 'G', 'H', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'R', 'S',
#ifdef TOURIST
	'T',
#endif
	'U', 'V', 'W',
#ifdef YEOMAN
	'Y',
#endif
#ifdef ZOUTHERN
	'Z',
#endif
	'\0'
};
#endif


/* Table of all genders */
const struct Gender genders[] = {
	{"male",	"he",	"him",	"his",	ROLE_MALE},
	{"female",	"she",	"her",	"her",	ROLE_FEMALE},
	{"neuter",	"it",	"it",	"its",	ROLE_NEUTER}
};


/* Table of all alignments */
const struct Align aligns[] = {
	{"law",		"lawful",	ROLE_LAWFUL,	A_LAWFUL},
	{"balance",	"neutral",	ROLE_NEUTRAL,	A_NEUTRAL},
	{"chaos",	"chaotic",	ROLE_CHAOTIC,	A_CHAOTIC},
	{"evil",	"unaligned",0,				A_NONE}
};



/*
 *	Special setup modifications here:
 *
 *	Unfortunately, this is going to have to be done
 *	on each newgame or restore, because you lose the permonst mods
 *	across a save/restore.  :-)
 *
 *	1 - The Rogue Leader is the Tourist Nemesis.
 *	2 - Priests start with a random alignment - convert the leader and
 *	    guardians here.
 *	3 - Elves can have one of two different leaders, but can't work it
 *	    out here because it requires hacking the level file data (see
 *	    sp_lev.c).
 *
 * This code replaces quest_init().
 */
void role_init ()
{
	register char *ptr;
	int i, align;


	/* Strip the role letter out of the player name.
	 * This is included for backwards compatibility.
	 */
	if ((strlen(plname) > 2) && ((ptr = rindex(plname, '-')) != 0)) {
		strncpy(pl_character, ptr+1, PL_CSIZ-1);
		pl_character[PL_CSIZ-1] = '\0';
		*ptr = '\0';
	}

	/* Check for a valid role.  Try flags.irole first. */
	if (flags.irole < 0 || flags.irole >= SIZE(roles)-1) {
		/* Try the player letter second */
		if ((flags.irole = str2role(pl_character)) < 0)
			/* None specified; pick a random role */
			flags.irole = rn2(SIZE(roles)-1);
	}

	/* We now have a valid role index.  Copy the role name back. */
	/* This should become OBSOLETE */
	strcpy(pl_character, roles[flags.irole].name.m);
	pl_character[PL_CSIZ-1] = '\0';

	/* Check for a valid gender.  Try flags.igend first. */
	if (flags.igend < 0 || flags.igend >= ROLE_GENDERS)
		/* Use flags.female second.  Note that there is no way
		 * to check for an unspecified gender.
		 */
		flags.igend = flags.female;

	/* Validate the gender with the role */
	i = flags.igend;
	do {
		if (roles[flags.irole].allow & genders[i].allow) break;
		if (++i >= ROLE_GENDERS) i = 0;
	} while (i != flags.igend);
	flags.igend = i;
	/* Don't touch flags.female; this may be a restore */

	/* Check for a valid alignment */
	if (flags.ialign < 0 || flags.ialign >= ROLE_ALIGNS)
		/* Pick a random alignment */
		flags.ialign = rn2(ROLE_ALIGNS);

	/* Validate the alignment with the role */
	i = flags.ialign;
	do {
		if (roles[flags.irole].allow & aligns[i].allow) break;
		if (++i >= ROLE_ALIGNS) i = 0;
	} while (i != flags.ialign);
	flags.ialign = i;
	align = aligns[flags.ialign].value;

	/* Initialize urole */
	urole = roles[flags.irole];

	/* Class-specific setups */
	if (Role_if(PM_ELF)) {
		if (align == A_CHAOTIC) {
			urole.malenum = urole.femalenum = PM_DROW;
			urole.filename = "Dro";
			urole.intermed = urole.homebase;
			urole.homebase = "the Temple of Lolth";
			urole.ldrnum = PM_LOLTH;
			urole.guardnum = PM_DROW;
			urole.neminum = PM_EARENDIL;
			urole.enemy1num = PM_HIGH_ELF;
			urole.enemy2num = PM_GREY_ELF;
			urole.enemy1sym = S_DOG;
			urole.enemy2sym = S_HUMAN;
			urole.gift1arti = ART_PLAGUE;
			urole.gift2arti = ART_STORMBRINGER;
			urole.questarti = ART_TENTACLE_STAFF;
		} else if (flags.female) {
			urole.homebase = "the great Circle of Elwing";
			urole.ldrnum = PM_ELWING;
		}
	}

	/* Fix up the quest leader */
	if (urole.ldrnum) {
		mons[urole.ldrnum].msound = MS_LEADER;
		mons[urole.ldrnum].mflags2 |= (M2_PEACEFUL);
		mons[urole.ldrnum].mflags3 = M3_CLOSE;
		mons[urole.ldrnum].maligntyp = align * 3;
	}

	/* Fix up the quest guardians */
	if (urole.guardnum) {
		mons[urole.guardnum].mflags2 |= (M2_PEACEFUL);
		mons[urole.guardnum].maligntyp = align * 3;
	}

	/* Fix up the quest nemesis */
	if (urole.neminum) {
		mons[urole.neminum].msound = MS_NEMESIS;
		mons[urole.neminum].mflags2 &= ~(M2_PEACEFUL);
		mons[urole.neminum].mflags2 |= (M2_NASTY|M2_STALK|M2_HOSTILE);
		mons[urole.neminum].mflags3 = M3_WANTSARTI | M3_WAITFORU;
	}

	/* Artifacts are fixed in hack_artifacts(). */

	/* Success! */
	return;
}


int
str2role (str)
	char *str;
{
	int i, len;


	/* Is str valid? */
	if (!str || !str[0])
		return (-1);

	/* "@" returns a random role */
	if (str[0] == '@')
		return (rn2(SIZE(roles)-1));

	/* Match as much of str as is provided */
	len = strlen(str);
	for (i = 0; roles[i].name.m; i++) {
		if (!strncmpi(str, roles[i].name.m, len) ||
				roles[i].name.f && !strncmpi(str, roles[i].name.f, len))
			return (i);
	}

	/* Couldn't find anything appropriate */
	return (-1);
}


char *
Hello ()
{
	switch (Role_switch) {
	case PM_DOPPELGANGER:
		return ("Moin moin");   /* N. Germany */
#ifdef DWARF
	case PM_DWARF:
#endif
	case PM_GNOME:
		return ("Gruss Gott");  /* S. Germany, umlaut omitted */
/*	case PM_ELF:
	case PM_DROW:
		return ("");            /* Tolkien elf */
#ifdef YEOMAN
	case PM_YEOMAN:
#endif
	case PM_KNIGHT:
		return ("Salutations"); /* Olde English */
	case PM_SAMURAI:
		return ("Konnichi wa"); /* Japanese */
#ifdef TOURIST
	case PM_TOURIST:
		return ("Aloha");       /* Hawaiian */
#endif
	case PM_VALKYRIE:
		return ("Velkommen");   /* Norse */
#ifdef ZOUTHERNER
/*	case PM_ZOUTHERNER:
	return ("G'day");       /* Aussie */
#endif
	default:	return ("Hello");
	}
}


char *
Goodbye ()
{
	switch (Role_switch) {
	case PM_DOPPELGANGER:
		return ("Auf Wiedersehen"); /* N. Germany */
#ifdef DWARF
	case PM_DWARF:
#endif
	case PM_GNOME:
		return ("Tschuss");         /* S. Germany, umlaut omitted */
/*	case PM_ELF:
	case PM_DROW:
		return ("");                /* Tolkien elf */
#ifdef YEOMAN
	case PM_YEOMAN:
#endif
	case PM_KNIGHT:
		return ("Fare thee well");  /* Olde English */
	case PM_SAMURAI:
		return ("Sayonara");        /* Japanese */
#ifdef TOURIST
	case PM_TOURIST:
		return ("Aloha");           /* Hawaiian */
#endif
	case PM_VALKYRIE:
		return ("Farvel");          /* Norse */
#ifdef ZOUTHERNER
/*	case PM_ZOUTHERNER:
	"Ooroo"?
	return ("G'bye");           /* Aussie */
#endif
	default:
		return ("Goodbye");
	}
}


char *
clockwise (counter)
	boolean	counter;
{
	static char *txt = "counterclockwise";

#ifdef ZOUTHERN
	/* The world spins in the opposite direction for Zoutherners */
	if (Role_if(PM_ZOUTHERNER))
		return (counter ? txt+7 : txt);
	else
#endif
		return (counter ? txt : txt+7);
}



#endif	/* ROLE_PATCH */
