/*	SCCS Id: @(#)artilist.h	3.2	96/05/19	*/
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

/* WAC for blackmarket,  spoon */
#include "config.h"

#ifdef MAKEDEFS_C
/* in makedefs.c, all we care about is the list of names */

#define A(nam,typ,s1,s2,mt,atk,dfn,cry,inv,al,cl) nam
#define A_QUEST(nam,typ,s1,s2,mt,atk,dfn,cry,inv,al,cl) nam

static const char *artifact_names[] = {
#else
/* in artifact.c, set up the actual artifact list structure */

#define A(nam,typ,s1,s2,mt,atk,dfn,cry,inv,al,cl) \
 { typ, nam, s1, s2, mt, atk, dfn, cry, inv, al, cl, FALSE }
#define A_QUEST(nam,typ,s1,s2,mt,atk,dfn,cry,inv,al,cl) \
 { typ, nam, s1, s2, mt, atk, dfn, cry, inv, al, cl, TRUE }

#define     NO_ATTK     {0,0,0,0}               /* no attack */
#define     NO_DFNS     {0,0,0,0}               /* no defense */
#define     NO_CARY     {0,0,0,0}               /* no carry effects */
#define     DFNS(c)     {0,c,0,0}
#define     CARY(c)     {0,c,0,0}
#define     PHYS(a,b)   {0,AD_PHYS,a,b}         /* physical */
#define     DRLI(a,b)   {0,AD_DRLI,a,b}         /* life drain */
#define     COLD(a,b)   {0,AD_COLD,a,b}
#define     FIRE(a,b)   {0,AD_FIRE,a,b}
#define     ELEC(a,b)   {0,AD_ELEC,a,b}         /* electrical shock */
#define     STUN(a,b)   {0,AD_STUN,a,b}         /* magical attack */

STATIC_OVL NEARDATA struct artifact artilist[] = {
#endif	/* MAKEDEFS_C */

/*  dummy element #0, so that all interesting indices are non-zero */
A("",                           STRANGE_OBJECT,
	0, 0, 0, NO_ATTK, NO_DFNS, NO_CARY, 0, A_NONE, 0 ),

/* [Tom] rearranged by alignment, so when people ask... */
/* KMH -- Further arranged:
 * 1.  By alignment (but quest artifacts last).
 * 2.  By weapon class (skill).
 */


/*** Lawful artifacts ***/
A("Firewall",                  ATHAME,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	FIRE(4,4),      FIRE(0,0),      NO_CARY,        0, A_LAWFUL, PM_FLAME_MAGE),

A("Sting",                      ELVEN_DAGGER,
	(SPFX_WARN|SPFX_DCLAS), 0, S_SPIDER,
	PHYS(5,7),      NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_HOBBIT),

A("Giantkiller",                AXE,
	(SPFX_RESTR|SPFX_DFLAG2), 0, M2_GIANT,
	PHYS(2,30),      NO_DFNS,        NO_CARY,       0, A_LAWFUL, PM_CAVEMAN),

#ifdef DWARF
A("Axe of Durin",       BATTLE_AXE,
	(SPFX_RESTR), 0, 0,
	PHYS(5,0),    NO_DFNS,  NO_CARY,  0, A_LAWFUL, PM_DWARF),
#endif

A("Quick Blade",                ELVEN_SHORT_SWORD,
	SPFX_RESTR, 0, 0,
	PHYS(9,2),      NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_ELF),

A("Orcrist",                    ELVEN_BROADSWORD,
	SPFX_DFLAG2, 0, M2_ORC,
	PHYS(5,15),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_ELF),

A("Dragonbane",                 BROADSWORD,
	(SPFX_RESTR|SPFX_DCLAS), 0, S_DRAGON,
	PHYS(5,30),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_KNIGHT),

A("Excalibur",                  LONG_SWORD,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_SEEK|SPFX_DEFN|SPFX_INTEL|SPFX_SEARCH),0,0,
	PHYS(5,6),      DRLI(0,0),      NO_CARY,        0, A_LAWFUL, PM_KNIGHT),

A("Sunsword",                   LONG_SWORD,
	(SPFX_RESTR|SPFX_INTEL|SPFX_DFLAG2|SPFX_DEFN), 0, M2_UNDEAD,
	PHYS(5,12),     DRLI(0,0),     NO_CARY, LIGHT_AREA, A_LAWFUL, PM_PRIEST),
                    /*DFNS(AD_BLND)*/

A("Snickersnee",                KATANA,
	SPFX_RESTR, 0, 0,
	PHYS(5,8),      NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_SAMURAI),

#ifdef YEOMAN
/* KMH -- Renamed from Holy Sword of Law (Stephen White)
 * This is an actual sword used in British coronations!
 */
A("Sword of Justice",           LONG_SWORD,
	(SPFX_RESTR|SPFX_DALIGN), 0, 0,
	PHYS(5,12),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_YEOMAN),
#endif

A("Demonbane",                  LONG_SWORD,
	(SPFX_RESTR|SPFX_DFLAG2), 0, M2_DEMON,
	PHYS(5,30),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_KNIGHT),

A("Werebane",                   SILVER_SABER,
	(SPFX_RESTR|SPFX_DFLAG2), 0, M2_WERE,
	PHYS(5,20),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_ARCHEOLOGIST),

A("Grayswandir",                SILVER_SABER,
	(SPFX_RESTR|SPFX_HALRES), 0, 0,
	PHYS(7,7),      NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_ARCHEOLOGIST),

A("Skullcrusher",               CLUB,
	SPFX_RESTR, 0, 0,
	PHYS(3,10),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_CAVEMAN),

A("Trollsbane",                 MORNING_STAR,
	(SPFX_RESTR|SPFX_DCLAS), 0, S_TROLL,
	PHYS(5,30),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_DOPPELGANGER),

A("Ogresmasher",                WAR_HAMMER,
	(SPFX_RESTR|SPFX_DCLAS), 0, S_OGRE,
	PHYS(5,30),     NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_GNOME),

#ifdef YEOMAN
A("Reaper",                     HALBERD,
	SPFX_RESTR, 0, 0,
	PHYS(5,20),      NO_DFNS,        NO_CARY,        0, A_LAWFUL, PM_YEOMAN),
#endif

A("Holy Spear of Light",        SILVER_SPEAR,
       (SPFX_RESTR|SPFX_INTEL|SPFX_DFLAG2), 0, M2_UNDEAD,
       PHYS(5,10),      NO_DFNS,  NO_CARY,     LIGHT_AREA, A_LAWFUL, PM_UNDEAD_SLAYER),


/*** Neutral artifacts ***/
A("Magicbane",                  ATHAME,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	STUN(3,4),      DFNS(AD_MAGM),  NO_CARY,        0, A_NEUTRAL, PM_WIZARD),

A("Luckblade",                  SHORT_SWORD,
	(SPFX_RESTR|SPFX_LUCK), 0, 0,
	PHYS(5,5),      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_GNOME),

A("Sword of Balance",           SILVER_SHORT_SWORD,
	SPFX_DALIGN, 0, 0,
	PHYS(2,5),      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, 0),

A("Fire Brand",                 LONG_SWORD,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	FIRE(5,5),      COLD(0,0),      NO_CARY,        0, A_NEUTRAL, PM_FLAME_MAGE),

A("Frost Brand",                LONG_SWORD,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	COLD(5,5),      FIRE(0,0),      NO_CARY,        0, A_NEUTRAL, PM_ICE_MAGE),

A("Vorpal Blade",               LONG_SWORD,
	(SPFX_RESTR|SPFX_BEHEAD), 0, 0,
	PHYS(5,1),      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, 0),

A("Disrupter",                  MACE,
	(SPFX_RESTR|SPFX_DFLAG2), 0, M2_UNDEAD,
	PHYS(5,30),     NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_PRIEST),

/*
 *	Mjollnir will return to the hand of a Valkyrie when thrown
 *	if the wielder is wearing Gauntlets of Power.
 */
A("Mjollnir",                   HEAVY_HAMMER,           /* Mjo:llnir */
	(SPFX_RESTR|SPFX_ATTK),  0, 0,
	ELEC(5,16),     NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_VALKYRIE),

/* STEPHEN WHITE'S NEW CODE */
A("Gauntlets of Defense",    GAUNTLETS_OF_DEXTERITY,
	SPFX_RESTR, SPFX_HPHDAM, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,    INVIS, A_NEUTRAL, PM_MONK),

A("Mirrorbright",               SHIELD_OF_REFLECTION,
	(SPFX_RESTR|SPFX_HALRES|SPFX_REFLCT), 0, 0,
	NO_ATTK,      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_HEALER),

A("Deluder",               CLOAK_OF_DISPLACEMENT,
	(SPFX_RESTR|SPFX_STLTH|SPFX_LUCK), 0, 0,
	NO_ATTK,      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_WIZARD),

#ifdef TOURIST
A("Whisperfeet",               SPEED_BOOTS,
	(SPFX_RESTR|SPFX_STLTH|SPFX_LUCK), 0, 0,
	NO_ATTK,      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, PM_TOURIST),
#else
A("Whisperfeet",               SPEED_BOOTS,
	(SPFX_RESTR|SPFX_STLTH|SPFX_LUCK), 0, 0,
	NO_ATTK,      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, 0),
#endif
	
/* KMH -- Do we really need these? */
#if 0
/* [Tom] added artifacts of Nehwon...
 * they're a little more studly in Nethack then they were in the Leiber
 * books, but oh well... :)  Both Fafhrd and the Gray Mouser were typically
 * Neutral. */
/* Fafhrd's swords */
/* Fafhrd was from the snowy north, so we'll make his main weapon like
   a frost brand, but it doesn't protect you from fire, and does a little
   more damage, being a two-handed sword */
A("Graywand",                TWO_HANDED_SWORD,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	COLD(3,6),      NO_DFNS,      NO_CARY,        0, A_NEUTRAL, 0),
/* His secondary weapon has a special attack in artifact.h, fitting its
   name. */
A("Heartseeker",             SHORT_SWORD,
	(SPFX_RESTR), 0, 0,
	PHYS(3,3),      NO_DFNS,      NO_CARY,        0, A_NEUTRAL, 0),
/* The Gray Mouser's weapons */
/* His rapier is supposedly really fast, so we'll make it hit a lot, and
   put some special stuff in artifact.h */
A("Scalpel",             RAPIER,
	(SPFX_RESTR), 0, 0,
	PHYS(8,2),      NO_DFNS,      NO_CARY,        0, A_NEUTRAL, 0),
/* Because of his adventures below Lankhmar, and the names ("Mouser" and
  "Cat's Claw"), we'll make his dagger specially suited for rats. */
A("Cat's Claw",                      DAGGER,
	(SPFX_RESTR|SPFX_WARN|SPFX_DCLAS), 0, S_RODENT,
	PHYS(5,7),      NO_DFNS,        NO_CARY,        0, A_NEUTRAL, 0),
/* back to our program... */
#endif


/*** Chaotic artifacts ***/
A("Grimtooth",                  ORCISH_DAGGER,
	SPFX_RESTR, 0, 0,
	PHYS(2,12),      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_NECROMANCER),

A("Deep Freeze",                ATHAME,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN), 0, 0,
	COLD(5,5),      COLD(0,0),      NO_CARY,        0, A_CHAOTIC, PM_ICE_MAGE),


A("Serpent's Tongue",            DAGGER,
	SPFX_RESTR, 0, 0,
        PHYS(2,0),      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_NECROMANCER),
	/* See artifact.c for special poison damage */

A("Cleaver",                    BATTLE_AXE,
	SPFX_RESTR, 0, 0,
	PHYS(3,10),     NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_BARBARIAN),

A("Doomblade",                  ORCISH_SHORT_SWORD,
	SPFX_RESTR, 0, 0,
	PHYS(0,10),     NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_HUMAN_WEREWOLF),

/*
 *	Stormbringer only has a 2 because it can drain a level,
 *	providing 8 more.
 */
A("Stormbringer",               RUNESWORD,
	(SPFX_RESTR|SPFX_ATTK|SPFX_DEFN|SPFX_INTEL|SPFX_DRLI), 0, 0,
	DRLI(5,2),      DRLI(0,0),      NO_CARY,        0, A_CHAOTIC, PM_DROW),

#ifdef BLACKMARKET
A("Thiefbane",                  LONG_SWORD,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_BEHEAD|SPFX_DCLAS), 0, S_HUMAN,
	DRLI(5,1),      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, 0),
#endif /* BLACKMARKET */

A("Deathsword",                   TWO_HANDED_SWORD,
	(SPFX_RESTR|SPFX_DFLAG2), 0, S_HUMAN,
	PHYS(5,14),      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_BARBARIAN),

A("Bat from Hell",                BASEBALL_BAT,
	(SPFX_RESTR), 0, 0,
	PHYS(3,20),      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_ROGUE),

A("Elfrist",                    ORCISH_SPEAR,
	SPFX_DFLAG2, 0, M2_ELF,
	PHYS(5,15),     NO_DFNS,        NO_CARY,        0, A_CHAOTIC, PM_HUMAN_WEREWOLF),

A("Plague", DARK_ELVEN_BOW,	/* KMH */
	(SPFX_RESTR|SPFX_DEFN), 0, 0,
	PHYS(5,7),        DFNS(AD_DRST),  NO_CARY,        0, A_CHAOTIC, PM_DROW),
	/* Auto-poison code in dothrow.c */

A("Hellfire", CROSSBOW,	/* WAC */
	(SPFX_RESTR|SPFX_DEFN), 0, 0,
	PHYS(5,7),        FIRE(0,0),  NO_CARY,        0, A_CHAOTIC, 0),
	/* Auto-explode code in dothrow.c, uhitm.c */

#ifdef P_SPOON
A("Houchou",                SPOON,
	(SPFX_RESTR), 0, 0,
        NO_ATTK,      NO_DFNS,        NO_CARY,        0, A_CHAOTIC, 0),
#endif


/*** Special Artifacts ***/

# ifdef WALLET_O_P
/* KMH -- made it a bag of holding */
A("Wallet of Perseus",       BAG_OF_HOLDING,
        (SPFX_RESTR), 0, 0,
        NO_ATTK,        NO_DFNS,        NO_CARY,
        0,      A_NONE, 0),
# endif /* WALLET_O_P */

A("Nighthorn", UNICORN_HORN,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_REFLCT), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	0,      A_LAWFUL, 0),

A("The Key of Law", SKELETON_KEY,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	0,      A_LAWFUL, 0),

A("The Eye of the Beholder", EYEBALL,
	(SPFX_NOGEN|SPFX_RESTR), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	DEATH_GAZE,     A_NEUTRAL, 0),

A("The Key of Neutrality", SKELETON_KEY,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	0,      A_NEUTRAL, 0),

#if 0
/* Eye/Hand of Vecna */
/* don't use hand/eye for anything else! */
A("The Eye of Vecna",       EYEBALL,
	(SPFX_NOGEN|SPFX_RESTR), (SPFX_ESP|SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_COLD),
	DEATH_GAZE,      A_CHAOTIC, 0),
#endif

A("The Hand of Vecna",       SEVERED_HAND,
	(SPFX_NOGEN|SPFX_RESTR), (SPFX_REGEN|SPFX_HPHDAM), 0,
	NO_ATTK,        DRLI(0,0),      CARY(AD_COLD),
	SUMMON_UNDEAD,          A_CHAOTIC, 0),

A("The Key of Chaos", SKELETON_KEY,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	0,      A_CHAOTIC, 0),


/*** The artifacts for the quest dungeon, all self-willed ***/

A_QUEST("The Orb of Detection",       CRYSTAL_BALL,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), (SPFX_ESP|SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	INVIS,          A_LAWFUL, PM_ARCHEOLOGIST),

A_QUEST("The Heart of Ahriman", LUCKSTONE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), SPFX_STLTH, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	LEVITATION,     A_CHAOTIC, PM_BARBARIAN),

A_QUEST("The Sceptre of Might",       QUARTERSTAFF,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_DALIGN), 0, 0,
	PHYS(3,5),      NO_DFNS,        CARY(AD_MAGM),
	CONFLICT,       A_LAWFUL, PM_CAVEMAN),

/* STEPHEN WHITE'S NEW CODE */
A_QUEST("The Medallion of Shifters",  AMULET_OF_ESP,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	PROT_POLY,      A_NEUTRAL, PM_DOPPELGANGER),

#ifdef DWARF
A_QUEST("The Arkenstone",       DIAMOND,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_LUCK), 0, 0,
	NO_ATTK,      NO_DFNS,    CARY(AD_MAGM),
	OBJ_DETECTION,            A_LAWFUL, PM_DWARF),
#endif

A_QUEST("The Palantir of Westernesse",        CRYSTAL_BALL,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL),
		(SPFX_ESP|SPFX_REGEN|SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	TAMING,         A_LAWFUL, PM_ELF),

A_QUEST("The Tentacle Staff",  QUARTERSTAFF,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_ATTK|SPFX_DRLI), (SPFX_EREGEN|SPFX_HSPDAM), 0,
	DRLI(8,5),        NO_DFNS,        CARY(AD_MAGM),
	LEV_TELE,         A_CHAOTIC, PM_DROW),

/* STEPHEN WHITE'S NEW CODE */
A_QUEST("The Candle of Eternal Flame",        MAGIC_CANDLE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), (SPFX_WARN|SPFX_TCTRL), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_COLD),
	SUMMON_FIRE_ELEMENTAL,         A_NEUTRAL, PM_FLAME_MAGE),

A_QUEST("The Pick of Flandal Steelskin",       PICK_AXE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_DALIGN), (SPFX_WARN), 0,
	FIRE(5,20),     NO_DFNS,        CARY(AD_FIRE),
	CONFLICT,       A_NEUTRAL, PM_GNOME),

A_QUEST("The Staff of Aesculapius",   QUARTERSTAFF,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_ATTK|SPFX_INTEL|SPFX_DRLI|SPFX_REGEN), 0,0,
	DRLI(3,0),      NO_DFNS,        NO_CARY,
	HEALING,        A_NEUTRAL, PM_HEALER),

A_QUEST("The One Ring", RIN_INVISIBILITY,
    (SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), (SPFX_HSPDAM|SPFX_WARN), 0,
    NO_ATTK,        NO_DFNS,        CARY(AD_DRLI),
	CONFLICT,       A_LAWFUL,       PM_HOBBIT),

/* STEPHEN WHITE'S NEW CODE */
A_QUEST("The Storm Whistle",          MAGIC_WHISTLE,
	(SPFX_NOGEN|SPFX_RESTR), (SPFX_WARN|SPFX_TCTRL), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_FIRE),
	SUMMON_WATER_ELEMENTAL,         A_LAWFUL, PM_ICE_MAGE),

A_QUEST("The Magic Mirror of Merlin", MIRROR,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_SPEAK), SPFX_ESP, 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	0,              A_LAWFUL, PM_KNIGHT),

/* STEPHEN WHITE'S NEW CODE */
A_QUEST("The Staff of Withering",       QUARTERSTAFF,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_ATTK|SPFX_INTEL|SPFX_DRLI|SPFX_DALIGN), 0, 0,
	DRLI(3,5),      NO_DFNS,        CARY(AD_COLD),
	ENERGY_BOOST,   A_CHAOTIC, PM_HUMAN_WEREWOLF),

/* STEPHEN WHITE'S NEW CODE */
A_QUEST("The Mantle of Knowledge",      HELM_OF_BRILLIANCE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), SPFX_ESP, 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	ENERGY_BOOST,   A_NEUTRAL, PM_MONK),

A_QUEST("The Great Dagger of Glaurgnaa",       GREAT_DAGGER,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_ATTK|SPFX_INTEL|SPFX_DRLI|SPFX_DALIGN), 0, 0,
	DRLI(8,4),      NO_DFNS,        CARY(AD_MAGM),
	ENERGY_BOOST,   A_CHAOTIC, PM_NECROMANCER),

A_QUEST("The Mitre of Holiness",      HELM_OF_BRILLIANCE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_DCLAS|SPFX_INTEL), 0, M2_UNDEAD,
	NO_ATTK,        NO_DFNS,        CARY(AD_FIRE),
	ENERGY_BOOST,   A_LAWFUL, PM_PRIEST),

A_QUEST("The Master Key of Thievery", SKELETON_KEY,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_SPEAK),
		(SPFX_WARN|SPFX_TCTRL|SPFX_HPHDAM), 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	UNTRAP,         A_CHAOTIC, PM_ROGUE),

A_QUEST("The Tsurugi of Muramasa",    TSURUGI,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_BEHEAD|SPFX_LUCK), 0, 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	0,              A_LAWFUL, PM_SAMURAI),

# ifdef TOURIST
A_QUEST("The Platinum Yendorian Express Card", CREDIT_CARD,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_DEFN),
		(SPFX_ESP|SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	CHARGE_OBJ,     A_NEUTRAL, PM_TOURIST),
# endif

/* KMH -- More effective against normal monsters
 * Was +10 to-hit, +d20 damage only versus vampires
 */
A_QUEST("The Stake of Van Helsing",        WOODEN_STAKE,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), 0, 0,
	PHYS(5,12),    NO_DFNS,        CARY(AD_MAGM),
	0,              A_LAWFUL, PM_UNDEAD_SLAYER),

A_QUEST("The Orb of Fate",            CRYSTAL_BALL,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL|SPFX_LUCK),
		(SPFX_WARN|SPFX_HSPDAM|SPFX_HPHDAM), 0,
	NO_ATTK,        NO_DFNS,        NO_CARY,
	LEV_TELE,       A_NEUTRAL, PM_VALKYRIE),

A_QUEST("The Eye of the Aethiopica",  AMULET_OF_ESP,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), (SPFX_EREGEN|SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	CREATE_PORTAL,  A_NEUTRAL, PM_WIZARD),

#ifdef YEOMAN
A_QUEST("The Crown of Saint Edward", HELM_OF_TELEPATHY,
	(SPFX_NOGEN|SPFX_RESTR|SPFX_INTEL), (SPFX_HSPDAM), 0,
	NO_ATTK,        NO_DFNS,        CARY(AD_MAGM),
	0,  A_LAWFUL, PM_YEOMAN),
#endif

/*
 *  terminator; otyp must be zero
 */
A(0, 0, 0, 0, 0, NO_ATTK, NO_DFNS, NO_CARY, 0, A_NONE, 0)

};      /* artilist[] (or artifact_names[]) */

#undef  A
#undef  A_QUEST

#ifndef MAKEDEFS_C
#undef  NO_ATTK
#undef  NO_DFNS
#undef  DFNS
#undef  PHYS
#undef  DRLI
#undef  COLD
#undef  FIRE
#undef  ELEC
#undef  STUN
#endif

/*artilist.h*/
