
/* CREATE TABLES */

CREATE TABLE `sitebar_acl` (
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  `nid` int(10) unsigned NOT NULL DEFAULT '0',
  `allow_select` tinyint(1) NOT NULL DEFAULT '1',
  `allow_update` tinyint(1) NOT NULL DEFAULT '0',
  `allow_delete` tinyint(1) NOT NULL DEFAULT '0',
  `allow_purge` tinyint(1) NOT NULL DEFAULT '0',
  `allow_insert` tinyint(1) NOT NULL DEFAULT '0',
  `allow_grant` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`gid`,`nid`),
  KEY `IGID` (`gid`)
) TYPE=MyISAM COMMENT='Access control list. Defines rights of groups to root nodes.';

CREATE TABLE `sitebar_config` (
  `gid_admins` int(10) unsigned NOT NULL DEFAULT '1',
  `gid_everyone` int(10) unsigned NOT NULL DEFAULT '2',
  `release` varchar(10) NOT NULL DEFAULT '3.2.5',
  `params` text
) TYPE=MyISAM COMMENT='Basic Sitebar parameters';

CREATE TABLE `sitebar_group` (
  `gid` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(50) DEFAULT NULL,
  `allow_addself` tinyint(1) NOT NULL DEFAULT '0',
  `allow_contact` tinyint(1) NOT NULL DEFAULT '0',
  `auto_join` text,
  `comment` text,
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='Groups of users with auto join feature.';

CREATE TABLE `sitebar_link` (
  `lid` int(10) unsigned NOT NULL auto_increment,
  `nid` int(10) unsigned NOT NULL DEFAULT '0',
  `url` text NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `private` tinyint(1) DEFAULT '0',
  `comment` longtext DEFAULT '',
  `favicon` text DEFAULT '',
  `changed` timestamp(14) NOT NULL,
  `tested` timestamp(14) NOT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `is_dead` tinyint(1) NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `validate` tinyint(1)  NOT NULL DEFAULT '1',
  PRIMARY KEY  (`lid`),
  UNIQUE KEY `name` (`nid`,`name`)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='Each link must belong to a node.';

CREATE TABLE `sitebar_visit` (
  `lid` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `visit` timestamp(14) NOT NULL,
  PRIMARY KEY  (`lid`,`uid`)
) TYPE=MyISAM COMMENT='Last link visit for each user';

CREATE TABLE `sitebar_member` (
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `moderator` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`gid`,`uid`)
) TYPE=MyISAM COMMENT='Membership';

CREATE TABLE `sitebar_node` (
  `nid` int(10) unsigned NOT NULL auto_increment,
  `nid_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `comment` text,
  `sort_mode` char(10) DEFAULT 'user',
  `custom_order` text,
  PRIMARY KEY  (`nid`),
  UNIQUE KEY `name` (`nid_parent`,`name`),
  KEY `pnid` (`nid_parent`)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='Node contains other nodes and links.';

CREATE TABLE `sitebar_root` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY  (`nid`),
  UNIQUE KEY `nid` (`nid`,`uid`)
) TYPE=MyISAM COMMENT='Contains list of trees and their respective owners.';

CREATE TABLE `sitebar_user` (
  `uid` int(10) unsigned NOT NULL auto_increment,
  `email` varchar(50) NOT NULL DEFAULT '',
  `pass` varchar(32) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `demo` tinyint(1) NOT NULL DEFAULT '0',
  `code` int(6) DEFAULT NULL,
  `comment` text,
  `params` text,
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `email` (`email`)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='Users of the application.';

CREATE TABLE `sitebar_session` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `code` varchar(32) NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `expires` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY  (`code`)
) TYPE=MyISAM COMMENT='Session management';

CREATE TABLE `sitebar_favicon` (
  `favicon_md5` char(32) NOT NULL,
  `ico` mediumblob NOT NULL,
  `changed` timestamp(14) NOT NULL,
  PRIMARY KEY  (`favicon_md5`)
) TYPE=MyISAM COMMENT='Contains the favicon cache.';

/* INSERT DEFAULT DATA
   - this data can be modified, however this is standard setup and
     any change here might lead to malfunction of SiteBar 3.
*/

INSERT INTO `sitebar_config` VALUES();

INSERT INTO `sitebar_user` (`uid`, `email`, `comment`)
VALUES (1, 'Admin', 'Administrator of the system');

INSERT INTO `sitebar_user` (`uid`, `email`, `name`, `params`)
VALUES (2, 'Anonymous', 'Anonymous user','root_order=2~1');

INSERT INTO `sitebar_group` VALUES (1, 'Admins', 0, 0, NULL, 'DEFAULT group for administrators');
INSERT INTO `sitebar_group` VALUES (2, 'Everyone', 1, 1, '.*', 'DEFAULT public group');

INSERT INTO `sitebar_member` VALUES (1, 1, 1);
INSERT INTO `sitebar_member` VALUES (2, 1, 1);
INSERT INTO `sitebar_member` VALUES (2, 2, 0);

INSERT INTO `sitebar_node` VALUES (1, 0, 'Admins&#39; Bookmarks', NULL, 'Bookmarks of SiteBar Administrators','user','');
INSERT INTO `sitebar_node` VALUES (2, 0, 'Public Bookmarks', NULL, NULL,'user','');

INSERT INTO `sitebar_root` VALUES (1, 1);
INSERT INTO `sitebar_root` VALUES (2, 1);

INSERT INTO `sitebar_acl` VALUES (1, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `sitebar_acl` VALUES (1, 2, 1, 1, 1, 1, 1, 1);
INSERT INTO `sitebar_acl` VALUES (2, 2, 1, 0, 0, 0, 0, 0);

/* SITEBAR Bookmarks */

INSERT INTO `sitebar_node` VALUES (3, 2, 'SiteBar Project', NULL, '', 'custom', 'n4~102:n5~103:n6~101:n7~104:n9~105:n10~106:l1~110:l2~100:l3~111');
INSERT INTO `sitebar_node` VALUES (4, 3, 'Development Team', NULL, 'Members and their roles', 'custom', 'l4~102:l5~101:l6~100:l7~103:l8~10');
INSERT INTO `sitebar_node` VALUES (5, 3, 'Documentation', NULL, '', 'custom', 'l9~13:l10~14:l11~12:l12~11:l13~10');
INSERT INTO `sitebar_node` VALUES (6, 3, 'Forums', NULL, NULL, 'user', NULL);
INSERT INTO `sitebar_node` VALUES (7, 3, 'Project Details', NULL, 'Hosted on Sourceforge.net', 'custom', 'l18~10:l17~11:l19~21:l16~22:l20~13:l21~14');
INSERT INTO `sitebar_node` VALUES (8, 7, 'Trackers', 1, NULL, 'user', NULL);
INSERT INTO `sitebar_node` VALUES (9, 3, 'Promotion', NULL, 'Please rate SiteBar if you like it.', 'user', NULL);
INSERT INTO `sitebar_node` VALUES (10, 3, 'User Reviews', NULL, NULL, 'user', NULL);

INSERT INTO `sitebar_link` VALUES (1, 3, 'http://brablc.com/sitebar', 'Development Demo', 0, 'The most up-to-date version of SiteBar (CVS or pre CVS).', 'http://brablc.com/favicon.ico', '2004-04-25 09:32:29', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (2, 3, 'http://www.sitebar.org', 'Homepage', 0, 'Official Homepage', NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (3, 3, 'http://brablc.com/sitebar/translator.php', 'Translations', 0, '', 'http://brablc.com/favicon.ico', '2004-04-25 09:32:20', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (4, 4, 'http://www.mindslip.com/', 'David Szego', 0, 'Author of SiteBar', 'http://www.mindslip.com/favicon.ico', '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (5, 4, 'http://gunnarwrobel.de/', 'Gunnar Wrobel', 0, 'Favicon cache and page validation.', NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (6, 4, 'http://brablc.com/', 'Ondrej Brablc', 0, 'Author of SiteBar Release 3', 'http://brablc.com/favicon.ico', '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (7, 4, 'http://www.sitebar.org/team.php', 'SiteBar Team', 0, NULL, NULL, '2004-04-25 09:23:29', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (8, 5, 'http://www.sitebar.org/?doc=engine', 'Bookmark Backend Engine', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (9,  5, 'http://www.sitebar.org/?doc=licence', 'GNU General Public License', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (10, 5, 'http://www.sitebar.org/?doc=history', 'History Log', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (11, 5, 'http://www.sitebar.org/?doc=install', 'Installation & Upgrade Guide', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (12, 5, 'http://www.sitebar.org/?doc=readme', 'Read Me', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (13, 6, 'http://sourceforge.net/forum/forum.php?forum_id=261003', 'Help', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (14, 6, 'http://sourceforge.net/forum/forum.php?forum_id=261002', 'Open Discussion', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (15, 7, 'http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/sitebar/sitebar3/#dirlist', 'Browse CVS', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (16, 7, 'http://sourceforge.net/project/showfiles.php?group_id=76467', 'Downloads', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (17, 7, 'http://sourceforge.net/projects/sitebar', 'Project Page', 0, 'Open Source Project Hosting Site', NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (18, 7, 'http://sourceforge.net/project/stats/?group_id=76467', 'Project Statistics', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (19, 7, 'http://sourceforge.net/tracker/?group_id=76467&atid=547187', 'Bugs', 0, NULL, NULL, '2004-04-25 09:25:31', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (20, 7, 'http://sourceforge.net/tracker/?group_id=76467&atid=547190', 'Feature Requests', 0, NULL, NULL, '2004-04-25 09:25:34', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (21, 9, 'http://freshmeat.net/projects/sitebar/', 'freshmeat.net', 0, '', '', '2004-04-25 09:36:04', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (22, 9, 'http://www.hotscripts.com/Detailed/26925.html', 'HotScripts.com', 0, '', 'http://www.hotscripts.com/favicon.ico', '2004-04-25 09:29:53', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (23, 9, 'http://www.needscripts.com/Resource/13537.html', 'Need Scripts', 0, '', 'http://www.needscripts.com/ns-images/needscripts.ico', '2004-04-25 09:30:06', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (24, 9, 'http://lbstone.com/apb/stats/', 'Stats for Bookmark Programs', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (25, 9, 'http://www.webscriptsdirectory.com/PHP/Bookmarks/SiteBar-L791/', 'Web Scripts Directory', 0, '', 'http://www.webscriptsdirectory.com/favicon.ico', '2004-04-25 09:30:29', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (26, 10, 'http://www.mis98.com/joediev/archives/2003_12.html#000157', 'Joedie Villanueva&#39;s Blog', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (27, 10, 'http://www.netalive.org/topics/17074', 'Netalive.org', 0, '', 'http://www.netalive.org/images/favicon.ico', '2004-04-25 09:31:38', '0000-00-00 00:00:00', NULL, 0, 0, 1);
INSERT INTO `sitebar_link` VALUES (28, 10, 'http://www.yhbt.com/article.php?story=20030928163414229', 'Philip Lowman&#39;s Blog', 0, NULL, NULL, '2004-04-25 09:20:46', '0000-00-00 00:00:00', NULL, 0, 0, 1);
