#!/bin/sh

# test-setup.sh - test remstats setup
# $Id: test-setup.sh,v 1.17 2001/08/28 15:22:24 remstats Exp $

# - - -   Version History   - - -

# $Revision: 1.17 $

# - - -   Setup   - - -

PATH=${PATH}:@@BINDIR@@
export PATH

if [ $# = 2 ] ; then
	COMMUNITY=$1
	NTSTATUSSERVER=$2
else
	echo >&2 "usage $0 snmp-community nt-status-server-host"
	exit 1
fi

# - - -   Mainline   - - -

echo "=== removing old config ==="
if [ -d @@CONFIGDIR@@ ] ; then
	rm -rf @@CONFIGDIR@@ || exit 1
fi

echo "=== making new configdir ==="
./new-config @@CONFIGDIR@@ || exit 1

echo "=== making groups file ==="
echo Servers >@@CONFIGDIR@@/groups || exit 1
echo Workstations >> @@CONFIGDIR@@/groups || exit 1
echo Network  >>@@CONFIGDIR@@/groups || exit 1
echo Remstats >>@@CONFIGDIR@@/groups || exit 1

echo "=== adding some ping hosts ==="
new-ping-hosts Workstations <<EOD_PING || exit 1
musgrave
openshaw
adler
EOD_PING

echo "=== adding some port hosts ==="
new-port-hosts Servers <<EOD_PORT || exit 1
sherlock
mcmurdo
trevelyan
straker
EOD_PORT

echo "=== adding some snmp hosts ==="
new-snmp-hosts Servers ${COMMUNITY} <<EOD_SNMP || exit 1
c2900-1
3com-hubs
ups1
ups2
EOD_SNMP
grep -v mbps @@CONFIGDIR@@/hosts/3com-hubs >tom
mv tom @@CONFIGDIR@@/hosts/3com-hubs

echo "=== adding some unix hosts ==="
new-unix-hosts Servers <<EOD_UNIX || exit 1
trevelyan
lexington
EOD_UNIX

# Adding the remstats instrumentation
echo "=== adding the remstats instrumentation pseudo-host ==="
cat <<EOD_REMSTATS >@@CONFIGDIR@@/hosts/_remstats_
desc status of remstats itself
tools	availability status
rrd	collector-cisco-access-server
rrd	collector-log
rrd	collector-nt-status
rrd	collector-ping
rrd	collector-port
rrd	collector-snmp
rrd	collector-snmp-route
rrd	collector-unix-status
EOD_REMSTATS

# Add some templates for NT hosts
echo "=== adding some host templates ==="
cat >@@CONFIGDIR@@/host-templates/nt-servers <<EOD_NT_TEMPLATE
group	Servers
tools	ping traceroute availability status
rrd	ping
rrd	ntcpu
rrd	ntmemory
rrd	ntnetworkinterface-0
rrd	ntlogicaldisk-c
EOD_NT_TEMPLATE

cat >@@CONFIGDIR@@/host-templates/nt-status-server <<EOD_NT_SERVER
nt-status-server $NTSTATUSSERVER
EOD_NT_SERVER

# Adding some nt hosts
echo "=== adding some NT hosts ==="
for nt in doyle melas ryder ; do
	if [ "$nt" != "$NTSTATUSSERVER" ] ; then
		echo >>@@CONFIGDIR@@/hosts/$nt template nt-status-server
	fi
	cat >>@@CONFIGDIR@@/hosts/$nt <<EOD_NT
desc	NT host $nt
template nt-servers
EOD_NT
done

echo "=== checking config ==="
check-config || exit 1

echo "=== collecting some data ==="
touch @@CONFIGDIR@@
run-remstats || exit 1
echo "=== sleeping 5 min ==="
sleep 300
echo "=== collecting a second pass ==="
run-remstats || exit 1
