#ifndef	_PPXP_CPS_H
#define	_PPXP_CPS_H

#define	ENDOF_LIST	0xff

enum {
    CPCODE_VENDOR_SPEC=0,
    CPCODE_CONF_REQ,
    CPCODE_CONF_ACK,
    CPCODE_CONF_NAK,
    CPCODE_CONF_REJ,
    CPCODE_TERM_REQ,
    CPCODE_TERM_ACK,
    CPCODE_CODE_REJ,
    CPCODE_PROT_REJ,
    CPCODE_ECHO_REQ,
    CPCODE_ECHO_REP,
    CPCODE_DISC_REQ,
    CPCODE_IDENTIFICATION,
    CPCODE_TIME_REM,
    CPCODE_RESET_REQ,
    CPCODE_RESET_ACK,
    CPCODE_MAX
};

typedef u_int8_t	cpcode_t;
typedef u_int8_t	cptype_t;
struct fsmreg_s;

struct cpframeheader_s {
    cpcode_t code;
    u_int8_t id;
    u_int16_t nbo_len;
};

struct cpdataheader_s {
    cptype_t type;
    u_int8_t len;
};

#define	RSIZEOF_CPDATAHEADER	2	/* sizeof(struct cpdataheader_s) */

struct cpstate_s {
    struct cpcodeop_s {		/* code oprators */
	int (*fsmevent)();
	int (*encode)();
    } *cop;
    struct cptypeop_s {		/* type operators */
	const char *name;	/* description */
	char *(*tostr)();	/* to printable string */
	void *entry;		/* entry buffer */
	int (*coder)();		/* special encoder/decoder */
	int size;		/* bytes of data */
	cptype_t type;
    } *top;
    void *r_reg;
    void *l_reg;
    u_char **r_bp;		/* Received buffer pointers */
    cptype_t *e_order;		/* Encode order */
    cptype_t *r_order;		/* Remote(Received) order */
    cptype_t *l_order;		/* Local order */
    b256_t e_list;	/* Encode list */
    b256_t r_list;	/* Requested(Remote) list */
    b256_t l_list;	/* Request(Local) list */
    cptype_t num_type;
    u_int16_t nbo_proto;
    u_int8_t r_id, l_id;	/* remote, local ID */
};

extern int CpEncode16();
extern void CpEnqueueFrame(struct fsmreg_s *, cpcode_t,  void *, u_int8_t);
extern int CpEncodeReg();
extern int CpDecodeReg();
extern time_t CpDecodeFrame();
extern int CpRtr();
extern int CpRta();
extern void RegisterCp();

#endif	/* _PPXP_CPS_H */
