<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.uitimeperiod.inc.php,v 1.29 2001/09/06 22:56:15 bettina Exp $ */

	class uitimeperiod
	{
		var $grants;
		var $cat_id;
		var $start;
		var $order;
		var $sort;
		var $filter;

		var $public_functions = array
		(
			'prefs_time'	=> True,
			'add_tp'		=> True,
			'edit_tp'		=> True,
			'delete_tp'		=> True,
			'view_tp'		=> True,
			'setup_time'	=> True,
			'add_time'		=> True
		);

		function uitimeperiod()
		{
			global $phpgw, $phpgw_info;

			$this->account					= $phpgw_info['user']['account_id'];
			$this->t						= $phpgw->template;
			$this->cats						= CreateObject('phpgwapi.categories');
			$this->nextmatchs				= CreateObject('phpgwapi.nextmatchs');
			$this->grants					= $phpgw->acl->get_grants('netsaint');
			$this->grants[$this->account]	= PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;
			$this->botimeperiod				= CreateObject('netsaint.botimeperiod',True);
			$this->bonetsaint				= CreateObject('netsaint.bonetsaint');

			$this->start					= $this->botimeperiod->start;
			$this->query					= $this->botimeperiod->query;
			$this->filter					= $this->botimeperiod->filter;
			$this->sort						= $this->botimeperiod->sort;
			$this->order					= $this->botimeperiod->order;
			$this->cat_id					= $this->botimeperiod->cat_id;
		}

		function save_sessiondata()
		{
			$data = array
			(
				'start'		=> $this->start,
				'query'		=> $this->query,
				'filter'	=> $this->filter,
				'sort'		=> $this->sort,
				'order'		=> $this->order,
				'cat_id'	=> $this->cat_id
			);
			$this->botimeperiod->save_sessiondata($data);
		}

		function set_app_langs()
		{
			global $phpgw, $phpgw_info, $tr_color;

			$this->t->set_var('bg_color',$phpgw_info['theme']['th_bg']);
			$this->t->set_var('row_on',$phpgw_info['theme']['row_on']);
			$this->t->set_var('row_off',$phpgw_info['theme']['row_off']);

			$this->t->set_var('lang_netsaint',lang('Netsaint'));
			$this->t->set_var('lang_prefs',lang('Preferences'));	
			$this->t->set_var('lang_timeperiods',lang('Time Periods'));
			$this->t->set_var('lang_hosts',lang('Hosts'));
			$this->t->set_var('lang_host_groups',lang('Host groups'));
			$this->t->set_var('lang_contacts',lang('Contacts'));
			$this->t->set_var('lang_contact_groups',lang('Contact groups'));
			$this->t->set_var('lang_services',lang('Services'));
			$this->t->set_var('lang_notifications',lang('Notifications'));
			$this->t->set_var('lang_s_escalation',lang('Service escalation'));
			$this->t->set_var('lang_hg_escalation',lang('Host group escalation'));
			$this->t->set_var('lang_escalations',lang('Escalations'));

			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_view',lang('View'));
			$this->t->set_var('lang_edit',lang('Edit'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('lang_delete',lang('Delete'));

			$this->t->set_var('lang_times',lang('Times'));
			$this->t->set_var('lang_edit_times',lang('Edit times'));
			$this->t->set_var('lang_add_time',lang('Add time'));
			$this->t->set_var('lang_repeat',lang('Repeat this times every day'));
			$this->t->set_var('lang_repeat_days',lang('Select days to repeat this times'));
			$this->t->set_var('lang_name',lang('Short name'));
			$this->t->set_var('lang_alias',lang('Description'));
			$this->t->set_var('lang_cat',lang('Category'));
			$this->t->set_var('lang_private',lang('Private'));
			$this->t->set_var('lang_access',lang('Access'));
			$this->t->set_var('lang_mo',lang('monday'));
			$this->t->set_var('lang_di',lang('tuesday'));
			$this->t->set_var('lang_mi',lang('wednesday'));
			$this->t->set_var('lang_do',lang('thursday'));
			$this->t->set_var('lang_fr',lang('friday'));
			$this->t->set_var('lang_sa',lang('saturday'));
			$this->t->set_var('lang_so',lang('sunday'));
			$this->t->set_var('lang_created',lang('Created by'));
			$this->t->set_var('lang_modified',lang('last modified'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_all',lang('All'));
			$this->t->set_var('lang_enter_per_week',lang('Specify the times and select the days to repeat'));
			$this->t->set_var('lang_enter_per_day',lang('Specify the times per day'));
		}

		function display_prefs_header()
		{
			global $phpgw, $phpgw_info, $Update;

			$this->t->set_file(array('prefs' => 'prefs_header.tpl'));
            $this->t->set_block('prefs','header');

			if ($Update)
			{
				$msg = $this->bonetsaint->check_config();

				if (is_array($msg))
				{
					$this->t->set_var('message',$phpgw->common->error_list($msg));
				}
				else
				{
					$this->bonetsaint->create_config();
					$this->t->set_var('message',lang('Netsaint configuration files have been created successfully !'));
					$this->bonetsaint->set_config_status('off');
				}
			}

			$this->set_app_langs();

			$this->t->set_var('link_time',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));
			$this->t->set_var('link_host',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_host&action=host'));
			$this->t->set_var('link_host_group',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_hg&action=hg'));
			$this->t->set_var('link_contact',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_contact&action=contact'));
			$this->t->set_var('link_contact_group',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_cg&action=cg'));
			$this->t->set_var('link_service',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_service&action=service'));
			$this->t->set_var('link_escalation',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_escal&action=host'));

			$update_config = $this->bonetsaint->check_config_status();

			if ($update_config == True)
			{
				$this->t->set_var('update','<form method="POST"><input type="submit" name="Update" value="' . lang('Update') . '"></form>');
			}
			else
			{
				$this->t->set_var('update','');
			}

			$this->t->fp('prefs','header');

			$phpgw->common->phpgw_header();
			echo parse_navbar();
		}

		function prefs_time()
		{
			global $phpgw, $phpgw_info;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'item_list_t' => 'prefs_default.tpl'));
			$this->t->set_block('item_list_t','item_list','list');

			if (!$this->start)
			{
				$this->start = 0;
			}

			$time_list = $this->botimeperiod->read_timeperiods($this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$link_data = array
			(
				'menuaction' => 'netsaint.uitimeperiod.prefs_time'
			);

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->botimeperiod->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->botimeperiod->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->botimeperiod->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Time periods'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'tp_name',$this->order,'/index.php',lang('Short name')));
			$this->t->set_var(sort_alias,$this->nextmatchs->show_sort_order($this->sort,'tp_alias',$this->order,'/index.php',lang('Description')));
			$this->t->set_var(sort_owner,$this->nextmatchs->show_sort_order($this->sort,'tp_owner',$this->order,'/index.php',lang('created by')));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'tp_date',$this->order,'/index.php',lang('last modified')));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($time_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);
				$new_date = $time_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$alias = split(' ',$phpgw->strip_html($time_list[$i]['alias']));
				$first = "$alias[0] $alias[1] $alias[2] $alias[3] .....";

				$cached_data = $this->bonetsaint->cached_accounts(intval($time_list[$i]['owner']));
				$ownerout = $phpgw->strip_html($cached_data[$time_list[$i]['owner']]['account_lid']
                                        . ' [' . $cached_data[$time_list[$i]['owner']]['firstname'] . ' '
                                        . $cached_data[$time_list[$i]['owner']]['lastname'] . ' ]');

				$this->t->set_var(array
				(
					'i_name'	=> $phpgw->strip_html($time_list[$i]['name']),
					'alias'		=> $first,
					'owner'		=> $ownerout,
					'modified'	=> $new_dateout
				));

				$link_data['tp_id'] = $time_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uitimeperiod.view_tp';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$time_list[$i]['owner']],PHPGW_ACL_EDIT) || $time_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uitimeperiod.edit_tp';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$time_list[$i]['owner']],PHPGW_ACL_DELETE) || $time_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uitimeperiod.delete_tp';

					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','item_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.add_tp',
				'cat_id'		=> $this->cat_id
			);

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add time period') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add time period') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','item_list_t',True);
			$this->save_sessiondata();
//			$phpgw->common->phpgw_footer();
		}

		function setup_time()
		{
			global $phpgw, $phpgw_info, $action, $start, $delete, $t_id, $tp_id;

			if ($delete)
			{
				$this->botimeperiod->delete_timeperiod('time',$t_id);
			}

			$this->display_prefs_header();

			$this->t->set_file(array('time_list_t' => 'setup_time.tpl'));
			$this->t->set_block('time_list_t','time_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.setup_time',
				'tp_id'			=> $tp_id,
				'action'		=> $action,
				'start'			=> $start,
				'delete'		=> False
			);

			if (!$start)
			{
				$start = 0;
			}

			$time_list = $this->botimeperiod->read_times($start, True);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$start,$this->botimeperiod->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$start,$this->botimeperiod->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->botimeperiod->total_records,$start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Times'));

			for ($i=0;$i<count($time_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);
				$this->t->set_var(array
				(
					't_value'	=> $time_list[$i]['value']
				));

				$link_data['t_id'] = $time_list[$i]['id'];
				$link_data['delete'] = True;

				$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_delete_entry',lang('Delete'));

				$this->t->fp('list','time_list',True);
			}

			$link_data['menuaction'] = 'netsaint.uitimeperiod.add_time';

			$this->t->set_var('addurl',$phpgw->link('/index.php',$link_data));

			switch ($action)
			{
				case 'add': $link_data['menuaction'] = 'netsaint.uitimeperiod.add_tp'; break;
				case 'edit': $link_data['menuaction'] = 'netsaint.uitimeperiod.edit_tp'; break;
			}

			$this->t->set_var('doneurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_add_times',lang('Add times'));

			$this->t->pfp('out','time_list_t',True);
//			$phpgw->common->phpgw_footer();
		}

		function add_tp()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.add_tp'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				$error = $this->botimeperiod->check_values('tp', $values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->botimeperiod->save_timeperiod('tp', $values);

					$link_data['menuaction'] = 'netsaint.uitimeperiod.prefs_time';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('time_add' => 'tp_form.tpl'));
			$this->t->set_block('time_add','add','addhandle');
			$this->t->set_block('time_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('timeurl',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.setup_time&action=add'));

			$this->t->set_var('lang_action',lang('Add time period'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('repeat','<input type="checkbox" name="values[repeat]" value="True">');

			$this->t->set_var('tp_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('alias',$phpgw->strip_html($values['alias']));


			$this->t->set_var('seven_select',$this->botimeperiod->select_tp_list('time',$values['seven']));

// -------- monday -----------------------

			$this->t->set_var('mo_select',$this->botimeperiod->select_tp_list('time',$values[0]));

// ------------ dienstag --------------------

			$this->t->set_var('di_select',$this->botimeperiod->select_tp_list('time',$values[1]));

// -------------- mittwoch ------------------

			$this->t->set_var('mi_select',$this->botimeperiod->select_tp_list('time',$values[2]));

// ---------------- donnerstag ---------------

			$this->t->set_var('do_select',$this->botimeperiod->select_tp_list('time',$values[3]));

// ---------------- freitag --------------------

			$this->t->set_var('fr_select',$this->botimeperiod->select_tp_list('time',$values[4]));

// --------------- saturday -----------------------

			$this->t->set_var('sa_select',$this->botimeperiod->select_tp_list('time',$values[5]));

// ---------------- sunday --------------------------

			$this->t->set_var('so_select',$this->botimeperiod->select_tp_list('time',$values[6]));

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','time_add');
			$this->t->pfp('addhandle','add');
//			$phpgw->common->phpgw_footer();
		}

		function add_time()
		{
			global $phpgw, $phpgw_info, $add, $values, $action, $tp_id;

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.add_time',
				'tp_id'			=> $tp_id,
				'action'		=> $action
			);

			if ($add)
			{
				$error = $this->botimeperiod->check_values('time',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->botimeperiod->save_timeperiod('time', $values);

					$link_data['menuaction'] = 'netsaint.uitimeperiod.setup_time';

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('time_add' => 'time_form.tpl'));

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add time'));

			$this->t->set_var('lang_shour',lang('Start hour'));
			$this->t->set_var('lang_smin',lang('Start minute'));
			$this->t->set_var('lang_ehour',lang('End hour'));
			$this->t->set_var('lang_emin',lang('End minute'));

			for ($i=0;$i<=24;$i++)
			{
				$i_f = sprintf("%02d",$i);

				$shour_select .= '<option value="' . $i_f . '">' . $i_f . '</option>';
				$ehour_select .= '<option value="' . $i_f . '">' . $i_f . '</option>';
			}

			for ($j=0;$j<=59;$j++)
			{
				$j_f = sprintf("%02d",$j);

				$smin_select .= '<option value="' . $j_f . '">' . $j_f . '</option>';
				$emin_select .= '<option value="' . $j_f . '">' . $j_f . '</option>';
			}

			$this->t->set_var('shour_select',$shour_select);
			$this->t->set_var('ehour_select',$ehour_select);
			$this->t->set_var('smin_select',$smin_select);
			$this->t->set_var('emin_select',$emin_select);

			$this->t->pfp('out','time_add');
//			$phpgw->common->phpgw_footer();
		}

		function edit_tp()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $tp_id;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.edit_tp',
				'tp_id'			=> $tp_id
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $tp_id;

				$error = $this->botimeperiod->check_values('tp', $values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->botimeperiod->save_timeperiod('tp', $values);
					$this->bonetsaint->set_config_status('on');
					$link_data['menuaction'] = 'netsaint.uitimeperiod.prefs_time';
					$link_data['cat_id'] = $cat_id;
					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('time_edit' => 'tp_form.tpl'));
			$this->t->set_block('time_edit','add','addhandle');
			$this->t->set_block('time_edit','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit time period'));

			$link_data['menuaction']	= 'netsaint.uitimeperiod.setup_time';
			$link_data['action']		= 'edit';

			$this->t->set_var('timeurl',$phpgw->link('/index.php',$link_data));

			$values = $this->botimeperiod->read_single_tp($tp_id);

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('repeat','<input type="checkbox" name="values[repeat]" value="True">');

			$this->t->set_var('tp_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('alias',$phpgw->strip_html($values['alias']));

			if ($values['mon_time'])
			{
				$saved_mon = explode(',',$values['mon_time']);
			}

			if ($values['tue_time'])
			{
				$saved_tue = explode(',',$values['tue_time']);
			}

			if ($values['wed_time'])
			{
				$saved_wed = explode(',',$values['wed_time']);
			}

			if ($values['thu_time'])
			{
				$saved_thu = explode(',',$values['thu_time']);
			}

			if ($values['fri_time'])
			{
				$saved_fri = explode(',',$values['fri_time']);
			}

			if ($values['sat_time'])
			{
				$saved_sat = explode(',',$values['sat_time']);
			}

			if ($values['sun_time'])
			{
				$saved_sun = explode(',',$values['sun_time']);
			}

			$this->t->set_var('seven_select',$this->botimeperiod->select_tp_list('time',$values['seven']));

// -------- monday -----------------------

			$this->t->set_var('mo_select',$this->botimeperiod->select_tp_list('time',$saved_mon));

// ------------ dienstag --------------------

			$this->t->set_var('di_select',$this->botimeperiod->select_tp_list('time',$saved_tue));

// -------------- mittwoch ------------------

			$this->t->set_var('mi_select',$this->botimeperiod->select_tp_list('time',$saved_wed));

// ---------------- donnerstag ---------------

			$this->t->set_var('do_select',$this->botimeperiod->select_tp_list('time',$saved_thu));

// ---------------- freitag --------------------

			$this->t->set_var('fr_select',$this->botimeperiod->select_tp_list('time',$saved_fri));

// --------------- saturday -----------------------

			$this->t->set_var('sa_select',$this->botimeperiod->select_tp_list('time',$saved_sat));

// ---------------- sunday --------------------------

			$this->t->set_var('so_select',$this->botimeperiod->select_tp_list('time',$saved_sun));


			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uitimeperiod.delete_tp';

				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','time_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function delete_tp()
		{
			global $phpgw, $confirm, $tp_id;

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uitimeperiod.delete_time',
				'tp_id'			=> $tp_id
			);

			if ($confirm)
			{
				$this->botimeperiod->delete_timeperiod('tp',$tp_id);
				$link_data['menuaction'] = 'netsaint.uitimeperiod.prefs_time';
				Header('Location: ' . $phpgw->link('/index.php',$link_data));				
			}
			else
			{
				$this->display_prefs_header();

				$this->t->set_file(array('delete' => 'delete.tpl'));

				$this->t->set_var('action_url',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('done_action',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));
				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this entry ?'));
				$this->t->set_var('lang_no',lang('No'));
				$this->t->set_var('lang_yes',lang('Yes'));
				$this->t->pfp('out','delete');
//				$phpgw->common->phpgw_footer();
			}
		}

		function view_tp()
		{
			global $tp_id, $phpgw, $phpgw_info;

			$this->display_prefs_header();

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$tp = $this->botimeperiod->read_single_tp($tp_id);
			$this->t->set_var('lang_action',lang('View time period'));

			$this->t->set_var('cat',$this->cats->id2name($tp['cat']));

			$new_date = $tp['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$alias = nl2br($phpgw->strip_html($tp['alias']));

			$this->t->set_var('alias',$alias);
			$this->t->set_var('h_name',$phpgw->strip_html($tp['name']));
			$this->t->set_var('access',lang($tp['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($tp['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$tp['owner']]['account_lid']
                                        . ' [' . $cached_data[$tp['owner']]['firstname'] . ' '
                                        . $cached_data[$tp['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('mon_time',$tp['mon_time']);
			$this->t->set_var('tue_time',$tp['tue_time']);
			$this->t->set_var('wed_time',$tp['wed_time']);
			$this->t->set_var('thu_time',$tp['thu_time']);
			$this->t->set_var('fri_time',$tp['fri_time']);
			$this->t->set_var('sat_time',$tp['sat_time']);
			$this->t->set_var('sun_time',$tp['sun_time']);

			$this->t->set_var('done_action',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('tphandle','tp');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}
	}
?>
