<?php
/**
 * English texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.en.php,v 1.335.2.350 2006/08/08 06:56:57 meliza Exp $
 */
if (preg_match("/lang\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

$pgv_lang["upload_replacement"]		="Upload Replacement";
$pgv_lang["roman_surn"]				= "Romanized Surname";
$pgv_lang["roman_givn"]				= "Romanized Given Names";
$pgv_lang["hebrew_surn"]			= "Hebrew Surname";
$pgv_lang["hebrew_givn"]			= "Hebrew Given Names";
$pgv_lang["include"]				= "Include:";
$pgv_lang["page_x_of_y"]				= "Page #GLOBALS[currentPage]# of #GLOBALS[lastPage]#";
$pgv_lang["options"]				= "Options:";
$pgv_lang["inc_languages"]				= " Languages";
$pgv_lang["config_update_ok"]			= "Configuration file updated successfully.";
$pgv_lang["date_of_entry"]				= "Date of entry in original source";
$pgv_lang["main_media_ok1"]				= "Main media file <b>#GLOBALS[oldMediaName]#</b> successfully renamed to <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_ok2"]				= "Main media file <b>#GLOBALS[oldMediaName]#</b> successfully moved from <b>#GLOBALS[oldMediaFolder]#</b> to <b>#GLOBALS[newMediaFolder]#</b>.";
$pgv_lang["main_media_ok3"]				= "Main media file successfully moved and renamed from <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> to <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail0"]			= "Main media file <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> does not exist.";
$pgv_lang["main_media_fail1"]			= "Main media file <b>#GLOBALS[oldMediaName]#</b> could not be renamed to <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail2"]			= "Main media file <b>#GLOBALS[oldMediaName]#</b> could not be moved from <b>#GLOBALS[oldMediaFolder]#</b> to <b>#GLOBALS[newMediaFolder]#</b>.";
$pgv_lang["main_media_fail3"]			= "Main media file could not be moved and renamed from <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> to <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok1"]			= "Thumbnail file <b>#GLOBALS[oldMediaName]#</b> successfully renamed to <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok2"]			= "Thumbnail file <b>#GLOBALS[oldMediaName]#</b> successfully moved from <b>#GLOBALS[oldThumbFolder]#</b> to <b>#GLOBALS[newThumbFolder]#</b>.";
$pgv_lang["thumb_media_ok3"]			= "Thumbnail file successfully moved and renamed from <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> to <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_fail0"]			= "Thumbnail file <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> does not exist.";
$pgv_lang["thumb_media_fail1"]			= "Thumbnail file <b>#GLOBALS[oldMediaName]#</b> could not be renamed to <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_fail2"]			= "Thumbnail file <b>#GLOBALS[oldMediaName]#</b> could not be moved from <b>#GLOBALS[oldThumbFolder]#</b> to <b>#GLOBALS[newThumbFolder]#</b>.";
$pgv_lang["thumb_media_fail3"]			= "Thumbnail file could not be moved and renamed from <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> to <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["server_file"]				= "File name on server";
$pgv_lang["server_file_advice"]			= "Do not change to keep original file name.";
$pgv_lang["server_file_advice2"]		= "You may enter a URL, beginning with &laquo;http://&raquo;.";
$pgv_lang["server_folder"]				= "Folder name on server";
$pgv_lang["server_folder_advice"]		= "You can enter up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder names to follow the default &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo;.<br />Do not enter the &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo; part of the destination folder name.";
$pgv_lang["server_folder_advice2"]		= "This entry is ignored if you have entered a URL into the file name field.";
$pgv_lang["add_linkid_advice"]			= "Enter or search for the ID of the person, family, or source to which this media item should be linked.";
$pgv_lang["use_browse_advice"]			= "Use the &laquo;Browse&raquo; button to search your local computer for the desired file.";
$pgv_lang["add_media_other_folder"]		= "Other folder... please type in";
$pgv_lang["add_media_file"]				= "Existing Media file on server";
$pgv_lang["link_to_existing_media"]		= "Link to an existing Media item";
$pgv_lang["page_size"]					= "Page size";
$pgv_lang["record_not_found"]			= "The requested GEDCOM record could not be found.  This could be caused by a link to an invalid person or by a corrupt GEDCOM file.";
$pgv_lang["record_marked_deleted"]		= "This record has been marked for deletion upon admin approval.";
$pgv_lang["result_page"]				= "Result Page";
$pgv_lang["edit_media"]					= "Edit Media Item";
$pgv_lang["wiki_main_page"]				= "Wiki Main Page";
$pgv_lang["wiki_users_guide"]			= "Wiki User's Guide";
$pgv_lang["wiki_admin_guide"]			= "Wiki Administrator's Guide";
$pgv_lang["no_search_for"]			= "Be sure to select an option to search for.";
$pgv_lang["no_search_site"]			= "Be sure to select at least one remote site.";
$pgv_lang["other_searches"]			= "Other Searches";
$pgv_lang["multi_site_search"] 		= "Multi Site Search";
$pgv_lang["search_sites"] 			= "Sites to search";
$pgv_lang["search_sites_discription"] = "Search known sites";
$pgv_lang["search_asso_text_unavailable"] = " Association<br /> not yet availabe with <br /> site search";
$pgv_lang["no_known_servers"]		= "No known Servers<br />No results will be found";
$pgv_lang["basic_search_discription"] = "Basic site search";
$pgv_lang["advanced_search_discription"] = "Advanced site search";
$pgv_lang["basic_search"]			= "search";
$pgv_lang["advanced_search"]		= "Advanced site search";
$pgv_lang["name_search"]			= "Name: ";
$pgv_lang["birthdate_search"]		= "Birth date: ";
$pgv_lang["birthplace_search"]		= "Birth Place: ";
$pgv_lang["deathdate_search"]		= "Death date: ";
$pgv_lang["deathplace_search"]		= "Death Place: ";
$pgv_lang["gender_search"]			= "Sex: ";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["site_had"]				= " contained the following";
$pgv_lang["invalid_search_multisite_input"] = "Please enter one of the following:  Name, Birth Date, Birth Place, Death Date, Death Place, and Sex ";
$pgv_lang["invalid_search_multisite_input_gender"] = "Please search again with more information than just sex";
//$pgv_lang["label_ban_server"] = "Submit";
$pgv_lang["link_manage_servers"]    = "Manage Sites";
$pgv_lang["indi_is_remote"]			= "The information for this individual was linked from a remote site.";
$pgv_lang["link_remote"]            = "Link remote person";
$pgv_lang["current_person"]         = "Same As Current";
$pgv_lang["title_remote_link"]      = "Add Remote Link";
$pgv_lang["label_same_server"]      = "Same Site";
$pgv_lang["label_diff_server"]      = "Different Site";
$pgv_lang["label_accept_changes"]   = "Accept All Changes";
$pgv_lang["label_ask_first"]        = "Ask Me First";
$pgv_lang["label_rel_to_current"]   = "Relationship To Current Person";
$pgv_lang["label_location"]         = "Location";
$pgv_lang["label_site"]             = "Site";
$pgv_lang["label_site_url"]         = "Site Url:";
$pgv_lang["label_remote_id"]        = "Remote Person ID";
$pgv_lang["label_local_id"]         = "Person ID";
$pgv_lang["label_merge_options"]    = "Merge Options";
$pgv_lang["label_gedcom_id"]        = "GEDCOM ID";
$pgv_lang["label_gedcom_id2"]       = "GEDCOM ID:";
$pgv_lang["label_add_remote_link"]  = "Add Link";
$pgv_lang["error_remote"]           = "You have selected a remote site.";
$pgv_lang["error_same"]             = "You have selected the same site.";
$pgv_lang["lbl_server_list"]        = "Use an existing site.";
$pgv_lang["lbl_type_server"]        = "Type in a new site.";
$pgv_lang["error_url_blank"]		= "Please do not leave remote site title or URL blank";
$pgv_lang["error_siteauth_failed"]	= "Failed to authenticate to remote site";
$pgv_lang["label_ban_server"]		= "Submit";
$pgv_lang["label_add_search_server"]	= "Add IP";
$pgv_lang["remove_ip"] 			= "Remove IP";
$pgv_lang["label_remove_ip"]		= "Ban IP Address (Eg: 198.128.*.*): ";
$pgv_lang["label_remove_search"]	= "Mark IP addresses as Search Engine Spiders: ";
$pgv_lang["label_username_id"]		= "Username";
$pgv_lang["label_username_id2"]		= "Username: ";
$pgv_lang["label_password_id"]		= "Password";
$pgv_lang["label_password_id2"]		= "Password: ";
$pgv_lang["error_ban_server"]       = "Invalid IP address.";
$pgv_lang["error_view_connections"] = "You must select the site to be Viewed.";
$pgv_lang["error_delete_server"]    = "You must select the site to be Deleted.";
$pgv_lang["title_manage_servers"]   = "Manage Sites";
$pgv_lang["label_banned_servers"]   = "Ban Sites by IP";
$pgv_lang["label_manual_search_engines"]   = "Manually mark Search Engines by IP";
$pgv_lang["label_search_engine_detected"]  = "Search Engine Spider Detected";
$pgv_lang["label_search_engine_spider"]    = "Search Engine Spider";
$pgv_lang["label_ban_view_links"]   = "View links to this banned site";
$pgv_lang["label_delete"]           = "Delete";
$pgv_lang["label_new_server"]       = "Add new site";
$pgv_lang["label_server_url"]       = "Site URL/IP";
$pgv_lang["label_add_server"]       = "Add";
$pgv_lang["label_added_servers"]	= "Added Remote Servers";
$pgv_lang["error_url"]              = "A site must have a URL/IP.";
$pgv_lang["error_exists_server"]    = "The site already exists.";
$pgv_lang["error_view_info"]        = "You must select the person whose information you wish to view.";
$pgv_lang["error_delete_person"]    = "You must select the person whose remote link you wish to delete.";
$pgv_lang["title_view_conns"]       = "View Connections";
$pgv_lang["label_server_info"]      = "All people remotely linked through the site:";
$pgv_lang["label_view_local"]       = "View local information on person";
$pgv_lang["label_view_remote"]      = "View remote information on person";
$pgv_lang["label_individuals"]      = "Individuals";
$pgv_lang["label_families"]         = "Families";

$pgv_lang["ex-spouse"] = "Ex-Spouse";
$pgv_lang["ex-wife"] = "Ex-Wife";
$pgv_lang["ex-husband"] = "Ex-Husband";
$pgv_lang["noemail"] 				= "Addresses without emails";
$pgv_lang["onlyemail"] 				= "Only addresses with emails";
$pgv_lang["maxviews_exceeded"]		= "Page view rate exceeded, try again later.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Send message to users who have not logged in for 6 months";
$pgv_lang["broadcast_never_logged_in"]	= "Send message to users who have never logged in";
$pgv_lang["stats_to_show"]			= "Select the stats to show in this block";
$pgv_lang["stat_avg_age_at_death"]	= "Average age at death";
$pgv_lang["stat_longest_life"]		= "Person who lived the longest";
$pgv_lang["stat_most_children"]		= "Family with the most children";
$pgv_lang["stat_average_children"]	= "Average number of children per family";
$pgv_lang["stat_events"]			= "Total events";
$pgv_lang["stat_media"]				= "Media objects";
$pgv_lang["stat_surnames"]			= "Total surnames";
$pgv_lang["stat_users"]				= "Total users";
$pgv_lang["no_family_facts"]		= "No facts for this family.";

$pgv_lang["sunday_1st"]				= "Su";
$pgv_lang["monday_1st"]				= "M";
$pgv_lang["tuesday_1st"]			= "Tu";
$pgv_lang["wednesday_1st"]			= "W";
$pgv_lang["thursday_1st"]			= "Th";
$pgv_lang["friday_1st"]				= "F";
$pgv_lang["saturday_1st"]			= "Sa";

$pgv_lang["january_1st"]			= "Jan";
$pgv_lang["february_1st"]			= "Feb";
$pgv_lang["march_1st"]				= "March";
$pgv_lang["april_1st"]				= "April";
$pgv_lang["may_1st"]				= "May";
$pgv_lang["june_1st"]				= "June";
$pgv_lang["july_1st"]				= "July";
$pgv_lang["august_1st"]				= "Aug";
$pgv_lang["september_1st"]			= "Sep";
$pgv_lang["october_1st"]			= "Oct";
$pgv_lang["november_1st"]			= "Nov";
$pgv_lang["december_1st"]			= "Dec";

$pgv_lang["edit_source"]			= "Edit Source";
$pgv_lang["source_menu"]			= "Options for source";
$pgv_lang["familybook_chart"]		= "Family Book Chart";
$pgv_lang["family_of"]				= "Family of:&nbsp;";
$pgv_lang["descent_steps"]			= "Descent Steps";

$pgv_lang["user_auto_accept"]		= "Automatically accept changes made by this user";
$pgv_lang["cancel"]					= "Cancel";
$pgv_lang["cookie_help"]			= "This site uses cookies to keep track of your login status.<br /><br />Cookies do not appear to be enabled in your browser. You must enable cookies for this site before you can login.  You can consult your browser's help documentation for information on enabling cookies.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]			= "The information for this individual was linked from a remote site.";
$pgv_lang["link_remote"]            = "Link remote person";
//Add Remote Link
$pgv_lang["current_person"]         = "Same As Current";
$pgv_lang["title_remote_link"]      = "Add Remote Link";
$pgv_lang["title_search_link"]      = "Add Local Link";
$pgv_lang["label_same_server"]      = "Same Site";
$pgv_lang["label_diff_server"]      = "Different Site";
$pgv_lang["label_accept_changes"]   = "Accept All Changes";
$pgv_lang["label_ask_first"]        = "Ask Me First";
$pgv_lang["label_rel_to_current"]   = "Relationship To Current Person";
$pgv_lang["label_location"]         = "Site Location";
$pgv_lang["label_site"]             = "Site";
$pgv_lang["label_site_url"]         = "Site URL:";
$pgv_lang["label_site_url2"]        = "Site URL";
$pgv_lang["label_remote_id"]        = "Remote Person ID";
$pgv_lang["label_local_id"]         = "Person ID";
$pgv_lang["label_merge_options"]    = "Merge Options";
$pgv_lang["label_gedcom_id"]        = "Database ID";
$pgv_lang["label_gedcom_id2"]       = "Database ID: ";
$pgv_lang["label_add_remote_link"]  = "Add Link";
$pgv_lang["error_remote"]           = "You have selected a remote site.";
$pgv_lang["error_same"]             = "You have selected the same site.";
$pgv_lang["error_server_exists"]    = "The site you are trying to insert already exists; please select it from the &laquo;Use an existing site&raquo; list.";
$pgv_lang["lbl_server_list"]        = "Use an existing site.";
$pgv_lang["lbl_type_server"]         = "Type in a new site.";
$pgv_lang["link_success"]			= "Successfully added link";
//new stuff

$pgv_lang["change"]					= "Change";
$pgv_lang["change_family_instr"]	= "Use this page to change or remove family members.<br /><br />For each member in the family, you can use the Change link to choose a different person to fill that role in the family.  You can also use the Remove link to remove that person from the family.<br /><br />When you have finished changing the family members, click the Save button to save the changes.<br />";
$pgv_lang["cancel"]					= "Cancel";
$pgv_lang["change_family_members"]	= "Change Family Members";
$pgv_lang["delete_family_confirm"]	= "Deleting the family will unlink all of the individuals from each other but will leave the individuals in place.  Are you sure you want to delete this family?";
$pgv_lang["delete_family"]			= "Delete family";
$pgv_lang["add_favorite"]			= "Add a new favorite";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Enter an optional note about this favorite";
$pgv_lang["add_fav_or_enter_url"]	= "OR<br />\nEnter a URL and a title";
$pgv_lang["add_fav_enter_id"]		= "Enter a Person, Family, or Source ID";
$pgv_lang["import_time_exceeded"]	= "The execution time limit was reached.  Click the Continue button below to resume importing the GEDCOM file.";
$pgv_lang["next_email_sent"]		= "Next email reminder will be sent after ";
$pgv_lang["last_email_sent"]		= "Last email reminder was sent ";
$pgv_lang["confirm_remove"]			= "Are you sure you want to remove this person from the family?";
$pgv_lang["remove_child"]			= "Remove this child from the family";
$pgv_lang["link_new_husb"]			= "Add a husband using an existing person";
$pgv_lang["link_new_wife"]			= "Add a wife using an existing person";
$pgv_lang["address_labels"]			= "Address Labels";
$pgv_lang["filter_address"]			= "Show addresses that contain:";
$pgv_lang["address_list"]			= "Address List";
$pgv_lang["autocomplete"]			= "Autocomplete";
$pgv_lang["undo_all_confirm"]		= "Are you sure you want to undo all of the changes for this GEDCOM?";
$pgv_lang["undo_all"]				= "Undo all changes";
$pgv_lang["index_edit_advice"]		= "Highlight a  block name and then click on one of the arrow icons to move that highlighted block in the indicated direction.";
$pgv_lang["importing_dates"]		= "Importing date records";
$pgv_lang["changelog"]				= "Version #VERSION# changes";
$pgv_lang["view_changelog"]			= "View changelog.txt file";
$pgv_lang["html_block_descr"]		= "This is a simple HTML block that you can place on your page to add any sort of message you may want.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Put your title here</b></p><br /><p>Click the configure button";
$pgv_lang["html_block_sample_part2"]	= "to change what is printed here.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Advanced HTML";
$pgv_lang["htmlplus_block_descr"]	= "This is an HTML block that you can place on your page to add any sort of message you may want.  You can insert referenes to information from your GEDCOM into the HTML text.";
$pgv_lang["htmlplus_block_templates"] = "Templates";
$pgv_lang["htmlplus_block_content"] = "Content";
$pgv_lang["htmlplus_block_narrative"] = "Narrative style (English only)";
$pgv_lang["num_to_show"]			= "Number of items to show";
$pgv_lang["days_to_show"]			= "Number of days to show";
$pgv_lang["before_or_after"]		= "Place counts before or after name?";
$pgv_lang["before"]					= "before";
$pgv_lang["after"]					= "after";
$pgv_lang["config_block"]			= "Configure";
$pgv_lang["pls_note12"]				= "Please use this field to describe why you are requesting an account on this site and how you are related to the genealogy data.";
$pgv_lang["enter_comments"]			= "Please enter your relationship to the data in the Comments field.";
$pgv_lang["comments"]				= "Comments";
$pgv_lang["none"]					= "None";
$pgv_lang["child-family"]			= "Parents and siblings";
$pgv_lang["spouse-family"]			= "Spouse and children";
$pgv_lang["direct-ancestors"]		= "Direct line ancestors";
$pgv_lang["ancestors"]				= "Direct line ancestors and their families";
$pgv_lang["descendants"]			= "Descendants";
$pgv_lang["choose_relatives"]		= "Choose relatives";
$pgv_lang["relatives_report"]		= "Relatives Report";
$pgv_lang["total_living"]			= "Total living";
$pgv_lang["total_dead"]				= "Total dead";
$pgv_lang["total_not_born"]			= "Total not yet born";
$pgv_lang["remove_custom_tags"]		= "Remove custom PGV tags? (eg. _PGVU, _THUM)";
$pgv_lang["download_zipped"]		= "Download GEDCOM as ZIP file?";
$pgv_lang["cookie_login_help"]		= "This site remembered you from a previous login.  This allows you to access private information and other user-based features, but in order to edit or administer the site, you must login again for increased security.";
$pgv_lang["remember_me"]			= "Remember me from this computer?";
$pgv_lang["add_unlinked_person"]	= "Add an unlinked person";
$pgv_lang["add_unlinked_source"]	= "Add an unlinked source";
$pgv_lang["fams_with_surname"]		= "Families with surname #surname#";
$pgv_lang["support_contact"]		= "Technical help contact";
$pgv_lang["genealogy_contact"]		= "Genealogy contact";
$pgv_lang["continue_import"]		= "Continue importing";
$pgv_lang["importing_places"]		= "Importing place records";
$pgv_lang["common_upload_errors"]	= "This error probably means that the file you tried to upload exceeded the limit set by your host.  The default limit in PHP is 2MB.  You can contact your host's Support group to have them increase the limit in the php.ini file, or you can upload the file using FTP.  Use the <a href=\"uploadgedcom.php?action=add_form\"><b>Add GEDCOM</b></a> page to add a GEDCOM file you have uploaded using FTP.";
$pgv_lang["total_memory_usage"]		= "Total Memory Usage:";
$pgv_lang["mothers_family_with"]	= "Mother's Family with ";
$pgv_lang["fathers_family_with"]	= "Father's Family with ";
$pgv_lang["halfsibling"]			= "Half-Sibling";
$pgv_lang["halfbrother"]			= "Half-Brother";
$pgv_lang["halfsister"]				= "Half-Sister";
$pgv_lang["family_timeline"]		= "Show family on timeline chart";
$pgv_lang["children_timeline"]		= "Show children on timeline chart";
$pgv_lang["other"]					= "Other";
$pgv_lang["sort_by_marriage"]		= "Sort by marriage date";
$pgv_lang["reorder_families"]		= "Reorder Families";
$pgv_lang["indis_with_surname"]		= "Individuals with surname #surname#";
$pgv_lang["first_letter_fname"]		= "Choose a letter to show individuals whose first name starts with that letter.";
$pgv_lang["import_marr_names"]		= "Import Married Names";
$pgv_lang["marr_name_import_instr"]	= "Click the button below only if you want PhpGedView to calculate married names for female individuals in this GEDCOM.  This will allow you to search and list females by their married names.  <i>Note: The married names will only show up in the lists if you enable this option in the GEDCOM configuration. <b>Calculating married names is optional.</b></i>";
$pgv_lang["calc_marr_names"]		= "Calculating Married Names";
$pgv_lang["total_names"]			= "Total Names";
$pgv_lang["top10_pageviews_nohits"]	= "There are currently no hits to show.";
$pgv_lang["top10_pageviews_msg"]	= "Hit counters must be enabled in the GEDCOM configuration, Display and Layout section, Hide and Show group.";
$pgv_lang["review_changes_descr"]	= "The Pending Changes block will give users with Edit rights a list of the records that have been changed online and that still need to be reviewed and accepted.  These changes are pending acceptance or rejection.<br /><br />If this block is enabled, users with Accept rights will receive an email once a day notifying them that changes need to be reviewed.";
$pgv_lang["review_changes_block"]	= "Pending Changes";
$pgv_lang["review_changes_email"]	= "Send out reminder emails?";
$pgv_lang["review_changes_email_freq"]	= "Reminder email frequency (days)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Review changes";
$pgv_lang["review_changes_body"]	= "Online changes have been made to a genealogical database.  These changes need to be reviewed and accepted before they will appear to all users.  Please use the URL below to enter that PhpGedView site and login to review the changes.";
$pgv_lang["show_spouses"]		= "Show spouses";
$pgv_lang["quick_update_title"] = "Quick Update";
$pgv_lang["quick_update_instructions"] = "This page allows you to quickly update information for an individual.  You only need to fill out the information that is new or that has changed from what is currently in the database.  After your changes have been submitted they have to be reviewed by an administrator before they will become visible to all.";
$pgv_lang["update_name"] = "Update Name";
$pgv_lang["update_fact"] = "Update a Fact";
$pgv_lang["update_fact_restricted"] = "Update of this fact is restricted:";
$pgv_lang["update_photo"] = "Update Photo";
$pgv_lang["photo_replace"] = "Do you want to replace an older photo with this one?";
$pgv_lang["select_fact"] = "Select a fact...";
$pgv_lang["update_address"] = "Update Address";
$pgv_lang["add_new_chil"] = "Add a new child";
$pgv_lang["top10_pageviews_descr"]	= "This block will show the 10 records that have been viewed the most.  This block requires that Hit Counters be enabled in the GEDCOM configuration settings.";
$pgv_lang["top10_pageviews"]		= "Most Viewed Items";
$pgv_lang["top10_pageviews_block"]		= "Most Viewed Items";
$pgv_lang["user_default_tab"]		= "Default Tab to show on Individual Information page";
$pgv_lang["stepfamily"]				= "Step Family";
$pgv_lang["stepdad"]				= "Step-Father";
$pgv_lang["stepmom"]				= "Step-Mother";
$pgv_lang["stepsister"]				= "Step-Sister";
$pgv_lang["stepbrother"]			= "Step-Brother";
$pgv_lang["max_upload_size"]		= "Maximum upload size: ";
$pgv_lang["edit_fam"]				= "Edit Family";
$pgv_lang["fams_charts"]			= "Options for family";
$pgv_lang["sort_by_birth"]			= "Sort by birth dates";
$pgv_lang["reorder_children"]		= "Re-order children";
$pgv_lang["add_from_clipboard"]		= "Add from Clipboard: ";
$pgv_lang["record_copied"]			= "Record copied to clipboard";
$pgv_lang["copy"]					= "Copy";
$pgv_lang["cut"]					= "Cut";
$pgv_lang["indis_charts"]			= "Options for individual";
$pgv_lang["edit_indi"] 				= "Edit individual";
$pgv_lang["locked"]					= "Do not change";
$pgv_lang["privacy"]				= "Privacy";
$pgv_lang["number_sign"]			= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"] 					= "?";
$pgv_lang["qm_ah"]					= "?";
$pgv_lang["page_help"]				= "Help";
$pgv_lang["help_for_this_page"] 	= "Help with this page";
$pgv_lang["help_contents"]			= "Help Contents";
$pgv_lang["show_context_help"]		= "Show Contextual Help";
$pgv_lang["hide_context_help"]		= "Hide Contextual Help";
$pgv_lang["sorry"]					= "<b>Sorry, Help text for this page or item is not yet available.</b>";
$pgv_lang["help_not_exist"] 		= "<b>Help text for this page or item is not yet available.</b>";
$pgv_lang["var_not_exist"]			= "<span style=\"font-weight: bold\">The language variable does not exist. Please report this as it is an error.</span>";
$pgv_lang["resolution"] 			= "Screen Resolution";
$pgv_lang["menu"]					= "Menu";
$pgv_lang["header"] 				= "Header";
$pgv_lang["imageview"]				= "Image Viewer";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"] 			= "PhpGedView User Login";
$pgv_lang["error_title"]			= "ERROR: Cannot open GEDCOM file";
$pgv_lang["error_header"]			= "The GEDCOM file, <b>#GEDCOM#</b>, does not exist at the specified location.";
$pgv_lang["error_header_write"] 	= "The GEDCOM file, <b>#GEDCOM#</b>, is not writable. Please check attributes and access rights.";
$pgv_lang["for_support"]			= "For technical support and information contact";
$pgv_lang["for_contact"]			= "For help with genealogy questions contact";
$pgv_lang["for_all_contact"]		= "For technical support or genealogy questions, please contact";
$pgv_lang["build_title"]			= "Building Index Files";
$pgv_lang["build_error"]			= "GEDCOM file has been updated.";
$pgv_lang["please_wait"]			= "Please wait while Index files are rebuilt.";
$pgv_lang["choose_gedcom"]			= "Choose a GEDCOM dataset";
$pgv_lang["username"]				= "User name";
$pgv_lang["invalid_username"]		= "User name contains invalid characters";
$pgv_lang["firstname"]				= "First Name";
$pgv_lang["lastname"]				= "Last Name";
$pgv_lang["password"]				= "Password";
$pgv_lang["confirm"]				= "Confirm Password";
$pgv_lang["user_contact_method"]	= "Preferred Contact Method";
$pgv_lang["login"]					= "Login";
$pgv_lang["login_aut"]				= "Edit User";
$pgv_lang["logout"] 				= "Logout";
$pgv_lang["admin"]					= "Admin";
$pgv_lang["logged_in_as"]			= "Logged in as ";
$pgv_lang["my_pedigree"]			= "My Pedigree";
$pgv_lang["my_indi"]				= "My Individual Record";
$pgv_lang["yes"]					= "Yes";
$pgv_lang["no"] 					= "No";
$pgv_lang["add_gedcom"] 			= "Add GEDCOM";
$pgv_lang["change_theme"]			= "Change Theme";
$pgv_lang["gedcom_downloadable"] 	= "This GEDCOM file is downloadable over the internet!<br />Please see the SECURITY section of the <a href=\"readme.txt\"><b>readme.txt</b></a> file to fix this problem";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]			= "Pedigree Tree";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS# Generation Pedigree Chart";
$pgv_lang["generations"]			= "Generations";
$pgv_lang["view"]					= "View";
$pgv_lang["fam_spouse"] 			= "Family with spouse";
$pgv_lang["root_person"]			= "Root Person ID";
$pgv_lang["hide_details"]			= "Hide Details";
$pgv_lang["show_details"]			= "Show Details";
$pgv_lang["person_links"]			= "Links to charts, families, and close relatives of this person. Click this icon to view this page, starting at this person.";
$pgv_lang["zoom_box"]				= "Zoom in/out on this box.";
$pgv_lang["orientation"]			= "Orientation";
$pgv_lang["portrait"]				= "Portrait";
$pgv_lang["landscape"]				= "Landscape";
$pgv_lang["start_at_parents"]		= "Start at parents";
$pgv_lang["charts"] 				= "Charts";
$pgv_lang["lists"]					= "Lists";
$pgv_lang["welcome_page"]			= "Welcome Page";
$pgv_lang["max_generation"] 		= "The maximum number of pedigree generations is #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"] 		= "The minimum number of pedigree generations is 3.";
$pgv_lang["box_width"] 				= "Box width";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Unable to find family with ID";
$pgv_lang["unable_to_find_indi"]	= "Unable to find individual with ID";
$pgv_lang["unable_to_find_record"]	= "Unable to find record with ID";
$pgv_lang["unable_to_find_source"]	= "Unable to find source with ID";
$pgv_lang["unable_to_find_repo"]	= "Unable to find repository with ID";
$pgv_lang["repo_name"]				= "Repository Name:";
$pgv_lang["address"]				= "Address:";
$pgv_lang["phone"]					= "Phone:";
$pgv_lang["source_name"]			= "Source Name:";
$pgv_lang["title"]					= "Title";
$pgv_lang["author"] 				= "Author:";
$pgv_lang["publication"]			= "Publication:";
$pgv_lang["call_number"]			= "Call Number:";
$pgv_lang["living"] 				= "Living";
$pgv_lang["private"]				= "Private";
$pgv_lang["birth"]					= "Birth:";
$pgv_lang["death"]					= "Death:";
$pgv_lang["descend_chart"]			= "Descendancy Chart";
$pgv_lang["individual_list"]		= "Individual List";
$pgv_lang["family_list"]			= "Family List";
$pgv_lang["source_list"]			= "Source List";
$pgv_lang["place_list"] 			= "Place Hierarchy";
$pgv_lang["place_list_aft"] 		= "Place Hierarchy after";
$pgv_lang["media_list"] 			= "MultiMedia List";
$pgv_lang["search"] 				= "Search";
$pgv_lang["clippings_cart"] 		= "Family Tree Clippings Cart";
$pgv_lang["print_preview"]			= "Printer-friendly Version";
$pgv_lang["cancel_preview"] 		= "Back to normal view";
$pgv_lang["change_lang"]			= "Change Language";
$pgv_lang["print"]					= "Print";
$pgv_lang["total_queries"]			= "Total Database Queries: ";
$pgv_lang["total_privacy_checks"]	= "Total privacy checks: ";
$pgv_lang["back"]					= "Back";
$pgv_lang["privacy_list_indi_error"]= "Due to privacy rules, one or more people are hidden.";
$pgv_lang["privacy_list_fam_error"] = "Due to privacy rules, one or more families are hidden.";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]					= "AKAs";
$pgv_lang["male"]					= "Male";
$pgv_lang["female"] 				= "Female";
$pgv_lang["temple"] 				= "LDS Temple";
$pgv_lang["temple_code"]			= "LDS Temple Code:";
$pgv_lang["status"] 				= "Status";
$pgv_lang["source"] 				= "Source";
$pgv_lang["citation"]				= "Citation:";
$pgv_lang["text"]					= "Source Text:";
$pgv_lang["note"]					= "Note";
$pgv_lang["NN"] 					= "(unknown)";
$pgv_lang["PN"] 					= "(unknown)";
$pgv_lang["unrecognized_code"]		= "Unrecognized GEDCOM Code";
$pgv_lang["unrecognized_code_msg"]	= "This is an error, and we would like to fix it. Please report this error to";
$pgv_lang["indi_info"]				= "Individual Information";
$pgv_lang["pedigree_chart"] 		= "Pedigree Chart";
$pgv_lang["individual"]				= "Individual";
$pgv_lang["family"] 				= "Family";
$pgv_lang["family_with"]			= "Family with";
$pgv_lang["as_spouse"]				= "Family with Spouse";
$pgv_lang["as_child"]				= "Family with Parents";
$pgv_lang["view_gedcom"]			= "View GEDCOM Record";
$pgv_lang["add_to_cart"]			= "Add to Clippings Cart";
$pgv_lang["still_living_error"] 	= "This person is still living or does not have a birth or death date recorded.	All details of living persons are hidden from public view.<br />For more information contact";
$pgv_lang["privacy_error"]			= "Details on this person are private.<br />";
$pgv_lang["more_information"]		= "For more information contact";
$pgv_lang["name"]					= "Name";
$pgv_lang["given_name"] 			= "Given Name:";
$pgv_lang["surname"]				= "Surname:";
$pgv_lang["suffix"] 				= "Suffix:";
$pgv_lang["object_note"]			= "Object Note:";
$pgv_lang["sex"]					= "Gender";
$pgv_lang["personal_facts"] 		= "Personal Facts and Details";
$pgv_lang["type"]					= "Type";
$pgv_lang["date"]					= "Date";
$pgv_lang["place_description"]		= "Place / Description";
$pgv_lang["parents"]				= "Parents:";
$pgv_lang["siblings"]				= "Sibling";
$pgv_lang["father"] 				= "Father";
$pgv_lang["mother"] 				= "Mother";
$pgv_lang["parent"] 				= "Parent";
$pgv_lang["relatives"]				= "Close Relatives";
$pgv_lang["relatives_events"]		= "Events of close relatives";
$pgv_lang["child"]					= "Child";
$pgv_lang["spouse"] 				= "Spouse";
$pgv_lang["surnames"]				= "Surnames";
$pgv_lang["adopted"]				= "Adopted";
$pgv_lang["foster"] 				= "Foster";
$pgv_lang["sealing"]				= "Sealing";
$pgv_lang["challenged"]				= "Challenged";
$pgv_lang["disproved"]				= "Disproved";
$pgv_lang["infant"]					= "Infant";
$pgv_lang["stillborn"]				= "Stillborn";
$pgv_lang["deceased"]				= "Deceased";
$pgv_lang["link_as_child"]			= "Link this person to an existing family as a child";
$pgv_lang["link_as_wife"]			= "Link this person to an existing family as a wife";
$pgv_lang["link_as_husband"]		= "Link this person to an existing family as a husband";
$pgv_lang["no_tab1"]				= "There are no Facts for this individual.";
$pgv_lang["no_tab2"]				= "There are no Notes for this individual.";
$pgv_lang["no_tab3"]				= "There are no Source citations for this individual.";
$pgv_lang["no_tab4"]				= "There are no media objects for this individual.";
$pgv_lang["no_tab5"]				= "There are no close relatives for this individual.";
$pgv_lang["no_tab6"]				= "There are no research logs attached to this individual.";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]			= "Family Information";
$pgv_lang["family_group_info"]		= "Family Group Information";
$pgv_lang["husband"]				= "Husband";
$pgv_lang["wife"]					= "Wife";
$pgv_lang["marriage"]				= "Marriage:";
$pgv_lang["lds_sealing"]			= "LDS Sealing:";
$pgv_lang["marriage_license"]		= "Marriage License:";
$pgv_lang["media_object"]			= "Multimedia Object";
$pgv_lang["children"]				= "Children";
$pgv_lang["no_children"]			= "No recorded children";
$pgv_lang["childless_family"]		= "This family remained childless";
$pgv_lang["number_children"]		= "Number of children: ";
$pgv_lang["parents_timeline"]		= "Show couple on timeline chart";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]				= "Clippings Cart";
$pgv_lang["clip_explaination"]		= "The Family Tree Clippings Cart allows you to take &quot;clippings&quot; from this family tree and bundle them up into a single file for downloading in GEDCOM format.<br /><br />";
$pgv_lang["item_with_id"]			= "Item with ID";
$pgv_lang["error_already"]			= "is already in your clippings cart.";
$pgv_lang["which_links"]			= "Which other links from this family would you like to add?";
$pgv_lang["just_family"]			= "Add just this family record.";
$pgv_lang["parents_and_family"] 	= "Add parents' records together with this family record.";
$pgv_lang["parents_and_child"]		= "Add parents' and children's records together with this family record.";
$pgv_lang["parents_desc"]			= "Add parents' and all descendants' records together with this family record.";
$pgv_lang["continue"]				= "Continue Adding";
$pgv_lang["which_p_links"]			= "Which links from this person would you also like to add?";
$pgv_lang["just_person"]			= "Add just this person.";
$pgv_lang["person_parents_sibs"]	= "Add this person, his parents, and siblings.";
$pgv_lang["person_ancestors"]		= "Add this person and his direct line ancestors.";
$pgv_lang["person_ancestor_fams"]	= "Add this person, his direct line ancestors, and their families.";
$pgv_lang["person_spouse"]			= "Add this person, his spouse, and children.";
$pgv_lang["person_desc"]			= "Add this person, his spouse, and all descendants.";
$pgv_lang["unable_to_open"] 		= "Unable to open Clippings folder for writing";
$pgv_lang["person_living"]			= "This person is living. Personal details will not be included.";
$pgv_lang["person_private"] 		= "Details about this person are private. Personal details will not be included.";
$pgv_lang["family_private"] 		= "Details about this family are private. Family details will not be included.";
$pgv_lang["download"]				= "Right click (control-click on a Macintosh) on the links below and select &quot;Save target as&quot; to download the files.";
$pgv_lang["media_files"]			= "Media Files referenced in this GEDCOM";
$pgv_lang["cart_is_empty"]			= "Your Clippings Cart is empty.";
$pgv_lang["id"] 					= "ID";
$pgv_lang["name_description"]		= "Name / Description";
$pgv_lang["remove"] 				= "Remove";
$pgv_lang["empty_cart"] 			= "Empty Cart";
$pgv_lang["download_now"]			= "Download Now";
$pgv_lang["indi_downloaded_from"]	= "This Individual was downloaded from:";
$pgv_lang["family_downloaded_from"] = "This Family was downloaded from:";
$pgv_lang["source_downloaded_from"] = "This Source was downloaded from:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]			= "Place connections found";
$pgv_lang["top_level"]				= "Top Level";
$pgv_lang["form"]					= "Places are encoded in the form: ";
$pgv_lang["default_form"]			= "City, County, State/Province, Country";
$pgv_lang["default_form_info"]		= "(Default)";
$pgv_lang["gedcom_form_info"]		= "(GEDCOM)";
$pgv_lang["unknown"]				= "unknown";
$pgv_lang["individuals"]			= "Individuals";
$pgv_lang["view_records_in_place"]	= "View all records found in this place";
$pgv_lang["place_list2"] 			= "Place List";
$pgv_lang["show_place_hierarchy"]	= "Show Places in Hierarchy";
$pgv_lang["show_place_list"]		= "Show All Places in a List";
$pgv_lang["total_unic_places"]		= "Total Unique Places";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "External objects";
$pgv_lang["multi_title"]			= "MultiMedia Object List";
$pgv_lang["media_found"]			= "Media Objects found";
$pgv_lang["view_person"]			= "View Person";
$pgv_lang["view_family"]			= "View Family";
$pgv_lang["view_source"]			= "View Source";
$pgv_lang["view_object"]			= "View Object";
$pgv_lang["prev"]					= "&lt; Previous";
$pgv_lang["next"]					= "Next &gt;";
$pgv_lang["file_not_found"] 		= "File not found.";
$pgv_lang["medialist_show"] 		= "Show";
$pgv_lang["per_page"]				= "media objects per page";
$pgv_lang["delete_directory"]		= "Delete directory";
$pgv_lang["remove_object"]			= "Remove object";
$pgv_lang["confirm_remove_object"]	= "Are you sure you want to remove this object from the database?";
$pgv_lang["remove_links"]			= "Remove links";
$pgv_lang["confirm_remove_links"]	= "Are you sure you want to remove all links to this object?";
$pgv_lang["delete_file"]			= "Delete file";
$pgv_lang["confirm_delete_file"]	= "Are you sure you want to delete this file?";
$pgv_lang["multiple_gedcoms"]		= "This file is linked to another genealogical database on this server.  It cannot be deleted, moved, or renamed until these links have been removed.";
$pgv_lang["external_file"]			= "This media object does not exist as a file on this server.  It cannot be deleted, moved, or renamed.";
$pgv_lang["directory_not_empty"]	= "Directory not empty.";
$pgv_lang["directory_not_exist"]	= "Directory does not exist.";
$pgv_lang["media_not_deleted"]		= "Media directory not removed.";
$pgv_lang["media_deleted"]			= "Media directory successfully removed.";
$pgv_lang["thumbs_not_deleted"]		= "Thumbnail directory not removed.";
$pgv_lang["thumbs_deleted"]			= "Thumbnail directory successfully removed.";
$pgv_lang["delete_dir_success"]		= "Media and thumbnail directories successfully removed.";
$pgv_lang["current_dir"]			= "Current directory";
$pgv_lang["add_directory"]			= "Add directory";
$pgv_lang["show_thumbnail"]			= "Show thumbnails";
$pgv_lang["image_format"]			= "Image Format";
$pgv_lang["media_format"]			= "Media Format";
$pgv_lang["image_size"]				= "Image Dimensions";
$pgv_lang["media_file_size"]		= "Media Size";
$pgv_lang["no_thumb_dir"]			= " thumbnail directory does not exist and it could not be created.";
$pgv_lang["manage_media"]			= "Manage Media";
$pgv_lang["gen_thumb"]				= "Create thumbnail";
$pgv_lang["move_to"]				= "Move To";
$pgv_lang["folder_created"]			= "Directory created";
$pgv_lang["folder_no_create"]		= "Directory could not be created";
$pgv_lang["security_no_create"]		= "Security Warning: Could not create file <b><i>index.php</i></b> in ";
$pgv_lang["security_not_exist"]		= "Security Warning: File <b><i>index.php</i></b> does not exist in ";
$pgv_lang["illegal_chars"]			= "Blank name or illegal characters in name";
$pgv_lang["link_media"]				= "Link Media";
$pgv_lang["to_person"]				= "To Person";
$pgv_lang["to_family"]				= "To Family";
$pgv_lang["to_source"]				= "To Source";
$pgv_lang["media_id"]				= "Media ID";
$pgv_lang["invalid_id"]				= "No such ID exists in this GEDCOM file.";
$pgv_lang["media_exists"]			= "Media file already exists.";
$pgv_lang["media_thumb_exists"]		= "Media thumbnail already exists.";
$pgv_lang["move_file_success"]		= "Media and thumbnail files successfully moved.";
$pgv_lang["media_folder_corrupt"]	= "The media folder is corrupted.";
$pgv_lang["max_media_depth"]		= "You can only go #MEDIA_DIRECTORY_LEVELS# directories deep";
$pgv_lang["upload_file"]			= "Upload file from your computer";
$pgv_lang["thumb_genned"]			= "Thumbnail #thumbnail# generated automatically.";
$pgv_lang["thumbgen_error"]			= "Thumbnail #thumbnail# could not be generated automatically.";
$pgv_lang["generate_thumbnail"]		= "Generate thumbnail automatically from ";
$pgv_lang["auto_thumbnail"]			= "Automatic thumbnail";
$pgv_lang["no_upload"]				= "Uploading media files is not allowed because multi-media items have been disabled or because the media directory is not writable.";
$pgv_lang["upload"]					= "Upload";
$pgv_lang["upload_media"]			= "Upload Media files";
$pgv_lang["folder"]		 			= "Folder on server";
$pgv_lang["media_file"] 			= "Media file to upload";
$pgv_lang["thumbnail"]				= "Thumbnail to upload";
$pgv_lang["upload_successful"]		= "Upload successful.";
$pgv_lang["media_file_deleted"]		= "Media file successfully deleted.";
$pgv_lang["media_file_not_deleted"]	= "Media file could not be deleted.";
$pgv_lang["media_file_not_moved"]	= "Media file could not be moved.";
$pgv_lang["media_file_not_renamed"]	= "Media file could not be moved or renamed.";
$pgv_lang["thumbnail_deleted"]		= "Thumbnail file successfully deleted.";
$pgv_lang["thumbnail_not_deleted"]	= "Thumbnail file could not be deleted.";
$pgv_lang["media_record_deleted"]	= "Media record #xref# and links successfully deleted from database.";
$pgv_lang["media_record_not_deleted"]	= "Media record #xref# and links could not be deleted from database.";
$pgv_lang["record_updated"]			= "Record #pid# successfully updated.";
$pgv_lang["record_not_updated"]		= "Record #pid# could not be updated.";
$pgv_lang["record_removed"]			= "Record #xref# successfully removed from GEDCOM.";
$pgv_lang["record_not_removed"]		= "Record #xref# could not be removed from GEDCOM.";
$pgv_lang["record_added"]			= "Record #xref# successfully added to GEDCOM.";
$pgv_lang["record_not_added"]		= "Record #xref# could not be added to GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]			= "Search databases";
$pgv_lang["enter_terms"]			= "Enter Search terms";
$pgv_lang["soundex_search"] 		= "Search the way you think the name is written (Soundex)";
$pgv_lang["sources"]				= "Sources";
$pgv_lang["firstname_search"]		= "Given name";
$pgv_lang["lastname_search"]		= "Last name";
$pgv_lang["search_place"]			= "Place";
$pgv_lang["search_year"]			= "Year";
$pgv_lang["no_results"] 			= "No results found.";
$pgv_lang["invalid_search_input"] 	= "Please enter a Given name, Last name, or Place in addition to Year";
$pgv_lang["search_options"]			= "Search options";
$pgv_lang["search_geds"]			= "Databases to search in";
$pgv_lang["search_type"]			= "Search type";
$pgv_lang["search_general"]			= "General search";
$pgv_lang["search_soundex"]			= "Soundex search";
$pgv_lang["search_inrecs"]			= "Search for";
$pgv_lang["search_fams"]			= "Families";
$pgv_lang["search_indis"]			= "Individuals";
$pgv_lang["search_sources"]			= "Sources";
$pgv_lang["search_more_chars"]      = "Please enter more than one character";
$pgv_lang["search_soundextype"]		= "Soundex type:";
$pgv_lang["search_russell"]			= "Basic";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_prtnames"]		= "Individuals'<br />names to print:";
$pgv_lang["search_prthit"]			= "Names with hit";
$pgv_lang["search_prtall"]			= "All names";
$pgv_lang["search_tagfilter"]		= "Exclude Filter";
$pgv_lang["search_tagfon"]			= "Exclude some non-genealogical data";
$pgv_lang["search_tagfoff"]			= "Off";
$pgv_lang["associate"]				= "associate";
$pgv_lang["search_asso_label"]		= "Associates";
$pgv_lang["search_asso_text"]		= "Show related persons/families";
$pgv_lang["results_per_page"]		= "Results per page";
$pgv_lang["search_to"]				= "to";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]			= "Sources Found";
$pgv_lang["titles_found"]			= "Titles";
$pgv_lang["find_source"]			= "Find Source";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repo_list"]				= "Repository List";
$pgv_lang["repos_found"]			= "Repositories found";
$pgv_lang["find_repository"]		= "Find Repository";
$pgv_lang["total_repositories"]		= "Total Repositories";
$pgv_lang["repo_info"]				= "Repository Information";
$pgv_lang["delete_repo"]			= "Delete Repository";
$pgv_lang["other_repo_records"]		= "Records that link to this Repository:";
$pgv_lang["create_repository"]		= "Create Repository";
$pgv_lang["new_repo_created"]		= "New Repository created";
$pgv_lang["paste_rid_into_field"]	= "Paste the following Repository ID into your editing fields to reference this Repository ";
$pgv_lang["confirm_delete_repo"]	= "Are you sure you want to delete this Repository from the database?";


//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]			= "Source Information";
$pgv_lang["other_records"]			= "Records that link to this Source:";
$pgv_lang["people"] 				= "People";
$pgv_lang["families"]				= "Families";
$pgv_lang["total_sources"]			= "Total Sources";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]			= "Building Individual and Family Index";
$pgv_lang["building_index"] 		= "Building Index lists";
$pgv_lang["invalid_gedformat"]		= "Invalid GEDCOM 5.5 format";
$pgv_lang["importing_records"]		= "Importing records into database";
$pgv_lang["detected_change"]		= "PhpGedView detected a change in <b>#GEDCOM#</b>. Index files must be rebuilt before proceeding.";
$pgv_lang["please_be_patient"]		= "Please be patient";
$pgv_lang["reading_file"]			= "Reading GEDCOM file";
$pgv_lang["flushing"]				= "Flushing contents";
$pgv_lang["found_record"]			= "Found record";
$pgv_lang["exec_time"]				= "Execution time:";
$pgv_lang["time_limit"]				= "Time limit:";
$pgv_lang["unable_to_create_index"] = "Unable to create Index files.  Make sure Write permissions are set on the PhpGedView directory.  Permissions may be restored once Index files are written.";
$pgv_lang["indi_complete"]			= "Individual Index file update complete.";
$pgv_lang["family_complete"]		= "Family Index file update complete.";
$pgv_lang["source_complete"]		= "Source Index file update complete.";
$pgv_lang["tables_exist"]			= "PhpGedView tables already exist in the database";
$pgv_lang["you_may"]				= "You may:";
$pgv_lang["drop_tables"]			= "Drop the current tables";
$pgv_lang["import_multiple"]		= "Import and work with multiple GEDCOMs";
$pgv_lang["explain_options"]		= "If you choose to drop the tables <u>all</u> of the data will be replaced with information from this GEDCOM file.<br /><br />If you choose to import and work with multiple GEDCOMs, PhpGedView will erase any data that was imported using a GEDCOM with the same file name.  This option allows you to store multiple genealogical data sets in the same tables and switch between them easily.<br /><br /><b>Please note that file names are case sensitive.</b>  This means that <b>Test.GED</b> is <u>not</u> the same as <b>test.ged</b>.";
$pgv_lang["path_to_gedcom"] 		= "Enter the path to your GEDCOM file:";
$pgv_lang["dataset_exists"] 		= "A GEDCOM with this file name has already been imported into the database.";
$pgv_lang["changes_present"]		= "The current GEDCOM has changes pending review.  If you continue this Import, these pending changes will be posted to the database immediately.  You should review the pending changes before continuing the Import.";
$pgv_lang["empty_dataset"]			= "Do you want to erase the old data and replace it with this new data?";
$pgv_lang["index_complete"] 		= "Index complete.";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Click here to go to the Pedigree tree.";
$pgv_lang["updating_is_dead"]		= "Updating \"Is Dead\" status for INDI ";
$pgv_lang["import_complete"]		= "Import complete";
$pgv_lang["updating_family_names"]	= "Updating family names for FAM ";
$pgv_lang["processed_for"]			= "Processed file for ";
$pgv_lang["run_tools"]				= "Do you want to run one of the following tools on your GEDCOM before it is imported:";
$pgv_lang["addmedia"]				= "Add Media tool";
$pgv_lang["dateconvert"]			= "Date Conversion tool";
$pgv_lang["xreftorin"]				= "Convert XREF IDs to RIN number";
$pgv_lang["tools_readme"]			= "See the Tools section of the README.TXT file for more information.";
$pgv_lang["sec"]					= "sec.";
$pgv_lang["bytes_read"] 			= "Bytes read:";
$pgv_lang["created_remotelinks"]	= "Successfully created <i>Remotelinks</i> table.";
$pgv_lang["created_remotelinks_fail"] 	= "Unable to create <i>Remotelinks</i> table.";
$pgv_lang["created_indis"]			= "Successfully created <i>Individuals</i> table.";
$pgv_lang["created_indis_fail"] 	= "Unable to create <i>Individuals</i> table.";
$pgv_lang["created_fams"]			= "Successfully created <i>Families</i> table.";
$pgv_lang["created_fams_fail"]		= "Unable to create <i>Families</i> table.";
$pgv_lang["created_sources"]		= "Successfully created <i>Sources</i> table.";
$pgv_lang["created_sources_fail"]	= "Unable to create <i>Sources</i> table.";
$pgv_lang["created_other"]			= "Successfully created <i>Other</i> table.";
$pgv_lang["created_other_fail"] 	= "Unable to create <i>Other</i> table.";
$pgv_lang["created_places"] 		= "Successfully created <i>Places</i> table.";
$pgv_lang["created_places_fail"]	= "Unable to create <i>Places</i> table.";
$pgv_lang["created_placelinks"] 	= "Successfully created <i>Place links</i> table.";
$pgv_lang["created_placelinks_fail"]	= "Unable to create <i>Place links</i> table.";
$pgv_lang["created_media_fail"]	= "Unable to create <i>Media</i> table.";
$pgv_lang["created_media_mapping_fail"]	= "Unable to create <i>Media mappings</i> table.";
$pgv_lang["import_progress"]		= "Import Progress...";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"] 			= "Total families";
$pgv_lang["total_indis"]			= "Total individuals";
$pgv_lang["starts_with"]			= "Starts with:";
$pgv_lang["person_list"]			= "Person list:";
$pgv_lang["paste_person"]			= "Paste Person";
$pgv_lang["notes_sources_media"]	= "Notes, Sources, and Media";
$pgv_lang["notes"]					= "Notes";
$pgv_lang["ssourcess"]				= "Sources";
$pgv_lang["media"]					= "Media";
$pgv_lang["name_contains"]			= "Name contains:";
$pgv_lang["filter"] 				= "Filter";
$pgv_lang["find_individual"]		= "Find Individual ID";
$pgv_lang["find_familyid"]			= "Find Family ID";
$pgv_lang["find_sourceid"]			= "Find Source ID";
$pgv_lang["find_specialchar"]		= "Find Special Characters";
$pgv_lang["magnify"]				= "Magnify";
$pgv_lang["skip_surnames"]			= "Skip Surname lists";
$pgv_lang["show_surnames"]			= "Show Surname lists";
$pgv_lang["all"]					= "ALL";
$pgv_lang["hidden"]					= "Hidden";
$pgv_lang["confidential"]			= "Confidential";
$pgv_lang["alpha_index"]				= "Alphabetical Index";
$pgv_lang["name_list"] 				= "Name List";
$pgv_lang["firstname_alpha_index"] 	= "Firstname Alphabetical Index";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]					= "Age";
$pgv_lang["days"]					= "days";
$pgv_lang["months"]					= "months";
$pgv_lang["years"]					= "years";
$pgv_lang["day1"]					= "day";
$pgv_lang["month1"]					= "month";
$pgv_lang["year1"]					= "year";
$pgv_lang["timeline_title"] 		= "PhpGedView Timeline";
$pgv_lang["timeline_chart"] 		= "Timeline Chart";
$pgv_lang["remove_person"]			= "Remove Person";
$pgv_lang["show_age"]				= "Show Age Marker";
$pgv_lang["add_another"]			= "Add another person to chart:<br />Person ID:";
$pgv_lang["find_id"]				= "Find ID";
$pgv_lang["show"]					= "Show";
$pgv_lang["year"]					= "Year:";
$pgv_lang["timeline_instructions"]	= "In most recent browsers you can click and drag the boxes around on the chart.";
$pgv_lang["zoom_in"]				= "Zoom In";
$pgv_lang["zoom_out"]				= "Zoom Out";

//-- MONTH NAMES
$pgv_lang["jan"]					= "January";
$pgv_lang["feb"]					= "February";
$pgv_lang["mar"]					= "March";
$pgv_lang["apr"]					= "April";
$pgv_lang["may"]					= "May";
$pgv_lang["jun"]					= "June";
$pgv_lang["jul"]					= "July";
$pgv_lang["aug"]					= "August";
$pgv_lang["sep"]					= "September";
$pgv_lang["oct"]					= "October";
$pgv_lang["nov"]					= "November";
$pgv_lang["dec"]					= "December";
$pgv_lang["abt"]					= "about";
$pgv_lang["aft"]					= "after";
$pgv_lang["and"]					= "and";
$pgv_lang["bef"]					= "before";
$pgv_lang["bet"]					= "between";
$pgv_lang["cal"]					= "calculated";
$pgv_lang["est"]					= "estimated";
$pgv_lang["from"]					= "from";
$pgv_lang["int"]					= "interpreted";
$pgv_lang["to"] 					= "to";
$pgv_lang["cir"]					= "circa";
$pgv_lang["apx"]					= "approx.";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Select an option below:";
$pgv_lang["readme_documentation"]	= "README documentation";
$pgv_lang["view_readme"]			= "View readme.txt file";
$pgv_lang["configuration"]			= "Configuration";
$pgv_lang["rebuild_indexes"]		= "Rebuild indexes";
$pgv_lang["user_admin"] 			= "User administration";
$pgv_lang["user_created"]			= "User created successfully.";
$pgv_lang["user_create_error"]		= "Unable to add user.  Please try again.";
$pgv_lang["password_mismatch"]		= "Passwords do not match.";
$pgv_lang["enter_username"] 		= "You must enter a user name.";
$pgv_lang["enter_fullname"] 		= "You must enter a first and last name.";
$pgv_lang["enter_password"] 		= "You must enter a password.";
$pgv_lang["confirm_password"]		= "You must confirm the password.";
$pgv_lang["update_user"]			= "Update User Account";
$pgv_lang["update_myaccount"]		= "Update MyAccount";
$pgv_lang["save"]					= "Save";
$pgv_lang["delete"] 				= "Delete";
$pgv_lang["edit"]					= "Edit";
$pgv_lang["full_name"]				= "Full Name";
$pgv_lang["visibleonline"]			= "Visible to other users when online";
$pgv_lang["comment"]				= "Admin comments on user";
$pgv_lang["comment_exp"]			= "Admin warning at date";
$pgv_lang["editaccount"]			= "Allow this user to edit his account information";
$pgv_lang["admin_gedcom"]			= "Admin GEDCOM";
$pgv_lang["confirm_user_delete"]	= "Are you sure you want to delete the user";
$pgv_lang["create_user"]			= "Create User";
$pgv_lang["no_login"]				= "Unable to authenticate user.";
$pgv_lang["basic_realm"]			= "PhpGedView Authentication System";
$pgv_lang["basic_auth_failure"]		= "You must enter a valid login ID and password to access this resource";
$pgv_lang["basic_auth"]				= "Basic Authentication";
$pgv_lang["digest_auth"]				= "Digest Authentication"; //not used in code yet
$pgv_lang["no_auth_needed"]			= "No Authentication";
$pgv_lang["import_gedcom"]			= "Import this GEDCOM file";
$pgv_lang["duplicate_username"] 	= "Duplicate user name.  A user with that user name already exists.  Please choose another user name.";
$pgv_lang["gedcomid"]				= "GEDCOM INDI record ID";
$pgv_lang["enter_gedcomid"] 		= "You must enter a GEDCOM ID.";
$pgv_lang["user_info"]				= "My User Information";
$pgv_lang["rootid"] 				= "Pedigree Chart Root Person";
$pgv_lang["download_gedcom"]		= "Download GEDCOM";
$pgv_lang["upload_gedcom"]			= "Upload GEDCOM";
$pgv_lang["add_new_gedcom"] 		= "Create a new GEDCOM";
$pgv_lang["gedcom_file"]			= "GEDCOM File:";
$pgv_lang["enter_filename"] 		= "You must enter a GEDCOM file name.";
$pgv_lang["file_not_exists"]		= "The filename entered does not exist.";
$pgv_lang["file_not_present"]		= "The file does not exist.";
$pgv_lang["file_exists"]			= "There is already a GEDCOM with that file name. Please choose a different file name or delete the old file.";
$pgv_lang["new_gedcom_title"]		= "Genealogy from [#GEDCOMFILE#]";
$pgv_lang["upload_error"]			= "There was an error uploading your file.";
$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Select files from your local computer to upload to your server.  All files will be uploaded to the directory <b>#MEDIA_DIRECTORY#</b> or to one of its sub-directories.<br /><br />Folder names you specify will be appended to #MEDIA_DIRECTORY#. For example, #MEDIA_DIRECTORY#myfamily. If the thumbnail directory does not exist, it is created automatically.";
$pgv_lang["upload_gedcom_help"]		= "Select the GEDCOM or ZIP file from your local computer to upload to your server.  The file will be uploaded to the directory <b>#INDEX_DIRECTORY#</b>.<br /><br />If you upload a ZIP file, it should contain only one GEDCOM, and that GEDCOM will be used automatically in the next steps.<br /><br />";
$pgv_lang["add_gedcom_instructions"]= "Enter a file name for this new GEDCOM.  The new GEDCOM file will be created in the Index directory: #INDEX_DIRECTORY#";
$pgv_lang["file_success"]			= "File successfully uploaded";
$pgv_lang["file_too_big"]			= "Uploaded file exceeds the allowed size";
$pgv_lang["file_partial"]			= "File was only partially uploaded, please try again";
$pgv_lang["file_missing"]			= "No file was received. Please upload again.";
$pgv_lang["manage_gedcoms"] 		= "Manage GEDCOMs and edit Privacy";
$pgv_lang["research_assistant"]		= "Research Assistant";
$pgv_lang["administration"] 		= "Administration";
$pgv_lang["ansi_to_utf8"]			= "Convert this ANSI encoded GEDCOM to UTF-8?";
$pgv_lang["utf8_to_ansi"]			= "Do you want to convert from UTF-8 to ANSI (ISO-8859-1)?";
$pgv_lang["visitor"]				= "Visitor";
$pgv_lang["user"]					= "Authenticated user";
$pgv_lang["gedadmin"]				= "GEDCOM administrator";
$pgv_lang["siteadmin"]				= "Site administrator";
$pgv_lang["apply_privacy"]			= "Apply privacy settings?";
$pgv_lang["choose_priv"]			= "Choose privacy level:";
$pgv_lang["user_manual"]			= "PhpGedView User Manual";
$pgv_lang["upgrade"]				= "Upgrade PhpGedView";
$pgv_lang["view_logs"]				= "View log files";
$pgv_lang["logfile_content"]		= "Content of log file";
$pgv_lang["step1"]					= "Step 1 of 4:";
$pgv_lang["step2"]					= "Step 2 of 4:";
$pgv_lang["step3"]					= "Step 3 of 4:";
$pgv_lang["step4"]					= "Step 4 of 4:";
$pgv_lang["validate_gedcom"]		= "Validate GEDCOM";
$pgv_lang["img_admin_settings"] 	= "Edit Image Manipulation Configuration";
$pgv_lang["download_note"]			= "NOTE: Large GEDCOMs can take a long time to process before downloading.  If PHP times out before the download is complete, you may not get a complete download.<br /><br />To make sure that the GEDCOM file was downloaded correctly, check that its last line is <b>0&nbsp;TRLR</b>.  GEDCOM files are text; you can use any suitable text editor, but be sure to <u>not</u> save the downloaded GEDCOM file after you have inspected it.<br /><br />In general, it could take as much time to download as it took to import your GEDCOM file.";
$pgv_lang["pgv_registry"]			= "View other sites using PhpGedView";
$pgv_lang["verify_upload_instructions"]	= "A GEDCOM file with the same name has been found. If you choose to continue, the old GEDCOM file will be replaced with the file that you uploaded and the Import process will begin again.  If you choose to cancel, the old GEDCOM will remain unchanged.";
$pgv_lang["cancel_upload"]			= "Cancel Upload";
$pgv_lang["add_media_records"]		= "Add Media records";
$pgv_lang["manage_media_files"]		= "Manage Media files";
$pgv_lang["link_media_records"]		= "Link Media";
$pgv_lang["add_media_button"]		= "Add Media";
$pgv_lang["media_linked"]			= "This media object is linked to the following:";
$pgv_lang["media_not_linked"]		= "This media object is not linked to any GEDCOM record.";
$pgv_lang["phpinfo"]				= "PHP information";
$pgv_lang["admin_info"]				= "Informational";
$pgv_lang["admin_geds"]				= "Data and GEDCOM administration";
$pgv_lang["admin_site"]				= "Site administration";

//-- Relationship chart messages
$pgv_lang["relationship_chart"] 	= "Relationship Chart";
$pgv_lang["person1"]				= "Person 1";
$pgv_lang["person2"]				= "Person 2";
$pgv_lang["no_link_found"]			= "No (other) link between the two individuals could be found.";
$pgv_lang["sibling"]				= "Sibling";
$pgv_lang["follow_spouse"]			= "Check relationships by marriage.";
$pgv_lang["timeout_error"]			= "The script timed out before a relationship could be found.";
$pgv_lang["son"]						= "Son";
$pgv_lang["daughter"]				= "Daughter";
$pgv_lang["son-in-law"]				= "Son-in-law";  // the husband of your daughter
$pgv_lang["daughter-in-law"]		= "Daughter-in-law"; // the wife of your son
$pgv_lang["grandchild"]				= "Grandchild";
$pgv_lang["grandson"]				= "Grandson";
$pgv_lang["granddaughter"]			= "Granddaughter";
$pgv_lang["brother"]				= "Brother";
$pgv_lang["sister"] 				= "Sister";
$pgv_lang["brother-in-law"]		= "Brother-in-law";
$pgv_lang["sister-in-law"]			= "Sister-in-law";
$pgv_lang["aunt"]					= "Aunt";
$pgv_lang["uncle"]				= "Uncle";
$pgv_lang["firstcousin"]			= "First cousin";
$pgv_lang["femalecousin"]			= "Female cousin";
$pgv_lang["malecousin"]				= "Male cousin";
$pgv_lang["cousin-in-law"]			= "Cousin-in-law";
$pgv_lang["relationship_to_me"] 	= "Relationship to me";
$pgv_lang["rela_husb"]				= "Relationship to husband";
$pgv_lang["rela_wife"]				= "Relationship to wife";
$pgv_lang["next_path"]				= "Find next path";
$pgv_lang["show_path"]				= "Show path";
$pgv_lang["line_up_generations"]	= "Line up the same generations";
$pgv_lang["oldest_top"]             = "Show oldest top";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]			= "Are you sure you want to delete this GEDCOM fact?";
$pgv_lang["access_denied"]			= "<b>Access Denied</b><br />You do not have access to this resource.";
$pgv_lang["gedrec_deleted"] 		= "GEDCOM record successfully deleted.";
$pgv_lang["gedcom_deleted"] 		= "GEDCOM [#GED#] successfully deleted.";
$pgv_lang["changes_exist"]			= "Changes have been made to this GEDCOM.";
$pgv_lang["accept_changes"] 		= "Accept / Reject Changes";
$pgv_lang["show_changes"]			= "This record has been updated.  Click here to show changes.";
$pgv_lang["hide_changes"]			= "Click here to hide changes.";
$pgv_lang["review_changes"] 		= "Review GEDCOM Changes";
$pgv_lang["undo_successful"]		= "Undo successful";
$pgv_lang["undo"]					= "Undo";
$pgv_lang["view_change_diff"]		= "View Change Diff";
$pgv_lang["changes_occurred"]		= "The following changes were made to this record:";
$pgv_lang["find_place"] 			= "Find Place";
$pgv_lang["refresh"]				= "Refresh";
$pgv_lang["close_window"]			= "Close Window";
$pgv_lang["close_window_without_refresh"] = "Close Window Without Reloading";
$pgv_lang["place_contains"] 		= "Place contains:";
$pgv_lang["accept_gedcom"]			= "Decide for each change to either accept or reject it.<br /><br />To accept all changes at once, click <b>\"Accept all changes\"</b> in the box below.<br />To get more information about a change,<br />click <b>\"View change diff\"</b> to see the differences,<br />or click <b>\"View GEDCOM record\"</b> to see the new data in GEDCOM format.";
$pgv_lang["ged_import"] 			= "Import";
$pgv_lang["now_import"] 			= "You should now import the GEDCOM records into PhpGedView by clicking on the Import link below.";
$pgv_lang["add_fact"]				= "Add new fact";
$pgv_lang["add"]					= "Add";
$pgv_lang["custom_event"]			= "Custom Event";
$pgv_lang["update_successful"]		= "Update successful";
$pgv_lang["add_child"]				= "Add child";
$pgv_lang["add_child_to_family"]	= "Add a child to this family";
$pgv_lang["add_sibling"]			= "Add a brother or sister";
$pgv_lang["add_son_daughter"]		= "Add a son or daughter";
$pgv_lang["must_provide"]			= "You must provide a ";
$pgv_lang["delete_person"]			= "Delete this individual";
$pgv_lang["confirm_delete_person"]	= "Are you sure you want to delete this person from the GEDCOM file?";
$pgv_lang["find_media"] 			= "Find Media";
$pgv_lang["set_link"]				= "Set Link";
$pgv_lang["add_source_lbl"] 		= "Add Source Citation";
$pgv_lang["add_source"] 			= "Add a new Source Citation";
$pgv_lang["add_note_lbl"]			= "Add Note";
$pgv_lang["add_note"]				= "Add a new Note";
$pgv_lang["add_media_lbl"]			= "Add Media";
$pgv_lang["add_media"]				= "Add a new Media item";
$pgv_lang["delete_source"]			= "Delete this Source";
$pgv_lang["confirm_delete_source"]	= "Are you sure you want to delete this Source from the GEDCOM file?";
$pgv_lang["add_husb"]				= "Add husband";
$pgv_lang["add_husb_to_family"] 	= "Add a husband to this family";
$pgv_lang["add_wife"]				= "Add wife";
$pgv_lang["add_wife_to_family"] 	= "Add a wife to this family";
$pgv_lang["find_family"]			= "Find Family";
$pgv_lang["find_fam_list"]			= "Find Family List";
$pgv_lang["add_new_wife"]			= "Add a new wife";
$pgv_lang["add_new_husb"]			= "Add a new husband";
$pgv_lang["edit_name"]				= "Edit Name";
$pgv_lang["delete_name"]			= "Delete Name";
$pgv_lang["no_temple"]				= "No Temple - Living Ordinance";
$pgv_lang["replace"]				= "Replace record";
$pgv_lang["append"] 				= "Append record";
$pgv_lang["add_father"] 			= "Add a new father";
$pgv_lang["add_mother"] 			= "Add a new mother";
$pgv_lang["add_obje"]				= "Add a new Multimedia object";
$pgv_lang["no_changes"] 			= "There are currently no changes to be reviewed.";
$pgv_lang["accept"] 				= "Accept";
$pgv_lang["accept_all"] 			= "Accept all changes";
$pgv_lang["accept_successful"]		= "Changes successfully accepted into database";
$pgv_lang["edit_raw"]				= "Edit raw GEDCOM record";
$pgv_lang["select_date"]			= "Select a date";
$pgv_lang["create_source"]			= "Create a new source";
$pgv_lang["new_source_created"] 	= "New source created successfully.";
$pgv_lang["paste_id_into_field"]	= "Paste the following ID into your editing fields to reference the newly created record ";
$pgv_lang["add_name"]				= "Add new Name";
$pgv_lang["privacy_not_granted"]	= "You have no access to";
$pgv_lang["user_cannot_edit"]		= "This user name cannot edit this GEDCOM.";
$pgv_lang["gedcom_editing_disabled"]	= "Editing this GEDCOM has been disabled by the administrator.";
$pgv_lang["privacy_prevented_editing"]	= "Privacy settings prevent you from editing this record.";
$pgv_lang["add_asso"]				= "Add a new Associate";
$pgv_lang["edit_sex"]				= "Edit Sex";
$pgv_lang["ged_noshow"]				= "This page has been disabled by the site administrator.";

//-- calendar.php messages
$pgv_lang["bdm"]					= "Births, Deaths, Marriages";
$pgv_lang["on_this_day"]			= "On This Day ...";
$pgv_lang["in_this_month"]			= "In This Month ...";
$pgv_lang["in_this_year"]			= "In This Year ...";
$pgv_lang["year_anniversary"]		= "#year_var# year anniversary";
$pgv_lang["today"]					= "Today";
$pgv_lang["day"]					= "Day:";
$pgv_lang["month"]					= "Month:";
$pgv_lang["showcal"]				= "Show events of:";
$pgv_lang["anniversary_calendar"]	= "Anniversary Calendar";
$pgv_lang["sunday"] 				= "Sunday";
$pgv_lang["monday"] 				= "Monday";
$pgv_lang["tuesday"]				= "Tuesday";
$pgv_lang["wednesday"]				= "Wednesday";
$pgv_lang["thursday"]				= "Thursday";
$pgv_lang["friday"] 				= "Friday";
$pgv_lang["saturday"]				= "Saturday";
$pgv_lang["viewday"]				= "View Day";
$pgv_lang["viewmonth"]				= "View Month";
$pgv_lang["viewyear"]				= "View Year";
$pgv_lang["all_people"] 			= "All People";
$pgv_lang["living_only"]			= "Living People";
$pgv_lang["recent_events"]			= "Recent Years (&lt; 100 yrs)";
$pgv_lang["day_not_set"]			= "Day not set";
$pgv_lang["year_error"] 			= "Sorry, dates before 1970 are not supported.";

//-- user self registration module
//$pgv_lang["no_pw_or_account"] 	= "If you do not have an account or if you have lost your password, please click the <b>Login</b> button";
$pgv_lang["lost_password"]			= "Lost your password?";
$pgv_lang["requestpassword"]		= "Request new password";
$pgv_lang["no_account_yet"] 		= "No account?";
$pgv_lang["requestaccount"] 		= "Request new user account";
$pgv_lang["emailadress"]			= "Email Address";
$pgv_lang["mandatory"] 			= "Fields marked with * are mandatory.";
$pgv_lang["mail01_line01"]			= "Hello #user_fullname# ...";
$pgv_lang["mail01_line02"]			= "A request was received at ( #SERVER_NAME# ) to create an account with your email address ( #user_email# ).";
$pgv_lang["mail01_line03"]			= "Information about the request is shown under the link below.";
$pgv_lang["mail01_line04"]			= "Please click on the following link and fill in the requested data to verify your account and email address.";
$pgv_lang["mail01_line05"]			= "If you didn't request an account, you can just delete this message.";
$pgv_lang["mail01_line06"]			= "You won't get any more email from this site, because the account request will be deleted automatically after seven days.";
$pgv_lang["mail01_subject"] 		= "Your registration at #SERVER_NAME#";

$pgv_lang["mail02_line01"]			= "Hello Administrator ...";
$pgv_lang["mail02_line02"]			= "A prospective user registered himself at ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]			= "The user received an email with the information necessary to verify his account.";
$pgv_lang["mail02_line04"]			= "You will be informed by email when this prospective user has verified himself.  You can then complete the process by activating the user name.  The new user will not be able to login until you activate the account.";
$pgv_lang["mail02_line04a"]			= "You will be informed by email when this prospective user has verified himself.  After verification, the user will be able to login without any action on your part.";
$pgv_lang["mail02_subject"] 		= "New registration at #SERVER_NAME#";

$pgv_lang["hashcode"]				= "Verification code:";
$pgv_lang["thankyou"]				= "Hello #user_fullname# ...<br />Thank you for your registration";
$pgv_lang["pls_note06"] 			= "We will now send a confirmation email to the address ( #user_email# ). You must verify your account request by following instructions in the confirmation email. If you do not verify your account request within seven days, your application for an account will be rejected automatically.  You will have to apply again.<br /><br />After you have followed the instructions in the confirmation email, the administrator still has to approve your request before your account can be used.<br /><br />To login to this site, you will need to know your user name and password.<br /><br />";
$pgv_lang["pls_note06a"] 			= "We will now send a confirmation email to the address ( #user_email# ). You must verify your account request by following instructions in the confirmation email. If you do not verify your account request within seven days, your application for an account will be rejected automatically.  You will have to apply again.<br /><br />After you have followed the instructions in the confirmation email, you can login.  To login to this site, you will need to know your user name and password.<br /><br />";

$pgv_lang["registernew"]			= "New Account confirmation";
$pgv_lang["user_verify"]			= "User verification";
$pgv_lang["send"]					= "Send";

$pgv_lang["pls_note07"] 			= "~#pgv_lang[user_verify]#~<br /><br />To verify your account request, please type in your user name, your password, and the verification code you received by email.";
$pgv_lang["pls_note08"] 			= "The data for the user #user_name# was checked.";

$pgv_lang["mail03_line01"]			= "Hello Administrator ...";
$pgv_lang["mail03_line02"]			= "User #newuser[username]# ( #newuser[fullname]# ) has verified his registration data.";
$pgv_lang["mail03_line03"]			= "Please click on the link below to login to your site.  You must Edit the user to activate the account so that he can login to your site.";
$pgv_lang["mail03_line03a"]			= "You do not have to take any action; the user can now login.";
$pgv_lang["mail03_subject"] 		= "New verification at #SERVER_NAME#";

$pgv_lang["pls_note09"] 			= "You have confirmed your request to become a registered user.";
$pgv_lang["pls_note10"] 			= "The Administrator has been informed.  As soon as he gives you permission to login, you can login with your user name and password.";
$pgv_lang["pls_note10a"]			= "You can now login with your user name and password.";
$pgv_lang["data_incorrect"] 		= "Data was not correct, please try again";
$pgv_lang["user_not_found"] 		= "Could not verify the information you entered.  Please try again or contact the site administrator for more information.";

$pgv_lang["lost_pw_reset"]			= "Lost password request";
$pgv_lang["pls_note11"] 			= "To have your password reset, enter your user name.<br /><br />We will respond by sending you an email to the address registered with your account.  The email will contain a URL and confirmation code for your account. When you visit this URL, you can change your password and login to this site. For security reasons, you should not give this confirmation code to anyone.<br /><br />If you require assistance from the site administrator, please use the contact link below.";
$pgv_lang["enter_email"]			= "You must enter an email address.";

$pgv_lang["mail04_line01"]			= "Hello #user_fullname# ...";
$pgv_lang["mail04_line02"]			= "A new password was requested for your user name.";
$pgv_lang["mail04_line03"]			= "Recommendation:";
$pgv_lang["mail04_line04"]			= "Please click on the link below or paste it into your browser, login with the new password, and change it immediately to keep the integrity of your data secure.";
$pgv_lang["mail04_line05"]			= "After you have logged in, select the '#pgv_lang[myuserdata]#' link under the '#pgv_lang[mygedview]#' menu and fill in the password fields to change your password.";
$pgv_lang["mail04_subject"] 		= "Data request at #SERVER_NAME#";

$pgv_lang["pwreqinfo"]				= "Hello...<br /><br />An email with your new password was sent to the address (#user[email]#).<br /><br />Please check your email account; you should receive our message soon.<br /><br />Recommendation:<br />You should login to this site with your new password as soon as possible, and you should change your password to maintain your data's security.";

$pgv_lang["editowndata"]			= "My Account";
$pgv_lang["savedata"]				= "Save changed data";
$pgv_lang["datachanged"]			= "User data was changed";
$pgv_lang["datachanged_name"]		= "You may need to login again with your new user name.";
$pgv_lang["myuserdata"] 			= "My Account";
$pgv_lang["verified"]				= "User verified himself";
$pgv_lang["verified_by_admin"]		= "User approved by Admin";
$pgv_lang["user_theme"] 			= "My Theme";
$pgv_lang["mgv"]					= "MyGedView";
$pgv_lang["mygedview"]				= "MyGedView Portal";
$pgv_lang["passwordlength"] 		= "Passwords must contain at least 6 characters.";
$pgv_lang["admin_approved"] 		= "Your account at #SERVER_NAME# has been approved";
$pgv_lang["you_may_login"]			= " by the site administrator.  You may now login to the PhpGedView site by accessing the link below:";
$pgv_lang["welcome_text_auth_mode_1"]	= "<center><b>Welcome to this Genealogy website</b></center><br />Access to this site is permitted to every visitor who has a user account.<br /><br />If you have a user account, you can login on this page.  If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying your application, the site administrator will activate your account.  You will receive an email when your application has been approved.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<center><b>Welcome to this Genealogy website</b></center><br />Access to this site is permitted to <u>authorized</u> users only.<br /><br />If you have a user account you can login on this page.  If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying your information, the administrator will either approve or decline your account application.  You will receive an email message when your application has been approved.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>Welcome to this Genealogy website</b></center><br />Access to this site is permitted to <u>family members only</u>.<br /><br />If you have a user account you can login on this page.  If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying the information you provide, the administrator will either approve or decline your request for an account.  You will receive an email when your request is approved.";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>Welcome to this Genealogy website</b></center><br />Access is permitted to users who have an account and a password for this website.<br />";


//-- mygedview page
$pgv_lang["welcome"]				= "Welcome";
$pgv_lang["upcoming_events"]		= "Upcoming Events";
$pgv_lang["living_or_all"]			= "Show only events of living people?";
$pgv_lang["basic_or_all"]			= "Show only Births, Deaths, and Marriages?";
$pgv_lang["no_events_living"]		= "No events for living people exist for the next #pgv_lang[global_num1]# days.";
$pgv_lang["no_events_living1"]		= "No events for living people exist for tomorrow.";
$pgv_lang["no_events_all"]			= "No events exist for the next #pgv_lang[global_num1]# days.";
$pgv_lang["no_events_all1"]			= "No events exist for tomorrow.";
$pgv_lang["no_events_privacy"]		= "Events exist for the next #pgv_lang[global_num1]# days, but privacy restrictions prevent you from seeing them.";
$pgv_lang["no_events_privacy1"]		= "Events exist for tomorrow, but privacy restrictions prevent you from seeing them.";
$pgv_lang["more_events_privacy"]	= "<br />More events exist for the next #pgv_lang[global_num1]# days, but privacy restrictions prevent you from seeing them.";
$pgv_lang["more_events_privacy1"]	= "<br />More events exist for tomorrow, but privacy restrictions prevent you from seeing them.";
$pgv_lang["none_today_living"]		= "No events for living people exist for today.";
$pgv_lang["none_today_all"]			= "No events exist for today.";
$pgv_lang["none_today_privacy"]		= "Events exist for today, but privacy restrictions prevent you from seeing them.";
$pgv_lang["more_today_privacy"]		= "<br />More events exist for today, but privacy restrictions prevent you from seeing them.";
$pgv_lang["chat"]					= "Chat";
$pgv_lang["users_logged_in"]		= "Users Logged In";
$pgv_lang["anon_user"]				= "1 anonymous logged-in user";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# anonymous logged-in users";
$pgv_lang["login_user"]				= "1 logged-in user";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# logged-in users";
$pgv_lang["no_login_users"]			= "No logged-in and no anonymous users";
$pgv_lang["message"]				= "Send Message";
$pgv_lang["my_messages"]			= "My Messages";
$pgv_lang["date_created"]			= "Date Sent:";
$pgv_lang["message_from"]			= "Email Address:";
$pgv_lang["message_from_name"]		= "Your Name:";
$pgv_lang["message_to"] 			= "Message To:";
$pgv_lang["message_subject"]		= "Subject:";
$pgv_lang["message_body"]			= "Body:";
$pgv_lang["no_to_user"] 			= "No recipient user was provided.  Cannot continue.";
$pgv_lang["provide_email"]			= "Please provide your email address so that we may contact you in response to this message.  If you do not provide your email address we will not be able to respond to your inquiry.  You email address will not be used in any other way besides responding to this inquiry.";
$pgv_lang["reply"]					= "Reply";
$pgv_lang["message_deleted"]		= "Message Deleted";
$pgv_lang["message_sent"]			= "Message successfully sent to #TO_USER#";
$pgv_lang["reset"]					= "Reset";
$pgv_lang["site_default"]			= "Site Default";
$pgv_lang["mygedview_desc"] 		= "Your MyGedView page allows you to keep bookmarks of your favorite people, track upcoming events, and collaborate with other PhpGedView users.";
$pgv_lang["no_messages"]			= "You have no pending messages.";
$pgv_lang["clicking_ok"]			= "When you click OK, another window will open and you may contact #user[fullname]#";
$pgv_lang["favorites"]				= "Favorites";
$pgv_lang["my_favorites"]			= "My Favorites";
$pgv_lang["no_favorites"]			= "You have not selected any favorites.<br /><br />To add an individual, a family, or a source to your favorites, click on the <b>#pgv_lang[add_favorite]#</b> link to reveal some fields where you can enter or search for an ID number.  Instead of an ID number, you can enter a URL and a title.";
$pgv_lang["add_to_my_favorites"]	= "Add to My Favorites";
$pgv_lang["gedcom_favorites"]		= "This GEDCOM's Favorites";
$pgv_lang["no_gedcom_favorites"]	= "At this moment there are no selected Favorites.	The admin can add Favorites to display at startup.";
$pgv_lang["confirm_fav_remove"] 	= "Are you sure you want to remove this item from your list of Favorites?";
$pgv_lang["invalid_email"]			= "Please enter a valid email address.";
$pgv_lang["enter_subject"]			= "Please enter a message subject.";
$pgv_lang["enter_body"] 			= "Please enter some message text before sending.";
$pgv_lang["confirm_message_delete"] = "Are you sure you want to delete this message?  It cannot be retrieved later.";
$pgv_lang["message_email1"] 		= "The following message has been sent to your PhpGedView user account from ";
$pgv_lang["message_email2"] 		= "You sent the following message to a PhpGedView user:";
$pgv_lang["message_email3"] 		= "You sent the following message to a PhpGedView administrator:";
$pgv_lang["viewing_url"]			= "This message was sent while viewing the following URL: ";
$pgv_lang["messaging2_help"]		= "When you send this message you will receive a copy sent via email to the address you provided.";
$pgv_lang["random_picture"] 		= "Random Picture";
$pgv_lang["message_instructions"]	= "<b>Please Note:</b> Private information of living individuals will only be given to family relatives and close friends.  You will be asked to verify your relationship before you will receive any private data.  Sometimes information of dead persons may also be private.  If this is the case, it is because there is not enough information known about the person to determine whether they are alive or not and we probaby do not have more information on this person.<br /><br />Before asking a question, please verify that you are inquiring about the correct person by checking dates, places, and close relatives.  If you are submitting changes to the genealogical data, please include the sources where you obtained the data.<br /><br />";
$pgv_lang["sending_to"] 			= "This message will be sent to #TO_USER#";
$pgv_lang["preferred_lang"] 		= "This user prefers to receive messages in #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "This GEDCOM was created using <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "This GEDCOM was created on <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " on <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]			= "GEDCOM Statistics";
$pgv_lang["stat_individuals"]		= "Individuals";
$pgv_lang["stat_families"]			= "Families";
$pgv_lang["stat_sources"]			= "Sources";
$pgv_lang["stat_other"] 			= "Other Records";
$pgv_lang["stat_earliest_birth"] 	= "Earliest Birth Year";
$pgv_lang["stat_latest_birth"] 	= "Latest Birth Year";
$pgv_lang["stat_earliest_death"] 	= "Earliest Death Year";
$pgv_lang["stat_latest_death"] 	= "Latest Death Year";
$pgv_lang["customize_page"] 		= "Customize MyGedView Portal";
$pgv_lang["customize_gedcom_page"]	= "Customize this GEDCOM Welcome page";
$pgv_lang["upcoming_events_block"]	= "Upcoming Events";
$pgv_lang["upcoming_events_descr"]	= "The Upcoming Events block shows anniversaries of events that will occur in the near future.  You can configure the amount of detail shown, and the administrator can configure how far into the future this block will look.";
$pgv_lang["todays_events_block"]	= "On This Day";
$pgv_lang["todays_events_descr"]	= "The On This Day, in Your History... block shows anniversaries of events for today.  You can configure the amount of detail shown.";
$pgv_lang["logged_in_users_block"]	= "Logged In Users";
$pgv_lang["logged_in_users_descr"]	= "The Logged In Users block shows a list of the users who are currently logged in.";
$pgv_lang["user_messages_block"]	= "User Messages";
$pgv_lang["user_messages_descr"]	= "The User Messages block shows a list of the messages that have been sent to the active user.";
$pgv_lang["user_favorites_block"]	= "User Favorites";
$pgv_lang["user_favorites_descr"]	= "The User Favorites block shows the user a list of his favorite people in the database so that he can easily link to them.";
$pgv_lang["welcome_block"]			= "User Welcome";
$pgv_lang["welcome_descr"]			= "The User Welcome block shows the user the current date and time, quick links to modify his account or go to his own Pedigree chart, and a link to customize his MyGedView Portal page.";
$pgv_lang["random_media_block"] 	= "Random Media";
$pgv_lang["random_media_descr"] 	= "The Random Media block randomly selects a photo or other media item from the currently active database and displays it to the user.<br /><br />The administrator determines whether this block can show media items associated with persons or events.";
$pgv_lang["random_media_persons_or_all"]	= "Show only persons, events, or all?";
$pgv_lang["random_media_persons"]	= "Persons";
$pgv_lang["random_media_events"]	= "Events";
$pgv_lang["gedcom_block"]			= "GEDCOM Welcome";
$pgv_lang["gedcom_descr"]			= "The GEDCOM Welcome block works the same as the User Welcome block.  It welcomes the visitor to the site and displays the title of the currently active database as well as the current date and time.";
$pgv_lang["gedcom_favorites_block"] = "GEDCOM Favorites";
$pgv_lang["gedcom_favorites_descr"] = "The GEDCOM Favorites block gives the administrator the ability to designate individuals from the database so that their information is easily accessible to all.  This is a way to highlight people who are important in your family history.";
$pgv_lang["gedcom_stats_block"] 	= "GEDCOM Statistics";
$pgv_lang["gedcom_stats_descr"] 	= "The GEDCOM Statistics block shows the visitor some basic information about the database, such as when it was created and how many people are in it.<br /><br />It also has a list of the most frequent surnames.  You can configure this block to not show the Frequent Surnames list, and you can also configure the GEDCOM to remove or add names to this list.  You can set the occurrence threshold for this list in the GEDCOM configuration.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Show common surnames?";
$pgv_lang["portal_config_intructions"]	= "~#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />You can customize the page by positioning the blocks on the page the way that you want them.<br /><br />The page is divided into <b>Main</b> and <b>Right</b> sections.	The <b>Main</b> section blocks appear larger and under the page title.  The <b>Right</b> section starts to the right of the title and goes down the right side of the page.<br /><br />Each section has its own list of blocks that will be printed on the page in the order they are listed.  You can add, remove, and reorder the blocks however you like.<br /><br />When one of the block lists is empty, the remaining blocks will take up the whole width of the page.<br /><br />";
$pgv_lang["login_block"]			= "Login";
$pgv_lang["login_descr"]			= "The Login block accepts a user name and password for users to login.";
$pgv_lang["theme_select_block"] 	= "Theme Select";
$pgv_lang["theme_select_descr"] 	= "The Theme Select block displays the Theme selector even when the Change Theme feature is disabled.";
$pgv_lang["block_top10_title"]		= "Top 10 Surnames";
$pgv_lang["block_top10"]			= "Top 10 Surnames";
$pgv_lang["block_top10_descr"]		= "This block shows a table of the 10 most frequently occurring surnames in the database.  The actual number of surnames shown in this block is configurable.  You can configure the GEDCOM to remove names from this list.";

$pgv_lang["gedcom_news_block"]		= "GEDCOM News";
$pgv_lang["gedcom_news_descr"]		= "The GEDCOM News block shows the visitor news releases or articles posted by an admin user.<br /><br />The News block is a good place to announce a significant database update, a family reunion, or the birth of a child.";
$pgv_lang["gedcom_news_limit"]		= "Limit display by:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "No limit";
$pgv_lang["gedcom_news_limit_date"]		= "Age of item";
$pgv_lang["gedcom_news_limit_count"]	= "Number of items";
$pgv_lang["gedcom_news_flag"]		= "Limit:";
$pgv_lang["gedcom_news_archive"] 	= "View archive";
$pgv_lang["user_news_block"]		= "User Journal";
$pgv_lang["user_news_descr"]		= "The User Journal block lets the user keep notes or a journal online.";
$pgv_lang["my_journal"] 			= "My Journal";
$pgv_lang["no_journal"] 			= "You have not created any Journal items.";
$pgv_lang["confirm_journal_delete"] = "Are you sure you want to delete this Journal entry?";
$pgv_lang["add_journal"]			= "Add a new Journal entry";
$pgv_lang["gedcom_news"]			= "News";
$pgv_lang["confirm_news_delete"]	= "Are you sure you want to delete this News entry?";
$pgv_lang["add_news"]				= "Add a News article";
$pgv_lang["no_news"]				= "No News articles have been submitted.";
$pgv_lang["edit_news"]				= "Add/Edit Journal/News entry";
$pgv_lang["enter_title"]			= "Please enter a title.";
$pgv_lang["enter_text"] 			= "Please enter some text for this News or Journal entry.";
$pgv_lang["news_saved"] 			= "News/Journal entry successfully saved.";
$pgv_lang["article_text"]			= "Entry Text:";
$pgv_lang["main_section"]			= "Main Section Blocks";
$pgv_lang["right_section"]			= "Right Section Blocks";
$pgv_lang["available_blocks"]		= "Available Blocks";
$pgv_lang["move_up"]				= "Move Up";
$pgv_lang["move_down"]				= "Move Down";
$pgv_lang["move_right"] 			= "Move Right";
$pgv_lang["move_left"]				= "Move Left";
$pgv_lang["broadcast_all"]			= "Broadcast to all users";
$pgv_lang["hit_count"]				= "Hit Count:";
$pgv_lang["phpgedview_message"] 	= "PhpGedView Message";
$pgv_lang["common_surnames"]		= "Most Common Surnames";
$pgv_lang["default_news_title"] 	= "Welcome to Your Genealogy";
$pgv_lang["default_news_text"]		= "The genealogy information on this website is powered by <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>.  This page provides an introduction and overview to this genealogy.<br /><br />To begin working with the data, choose one of the charts from the Charts menu, go to the Individual list, or search for a name or place.<br /><br />If you have trouble using the site, you can click on the Help icon to give you information on how to use the page that you are currently viewing.<br /><br />Thank you for visiting this site.";
$pgv_lang["reset_default_blocks"]	= "Reset to Default Blocks";
$pgv_lang["recent_changes"] 		= "Recent Changes";
$pgv_lang["recent_changes_block"]	= "Recent Changes";
$pgv_lang["recent_changes_descr"]	= "The Recent Changes block will list all of the changes that have been made to the database in the last month.  This block can help you stay current with the changes that have been made.  Changes are detected automatically, using the CHAN tag defined in the GEDCOM Standard.";
$pgv_lang["recent_changes_none"]	= "<b>There have been no changes within the last #pgv_lang[global_num1]# days.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Changes made within the last #pgv_lang[global_num1]# days</b><br />";
$pgv_lang["show_empty_block"]		= "Should this block be hidden when it is empty?";
$pgv_lang["hide_block_warn"]		= "If you hide an empty block, you will not be able to change its configuration until it becomes visible by no longer being empty.";
$pgv_lang["delete_selected_messages"]	= "Delete Selected Messages";
$pgv_lang["use_blocks_for_default"]	= "Use these blocks as the default block configuration for all users?";
$pgv_lang["block_not_configure"]	=	"This block cannot be configured.";

//-- validate GEDCOM
$pgv_lang["performing_validation"]	= "Performing GEDCOM validation...";
$pgv_lang["changed_mac"]			= "Macintosh line endings detected. All lines ending with only CR (Ctrl M) were changed to end with a CR (Ctrl M) followed by LF (Ctrl J).  This changed the internal file format from Macintosh to DOS as required by PhpGedView.";
$pgv_lang["changed_places"] 		= "Invalid Place encodings detected. Cleaned up place records to match proper GEDCOM 5.5 specifications.  An example from your input GEDCOM is:";
$pgv_lang["invalid_dates"]			= "Detected invalid date formats, on cleanup these will be changed to format of DD MMM YYYY (eg. 1 JAN 2004).";
$pgv_lang["valid_gedcom"]			= "Valid GEDCOM detected. No cleanup required.";
$pgv_lang["optional_tools"] 		= "You may also choose to run the following optional tools before importing.";
$pgv_lang["optional"]				= "Optional Tools";
$pgv_lang["day_before_month"]		= "Day before Month (DD MM YYYY)";
$pgv_lang["month_before_day"]		= "Month before Day (MM DD YYYY)";
$pgv_lang["do_not_change"]			= "Do not change";
$pgv_lang["change_id"]				= "Change Individual ID to:";
$pgv_lang["example_place"]			= "Example of invalid place from your GEDCOM:";
$pgv_lang["example_date"]			= "Example of invalid date from your GEDCOM:";
$pgv_lang["add_media_tool"] 		= "Add Media Tool";
$pgv_lang["launch_media_tool"]		= "Click here to launch the Add Media tool.";
$pgv_lang["add_media_descr"]		= "This tool will add media OBJE tags to the database.  Close this window when you have finished adding media.";
$pgv_lang["highlighted"]			= "Highlighted Image";
$pgv_lang["extension"]				= "Extension";
$pgv_lang["order"]					= "Order";
$pgv_lang["inject_media_tool"]		= "Add media to GEDCOM file";
$pgv_lang["media_table_created"]	= "Successfully updated <i>media</i> table.";
$pgv_lang["click_to_add_media"] 	= "Click here to add the Media listed above to GEDCOM #GEDCOM#";
$pgv_lang["adds_completed"] 		= "Media successfully added to GEDCOM file.";
$pgv_lang["ansi_encoding_detected"] = "ANSI file encoding detected.	PhpGedView works best with files encoded in UTF-8.";
$pgv_lang["invalid_header"] 		= "Detected lines before the GEDCOM header <b>0&nbsp;HEAD</b>.  On cleanup, these lines will be removed.";
$pgv_lang["macfile_detected"]		= "Macintosh file detected.  On cleanup your file will be converted to a DOS file.";
$pgv_lang["place_cleanup_detected"] = "Invalid place encodings were detected.  These errors should be fixed.";
$pgv_lang["cleanup_places"] 		= "Cleanup Places";
$pgv_lang["empty_lines_detected"]	= "Empty lines were detected in your GEDCOM file.	On cleanup, these empty lines will be removed.";
$pgv_lang["import_options"]		= "Import Options";
$pgv_lang["import_options_help"] 	= "You can choose additional options to be used when importing the GEDCOM.";
$pgv_lang["verify_gedcom"]		= "Verify GEDCOM";
$pgv_lang["verify_gedcom_help"]	= "Here you can choose to either continue with the upload and import of this GEDCOM file or to abort the upload and import.";
$pgv_lang["import_statistics"]	= "Import Statistics";
//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Hourglass Chart";

//-- report engine
$pgv_lang["choose_report"]			= "Choose a report to run";
$pgv_lang["enter_report_values"]	= "Enter report values";
$pgv_lang["selected_report"]		= "Selected Report";
$pgv_lang["run_report"] 			= "View report";
$pgv_lang["select_report"]			= "Select report";
$pgv_lang["download_report"]		= "Download report";
$pgv_lang["reports"]				= "Reports";
$pgv_lang["pdf_reports"]			= "PDF reports";
$pgv_lang["html_reports"]			= "HTML reports";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Ahnentafel Report";
$pgv_lang["ahnentafel_header"]		= "Ahnentafel Report for ";
$pgv_lang["ahnentafel_generation"]	= "Generation ";
$pgv_lang["ahnentafel_pronoun_m"]	= "He ";
$pgv_lang["ahnentafel_pronoun_f"]	= "She ";
$pgv_lang["ahnentafel_born_m"]		= "was born";			// male
$pgv_lang["ahnentafel_born_f"]		= "was born";			// female
$pgv_lang["ahnentafel_christened_m"] = "was christened";	// male
$pgv_lang["ahnentafel_christened_f"] = "was christened";	// female
$pgv_lang["ahnentafel_married_m"]	= "married";			// male
$pgv_lang["ahnentafel_married_f"]	= "married";			// female
$pgv_lang["ahnentafel_died_m"]		= "died";				// male
$pgv_lang["ahnentafel_died_f"]		= "died";				// female
$pgv_lang["ahnentafel_buried_m"]	= "was buried";			// male
$pgv_lang["ahnentafel_buried_f"]	= "was buried";			// female
$pgv_lang["ahnentafel_place"]		= " in ";				// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " but the details are unknown";

//-- Descendancy report
$pgv_lang["descend_report"]		= "Descendancy Report";
$pgv_lang["descendancy_header"]		= "Descendancy Report for ";

$pgv_lang["family_group_report"]	= "Family Group Report";
$pgv_lang["page"]					= "Page";
$pgv_lang["of"] 					= "of";
$pgv_lang["enter_famid"]			= "Enter Family ID";
$pgv_lang["show_sources"]			= "Show sources?";
$pgv_lang["show_notes"] 			= "Show notes?";
$pgv_lang["show_basic"] 			= "Print basic events when blank?";
$pgv_lang["show_photos"]			= "Show photos?";
$pgv_lang["relatives_report_ext"]	= "Expanded Relatives Report";
$pgv_lang["with"]					= "with";
$pgv_lang["on"]						= "on";			// for precise dates
$pgv_lang["in"]						= "in";			// for imprecise dates
$pgv_lang["individual_report"]		= "Individual Report";
$pgv_lang["enter_pid"]				= "Enter Individual ID";
$pgv_lang["individual_list_report"]	= "Individual List report";
$pgv_lang["generated_by"]			= "Generated by";
$pgv_lang["list_children"]			= "List each child in order of birth.";
$pgv_lang["birth_report"]			= "Birth Date and Place Report";
$pgv_lang["birthplace"]				= "Birth Place contains";
$pgv_lang["birthdate1"]				= "Birth Date range start";
$pgv_lang["birthdate2"]				= "Birth Date range end";
$pgv_lang["death_report"]			= "Death Date and Place Report";
$pgv_lang["deathplace"]				= "Death Place contains";
$pgv_lang["deathdate1"]				= "Death Date range start";
$pgv_lang["deathdate2"]				= "Death Date range end";
$pgv_lang["marr_report"]			= "Marriage Date and Place Report";
$pgv_lang["marrplace"]				= "Marriage Place contains";
$pgv_lang["marrdate1"]				= "Marriage Date range start";
$pgv_lang["marrdate2"]				= "Marriage Date range end";
$pgv_lang["sort_by"]				= "Sort by";

$pgv_lang["cleanup"]				= "Cleanup";
$pgv_lang["skip_cleanup"]			= "Skip Cleanup";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["dynasty_list"]			= "Overview of families";
$pgv_lang["patriarch_list"] 		= "Patriarch list";
$pgv_lang["statistics"] 			= "Statistics";

//-- Merge Records
$pgv_lang["merge_records"]			= "Merge records";
$pgv_lang["merge_same"] 			= "Records are not the same type.  Cannot merge records that are not the same type.";
$pgv_lang["merge_step1"]			= "Merge Step 1 of 3";
$pgv_lang["merge_step2"]			= "Merge Step 2 of 3";
$pgv_lang["merge_step3"]			= "Merge Step 3 of 3";
$pgv_lang["select_gedcom_records"]	= "Select two GEDCOM records to merge.  The records must be of the same type.";
$pgv_lang["merge_to"]				= "Merge To ID:";
$pgv_lang["merge_from"] 			= "Merge From ID:";
$pgv_lang["merge_facts_same"]		= "The following facts were exactly the same in both records and will be merged automatically.";
$pgv_lang["no_matches_found"]		= "No matching facts found";
$pgv_lang["unmatching_facts"]		= "The following facts did not match.  Select the information you would like to keep.";
$pgv_lang["record"] 				= "Record";
$pgv_lang["adding"] 				= "Adding";
$pgv_lang["updating_linked"]		= "Updating linked record";
$pgv_lang["merge_more"] 			= "Merge more records.";
$pgv_lang["same_ids"]				= "You entered the same IDs.  You cannot merge the same records.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "Ancestry Chart";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Generation Ancestry Chart";
$pgv_lang["chart_style"]			= "Chart style";
$pgv_lang["chart_list"]			= "List";
$pgv_lang["chart_booklet"]   	= "Booklet";
$pgv_lang["show_cousins"]			= "Show cousins";
// 1st generation
$pgv_lang["sosa_2"] 				= "Father";
$pgv_lang["sosa_3"] 				= "Mother";
// 2nd generation
$pgv_lang["sosa_4"] 				= "Grandfather";
$pgv_lang["sosa_5"] 				= "Grandmother";
$pgv_lang["sosa_6"] 				= "Grandfather";
$pgv_lang["sosa_7"] 				= "Grandmother";
// 3rd generation
$pgv_lang["sosa_8"] 				= "Great-grandfather";
$pgv_lang["sosa_9"] 				= "Great-grandmother";
$pgv_lang["sosa_10"]				= "Great-grandfather";
$pgv_lang["sosa_11"]				= "Great-grandmother";
$pgv_lang["sosa_12"]				= "Great-grandfather";
$pgv_lang["sosa_13"]				= "Great-grandmother";
$pgv_lang["sosa_14"]				= "Great-grandfather";
$pgv_lang["sosa_15"]				= "Great-grandmother";
// 4th generation
$pgv_lang["sosa_16"]				= "Great-great-grandfather";
$pgv_lang["sosa_17"]				= "Great-great-grandmother";
$pgv_lang["sosa_18"]				= "Great-great-grandfather";
$pgv_lang["sosa_19"]				= "Great-great-grandmother";
$pgv_lang["sosa_20"]				= "Great-great-grandfather";
$pgv_lang["sosa_21"]				= "Great-great-grandmother";
$pgv_lang["sosa_22"]				= "Great-great-grandfather";
$pgv_lang["sosa_23"]				= "Great-great-grandmother";
$pgv_lang["sosa_24"]				= "Great-great-grandfather";
$pgv_lang["sosa_25"]				= "Great-great-grandmother";
$pgv_lang["sosa_26"]				= "Great-great-grandfather";
$pgv_lang["sosa_27"]				= "Great-great-grandmother";
$pgv_lang["sosa_28"]				= "Great-great-grandfather";
$pgv_lang["sosa_29"]				= "Great-great-grandmother";
$pgv_lang["sosa_30"]				= "Great-great-grandfather";
$pgv_lang["sosa_31"]				= "Great-great-grandmother";
// 5th generation
$pgv_lang["sosa_32"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_33"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_34"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_35"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_36"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_37"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_38"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_39"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_40"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_41"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_42"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_43"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_44"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_45"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_46"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_47"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_48"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_49"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_50"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_51"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_52"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_53"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_54"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_55"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_56"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_57"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_58"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_59"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_60"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_61"]			   = "Great-great-great-grandmother";
$pgv_lang["sosa_62"]			   = "Great-great-great-grandfather";
$pgv_lang["sosa_63"]			   = "Great-great-great-grandmother";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Compact Chart";
$pgv_lang["fan_chart"]				= "Circle Diagram";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Generation Circle Diagram";
$pgv_lang["fan_width"]				= "Width";
$pgv_lang["gd_library"]				= "PHP server misconfiguration: GD 2.x library required to use image functions.";
$pgv_lang["gd_freetype"]			= "PHP server misconfiguration: FreeType library required to use TrueType fonts.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Font file not found on PHP server";
$pgv_lang["fanchart_IE"]			= "This Fanchart image cannot be printed directly by your browser. Use right-click then save and print.";

//-- RSS Feed
$pgv_lang["rss_descr"]				= "News and links from the #GEDCOM_TITLE# site";
$pgv_lang["rss_logo_descr"]			= "Feed created by PhpGedView";
$pgv_lang["rss_feeds"]				= "RSS Feeds";
$pgv_lang["no_feed_title"]			= "Feed not available";
$pgv_lang["no_feed"]				= "There is no RSS feed available for this PhpGedView site";
$pgv_lang["feed_login"]				= "If you have an account at this PhpGedView site, you can <a href=\"#AUTH_URL#\">log in</a> to the server using Basic HTTP Authentication to view private information.";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"] = "Attendant";
$pgv_lang["attending"] = "Attending";
$pgv_lang["best_man"] = "Best Man";
$pgv_lang["bridesmaid"] = "Bridesmaid";
$pgv_lang["buyer"] = "Buyer";
$pgv_lang["circumciser"] = "Circumciser";
$pgv_lang["civil_registrar"] = "Civil Registrar";
$pgv_lang["friend"] = "Friend";
$pgv_lang["godfather"] = "Godfather";
$pgv_lang["godmother"] = "Godmother";
$pgv_lang["godparent"] = "Godparent";
$pgv_lang["informant"] = "Informant";
$pgv_lang["lodger"] = "Lodger";
$pgv_lang["nurse"] = "Nurse";
$pgv_lang["priest"] = "Priest";
$pgv_lang["rabbi"] = "Rabbi";
$pgv_lang["registry_officer"] = "Registry Officer";
$pgv_lang["seller"] = "Seller";
$pgv_lang["servant"] = "Servant";
$pgv_lang["twin"] = "Twin";
$pgv_lang["twin_brother"] = "Twin brother";
$pgv_lang["twin_sister"] = "Twin sister";
$pgv_lang["witness"] = "Witness";

//-- statistics utility
$pgv_lang["statutci"]			= "unable to create index";
$pgv_lang["statnnames"]                = "number of names    =";
$pgv_lang["statnfam"]                  = "number of families =";
$pgv_lang["statnmale"]                 = "number of males    =";
$pgv_lang["statnfemale"]               = "number of females  =";
$pgv_lang["statvars"]			 = "Fill in the following variables for the plot";
$pgv_lang["statlxa"]			 = "along x-axis:";
$pgv_lang["statlya"]			 = "along y-axis:";
$pgv_lang["statlza"]			 = "along z-axis";
$pgv_lang["stat_10_none"]		 = "none";
$pgv_lang["stat_11_mb"]			 = "Month of birth";
$pgv_lang["stat_12_md"]			 = "Month of death";
$pgv_lang["stat_13_mm"]			 = "Month of marriage";
$pgv_lang["stat_14_mb1"]		= "Month of birth of first child in a relation";
$pgv_lang["stat_15_mm1"]		= "Month of first marriage";
$pgv_lang["stat_16_mmb"]		= "Months between marriage and first child.";
$pgv_lang["stat_17_arb"]			 = "age related to birth year.";
$pgv_lang["stat_18_ard"]			 = "age related to death year.";
$pgv_lang["stat_19_arm"]			 = "age in year of marriage.";
$pgv_lang["stat_20_arm1"]			 = "age in year of first marriage.";
$pgv_lang["stat_21_nok"]			 = "number of children.";
$pgv_lang["stat_gmx"]			= " check tickvalues for month";
$pgv_lang["stat_gax"]			= " check tickvalues for ages";
$pgv_lang["stat_gnx"]			= " check tickvalues for numbers";
$pgv_lang["stat_200_none"]			 = "all (or blank)";
$pgv_lang["stat_201_num"]			 = "numbers";
$pgv_lang["stat_202_perc"]			 = "percentage";
$pgv_lang["stat_300_none"]		= "none";
$pgv_lang["stat_301_mf"]			 = "male/female";
$pgv_lang["stat_302_cgp"]			 = "periods. Check tickvalues for periods z-axis";
$pgv_lang["statmess1"]			 = "<b>Just fill in next rows related to earlier settings on x-axis or z-axis</b>";
$pgv_lang["statar_xgp"]			 = "tickvalues for periods (x-axis):";
$pgv_lang["statar_xgl"]			 = "tickvalues for ages    (x-axis):";
$pgv_lang["statar_xgm"]			 = "tickvalues for month   (x-axis):";
$pgv_lang["statar_xga"]			 = "tickvalues for numbers (x-axis):";
$pgv_lang["statar_zgp"]			 = "tickvalues for periods (z-axis):";
$pgv_lang["statreset"]			 = "reset";
$pgv_lang["statsubmit"]			 = "show the plot";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]	= "Statistics Plot";
$pgv_lang["stpl"]			 	= "...";
$pgv_lang["stplGDno"]			 = "Graphics Display Library is not available in PHP 4. Please contact your system administrator";
$pgv_lang["stpljpgraphno"]		= "JPgraph modules are not available in directory <i>phpgedview/jpgraph/</i> . Please get them from http://www.aditus.nu/jpgraph/jpdownload.php<br /> <h3>First install JPgraph in directory <i>phpgedview/jpgraph/</i></h3><br />";
$pgv_lang["stplinfo"]			 = "plotting information:";
$pgv_lang["stpltype"]			 = "type:";
$pgv_lang["stplnoim"]			 = " not implemented:";
$pgv_lang["stplmf"]			 = " / man-woman";
$pgv_lang["stplipot"]			 = " / per timeperiod";
$pgv_lang["stplgzas"]			 = "borders z-axis:";
$pgv_lang["stplmonth"]			 = "month";
$pgv_lang["stplnumbers"]		 = "numbers for a family";
$pgv_lang["stplage"]			 = "age";
$pgv_lang["stplperc"]			 = "percentage";
$pgv_lang["stplnumof"]			 = "Counts ";
$pgv_lang["stplmarrbirth"]		 = "Months between marriage and birth of first child";

//-- alive in year
$pgv_lang["alive_in_year"]			= "Alive in Year";
$pgv_lang["is_alive_in"]			= "Is alive in #YEAR#";
$pgv_lang["alive"]					= "Alive ";
$pgv_lang["dead"]					= "Dead ";
$pgv_lang["maybe"]					= "Maybe ";

//-- Help system
$pgv_lang["definitions"]			= "Definitions";

//-- Index_edit
$pgv_lang["description"]			= "Description";
$pgv_lang["block_desc"]				= "Block Descriptions";
$pgv_lang["click_here"]				= "Click here to continue";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Click this button to save your changes.<br /><br />You will be returned to the #pgv_lang[welcome]# or #pgv_lang[mygedview]# page, but your changes may not be shown.  You may need to use the Page Reload function of your browser to view your changes properly.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Here is a short description of each of the blocks you can place on the #pgv_lang[welcome]# or #pgv_lang[mygedview]# page.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
// Built in index_edit.php
$pgv_lang["block_summary_table"]	= "&nbsp;";

//-- Find page
$pgv_lang["total_places"]			= "Places found";
$pgv_lang["media_contains"]			= "Media contains:";
$pgv_lang["repo_contains"]			= "Repository contains:";
$pgv_lang["source_contains"]		= "Source contains:";
$pgv_lang["display_all"]			= "Display all";

//-- accesskey navigation
$pgv_lang["accesskeys"]				= "Keyboard Shortcuts";
$pgv_lang["accesskey_skip_to_content"]	= "C";
$pgv_lang["accesskey_search"]	= "S";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Skip to Content";
$pgv_lang["accesskey_viewing_advice"]	= "0";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Viewing advice";
$pgv_lang["accesskey_home_page"]	= "1";
$pgv_lang["accesskey_help_content"]	= "2";
$pgv_lang["accesskey_help_current_page"]	= "3";
$pgv_lang["accesskey_contact"]	= "4";

$pgv_lang["accesskey_individual_details"]	= "I";
$pgv_lang["accesskey_individual_relatives"]	= "R";
$pgv_lang["accesskey_individual_notes"]	= "N";
$pgv_lang["accesskey_individual_sources"]	= "O";
//clash with IE addBookmark but not a likely problem
$pgv_lang["accesskey_individual_media"]	= "A";
$pgv_lang["accesskey_individual_research_log"]	= "L";
$pgv_lang["accesskey_individual_pedigree"]	= "P";
$pgv_lang["accesskey_individual_descendancy"]	= "D";
$pgv_lang["accesskey_individual_timeline"]	= "T";
$pgv_lang["accesskey_individual_relation_to_me"]	= "M";
//clash with rarely used English Netscape/Mozilla Go menu
$pgv_lang["accesskey_individual_gedcom"]	= "G";

$pgv_lang["accesskey_family_parents_timeline"]	= "P";
$pgv_lang["accesskey_family_children_timeline"]	= "D";
$pgv_lang["accesskey_family_timeline"]	= "T";
//clash with rarely used English Netscape/Mozilla English Go menu
$pgv_lang["accesskey_family_gedcom"]	= "G";

// FAQ Page
$pgv_lang["add_faq_header"] = "FAQ Header";
$pgv_lang["add_faq_body"] = "FAQ Body";
$pgv_lang["add_faq_order"] = "FAQ Position";
$pgv_lang["no_faq_items"] = "The FAQ list is empty.";
$pgv_lang["position_item"] = "Position item";
$pgv_lang["faq_list"] = "FAQ List";
$pgv_lang["confirm_faq_delete"] = "Are you sure you want to delete the FAQ entry";
$pgv_lang["preview"] =  "Preview";
$pgv_lang["no_id"] = "No FAQ ID has been specified !";

// Help search
$pgv_lang["hs_title"] 			= "Search Help Text";
$pgv_lang["hs_search"] 			= "Search";
$pgv_lang["hs_close"] 			= "Close window";
$pgv_lang["hs_results"] 		= "Results found:";
$pgv_lang["hs_keyword"] 		= "Search for";
$pgv_lang["hs_searchin"]		= "Search in";
$pgv_lang["hs_searchuser"]		= "User Help";
$pgv_lang["hs_searchconfig"]	= "Administrator Help";
$pgv_lang["hs_searchhow"]		= "Search type";
$pgv_lang["hs_searchall"]		= "All words";
$pgv_lang["hs_searchany"]		= "Any word";
$pgv_lang["hs_searchsentence"]	= "Exact phrase";
$pgv_lang["hs_intruehelp"]		= "Help text only";
$pgv_lang["hs_inallhelp"]		= "All text";

// Media import
$pgv_lang["media_import"] = "Import and convert media";
$pgv_lang["confirm_folder_delete"] = "Are you sure you want to delete this folder?";
$pgv_lang["choose"] = "Choose: ";
$pgv_lang["account_information"] = "Account Information";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Book";
$pgv_lang["TYPE__card"] = "Card";
$pgv_lang["TYPE__certificate"] = "Certificate";
$pgv_lang["TYPE__document"] = "Document";
$pgv_lang["TYPE__electronic"] = "Electronic";
$pgv_lang["TYPE__fiche"] = "Microfiche";
$pgv_lang["TYPE__film"] = "Microfilm";
$pgv_lang["TYPE__magazine"] = "Magazine";
$pgv_lang["TYPE__manuscript"] = "Manuscript";
$pgv_lang["TYPE__map"] = "Map";
$pgv_lang["TYPE__newspaper"] = "Newspaper";
$pgv_lang["TYPE__photo"] = "Photo";
$pgv_lang["TYPE__tombstone"] = "Tombstone";
$pgv_lang["TYPE__video"] = "Video";

if (file_exists( "languages/lang.en.extra.php")) require  "languages/lang.en.extra.php";
?>
