/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ChopRectangleConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.SetBoundsEdit;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Dimension2DDouble;

public abstract class AbstractFigure
extends AbstractBean
implements Figure {
    protected EventListenerList listenerList = new EventListenerList();
    private Drawing drawing;
    private boolean isSelectable = true;
    private boolean isRemovable = true;
    private boolean isVisible = true;
    private boolean isTransformable = true;
    protected int changingDepth = 0;

    @Override
    public void addFigureListener(FigureListener figureListener) {
        this.listenerList.add(FigureListener.class, figureListener);
    }

    @Override
    public void removeFigureListener(FigureListener figureListener) {
        this.listenerList.remove(FigureListener.class, figureListener);
    }

    @Override
    public void addNotify(Drawing drawing) {
        this.drawing = drawing;
        this.fireFigureAdded();
    }

    @Override
    public void removeNotify(Drawing drawing) {
        this.fireFigureRemoved();
        this.drawing = null;
    }

    protected Drawing getDrawing() {
        return this.drawing;
    }

    protected Object getLock() {
        return this.getDrawing() == null ? this : this.getDrawing().getLock();
    }

    public void fireAreaInvalidated() {
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    protected void fireAreaInvalidated(Rectangle2D.Double double_) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, double_);
                }
                ((FigureListener)objectArray[i + 1]).areaInvalidated(figureEvent);
            }
        }
    }

    protected void fireAreaInvalidated(FigureEvent figureEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FigureListener.class) continue;
            ((FigureListener)objectArray[i + 1]).areaInvalidated(figureEvent);
        }
    }

    protected void fireFigureRequestRemove() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureRequestRemove(figureEvent);
            }
        }
    }

    protected void fireFigureAdded() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureAdded(figureEvent);
            }
        }
    }

    protected void fireFigureRemoved() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureRemoved(figureEvent);
            }
        }
    }

    public void fireFigureChanged() {
        this.fireFigureChanged(this.getDrawingArea());
    }

    protected void fireFigureChanged(Rectangle2D.Double double_) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, double_);
                }
                ((FigureListener)objectArray[i + 1]).figureChanged(figureEvent);
            }
        }
    }

    protected void fireFigureChanged(FigureEvent figureEvent) {
        if (this.listenerList.getListenerCount() > 0) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                ((FigureListener)objectArray[i + 1]).figureChanged(figureEvent);
            }
        }
    }

    protected void fireAttributeChanged(AttributeKey attributeKey, Object object, Object object2) {
        if (!(this.listenerList.getListenerCount() <= 0 || object != null && object2 != null && object.equals(object2))) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, attributeKey, object, object2);
                }
                ((FigureListener)objectArray[i + 1]).attributeChanged(figureEvent);
            }
        }
    }

    protected void fireFigureHandlesChanged() {
        Rectangle2D.Double double_ = this.getDrawingArea();
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, double_);
                }
                ((FigureListener)objectArray[i + 1]).figureHandlesChanged(figureEvent);
            }
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        if (this.getDrawing() != null) {
            this.getDrawing().fireUndoableEditHappened(undoableEdit);
        }
    }

    @Override
    public AbstractFigure clone() {
        AbstractFigure abstractFigure = (AbstractFigure)super.clone();
        abstractFigure.listenerList = new EventListenerList();
        abstractFigure.drawing = null;
        return abstractFigure;
    }

    public final AbstractFigure basicClone(HashMap<Figure, Figure> hashMap) {
        return null;
    }

    @Override
    public void remap(Map<Figure, Figure> map, boolean bl) {
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, linkedList);
            }
        }
        return linkedList;
    }

    @Override
    public Cursor getCursor(Point2D.Double double_) {
        if (this.contains(double_)) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public final void setBounds(Rectangle2D.Double double_) {
        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = this.getStartPoint();
        Point2D.Double double_4 = this.getEndPoint();
        if (!double_3.equals(double_) || !double_4.equals(double_2)) {
            this.willChange();
            this.setBounds(double_, double_2);
            this.changed();
            this.fireUndoableEditHappened(new SetBoundsEdit(this, double_3, double_4, double_, double_2));
        }
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    protected void invalidate() {
    }

    protected boolean isChanging() {
        return this.changingDepth != 0;
    }

    protected int getChangingDepth() {
        return this.changingDepth;
    }

    @Override
    public void willChange() {
        if (this.changingDepth == 0) {
            this.fireAreaInvalidated();
            this.invalidate();
        }
        ++this.changingDepth;
    }

    protected void validate() {
    }

    @Override
    public void changed() {
        if (this.changingDepth == 1) {
            this.validate();
            this.fireFigureChanged(this.getDrawingArea());
        } else if (this.changingDepth < 0) {
            throw new InternalError("changed was called without a prior call to willChange. " + this.changingDepth);
        }
        --this.changingDepth;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        return this.contains(double_) ? this : null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        return Collections.emptyList();
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        return false;
    }

    @Override
    public boolean handleDrop(Point2D.Double double_, Collection<Figure> collection, DrawingView drawingView) {
        return false;
    }

    @Override
    public Point2D.Double getEndPoint() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
    }

    @Override
    public Point2D.Double getStartPoint() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Point2D.Double(double_.x, double_.y);
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Dimension2DDouble(double_.width, double_.height);
    }

    @Override
    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean bl) {
        boolean bl2 = this.isSelectable;
        this.isSelectable = bl;
        this.firePropertyChange("selectable", bl2, bl);
    }

    @Override
    public boolean isRemovable() {
        return this.isRemovable;
    }

    public void setRemovable(boolean bl) {
        boolean bl2 = this.isRemovable;
        this.isRemovable = bl;
        this.firePropertyChange("removable", bl2, bl);
    }

    @Override
    public boolean isTransformable() {
        return this.isTransformable;
    }

    public void setTransformable(boolean bl) {
        boolean bl2 = this.isTransformable;
        this.isTransformable = bl;
        this.firePropertyChange("transformable", bl2, bl);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible) {
            this.willChange();
            this.isVisible = bl;
            this.changed();
        }
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        linkedList.add(this);
        return linkedList;
    }

    protected FontRenderContext getFontRenderContext() {
        FontRenderContext fontRenderContext = null;
        if (fontRenderContext == null) {
            fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        }
        return fontRenderContext;
    }

    @Override
    public void requestRemove() {
        this.fireFigureRequestRemove();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public String getToolTipText(Point2D.Double double_) {
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        stringBuilder.append('@');
        stringBuilder.append(this.hashCode());
        return stringBuilder.toString();
    }

    @Override
    public Collection<Connector> getConnectors(ConnectionFigure connectionFigure) {
        LinkedList<Connector> linkedList = new LinkedList<Connector>();
        linkedList.add(new ChopRectangleConnector(this));
        return linkedList;
    }
}

