#!/usr/bin/perl

# Copyright (c) Kim Holviala <kimmy@iki.fi> 1997-2000

require 5.002;


# Message composition stuff =================================================

# Save draft ----------------------------------------------------------------

sub saveDraft {

# Format & save draft
	$CONFIG{'Draft'} = "To: $FORM{'to'}\nSubject: $FORM{'subject'}\nCC: $FORM{'cc'}\n" .
		"BCC: $FORM{'bcc'}\nNewsgroups: $FORM{'newsgroups'}\nX-Html: $FORM{'html'}\n" .
		"\n$FORM{'body'}";

# Show next page
	if ($FORM{'msg'}) { &read; }
	else { &inbox; }
}


# Show draft ----------------------------------------------------------------

sub showDraft {

	($header, $body) = split(/\n\n/, $CONFIG{'Draft'}, 2);

	$header =~ /^To: (.+)/m and $to = $1;
	$header =~ /^CC: (.+)/m and $cc = $1;
	$header =~ /^BCC: (.+)/m and $bcc = $1;
	$header =~ /^Subject: (.+)/m and $subject = $1;
	$header =~ /^Newsgroups: (.+)/m and $newsgroups = $1;
	$header =~ /^X-Html: (.+)/m and $htmlchecked = 1;

	&compose;
}


# Compose new message -------------------------------------------------------

sub compose {

	&httpHeaders;

	@address = split(/\n/, $CONFIG{'AddressBook'});

# Delete old attachemts
	$msg = 0;
	do { $msg++; }
	while ( unlink "$CONFIG{'TempPath'}$FORM{'u'}\.out\.$msg" );

# Set default values for fields
	$to = $FORM{'to'} if $FORM{'to'};
	$replyto ||= $CONFIG{'ReplyToAddress'} ? $CONFIG{'ReplyToAddress'} : $CONFIG{'RealEmail'};
	$from ||= "$CONFIG{'RealName'} <$CONFIG{'RealEmail'}>";
	$subject = $FORM{'subject'} if $FORM{'subject'};
	$body .= "\n\n\n\n" . &webify($CONFIG{'Signature'}) if $CONFIG{'Signature'};

	$cc .= ($cc ? ", $CONFIG{'DefaultCC'}" : $CONFIG{'DefaultCC'}) if ($CONFIG{'DefaultCC'});
	$bcc .= ($bcc ? ", $CONFIG{'DefaultBCC'}" : $CONFIG{'DefaultBCC'}) if ($CONFIG{'DefaultBCC'});
	
#	$to =~ s/\(.*?\)//g;		# Show draft bug!
	$to = &webify($to);
	$from = &webify($from);
	$cc = &webify($cc);
	$bcc = &webify($bcc);
	$body = &webify($body);
	$replyto = &webify($replyto);
	$subject = &webify($subject);

	$redirect = 0 unless $redirect;
	$htmlchecked = " CHECKED" if $htmlchecked;

# Generate buttons
	&btnStart;

	&btnAdd('do=logout', 'Logout');
	&btnBreak;

	&btnAdd($FORM{'msg'} ? "do=read\&msg=$FORM{'msg'}" : 'do=inbox', 'Cancel');
	&btnBreak;

	&btnAdd('SUBMIT', 'Send');
	&btnBreak;

	&btnAdd('javascript:saveDraft();', 'SaveDraft');
	&btnAdd($FORM{'msg'} ? "do=read\&msg=$FORM{'msg'}\&configDraft=" : 'do=inbox&configDraft=', 'DeleteDraft')
		if ($FORM{'do'} =~ /showdraft/);
	&btnBreak;

#	&btnAdd('javascript:openSearch();', 'Search');
	&btnAdd('javascript:spellCheck();', 'Spellcheck') if ($CONFIG{'JavaScript'} > 1);
#	&btnAdd('javascript:previewHTML();', 'Preview');
	&btnBreak;

	&btnAdd('do=inbox', 			'Inbox');

	&btnEnd;

# Print head
	&advertisement;
	&helpButton('Compose');

	$_ = &getTemplate('compose.html');

	s#application/x-www-form-urlencoded#multipart/form-data#
		if ($CONFIG{'FileUpload'} && $CONFIG{'JavaScript'} > 1);

	($htmlhead, $htmlfoot) = split(/<!--begin-->/);

	print "Content-Type: text/html$crlf$crlf$htmlhead\n",
	 	($CONFIG{'ButtonRowLocation'} =~ /(both|top)/ and "$buttonrow\n<P>\n");

# Print form
	$fonton = $CONFIG{'BigTextStart'};
	$fontoff = $CONFIG{'BigTextEnd'};
	$isize = $CONFIG{'ComposeFieldWidth'};
	$asize = $isize - 15;

	print "<TABLE>\n",
		"<TR><TD ALIGN=right>${fonton}$CONFIG{'TextTo'}:${fontoff}</TD>\n<TD ALIGN=left>",
		"<INPUT NAME=\"to\" TYPE=\"text\" VALUE=\"$to\" SIZE=$isize",
		($CONFIG{'JavaScript'} > 0 ? " onChange=\"completeName('to');\"" : ''), 
		"></TD></TR>\n";

	if ($CONFIG{'AddressBook'} and $CONFIG{'JavaScript'} == 0) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextTo'}:${fontoff}</TD>\n",
			"<TD ALIGN=left><SELECT NAME=\"alsoto\" SIZE=4 MULTIPLE><OPTION>-\n";

		foreach $_ (@address) {
			print "<OPTION>", &webify((split(/:/))[0]), "\n";
		}

		print "</SELECT></TD></TR>\n";
	}

	if ($CONFIG{'HideInCompose'} !~ /\bfrom\b/i) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextFrom'}:${fontoff}</TD>\n<TD ALIGN=left>",
			"<INPUT NAME=\"from\" TYPE=\"text\" VALUE=\"$from\" ",
			"SIZE=$isize></TD></TR>\n";
	}

	if ($CONFIG{'HideInCompose'} !~ /\breplyto\b/i) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextReplyTo'}:${fontoff}</TD>\n<TD ALIGN=left>",
			"<INPUT NAME=\"replyto\" TYPE=\"text\" VALUE=\"$replyto\" SIZE=$isize",
			($CONFIG{'JavaScript'} > 0 ? " onChange=\"completeName('replyto');\"" : ''), 
			"></TD></TR>\n";
	}

	print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextSubject'}:${fontoff}</TD>\n<TD ALIGN=left>",
		"<INPUT NAME=\"subject\" TYPE=\"text\" VALUE=\"$subject\" SIZE=$isize></TD></TR>\n";

	if ($CONFIG{'HideInCompose'} !~ /\bcc\b/i) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextCC'}:${fontoff}</TD>\n<TD ALIGN=left>",
			"<INPUT NAME=\"cc\" TYPE=\"text\" VALUE=\"$cc\" SIZE=$isize",
			($CONFIG{'JavaScript'} > 0 ? " onChange=\"completeName('cc');\"" : ''), 
			"></TD></TR>\n";
	}

	if ($CONFIG{'HideInCompose'} !~ /\bbcc\b/i) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextBCC'}:${fontoff}</TD>\n<TD ALIGN=left>",
			"<INPUT NAME=\"bcc\" TYPE=\"text\" VALUE=\"$bcc\" SIZE=$isize",
			($CONFIG{'JavaScript'} > 0 ? " onChange=\"completeName('bcc');\"" : ''), 
			"></TD></TR>\n";
	}

	if ($CONFIG{'HideInCompose'} !~ /\bnewsgroups\b/i) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextNewsgroups'}:${fontoff}</TD>\n<TD ALIGN=left>",
			"<INPUT NAME=\"newsgroups\" TYPE=\"text\" VALUE=\"$newsgroups\" SIZE=$isize></TD></TR>\n";
	}

	if ($CONFIG{'FileUpload'} and $CONFIG{'HideInCompose'} !~ /\battachments\b/i) {
		if ($CONFIG{'JavaScript'} > 0 and $CONFIG{'MultipleAttachments'}) {
			print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextAttachments'}:${fontoff}</TD>\n<TD ALIGN=left>",
				"<INPUT NAME=\"attachment\" TYPE=\"text\" VALUE=\"$attachment\" SIZE=$asize>\n",
				"$CONFIG{'TButtonStart'}<A HREF=\"javascript:newAttachment();\">",
				&config('TextNewAttachment'), "</A>$CONFIG{'TButtonEnd'}</TD></TR>\n";
		}
		else {
			print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextAttachment'}:${fontoff}</TD>\n<TD ALIGN=left>",
				"<INPUT NAME=\"attachment\" TYPE=\"file\" SIZE=$asize>\n",
				"</FONT></TD></TR>\n";
		}
	}

	if ($CONFIG{'AddressBook'} and $CONFIG{'JavaScript'} > 0) {
		print "<TR><TD ALIGN=right>${fonton}$CONFIG{'TextInsertRecipient'}:${fontoff}</TD>\n",
			"<TD ALIGN=left><SELECT NAME=\"friends\">";

		foreach $_ (@address) {
			print "<OPTION>", &webify((split(/:/))[0]), "\n";
		}

		print "</SELECT>\n",
			"$CONFIG{'TButtonStart'}<A HREF=\"javascript:insertName('to');\">",
			&config('TextInsertTo'), "</A>$CONFIG{'TButtonEnd'}\n";

			if ($CONFIG{'HideInCompose'} !~ /\bcc\b/i) {
				print "$CONFIG{'TButtonStart'}<A HREF=\"javascript:insertName('cc');\">",
					&config('TextInsertCC'), "</A>$CONFIG{'TButtonEnd'}\n";
			}

			if ($CONFIG{'HideInCompose'} !~ /\bbcc\b/i) {
				print "$CONFIG{'TButtonStart'}<A HREF=\"javascript:insertName('bcc');\">",
					&config('TextInsertBCC'), "</A>$CONFIG{'TButtonEnd'}\n";
			}

		print "</TD></TR>\n\n";
	}

	if ($CONFIG{'HideInCompose'} !~ /\bpriority\b/i) {
		print "<TD ALIGN=right>${fonton}$CONFIG{'TextPriority'}:${fontoff}</TD>\n",
			"<TD ALIGN=left><SELECT NAME=\"priority\">\n$CONFIG{'PriorityOptions'}\n",
			"</SELECT></TD></TR>\n";
	}

#	print "<TR><TD VALIGN=top>${fonton}$CONFIG{'TextMessageSettings'}:${fontoff}</TD>\n",
#		"<TD><INPUT NAME=\"html\" TYPE=\"checkbox\"$htmlchecked> $CONFIG{'TextAllowHTML'}<BR>\n";

	print "<TR><TD VALIGN=top>${fonton}$CONFIG{'TextMessageSettings'}:${fontoff}</TD>\n",
		"<TD>\n";

	if ($CONFIG{'VCard'}) {
		print "<INPUT NAME=\"vcard\" TYPE=\"checkbox\"",
			($CONFIG{'AttachVCard'} and " CHECKED"),
			"> $CONFIG{'TextAttachVCard'}<BR>\n";
	}

	&btnFixBottom;

#	print "<INPUT NAME=\"confirm\" TYPE=\"checkbox\"",
#		($CONFIG{'AlwaysConfirm'} and " CHECKED"),
#		"> $CONFIG{'TextConfirmSend'}<BR>\n",

	print "<INPUT NAME=\"deliverynotes\" TYPE=\"checkbox\"> ",
		"$CONFIG{'TextRequestDeliveryNotes'}\n</TD></TR></TABLE><BR>\n",

		"<TEXTAREA NAME=\"body\" ROWS=$CONFIG{'ComposeBodyRows'} ",
		"COLS=$CONFIG{'ComposeBodyColumns'} WRAP=virtual",
		($CONFIG{'JavaScript'} > 0 ? " onFocus=\"if (spellCheckInProgress) closeSpellCheck(1);\"" : ''),
		">", $body, "\n</TEXTAREA><P>\n",

		&hiddenFields('send'), 
		"<INPUT NAME=\"redirect\" TYPE=\"hidden\" VALUE=\"$redirect\">\n",
		"<INPUT NAME=\"date\" TYPE=\"hidden\">\n",

		($CONFIG{'HideInCompose'} =~ /\bfrom\b/i and
			"<INPUT NAME=\"from\" TYPE=\"hidden\" VALUE=\"$from\">\n"), 

		($CONFIG{'HideInCompose'} =~ /\breplyto\b/i and
			"<INPUT NAME=\"replyto\" TYPE=\"hidden\" VALUE=\"$replyto\">\n"), 

		($CONFIG{'ButtonRowLocation'} =~ /(both|bottom)/ and "$buttonrow\n<P>\n"), 
		$htmlfoot;
}


# Reply to a message --------------------------------------------------------

sub reply {

# Get the message
	$msg = $FORM{'msg'};

	&getMessage($msg);

	($header, $body) = split(/<\/X-MAILREADER-HEADER>.*\n/, $message, 2);
	$body =~ s/\{(\w+?)\}/&config($1)/ge;

# Fix the body
	$body =~ s/<LI>/ o /ig;
	$body =~ s/<HR.*?>/-----------------------------------------------------------------/ig;
	$body =~ s/<.*?>//gs;

	$body =~ s/\n\s*[\n\s]*\n/\n\n/g;
	$body =~ s/^[\n\s]*//;

# Parse all headers of this message
	@pairs = split(/\n/, $header);

	foreach $pair (@pairs) {
		($name, $value) = split(/:\ /, $pair, 2);
		$name =~ s/\s//g;
		$name =~ tr/A-Z/a-z/;
		$HEADER{$name} = $value;
	}

# Handle different actions
	for ($FORM{'do'}) {
		/reply/ and do {
			$HEADER{'message-id'} and $CONFIG{'RepliedMessages'} .= "$HEADER{'message-id'}\n";
			$to = ($HEADER{'reply-to'} or $HEADER{'from'});

			if (!$CONFIG{'NoAutoSave'}) {
				($name, $email) = &parseEmailaddress($HEADER{'from'});
				$email = (&parseEmailaddress($HEADER{'reply-to'}))[1] if ($HEADER{'reply-to'});

				&loadModule('misc.cgi');
				&saveAddress($name, $email);
			}

			$subject = $HEADER{'subject'};
			$subject = "$CONFIG{'ReplySubjectPrefix'}$subject" unless $subject =~ /^\s*Re:/i;

			if (!$CONFIG{'NoQuotedReply'}) {
				$body =~ s/\n/\n$CONFIG{'QuoteChar'}/g;
				$body = &parsePrefix($CONFIG{'ReplyBodyPrefix'}) .
					"\n\n$CONFIG{'QuoteChar'}$body";
			}
			else { $body = ""; };

			last;
		};
		/repall/ and do {
			$HEADER{'message-id'} and $CONFIG{'RepliedMessages'} .= "$HEADER{'message-id'}\n";
			$to = ($HEADER{'reply-to'} or $HEADER{'from'});

			$subject = $HEADER{'subject'};
			$subject = "$CONFIG{'ReplyAllSubjectPrefix'}$subject" unless $subject =~ /^\s*Re:/i;

			$cc = $HEADER{'to'} . ($HEADER{'cc'} and (", " . $HEADER{'cc'}));

			if (!$CONFIG{'NoQuotedReply'}) {
				$body =~ s/\n/\n$CONFIG{'QuoteChar'}/g;
				$body = &parsePrefix($CONFIG{'ReplyAllBodyPrefix'}) .
					"\n\n$CONFIG{'QuoteChar'}$body";
			}
			else { $body = ""; };

			last;
		};
		/forward/ and do {
			$subject = "$CONFIG{'ForwardSubjectPrefix'}$HEADER{'subject'}";

			$body =~ s/\n/\n$CONFIG{'QuoteChar'}/g;
			$body = &parsePrefix($CONFIG{'ForwardBodyPrefix'}) .
				"\n\n$CONFIG{'QuoteChar'}$body";

			last;
		};
		/redirect/ and do {
			$subject = "$CONFIG{'RedirectSubjectPrefix'}$HEADER{'subject'}";

			$body = &parsePrefix($CONFIG{'RedirectBodyPrefix'});
			$redirect = "true";

			$replyto = "$CONFIG{'RealEmail'}, " .
				(&parseEmailaddress($HEADER{'reply-to'} or $HEADER{'from'}))[1];

			last;
		};
	}

	&compose;
}


# Parse prefix for replies --------------------------------------------------

sub parsePrefix {

	my ($string) = shift;
	my ($temp);

	$temp = $HEADER{'date'};
	$temp =~ s/\s*\d+\:.*//;
	$temp =~ s/^\s*//;
	$temp = &translateDate($temp);

	$string =~ s/\\d/$temp/;
	$string =~ s/\\f/$HEADER{'from'}/;
	$string =~ s/\\s/$HEADER{'subject'}/;

	return $string;
}


# Send message --------------------------------------------------------------

sub sendMail {

	&loadModule('network.cgi');

	$msgsize = length($FORM{'body'}) + 600;		# 600 bytes for the headers & misc. stuff
	$parts = 0;

# Get the message to be redirected if necessary
	if ($FORM{'redirect'}) {
		&ConnectPOP3;
		eval $timeoutOn;

		print S "RETR $FORM{'msg'}$crlf";
		$_ = <S>;
		/^\+OK/ or &error('ErrorRelogin', 3000);

		$out = 1;
		while (-e "$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out") { $out++; }

		open(FILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out");
		print FILE "Content-Type: message/rfc822$crlf$crlf";

		for (;;) {
			eval $timeoutOn;
			$_ = <S> or last;
			/^\.\s*$/ and last;

			print FILE $_;
		}
		close(FILE);

		&DisconnectPOP3;
	}

# Show the next page if confirm not used
#	if (!$FORM{'confirm'}) {
		$CONFIG{'AlwaysConfirm'} = 0;

		if ($FORM{'msg'}) { &read; }
		else { &inbox; }

		&flush;
#		&forkProcess('', 1);
#	}

# Multipart message?
	$multipart = $FORM{'html'} ? 1 : 0;
	$multipart = 1 if (-e "$CONFIG{'TempPath'}$FORM{'u'}\.out\.1");
	$multipart = 1 if ($FORM{'vcard'});

# Create boundary for multipart-messages
	if ($multipart) {
		$t = time;
		$boundary = "=-=jUsT.aNoThEr.mImE.bOuNdArY=-=${t}$$=-=";
	}

# Parse nicknames
	$to = &parseNicknames(&parseNicknames($FORM{'to'}));
	$cc = &parseNicknames(&parseNicknames($FORM{'cc'}));
	$bcc = &parseNicknames(&parseNicknames($FORM{'bcc'}));
	$replyto = &parseNicknames(&parseNicknames($FORM{'replyto'}));

# Get date
	$date = $FORM{'date'} =~ /,/ ? $FORM{'date'} : &getDate;

# Print message to a temporary file
	$filename = &getRandomFilename('SMTP');

	open(FILE, ">$CONFIG{'SMTPPath'}$filename");
	binmode FILE if $WinNT;

# Print header
	print FILE
		"To: $to$crlf",
		"From: $FORM{'from'}$crlf",
		"Subject: $FORM{'subject'}$crlf",
		($replyto and "Reply-To: $replyto$crlf"),
		($cc and "CC: $cc$crlf"), 
		($bcc and "BCC: $bcc$crlf"), 
		"Date: $date$crlf";

	if ($FORM{'newsgroups'}) {
		print FILE "Newsgroups: $FORM{'newsgroups'}$crlf";
	}

	print FILE 
		"X-Sender: $CONFIG{'Login'}\@$CONFIG{'Server'}$crlf",
		"X-Originating-Host: $CONFIG{'RemoteHost'} [$ENV{'REMOTE_ADDR'}]; ", &getDate, $crlf,
		"X-Mailer: Mailreader.com $CONFIG{'SoftwareVersion'}$crlf",
		"X-Browser: $ENV{'HTTP_USER_AGENT'}, JavaScript: " , ($CONFIG{'JavaScript'} > 0 ? 'On' : 'Off') , "$crlf",
		"Message-ID: <jUsT.aNoTheR.mEsSaGe.iD.", time, $$, "\@$CONFIG{'ServerName'}>$crlf",
		"MIME-Version: 1.0$crlf";

	for ($FORM{'priority'}) {
		/1/ and do { print FILE "X-Priority: 1 (Highest)$crlf"; last; };
		/2/ and do { print FILE "X-Priority: 2 (High)$crlf"; last; };
		/4/ and do { print FILE "X-Priority: 4 (Low)$crlf"; last; };
		/5/ and do { print FILE "X-Priority: 5 (Lowest)$crlf"; last; };
	}

# Delivery notes?
	if ($FORM{'deliverynotes'}) {
		print FILE "Disposition-Notification-To: $CONFIG{'RealEmail'}$crlf",		# Rfc2298
			"Return-Receipt-To: $CONFIG{'RealEmail'}$crlf";							# MS Outlook way of doing it
	}

# Print correct main Content-Type
	if ($multipart) {
		print FILE "Content-Type: multipart/mixed;${crlf}        boundary=\"$boundary\"$crlf$crlf",
			"This is a multi-part message in MIME format.\n\n",
			"--$boundary$crlf";
	}

	if ($FORM{'html'}) { print FILE "Content-Type: text/html; charset=$CONFIG{'CharSet'}$crlf"; }
	else { print FILE "Content-Type: text/plain; charset=$CONFIG{'CharSet'}$crlf"; };
     
# Print the body
	$FORM{'body'} =~ s/.{74,}/&wordWrap($&, 65)/ge;
	print FILE "Content-Transfer-Encoding: 8bit$crlf$crlf$FORM{'body'}\n\n";

# Print vCard
	if ($FORM{'vcard'}) {
		print FILE "--$boundary${crlf}Content-Type: text/x-vcard$crlf",
			"Content-Transfer-Encoding: 8bit$crlf",
			"Content-Disposition: attachment$crlf$crlf$CONFIG{'VCard'}\n\n";
	}

	$CONFIG{'AttachVCard'} = ''; #$FORM{'vcard'} ? 1 : '';		# !!TEMPORARY REMOVAL!!

# Print rest of the parts
	if ($multipart) {
		for ($out = 1;;$out++) {
			open(ATCH, "<$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out") or last;

			$msgsize += -s "$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out";
			$parts++;

			$header = "";
			for (;;) {
				$_ = <ATCH>;
				/^\s*$/ and last;
				$header .= $_;
			}

			if ($CONFIG{'MultipleAttachments'} and $CONFIG{'JavaScript'} > 0 and
				$header =~ /filename=\"(.*?)\"/) {

				$FORM{'attachment'} =~ /$1/i or do {
					close(ATCH);
					next;
				}
			}

			print FILE "--$boundary$crlf$header\n";
			while (<ATCH>) { print FILE $_; }
			close(ATCH);
		};
	}

# Add a little advertisement to every outgoing email ;-D
	if (!$CONFIG{'NoMessageAdvertisement'} and !$FORM{'redirect'}) {

		print FILE "--$boundary${crlf}Content-Type: text/plain$crlf$crlf" if $multipart;
		print FILE "\n\n", $CONFIG{'MessageAdvertisement'}, "\n\n";
	}

# Close and send message
	print FILE "--$boundary--$crlf" if $multipart;
	close FILE;	

#	if ($FORM{'confirm'}) {
#		$CONFIG{'AlwaysConfirm'} = 1;

#		&confirmSendTop;
#		&flush;

#		&mailFile("$CONFIG{'SMTPPath'}$filename", $FORM{'deliverynotes'}, 1);

#		&confirmSendBottom;
#	}
#	else {
		&forkProcess('&mailFile("$CONFIG{\'SMTPPath\'}$filename", $FORM{\'deliverynotes\'});');
#	}

# Delete attachemts
	$out = 0;
	do { $out++; }
	while ( unlink "$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out" );

# Save log
	$logstring = "sent,1,$msgsize,$parts," .
		($FORM{'html'} ? "1," : "0,") .
		($FORM{'vcard'} ? "1," : "0,") .
		($FORM{'confirm'} ? "1," : "0,") .
		($FORM{'newsgroups'} ? "1" : "0");

	&saveString("$CONFIG{'LogPath'}main.log", "$logstring\n");
}


# Confirm sending of a message ----------------------------------------------

sub confirmSendTop {

	&httpHeaders;
	&advertisement;

	$_ = &getTemplate('confirm.html');
	($htmlhead, $htmlfoot) = split(/<!--begin-->/);

# Generate buttons
	&btnStart;

	&btnAdd('do=logout', 	'Logout');
	&btnBreak;

	&btnAdd($FORM{'msg'} ? "do=read&msg=$FORM{'msg'}" : 'do=inbox', 'OK');
	&btnBreak;

	&btnAdd('do=compose', 	'Compose');
	&btnAdd('do=showdraft',	'ShowDraft') if $CONFIG{'Draft'};
	&btnBreak;

	&btnAdd('do=inbox',		'Inbox');
	&btnEnd;

# Print page
	print "Content-Type: text/html$crlf$crlf$htmlhead\n",
	 	($CONFIG{'ButtonRowLocation'} =~ /(both|top)/ and "$buttonrow\n<P>\n"),
		"$CONFIG{'BigTextStart'}$CONFIG{'TextConfirmInfo'}$CONFIG{'BigTextEnd'}\n",
		"<STRONG><FONT COLOR=\"$CONFIG{'AltTextColor'}\"><P>\n";
}

sub confirmSendBottom {

# Print bottom buttons + stuff
	&btnFixBottom;

	print "</FONT></STRONG><P>\n",
		($CONFIG{'ButtonRowLocation'} =~ /(both|bottom)/ and "$buttonrow\n<P>\n"), 
		"$htmlfoot\n";
}


# Parse nicknames from a string ---------------------------------------------

sub parseNicknames {

	my ($string) = @_;

	$parsed = "";

	if (!$addressesParsed) {
		@nicknames = split(/\n/, $CONFIG{'AddressBook'});
		foreach $_ (@nicknames) {

			($nick, $addresses) = split(/\:/);
			$nick =~ s/^\s*//;
			$nick =~ s/\s*$//;
			$addresses =~ s/^\s*//;
			$addresses =~ s/\s*$//;

			$NICK{$nick} = $addresses if $nick;
		}

		$addressesParsed = 1;
	}

	@recipients = split(/\,/, $string);
	foreach $_ (@recipients) {

		s/^\s*//;
		s/\s*$//;
		
		if (/@/) {
			$parsed .= "$_, ";
			next;
		}

		if ($NICK{$_}) { $parsed .= "$NICK{$_}, "; }
		else { $parsed .= "$_, "; }
	}

	$parsed =~ s/\,\ $//;

	return $parsed;
}


1;
