Do not edit this file, it is generated automatically by apidocs.perl
from Imager's source files.

Each function description has a comment listing the source file and
line number where you can find the documentation.

=head1 NAME

Imager::APIRef - Imager's C API.

=head1 SYNOPSIS

  i_color color;
  color.rgba.red = 255; color.rgba.green = 0; color.rgba.blue = 255;
  i_fill_t *fill = i_new_fill_...(...);


  # Drawing
  i_arc(im, 50, 50, 20, 45, 135, &color);
  i_arc_aa(im, 50, 50, 35, 90, 135, &color);
  i_arc_aa_cfill(im, 50, 50, 35, 90, 135, fill);
  i_arc_cfill(im, 50, 50, 35, 90, 135, fill);
  i_box(im, 0, 0, im->xsize-1, im->ysize-1, &color).
  i_box_cfill(im, 0, 0, im->xsize-1, im->ysize-1, fill);
  i_box_filled(im, 0, 0, im->xsize-1, im->ysize-1, &color);
  i_circle_aa(im, 50, 50, 45, &color);
  i_flood_cfill(im, 50, 50, fill);
  i_flood_fill(im, 50, 50, &color);

  # Error handling

  # Fills
  fill = i_new_fill_fount(0, 0, 100, 100, i_ft_linear, i_ft_linear, 
                          i_fr_triangle, 0, i_fts_grid, 9, 1, segs);

  # Image

  # Image creation

  # Image quantization

  # Paletted images

  # Tags

   i_fill_destroy(fill);

=head1 DESCRIPTION

=head2 Drawing

=over

=item i_arc(im, x, y, rad, d1, d2, color)


Fills an arc centered at (x,y) with radius I<rad> covering the range
of angles in degrees from d1 to d2, with the color.


=for comment
From: Line 205 in draw.c

=item i_arc_aa(im, x, y, rad, d1, d2, color)


Antialias fills an arc centered at (x,y) with radius I<rad> covering
the range of angles in degrees from d1 to d2, with the color.


=for comment
From: Line 330 in draw.c

=item i_arc_aa_cfill(im, x, y, rad, d1, d2, fill)


Antialias fills an arc centered at (x,y) with radius I<rad> covering
the range of angles in degrees from d1 to d2, with the fill object.


=for comment
From: Line 356 in draw.c

=item i_arc_cfill(im, x, y, rad, d1, d2, fill)


Fills an arc centered at (x,y) with radius I<rad> covering the range
of angles in degrees from d1 to d2, with the fill object.


=for comment
From: Line 230 in draw.c

=item i_box(im, x1, y1, x2, y2, color)


Outlines the box from (x1,y1) to (x2,y2) inclusive with I<color>.


=for comment
From: Line 516 in draw.c

=item i_box_cfill(im, x1, y1, x2, y2, fill)


Fills the box from (x1,y1) to (x2,y2) inclusive with fill.


=for comment
From: Line 559 in draw.c

=item i_box_filled(im, x1, y1, x2, y2, color)


Fills the box from (x1,y1) to (x2,y2) inclusive with color.


=for comment
From: Line 541 in draw.c

=item i_circle_aa(im, x, y, rad, color)


Antialias fills a circle centered at (x,y) for radius I<rad> with
color.


=for comment
From: Line 462 in draw.c

=item i_flood_cfill(im, seedx, seedy, fill)


Flood fills the 4-connected region starting from the point (seedx,
seedy) with I<fill>.

Returns false if (seedx, seedy) are outside the image.


=for comment
From: Line 1317 in draw.c

=item i_flood_fill(im, seedx, seedy, color)


Flood fills the 4-connected region starting from the point (seedx,
seedy) with I<color>.

Returns false if (seedx, seedy) are outside the image.


=for comment
From: Line 1280 in draw.c

=item i_glin(im, l, r, y, colors)


Retrieves (r-l) pixels starting from (l,y) into I<colors>.

Returns the number of pixels retrieved.


=for comment
From: Line 202 in imext.c

=item i_glinf(im, l, r, y, colors)


Retrieves (r-l) pixels starting from (l,y) into I<colors> as floating
point colors.

Returns the number of pixels retrieved.


=for comment
From: Line 237 in imext.c

=item i_gpal(im, x, r, y, indexes)


Reads palette indexes for the horizontal line (x, y) to (r-1, y) into
indexes.

Returns the number of indexes read.

Always returns 0 for direct color images.


=for comment
From: Line 301 in imext.c

=item i_gpix(im, x, y, color)


Retrieves the I<color> of the pixel (x,y).

Returns 0 if the pixel was retrieved, or -1 if not.


=for comment
From: Line 130 in imext.c

=item i_gpixf(im, x, y, fcolor)


Retrieves the color of the pixel (x,y) as a floating point color into
I<fcolor>.

Returns 0 if the pixel was retrieved, or -1 if not.


=for comment
From: Line 166 in imext.c

=item i_gsamp(im, l, r, y, samp, chans, chan_count)


Reads sample values from im for the horizontal line (l, y) to (r-1,y)
for the channels specified by chans, an array of int with chan_count
elements.

If chans is NULL then the first chan_count channels are retrieved for
each pixel.

Returns the number of samples read (which should be (r-l) *
chan_count)


=for comment
From: Line 255 in imext.c

=item i_gsampf(im, l, r, y, samp, chans, chan_count)


Reads floating point sample values from im for the horizontal line (l,
y) to (r-1,y) for the channels specified by chans, an array of int
with chan_count elements.

If chans is NULL then the first chan_count channels are retrieved for
each pixel.

Returns the number of samples read (which should be (r-l) *
chan_count)


=for comment
From: Line 278 in imext.c

=item i_line(im, x1, y1, x2, y2, val, endp)


Draw a line to image using bresenhams linedrawing algorithm

   im   - image to draw to
   x1   - starting x coordinate
   y1   - starting x coordinate
   x2   - starting x coordinate
   y2   - starting x coordinate
   val  - color to write to image
   endp - endpoint flag (boolean)


=for comment
From: Line 630 in draw.c

=item i_line_aa(im, x1, x2, y1, y2, color, endp)


Antialias draws a line from (x1,y1) to (x2, y2) in color.

The point (x2, y2) is drawn only if endp is set.


=for comment
From: Line 834 in draw.c

=item i_plin(im, l, r, y, colors)


Sets (r-l) pixels starting from (l,y) using (r-l) values from
I<colors>.

Returns the number of pixels set.


=for comment
From: Line 184 in imext.c

=item i_plinf(im, l, r, fcolors)


Sets (r-l) pixels starting from (l,y) using (r-l) floating point
colors from I<colors>.

Returns the number of pixels set.


=for comment
From: Line 219 in imext.c

=item i_ppal(im, x, r, y, indexes)


Writes palette indexes for the horizontal line (x, y) to (r-1, y) from
indexes.

Returns the number of indexes written.

Always returns 0 for direct color images.


=for comment
From: Line 320 in imext.c

=item i_ppix(im, x, y, color)


Sets the pixel at (x,y) to I<color>.

Returns 0 if the pixel was drawn, or -1 if not.

Does no alpha blending, just copies the channels from the supplied
color to the image.


=for comment
From: Line 110 in imext.c

=item i_ppixf(im, x, y, fcolor)


Sets the pixel at (x,y) to the floating point color I<fcolor>.

Returns 0 if the pixel was drawn, or -1 if not.

Does no alpha blending, just copies the channels from the supplied
color to the image.


=for comment
From: Line 147 in imext.c


=back

=head2 Error handling

=over

=item i_clear_error()


Clears the error stack.

Called by any imager function before doing any other processing.


=for comment
From: Line 185 in error.c

=item i_push_error(int code, char const *msg)


Called by an imager function to push an error message onto the stack.

No message is pushed if the stack is full (since this means someone
forgot to call i_clear_error(), or that a function that doesn't do
error handling is calling function that does.).


=for comment
From: Line 211 in error.c

=item i_push_errorf(int code, char const *fmt, ...)


A version of i_push_error() that does printf() like formating.


=for comment
From: Line 273 in error.c

=item i_push_errorvf(int code, char const *fmt, va_list ap)


Intended for use by higher level functions, takes a varargs pointer
and a format to produce the finally pushed error message.


=for comment
From: Line 249 in error.c


=back

=head2 Fills

=over

=item i_fill_destroy(fill)


Call to destroy any fill object.


=for comment
From: Line 196 in fills.c

=item i_new_fill_fount(xa, ya, xb, yb, type, repeat, combine, super_sample, ssample_param, count, segs)



Creates a new general fill which fills with a fountain fill.


=for comment
From: Line 1713 in filters.c

=item i_new_fill_hatch(fg, bg, combine, hatch, cust_hatch, dx, dy)


Creates a new hatched fill with the fg color used for the 1 bits in
the hatch and bg for the 0 bits.  If combine is non-zero alpha values
will be combined.

If cust_hatch is non-NULL it should be a pointer to 8 bytes of the
hash definition, with the high-bits to the left.

If cust_hatch is NULL then one of the standard hatches is used.

(dx, dy) are an offset into the hatch which can be used to unalign adjoining areas, or to align the origin of a hatch with the the side of a filled area.


=for comment
From: Line 427 in fills.c

=item i_new_fill_hatchf(fg, bg, combine, hatch, cust_hatch, dx, dy)


Creates a new hatched fill with the fg color used for the 1 bits in
the hatch and bg for the 0 bits.  If combine is non-zero alpha values
will be combined.

If cust_hatch is non-NULL it should be a pointer to 8 bytes of the
hash definition, with the high-bits to the left.

If cust_hatch is NULL then one of the standard hatches is used.

(dx, dy) are an offset into the hatch which can be used to unalign adjoining areas, or to align the origin of a hatch with the the side of a filled area.


=for comment
From: Line 452 in fills.c

=item i_new_fill_image(im, matrix, xoff, yoff, combine)


Create an image based fill.

matrix is an array of 9 doubles representing a transformation matrix.

xoff and yoff are the offset into the image to start filling from.


=for comment
From: Line 489 in fills.c

=item i_new_fill_solid(color, combine)


Create a solid fill based on an 8-bit color.

If combine is non-zero then alpha values will be combined.


=for comment
From: Line 244 in fills.c

=item i_new_fill_solidf(color, combine)


Create a solid fill based on a float color.

If combine is non-zero then alpha values will be combined.


=for comment
From: Line 213 in fills.c


=back

=head2 Image

=over

=item i_copy(src)


Creates a new image that is a copy of src.

Tags are not copied, only the image data.

Returns: i_img *


=for comment
From: Line 626 in image.c

=item i_copyto(dest, src, x1, y1, x2, y2, tx, ty)


Copies image data from the area (x1,y1)-[x2,y2] in the source image to
a rectangle the same size with it's top-left corner at (tx,ty) in the
destination image.

If x1 > x2 or y1 > y2 then the corresponding co-ordinates are swapped.


=for comment
From: Line 557 in image.c

=item i_copyto_trans(im, src, x1, y1, x2, y2, tx, ty, trans)


(x1,y1) (x2,y2) specifies the region to copy (in the source coordinates)
(tx,ty) specifies the upper left corner for the target image.
pass NULL in trans for non transparent i_colors.


=for comment
From: Line 515 in image.c

=item i_img_destroy(im)


Destroy image and free data via exorcise.

   im - Image pointer


=for comment
From: Line 424 in image.c

=item i_img_info(im, info)


Return image information

   im - Image pointer
   info - pointer to array to return data

info is an array of 4 integers with the following values:

 info[0] - width
 info[1] - height
 info[2] - channels
 info[3] - channel mask


=for comment
From: Line 443 in image.c

=item i_rubthru(im, src, tx, ty, src_minx, src_miny, src_maxx, src_maxy )


Takes the sub image I<src[src_minx, src_maxx)[src_miny, src_maxy)> and
overlays it at (I<tx>,I<ty>) on the image object.

The alpha channel of each pixel in I<src> is used to control how much
the existing colour in I<im> is replaced, if it is 255 then the colour
is completely replaced, if it is 0 then the original colour is left 
unmodified.


=for comment
From: Line 701 in image.c


=back

=head2 Image creation

=over

=item i_img_16_new(x, y, ch)


Create a new 16-bit/sample image.

Returns the image on success, or NULL on failure.


=for comment
From: Line 192 in img16.c

=item i_img_8_new(x, y, ch)


Creates a new image object I<x> pixels wide, and I<y> pixels high with
I<ch> channels.


=for comment
From: Line 257 in image.c

=item i_img_double_new(int x, int y, int ch)


Creates a new double per sample image.


=for comment
From: Line 82 in imgdouble.c

=item i_img_pal_new(x, y, channels, maxpal)


Creates a new paletted image of the supplied dimensions.

Returns a new image or NULL on failure.


=for comment
From: Line 136 in palimg.c

=item i_sametype(i_img *im, int xsize, int ysize)


Returns an image of the same type (sample size, channels, paletted/direct).

For paletted images the palette is copied from the source.


=for comment
From: Line 1107 in image.c

=item i_sametype_chans(i_img *im, int xsize, int ysize, int channels)


Returns an image of the same type (sample size).

For paletted images the equivalent direct type is returned.


=for comment
From: Line 1149 in image.c


=back

=head2 Image quantization

=over

=item i_quant_makemap(quant, imgs, count)


Analyzes the I<count> images in I<imgs> according to the rules in
I<quant> to build a color map (optimal or not depending on
quant->make_colors).


=for comment
From: Line 30 in quant.c

=item i_quant_translate(quant, img)


Quantize the image given the palette in quant.

On success returns a pointer to a memory block of img->xsize *
img->ysize i_palidx entries.

On failure returns NULL.

You should call myfree() on the returned block when you're done with
it.

This function will fail if the supplied palette contains no colors.


=for comment
From: Line 86 in quant.c

=item i_quant_transparent(quant, data, img, trans_index)


Dither the alpha channel on I<img> into the palette indexes in
I<data>.  Pixels to be transparent are replaced with I<trans_pixel>.

The method used depends on the tr_* members of quant.


=for comment
From: Line 1470 in quant.c


=back

=head2 Paletted images

=over

=item i_addcolors(im, colors, count)


Adds colors to the image's palette.

On success returns the index of the lowest color added.

On failure returns -1.

Always fails for direct color images.


=for comment
From: Line 339 in imext.c

=item i_colorcount(im)


Returns the number of colors in the image's palette.

Returns -1 for direct images.


=for comment
From: Line 385 in imext.c

=item i_findcolor(im, color, &entry)


Searches the images palette for the given color.

On success sets *I<entry> to the index of the color, and returns true.

On failure returns false.

Always fails on direct color images.


=for comment
From: Line 420 in imext.c

=item i_getcolors(im, index, colors, count)


Retrieves I<count> colors starting from I<index> in the image's
palette.

On success stores the colors into I<colors> and returns true.

On failure returns false.

Always fails for direct color images.

Fails if there are less than I<index>+I<count> colors in the image's
palette.


=for comment
From: Line 360 in imext.c

=item i_maxcolors(im)


Returns the maximum number of colors the palette can hold for the
image.

Returns -1 for direct color images.


=for comment
From: Line 402 in imext.c

=item i_setcolors(im, index, colors, count)


Sets I<count> colors starting from I<index> in the image's palette.

On sucess returns true.

On failure returns false.

The image must have at least I<index>+I<count> colors in it's palette
for this to succeed.

Always fails on direct color images.


=for comment
From: Line 440 in imext.c


=back

=head2 Tags

=over

=item i_tags_delbycode(tags, code)


Delete any tags with the given code.

Returns the number of tags deleted.


=for comment
From: Line 294 in tags.c

=item i_tags_delbyname(tags, name)


Delete any tags with the given name.

Returns the number of tags deleted.


=for comment
From: Line 264 in tags.c

=item i_tags_delete(tags, index)


Delete a tag by index.

Returns true on success.


=for comment
From: Line 235 in tags.c

=item i_tags_destroy(tags)


Destroys the given tags structure.  Called by i_img_destroy().


=for comment
From: Line 158 in tags.c

=item i_tags_find(tags, name, start, &entry)


Searchs for a tag of the given I<name> starting from index I<start>.

On success returns true and sets *I<entry>.

On failure returns false.


=for comment
From: Line 181 in tags.c

=item i_tags_findn(tags, code, start, &entry)


Searchs for a tag of the given I<code> starting from index I<start>.

On success returns true and sets *I<entry>.

On failure returns false.


=for comment
From: Line 208 in tags.c

=item i_tags_get_color(tags, name, code, &value)


Retrieve a tag specified by name or code as color.

On success sets the i_color *I<value> to the color and returns true.

On failure returns false.


=for comment
From: Line 505 in tags.c

=item i_tags_get_float(tags, name, code, value)


Retrieves a tag as a floating point value.  

If the tag has a string value then that is parsed as a floating point
number, otherwise the integer value of the tag is used.

On success sets *I<value> and returns true.

On failure returns false.


=for comment
From: Line 320 in tags.c

=item i_tags_get_int(tags, name, code, &value)


Retrieve a tag specified by name or code as an integer.

On success sets the i_color *I<value> to the color and returns true.

On failure returns false.


=for comment
From: Line 406 in tags.c

=item i_tags_get_string(tags, name, code, value, value_size)


Retrieves a tag by name or code as a string.

On success copies the string to value for a max of value_size and
returns true.

On failure returns false.

value_size must be at least large enough for a string representation
of an integer.

The copied value is always NUL terminated.


=for comment
From: Line 569 in tags.c

=item i_tags_new(i_img_tags *tags)


Initialize a tags structure.  Should not be used if the tags structure
has been previously used.

This should be called tags member of an i_img object on creation (in
i_img_*_new() functions).

To destroy the contents use i_tags_destroy()


=for comment
From: Line 61 in tags.c

=item i_tags_set(tags, name, data, size)


Sets the given tag to the string I<data>


=for comment
From: Line 617 in tags.c

=item i_tags_set_color(tags, name, code, &value)


Stores the given color as a tag with the given name and code.


=for comment
From: Line 545 in tags.c

=item i_tags_set_float(tags, name, code, value)


Equivalent to i_tags_set_float2(tags, name, code, value, 30).


=for comment
From: Line 359 in tags.c

=item i_tags_set_float2(tags, name, code, value, places)


Sets the tag with the given name and code to the given floating point
value.

Since tags are strings or ints, we convert the value to a string before
storage at the precision specified by C<places>.


=for comment
From: Line 374 in tags.c

=item i_tags_setn(tags, name, idata)


Sets the given tag to the integer I<idata>


=for comment
From: Line 634 in tags.c


=back


=head1 AUTHOR

Tony Cook <tony@imager.perl.org>

=head1 SEE ALSO

Imager, Imager::ExtUtils, Imager::Inline

=cut
