# $Id: prot-a-is-legal-fnc.awk,v 1.2 1999/05/24 09:34:30 ceder Exp $
# Copyright (C) 1991, 1993-1996, 1999  Lysator Academic Computer Association.
#
# This file is part of the LysKOM server.
# 
# LysKOM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by 
# the Free Software Foundation; either version 1, or (at your option) 
# any later version.
# 
# LysKOM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License
# along with LysKOM; see the file COPYING.  If not, write to
# Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
# or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
# MA 02139, USA.
#
# Please mail bug reports to bug-lyskom@lysator.liu.se. 
#
# $Id: prot-a-is-legal-fnc.awk,v 1.2 1999/05/24 09:34:30 ceder Exp $

BEGIN {
    printf("/* Don't edit this file - it is generated automatically");
    printf(" from\n   prot-a-is-legal-fnc.awk and fncdef.txt */\n");
    printf("\n");
    printf("\tswitch(fnc) {\n");
    cnt = 0;
}
$1 == "#ifdef" {
    printf("#ifdef %s\n", $2);
    next;
}
$1 == "#endif" {
    printf("#endif\n");
    next;
}
$1 != "#" && $1 != "" {
  printf("\tcase call_fnc_%-20s: return %d;\n", $3, cnt++);
}
END {
    printf("\tdefault:\n");
    printf("\t\treturn -1;\n");
    printf("\t}\n");
}

