/***************************************************************************
                          frame.c  -  description
                             -------------------
    begin                : Fri Sep 7 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "config.h"
#include "levels.h"
#include "bricks.h"
#include "extras.h"
#include "frame.h"
#ifdef SOUND
#include "audio.h"
#endif

extern Sdl sdl;
extern SDL_Surface *offscreen;
extern SDL_Surface *bkgnd; /* background + frame */
/* parts of the frame: left, top, right */
extern SDL_Surface *frame_left, *frame_top, *frame_right;
extern SDL_Surface *frame; /* assembled frame */
extern SDL_Surface *frame_shadow; /* shadow of frame */
extern SDL_Surface *lamps; /* life lamps */
float score = 0; /* current score */
int dest_score; /* final score */
int score_x_offset = 54; /* display score at this position (right align)*/
int score_x, score_y = BRICK_HEIGHT / 2 - 2; /* center position where to write score */
int new_life_y; /* if new life lamp is drawn do this at this y position */
int name_x = 404, name_y = BRICK_HEIGHT / 2 - 2; /* offset (right side of screen) */
extern Font *frame_font;
extern int shadow_size;
extern Config config;
int info_x, info_y; /* absolute position is info_y + info_offset */
int info_offsets[EX_NUMBER]; /* offset at which extra info is displayed */
extern int active[EX_NUMBER];
extern int extra_time[EX_NUMBER];
extern SDL_Surface *extra_pic;
#ifdef SOUND
extern Sound_Chunk *wav_life_up, *wav_life_down;
#endif

/*
====================================================================
Locals
====================================================================
*/

/*
====================================================================
Publics
====================================================================
*/

/*
====================================================================
Create frame by loading and assembling all graphics and loading
additional graphics.
====================================================================
*/
void frame_create()
{
    /* setup position of extra info */
    info_x = sdl.screen->w - BRICK_WIDTH;
    info_y = 48;
	info_offsets[EX_GOLDSHOWER] = 30;
	info_offsets[EX_SLIME] = 60;
	info_offsets[EX_METAL] = 90;
	info_offsets[EX_WEAK_BALL] = 90;
	info_offsets[EX_EXPL_BALL] = 90;
	info_offsets[EX_WALL] = 120;
	info_offsets[EX_WEAPON] = 150;
	info_offsets[EX_FAST] = 180;
	info_offsets[EX_SLOW] = 180;
	info_offsets[EX_CHAOS] = 210;
	info_offsets[EX_GHOST_PADDLE] = 240;
/*    
	info_offsets[EX_SPIN_LEFT] = 270;
	info_offsets[EX_SPIN_RIGHT] = 270;
*/    
	info_offsets[EX_BONUS_MAGNET] = 270;
	info_offsets[EX_MALUS_MAGNET] = 270;
}

/*
====================================================================
Free all resources created by frame_create()
====================================================================
*/
void frame_delete()
{
}
/*
====================================================================
Draw frame to offscreen and to bkgnd as frame won't change while
playing.
====================================================================
*/
void frame_draw()
{
    /* offscreen */
    /* add shadow */
    if ( config.shadow ) {
        DEST( offscreen, shadow_size, shadow_size, offscreen->w, offscreen->h );
        SOURCE( frame_shadow, 0, 0 );
        alpha_blit_surf( SHADOW_ALPHA );
    }
    FULL_DEST( offscreen );
    FULL_SOURCE( frame );
    blit_surf();
    /* bkgnd */
    /* add shadow */
    if ( config.shadow ) {
        DEST( bkgnd, shadow_size, shadow_size, offscreen->w, offscreen->h );
        SOURCE( frame_shadow, 0, 0 );
        alpha_blit_surf( SHADOW_ALPHA );
    }
    FULL_DEST( bkgnd );
    FULL_SOURCE( frame );
    blit_surf();
}
/*
====================================================================
Add life lamps at left side of frame in offscreen
====================================================================
*/
void frame_draw_lives( int lives, int max_lives )
{
    int i;
    /* substract one life to have the same result like in old LBreakout */
    /* at maximum ten lamps may be displayed */
    for ( i = 0; i < 10; i++ ) {
        DEST( offscreen, 0, ( MAP_HEIGHT - i - 1 ) * BRICK_HEIGHT, BRICK_WIDTH, BRICK_HEIGHT );
        if ( i < lives - 1 )
            SOURCE( lamps, 0, BRICK_HEIGHT )
        else
            if ( i < max_lives - 1 )
                SOURCE( lamps, 0, 0 )
            else
                SOURCE( lamps, 0, BRICK_HEIGHT * 2 )
        blit_surf();
    }
    /* get position of next lamp */
    new_life_y = sdl.screen->h - lives * BRICK_HEIGHT;
}
/*
====================================================================
Add one new life at offscreen and screen (as this will happen in
game )
====================================================================
*/
void frame_add_life()
{
	if ( !active[EX_DARKNESS] ) {
    	DEST( sdl.screen, 0, new_life_y, BRICK_WIDTH, BRICK_HEIGHT );
    	SOURCE( lamps, 0, BRICK_HEIGHT );
    	blit_surf();
    	add_refresh_rect( 0, new_life_y, BRICK_WIDTH, BRICK_HEIGHT );
	}		
    new_life_y -= BRICK_HEIGHT;
#ifdef SOUND
    sound_play( wav_life_up );
#endif
}
/*
====================================================================
Switch of a life lamp
====================================================================
*/
void frame_remove_life()
{
    new_life_y += BRICK_HEIGHT;
    if ( new_life_y >= sdl.screen->h ) return;
	if ( !active[EX_DARKNESS] ) {
	    DEST( sdl.screen, 0, new_life_y, BRICK_WIDTH, BRICK_HEIGHT );
	    SOURCE( lamps, 0, 0 );
	    blit_surf();
	    add_refresh_rect( 0, new_life_y, BRICK_WIDTH, BRICK_HEIGHT );
	}		
#ifdef SOUND
    sound_play( wav_life_down );
#endif
}
/*
====================================================================
Draw players name.
====================================================================
*/
void frame_draw_player_name( char *name )
{
    frame_font->align = ALIGN_X_LEFT | ALIGN_Y_CENTER;
    write_text( frame_font, offscreen, name_x, name_y, name, OPAQUE );
    frame_font->last_width = frame_font->last_height = 0;
}
/*
====================================================================
Set destination score to this value (update in sdl.screen)
====================================================================
*/
void frame_score_set( int dest )
{
    dest_score = dest;
}
/*
====================================================================
Set destination score and current score
to this value (update in sdl.screen)
====================================================================
*/
void frame_score_reset( int dest )
{
    score = dest;
    dest_score = dest;
}
/*
====================================================================
Update score in sdl.screen
====================================================================
*/
void frame_score_hide()
{
    DEST( sdl.screen, frame_font->last_x, frame_font->last_y, frame_font->last_width, frame_font->last_height );
    SOURCE( frame, frame_font->last_x, frame_font->last_y );
    blit_surf();
    add_refresh_rect( frame_font->last_x, frame_font->last_y, frame_font->last_width, frame_font->last_height );
}
void frame_score_show()
{
    char    str[12];
    /* get score string */
    sprintf(str, "%i", (int)score);
    score_x = sdl.screen->w - score_x_offset;
    frame_font->align = ALIGN_X_RIGHT | ALIGN_Y_CENTER;
    frame_font->save_last = 1;
    write_text( frame_font, sdl.screen, score_x, score_y, str, OPAQUE );
    add_refresh_rect( frame_font->last_x, frame_font->last_y, frame_font->last_width, frame_font->last_height );
}
void frame_score_update( int ms )
{
    float change;
    if ( (int)score == dest_score ) return;
    /* change relative as for big scores we must count faster */
    change = ( dest_score - score ) / 2000;
    if ( change > 0 && change < 0.6 ) change = 0.6;
    if ( change < 0 && change > -0.6 ) change = -0.6;
    score += change * ms;
    if ( change > 0 && score > dest_score ) score = dest_score;
    if ( change < 0 && score < dest_score ) score = dest_score;
}
/*
====================================================================
Display extra information on right side of screen.
====================================================================
*/
void frame_info_hide()
{
    int i;
    for ( i = 0; i < EX_NUMBER; i++ )
        if ( info_offsets[i] > 0 && active[i] ) {
            DEST( sdl.screen, info_x, info_y + info_offsets[i], BRICK_WIDTH, BRICK_HEIGHT );
            SOURCE( offscreen, info_x, info_y + info_offsets[i] );
            blit_surf();
            add_refresh_rect( info_x, info_y + info_offsets[i], BRICK_WIDTH, BRICK_HEIGHT );
        }
}
void frame_info_show()
{
    char str[12];
    int i;
    frame_font->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;
    for ( i = 0; i < EX_NUMBER; i++ ) {
        if ( info_offsets[i] > 0 && active[i] ) {
            if ( i == EX_WALL && extra_time[i] <= 0 ) continue;
            /* picture */
            DEST( sdl.screen, info_x, info_y + info_offsets[i], BRICK_WIDTH, BRICK_HEIGHT );
            fill_surf( 0x0 );
            SOURCE( extra_pic, i * BRICK_WIDTH, 0 );
            alpha_blit_surf( 64 );
            /* remaining extra_time */
            sprintf(str, "%i", (extra_time[i] / 1000) + 1);
            /* write text without saving last rect as this is used for score update */
            frame_font->save_last = 0;
            write_text( frame_font, sdl.screen,
                        info_x + ( BRICK_WIDTH >> 1 ), info_y + info_offsets[i] + ( BRICK_HEIGHT >> 1 ),
                        str, OPAQUE );
            frame_font->save_last = 1;
            /* refresh */
            add_refresh_rect( info_x, info_y + info_offsets[i], BRICK_WIDTH, BRICK_HEIGHT );
        }
	}
}
