// $Id: koalarm.cpp,v 1.2 2001/06/22 11:17:49 cschumac Exp $

#include <kdebug.h>
#include <kglobal.h>
#include <klocale.h>

#include "incidence.h"
//#include "koprefs.h"

#include "koalarm.h"

using namespace KCal;

KOAlarm::KOAlarm(Incidence *parent)
{
  mParent = parent;

  mAlarmReadOnly = false;

  mAudioAlarmFile = "";
  mProgramAlarmFile = "";
  mMailAlarmAddress = "";
  mAlarmText = "";

  mAlarmSnoozeTime = 5;
  mAlarmRepeatCount = 0;
  mAlarmEnabled = false;
}

KOAlarm::~KOAlarm()
{
}

void KOAlarm::setAudioFile(const QString &audioAlarmFile)
{
  if (mAlarmReadOnly) return;
  mAudioAlarmFile = audioAlarmFile;
  mParent->emitEventUpdated(mParent);
}

const QString &KOAlarm::audioFile() const
{
  return mAudioAlarmFile;
}

void KOAlarm::setProgramFile(const QString &programAlarmFile)
{
  if (mAlarmReadOnly) return;
  mProgramAlarmFile = programAlarmFile;
  mParent->emitEventUpdated(mParent);
}

const QString &KOAlarm::programFile() const
{
  return mProgramAlarmFile;
}

void KOAlarm::setMailAddress(const QString &mailAlarmAddress)
{
  if (mAlarmReadOnly) return;
  mMailAlarmAddress = mailAlarmAddress;
  mParent->emitEventUpdated(mParent);
}

const QString &KOAlarm::mailAddress() const
{
  return mMailAlarmAddress;
}

void KOAlarm::setMailSubject(const QString &mailAlarmSubject)
{
  if (mAlarmReadOnly) return;
  mMailAlarmSubject = mailAlarmSubject;
  mParent->emitEventUpdated(mParent);
}

const QString &KOAlarm::mailSubject() const
{
  return mMailAlarmSubject;
}

void KOAlarm::setText(const QString &alarmText)
{
  if (mAlarmReadOnly) return;
  mAlarmText = alarmText;
  mParent->emitEventUpdated(mParent);
}

const QString &KOAlarm::text() const
{
  return mAlarmText;
}

void KOAlarm::setTime(const QDateTime &alarmTime)
{
  if (mAlarmReadOnly) return;
  mAlarmTime = alarmTime;
  mParent->emitEventUpdated(mParent);
}

const QDateTime &KOAlarm::time() const
{
  return mAlarmTime;
}

void KOAlarm::setSnoozeTime(int alarmSnoozeTime)
{
  if (mAlarmReadOnly) return;
  mAlarmSnoozeTime = alarmSnoozeTime;
  mParent->emitEventUpdated(mParent);
}

int KOAlarm::snoozeTime() const
{
  return mAlarmSnoozeTime;
}

void KOAlarm::setRepeatCount(int alarmRepeatCount)
{
  if (mAlarmReadOnly) return;
  mAlarmRepeatCount = alarmRepeatCount;
  mParent->emitEventUpdated(mParent);
}

int KOAlarm::repeatCount() const
{
  return mAlarmRepeatCount;
}

void KOAlarm::toggleAlarm()
{
  if (mAlarmReadOnly) return;
  if (mAlarmEnabled) {
    mAlarmEnabled = false;
  } else {
    mAlarmEnabled = true;
//    QString alarmStr(QString::number(KOPrefs::instance()->mAlarmTime));
// TODO: Fix default alarm time
    QString alarmStr("10");
    int pos = alarmStr.find(' ');
    if (pos >= 0)
      alarmStr.truncate(pos);
    mAlarmTime = mAlarmStart.addSecs(-60 * alarmStr.toUInt());
  }
  mParent->emitEventUpdated(mParent);
}

void KOAlarm::setEnabled(bool enable)
{
  if (mAlarmReadOnly) return;
  mAlarmEnabled = enable;
  mParent->emitEventUpdated(mParent);
}

bool KOAlarm::enabled() const
{
  return mAlarmEnabled;
}

