/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpushbutton.h>

#include <klocale.h>

#include "kmtmoduleview.h"


//***********************************
//
// Implementation of class ModuleView
//
//***********************************
ModuleView::ModuleView(QWidget* parent, const char* name)
  : QWidget(parent, name)
{
  topLayout = new QVBoxLayout(this, 12, 6);

  // Heading
  headLabel = new QLabel(this);
  topLayout->addWidget(headLabel);

  // Instead of a QSpacerItem...
  topLayout->addStretch(1);

  // The buttons
  QHBoxLayout* buttonLayout = new QHBoxLayout(0, 0, 6);
  buttonLayout->addItem(new QSpacerItem(1, 0, QSizePolicy::Expanding, QSizePolicy::Minimum));
  // Button "Calculate"
  calcButton = new QPushButton(i18n("&Calculate"), this);
  calcButton->setAutoDefault(true);
  calcButton->setDefault(true);
  buttonLayout->addWidget(calcButton);
  // Button "Clear"
  clearButton = new QPushButton(i18n("C&lear Input"), this);
  buttonLayout->addWidget(clearButton);
  topLayout->addLayout(buttonLayout);

  connect(calcButton, SIGNAL(clicked( )), SLOT(slotCalculate( )));
  connect(clearButton, SIGNAL(clicked( )), SLOT(slotClearInput( )));
  connect(this, SIGNAL(signalInputPresent(bool)), calcButton, SLOT(setEnabled(bool)));
  connect(this, SIGNAL(signalReturnPressed( )), calcButton, SLOT(animateClick( )));
}

void ModuleView::addMainLayout(QLayout* layout)
{
  topLayout->insertLayout(1, layout);
}

void ModuleView::setHeading(const QString& heading)
{
  headLabel->setText("<qt><h1>" + heading + "</h1></qt>");
}


//*****************************************
//
// Implementation of class SimpleModuleView
//
//*****************************************
SimpleModuleView::SimpleModuleView(QWidget* parent, const char* name)
  : ModuleView(parent, name)
{
  layout = new QHBoxLayout(0, 0, 6);
  layout->addStretch(1);

  // The main widget is later added here by setMainWidget( )

  layout->addStretch(1);
  addMainLayout(layout);
}

void SimpleModuleView::setMainWidget(QWidget* w)
{
  layout->insertWidget(1, w);
}


//****************************************
//
// Implementation of class ImageModuleView
//
//****************************************
ImageModuleView::ImageModuleView(QWidget* parent, const char* name)
  : ModuleView(parent, name)
{
  layout = new QHBoxLayout(0, 0, 6);

  // Pixmap
  pixLabel = new QLabel(this);
  pixLabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
  layout->addWidget(pixLabel);

  // Vertical line
  QFrame* frame = new QFrame(this);
  frame->setFrameStyle(QFrame::VLine | QFrame::Sunken);
  layout->addWidget(frame);

  // The main widget is later added here by setMainWidget( )

  addMainLayout(layout);
}

void ImageModuleView::setMainWidget(QWidget* w)
{
  layout->insertWidget(2, w);
}

void ImageModuleView::setPixmap(QPixmap p)
{
  pixLabel->setPixmap(p);
}

#include "kmtmoduleview.moc"
