//////////////////////////////////////////////////////////////
//      $Id: findf.cpp,v 1.20 2001/07/28 08:14:05 mlaurent Exp $
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "pkgInterface.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "findf.h"
#include "options.h"
#include <klocale.h>
#include <qlineedit.h>
#include <qdragobject.h>

extern pkgInterface *kpinterface[];
extern Opts *opts;

FindF::FindF(QWidget *parent)
    : KDialogBase(parent, "find_file", false,
		i18n("Find File"),
		User1 | Close, User1, true,
		i18n("&Find"))
{
    QFrame *page = makeMainWidget();

    setFocusPolicy(QWidget::StrongFocus);

    QVBoxLayout* vtop = new QVBoxLayout( page, 20, 10, "vtop");

    QFrame *frame1 = new QGroupBox(i18n("Find File"), page, "frame1");
    vtop->addWidget(frame1,4);
    QVBoxLayout* vf = new QVBoxLayout( frame1, 12, 10, "vf");

    value = new QLineEdit( frame1, "value");
    connect(value,SIGNAL(textChanged ( const QString & )),this,SLOT(textChanged ( const QString & )));
    vf->addWidget(value,1);
    value->setFocus();


    tab = new KListView(frame1,"tab");
    connect(tab, SIGNAL(selectionChanged ( QListViewItem * )),
	    this, SLOT(search( QListViewItem * )));
    tab->addColumn(i18n("Type"),40);
    tab->addColumn(i18n("Package"),120);
    tab->addColumn(i18n("File Name"),300);
    tab->setAllColumnsShowFocus(TRUE);
    tab->setSorting(1);
    vf->addWidget(tab,4);

    connect(this, SIGNAL(user1Clicked()), this, SLOT(ok_slot()));
    connect(this, SIGNAL(closeClicked()), this, SLOT(done_slot()));
    enableButton(User1 , false);
    show();

    setAcceptDrops(true);
}

FindF::~FindF()
{
}

void FindF::textChanged ( const QString & text)
{
    enableButton(User1 , !text.isEmpty());
}

void FindF::ok_slot()
{
  doFind(value->text());
}

void FindF::doFind(const QString &str)
{
  QString t;
  int i, cnt = 0;

  tab->clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      QStringList filelist = kpinterface[i]->FindFile(str);

      if (filelist.count() > 0) {
	cnt++;

	for ( QStringList::Iterator it = filelist.begin(); it != filelist.end(); ++it ) {
	  t = kpinterface[i]->head;
	  if ((*it).find("diversion by") >= 0) {
	    new QListViewItem(tab, "", *it);
	  }

	  int t1 = (*it).find('\t');
	  QString s1 = (*it).left(t1);
	  QString s2 = (*it).right((*it).length()-t1);

	  new QListViewItem(tab, t, s1, s2);
	}
      }
    }
  }

  if (!cnt) {
    new QListViewItem(tab, "", i18n("--Nothing found--"));
  }
}

void FindF::done_slot()
{
  hide();
}

void FindF::resizeEvent(QResizeEvent *){
}

void FindF::search(QListViewItem *item)
{
  int p;
  QString s = item->text(1);
  kdDebug() << "searchF=" << s << "\n";

  p = s.find(',');
  if (p > 0) {
    s.truncate(p);
  }
 KPLVItem *k =  kpackage->management->search(s ,item->text(0));
 if (k)
   kpackage->management->changePack(k);
}

void FindF::dragEnterEvent(QDragEnterEvent* e)
{
  e->accept(QUriDrag::canDecode(e));
}

void FindF::dropEvent(QDropEvent *de) // something has been dropped
{
  QStrList list;
  QUriDrag::decode(de, list);
  QString url;

  const char *s = list.first();
  KURL *u = new KURL( s );

  if (!u->isMalformed() && (u->protocol() == "file"  )) {
    url = u->path();
    if (url.right(1) == "/")
      url.truncate(url.length()-1);
    value->setText(url);
    doFind(url);
  } else {
    KpMsgE(i18n("Incorrect URL type"),FALSE);
  }
}
#include "findf.moc"
