/**
 * IMP Popup JavaScript.
 *
 * Provides the javascript to open popup windows.
 * This file should be included via Horde::addScriptFile().
 *
 * $Horde: imp/js/src/popup.js,v 1.2.2.5 2008/05/20 16:33:02 slusarz Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Open a popup window.
 *
 * @param string $url      The URL to open in the popup window.
 * @param integer $width   The width of the popup window. (Default: 600 px)
 * @param integer $height  The height of the popup window. (Default: 500 px)
 * @param string $args     Any additional args to pass to the script.
 *                         (Default: no args)
 */
function popup_imp(url, width, height, args)
{
    var name = new Date().getTime(), params, q, win;

    height = Math.min(screen.height - 75, height || 500);
    width = Math.min(screen.width - 75, width || 600);

    params = $H(url.toQueryParams());
    q = url.indexOf('?');
    if (q != -1) {
        url = url.substring(0, q);
    }

    if (args) {
        params.update(args.toQueryParams());
    }
    params.set('uniq', name);

    win = window.open(url + '?' + params.toQueryString(), name, 'toolbar=no,location=no,status=yes,scrollbars=yes,resizable=yes,width=' + width + ',height=' + height + ',left=0,top=0');
    if (!win) {
        alert(IMP.text.popup_block);
    } else {
        if (Object.isUndefined(win.name)) {
            win.name = name;
        }
        if (Object.isUndefined(win.opener)) {
            win.opener = self;
        }
        win.focus();
    }
}
