/* ------------------------------------------------------------------------- */
/* i2c-algo-biths.h i2c driver algorithms for faster bit-shift adapters      */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-99 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/* ------------------------------------------------------------------------- */

/* With some changes from Kysti Mlkki <kmalkki@cc.hut.fi> and even
   Frodo Looijaard <frodol@dds.nl> */

/* $Id: i2c-algo-biths.h,v 1.8 2003/07/25 07:56:42 khali Exp $ */

#ifndef _LINUX_I2C_ALGO_BITHS_H
#define _LINUX_I2C_ALGO_BITHS_H

#if 1
#define _HS_ATTR_
#else
#define _HS_ATTR_ __attribute__ ((regparm (2)))
#endif

#ifdef _HW_NO_INLINE_
#define _HW_ATTR_ __attribute__ ((regparm (2)))
#else
#define _HW_ATTR_ inline 
#endif

/* --- Defines for bit-adapters ---------------------------------------	*/
/*
 * This struct contains the hw-dependent functions of bit-style adapters to 
 * manipulate the line states, and to init any hw-specific features. This is
 * only used if you have more than one hw-type of adapter running. 
 */
struct i2c_algo_biths_data {
	void *hw_data;		/* private data for lowlevel routines */
	int hw_state;
	void (*setscl)(void *hw_data, int hw_state) _HS_ATTR_ ;
	void (*setsda)(void *hw_data, int hw_state) _HS_ATTR_ ;
	int (*getscl) (void *hw_data) _HS_ATTR_ ;
	int (*getsda) (void *hw_data) _HS_ATTR_ ;

	void (*setstate)(struct i2c_algo_biths_data *adap) _HS_ATTR_ ;
	void (*set_timer)(struct i2c_algo_biths_data *adap) _HS_ATTR_ ;
	void (*run_timer)(struct i2c_algo_biths_data *adap) _HS_ATTR_ ;

	short ctrl;
	short errors;
	char shiftreg;

	/* local settings */
	unsigned long bclock;
	unsigned long xloops;	/* 1/4 clock-cycle time in x86 TSC ticks */
				/* i.e. bus clock is 250*0x10c6 / xloops kHz */

	int timeout;		/* in jiffies */
	char *name;		/* replicate i2c_adapter->name */
	char *dstr;		/* protocol debug string */
};

#define I2C_BIT_ADAP_MAX	16

#define _HS_SCL		0x0001
#define _HS_SDA		0x0002
#define _HS_SDA_FREE	0x0004	/* client has SDA control */
#define _HS_STD_MODE	0x0008  /* drop speed to 100kHz */
#define _HS_DBL_DT	0x0010	/* T_sclhi is twice longer */

#define _HS_NAK		0x0001
#define _HS_TIMEOUT	0x0002
#define _HS_SDA_ARB	0x0004
#define _HS_HW_FAIL	0x0008

int i2c_biths_add_bus(struct i2c_adapter *);
int i2c_biths_del_bus(struct i2c_adapter *);

#endif /* _LINUX_I2C_ALGO_BITHS_H */
