/* 
 *	HT Editor
 *	syntax.h
 *
 *	Copyright (C) 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SYNTAX_H__
#define __SYNTAX_H__

#include "common.h"
#include "htio.h"

struct text_pos {
	UINT line;
	UINT pofs;
};

typedef UINT lexer_state;
typedef UINT lexer_state_set;
typedef UINT lexer_token;

enum lexer_rule_string_type {
	LRST_EMPTY,
	LRST_STRING,
	LRST_REGEX,
	LRST_CHARSET,
	LRST_WHITESPACE,
	LRST_ANYCHAR
};

struct syntax_lexer_rule {
	lexer_state_set needstate;
	bool need_line_start;
	lexer_rule_string_type string_type;
	char *string;
	lexer_state state;
	lexer_token token;
};

/*
 *	CLASS ht_syntax_lexer
 */

class ht_syntax_lexer: public object {
public:
/* new */
	virtual	lexer_state getinitstate()=0;
	virtual	lexer_token geterrortoken()=0;
	virtual	lexer_token gettoken(char *buf, lexer_state *state, text_pos *p, UINT *len, bool start_of_line, bool only_state_changers)=0;
	virtual	vcp gettoken_color(lexer_token t)=0;
};

/*
 *	CLASS ht_lang_syntax_lexer
 */

class ht_lang_syntax_lexer: public ht_syntax_lexer {
protected:
	syntax_lexer_rule *lexer_rules;
	void **lexer_rules_precompiled;
	int lexer_rules_count;

/* new */
			void free_lexer_rules();
			void set_lexer_rules(syntax_lexer_rule *lr);
public:
			void init(syntax_lexer_rule *lexer_rules);
	virtual	void done();
/* overwritten */
	virtual	lexer_token gettoken(char *buf, lexer_state *state, text_pos *p, UINT *len, bool start_of_line, bool only_state_changers);
};

/*
 *	CLASS ht_c_syntax_lexer
 */

class ht_c_syntax_lexer: public ht_lang_syntax_lexer {
protected:
	char **c_reserved_sorted;
	UINT c_reserved_count;
public:
			void init();
	virtual	void done();
/* overwritten */
	virtual	lexer_state getinitstate();
	virtual	lexer_token geterrortoken();
	virtual	lexer_token gettoken(char *buf, lexer_state *state, text_pos *p, UINT *len, bool start_of_line, bool only_state_changers);
	virtual	vcp gettoken_color(lexer_token t);
};

char **create_sorted_stringtable(char **table);

#endif /* __SYNTAX_H__ */
