/* 
 *	HT Editor
 *	vxdserv.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "vxd.h"

vxd_service_desc vxd_vmm_services[] = {
		{ 0x0000,	"Get_VMM_Version" },
		{ 0x0001,	"Get_Cur_VM_Handle"	},
		{ 0x0002,	"Test_Cur_VM_Handle" },
		{ 0x0003,	"Get_Sys_VM_Handle"	},
		{ 0x0004,	"Test_Sys_VM_Handle" },
		{ 0x0005,	"Validate_VM_Handle" },
		{ 0x0006,	"Get_VMM_Reenter_Count" },
		{ 0x0007,	"Begin_Reentrant_Execution" },
		{ 0x0008,	"End_Reentrant_Execution" },
		{ 0x0009,	"Install_V86_Break_Point" },
		{ 0x000a,	"Remove_V86_Break_Point"	},
		{ 0x000b,	"Allocate_V86_Call_Back"	},
		{ 0x000c,	"Allocate_PM_Call_Back" },
		{ 0x000d,	"Call_When_VM_Returns" },
		{ 0x000e,	"Schedule_Global_Event" },
		{ 0x000f,	"Schedule_VM_Event"	},
		{ 0x0010,	"Call_Global_Event"	},
		{ 0x0011,	"Call_VM_Event" },
		{ 0x0012,	"Cancel_Global_Event" },
		{ 0x0013,	"Cancel_VM_Event" },
		{ 0x0014,	"Call_Priority_VM_Event"	},
		{ 0x0015,	"Cancel_Priority_VM_Event" },
		{ 0x0016,	"Get_NMI_Handler_Addr" },
		{ 0x0017,	"Set_NMI_Handler_Addr" },
		{ 0x0018,	"Hook_NMI_Event" },
		{ 0x0019,	"Call_When_VM_Ints_Enabled" },
		{ 0x001a,	"Enable_VM_Ints" },
		{ 0x001b,	"Disable_VM_Ints" },
		{ 0x001c,	"Map_Flat" },
		{ 0x001d,	"Map_Lin_To_VM_Addr" },
		{ 0x001e,	"Adjust_Exec_Priority" },
		{ 0x001f,	"Begin_Critical_Section"	},
		{ 0x0020,	"End_Critical_Section" },
		{ 0x0021,	"End_Crit_And_Suspend" },
		{ 0x0022,	"Claim_Critical_Section"	},
		{ 0x0023,	"Release_Critical_Section" },
		{ 0x0024,	"Call_When_Not_Critical"	},
		{ 0x0025,	"Create_Semaphore" },
		{ 0x0026,	"Destroy_Semaphore"	},
		{ 0x0027,	"Wait_Semaphore" },
		{ 0x0028,	"Signal_Semaphore" },
		{ 0x0029,	"Get_Crit_Section_Status" },
		{ 0x002a,	"Call_When_Task_Switched" },
		{ 0x002b,	"Suspend_VM" },
		{ 0x002c,	"Resume_VM" },
		{ 0x002d,	"No_Fail_Resume_VM"	},
		{ 0x002e,	"Nuke_VM"	},
		{ 0x002f,	"Crash_Cur_VM"	},
		{ 0x0030,	"Get_Execution_Focus" },
		{ 0x0031,	"Set_Execution_Focus" },
		{ 0x0032,	"Get_Time_Slice_Priority" },
		{ 0x0033,	"Set_Time_Slice_Priority" },
		{ 0x0034,	"Get_Time_Slice_Granularity" },
		{ 0x0035,	"Set_Time_Slice_Granularity" },
		{ 0x0036,	"Get_Time_Slice_Info" },
		{ 0x0037,	"Adjust_Execution_Time" },
		{ 0x0038,	"Release_Time_Slice" },
		{ 0x0039,	"Wake_Up_VM" },
		{ 0x003a,	"Call_When_Idle" },
		{ 0x003b,	"Get_Next_VM_Handle" },
		{ 0x003c,	"Set_Global_Time_Out" },
		{ 0x003d,	"Set_VM_Time_Out" },
		{ 0x003e,	"Cancel_Time_Out" },
		{ 0x003f,	"Get_System_Time" },
		{ 0x0040,	"Get_VM_Exec_Time" },
		{ 0x0041,	"Hook_V86_Int_Chain" },
		{ 0x0042,	"Get_V86_Int_Vector" },
		{ 0x0043,	"Set_V86_Int_Vector" },
		{ 0x0044,	"Get_PM_Int_Vector"	},
		{ 0x0045,	"Set_PM_Int_Vector"	},
		{ 0x0046,	"Simulate_Int"	},
		{ 0x0047,	"Simulate_Iret" },
		{ 0x0048,	"Simulate_Far_Call"	},
		{ 0x0049,	"Simulate_Far_Jmp" },
		{ 0x004a,	"Simulate_Far_Ret" },
		{ 0x004b,	"Simulate_Far_Ret_N" },
		{ 0x004c,	"Build_Int_Stack_Frame" },
		{ 0x004d,	"Simulate_Push" },
		{ 0x004e,	"Simulate_Pop"	},
		{ 0x004f,	"HeapAllocate"	},
		{ 0x0050,	"HeapReAllocate" },
		{ 0x0051,	"HeapFree" },
		{ 0x0052,	"HeapGetSize" },
		{ 0x0053,	"PageAllocate"	},
		{ 0x0054,	"PageReAllocate" },
		{ 0x0055,	"PageFree" },
		{ 0x0056,	"PageLock" },
		{ 0x0057,	"PageUnLock" },
		{ 0x0058,	"PageGetSizeAddr" },
		{ 0x0059,	"PageGetAllocInfo" },
		{ 0x005a,	"GetFreePageCount" },
		{ 0x005b,	"GetSysPageCount" },
		{ 0x005c,	"GetVMPgCount"	},
		{ 0x005d,	"MapIntoV86" },
		{ 0x005e,	"PhysIntoV86" },
		{ 0x005f,	"TestGlobalV86Mem" },
		{ 0x0060,	"ModifyPageBits" },
		{ 0x0061,	"CopyPageTable" },
		{ 0x0062,	"LinMapIntoV86" },
		{ 0x0063,	"LinPageLock" },
		{ 0x0064,	"LinPageUnLock" },
		{ 0x0065,	"SetResetV86Pageable" },
		{ 0x0066,	"GetV86PageableArray" },
		{ 0x0067,	"PageCheckLinRange"	},
		{ 0x0068,	"PageOutDirtyPages"	},
		{ 0x0069,	"PageDiscardPages" },
		{ 0x006a,	"GetNulPageHandle" },
		{ 0x006b,	"GetFirstV86Page" },
		{ 0x006c,	"MapPhysToLinear" },
		{ 0x006d,	"GetAppFlatDSAlias"	},
		{ 0x006e,	"SelectorMapFlat" },
		{ 0x006f,	"GetDemandPageInfo"	},
		{ 0x0070,	"GetSetPageOutCount" },
		{ 0x0071,	"Hook_V86_Page" },
		{ 0x0072,	"Assign_Device_V86_Pages" },
		{ 0x0073,	"DeAssign_Device_V86_Pages" },
		{ 0x0074,	"Get_Device_V86_Pages_Array" },
		{ 0x0075,	"MMGR_SetNULPageAddr" },
		{ 0x0076,	"Allocate_GDT_Selector" },
		{ 0x0077,	"Free_GDT_Selector"	},
		{ 0x0078,	"Allocate_LDT_Selector" },
		{ 0x0079,	"Free_LDT_Selector"	},
		{ 0x007a,	"BuildDescriptorDWORDs" },
		{ 0x007b,	"GetDescriptor" },
		{ 0x007c,	"SetDescriptor" },
		{ 0x007d,	"MMGR_Toggle_HMA" },
		{ 0x007e,	"Get_Fault_Hook_Addrs" },
		{ 0x007f,	"Hook_V86_Fault" },
		{ 0x0080,	"Hook_PM_Fault" },
		{ 0x0081,	"Hook_VMM_Fault" },
		{ 0x0082,	"Begin_Nest_V86_Exec" },
		{ 0x0083,	"Begin_Nest_Exec" },
		{ 0x0084,	"Exec_Int" },
		{ 0x0085,	"Resume_Exec" },
		{ 0x0086,	"End_Nest_Exec" },
		{ 0x0087,	"Allocate_PM_App_CB_Area" },
		{ 0x0088,	"Get_Cur_PM_App_CB"	},
		{ 0x0089,	"Set_V86_Exec_Mode"	},
		{ 0x008a,	"Set_PM_Exec_Mode" },
		{ 0x008b,	"Begin_Use_Locked_PM_Stack" },
		{ 0x008c,	"End_Use_Locked_PM_Stack" },
		{ 0x008d,	"Save_Client_State"	},
		{ 0x008e,	"Restore_Client_State" },
		{ 0x008f,	"Exec_VxD_Int"	},
		{ 0x0090,	"Hook_Device_Service" },
		{ 0x0091,	"Hook_Device_V86_API" },
		{ 0x0092,	"Hook_Device_PM_API" },
		{ 0x0093,	"System_Control" },
		{ 0x0094,	"Simulate_IO" },
		{ 0x0095,	"Install_Mult_IO_Handlers" },
		{ 0x0096,	"Install_IO_Handler" },
		{ 0x0097,	"Enable_Global_Trapping"	},
		{ 0x0098,	"Enable_Local_Trapping" },
		{ 0x0099,	"Disable_Global_Trapping" },
		{ 0x009a,	"Disable_Local_Trapping"	},
		{ 0x009b,	"List_Create" },
		{ 0x009c,	"List_Destroy"	},
		{ 0x009d,	"List_Allocate" },
		{ 0x009e,	"List_Attach" },
		{ 0x009f,	"List_Attach_Tail" },
		{ 0x00a0,	"List_Insert" },
		{ 0x00a1,	"List_Remove" },
		{ 0x00a2,	"List_Deallocate" },
		{ 0x00a3,	"List_Get_First" },
		{ 0x00a4,	"List_Get_Next" },
		{ 0x00a5,	"List_Remove_First"	},
		{ 0x00a6,	"AddInstanceItem" },
		{ 0x00a7,	"Allocate_Device_CB_Area" },
		{ 0x00a8,	"Allocate_Global_V86_Data_Area" },
		{ 0x00a9,	"Allocate_Temp_V86_Data_Area"	},
		{ 0x00aa,	"Free_Temp_V86_Data_Area" },
		{ 0x00ab,	"Get_Profile_Decimal_Int" },
		{ 0x00ac,	"Convert_Decimal_String"	},
		{ 0x00ad,	"Get_Profile_Fixed_Point" },
		{ 0x00ae,	"Convert_Fixed_Point_String" },
		{ 0x00af,	"Get_Profile_Hex_Int" },
		{ 0x00b0,	"Convert_Hex_String" },
		{ 0x00b1,	"Get_Profile_Boolean" },
		{ 0x00b2,	"Convert_Boolean_String"	},
		{ 0x00b3,	"Get_Profile_String" },
		{ 0x00b4,	"Get_Next_Profile_String" },
		{ 0x00b5,	"Get_Environment_String"	},
		{ 0x00b6,	"Get_Exec_Path" },
		{ 0x00b7,	"Get_Config_Directory" },
		{ 0x00b8,	"OpenFile" },
		{ 0x00b9,	"Get_PSP_Segment" },
		{ 0x00ba,	"GetDOSVectors" },
		{ 0x00bb,	"Get_Machine_Info" },
		{ 0x00bc,	"GetSet_HMA_Info" },
		{ 0x00bd,	"Set_System_Exit_Code" },
		{ 0x00be,	"Fatal_Error_Handler" },
		{ 0x00bf,	"Fatal_Memory_Error" },
		{ 0x00c0,	"Update_System_Clock" },
		{ 0x00c1,	"Test_Debug_Installed" },
		{ 0x00c2,	"Out_Debug_String" },
		{ 0x00c3,	"Out_Debug_Chr" },
		{ 0x00c4,	"In_Debug_Chr"	},
		{ 0x00c5,	"Debug_Convert_Hex_Binary" },
		{ 0x00c6,	"Debug_Convert_Hex_Decimal" },
		{ 0x00c7,	"Debug_Test_Valid_Handle" },
		{ 0x00c8,	"Validate_Client_Ptr" },
		{ 0x00c9,	"Test_Reenter"	},
		{ 0x00ca,	"Queue_Debug_String" },
		{ 0x00cb,	"Log_Proc_Call" },
		{ 0x00cc,	"Debug_Test_Cur_VM"	},
		{ 0x00cd,	"Get_PM_Int_Type" },
		{ 0x00ce,	"Set_PM_Int_Type" },
		{ 0x00cf,	"Get_Last_Updated_System_Time" },
		{ 0x00d0,	"Get_Last_Updated_VM_Exec_Time" },
		{ 0x00d1,	"Test_DBCS_Lead_Byte" },
		{ 0x00d2,	"AddFreePhysPage" },
		{ 0x00d3,	"PageResetHandlePAddr" },
		{ 0x00d4,	"SetLastV86Page" },
		{ 0x00d5,	"GetLastV86Page" },
		{ 0x00d6,	"MapFreePhysReg" },
		{ 0x00d7,	"UnmapFreePhysReg" },
		{ 0x00d8,	"XchgFreePhysReg" },
		{ 0x00d9,	"SetFreePhysRegCalBk" },
		{ 0x00da,	"Get_Next_Arena" },
		{ 0x00db,	"Get_Name_Of_Ugly_TSR" },
		{ 0x00dc,	"Get_Debug_Options"	},
		{ 0x00dd,	"Set_Physical_HMA_Alias"	},
		{ 0x00de,	"GetGlblRng0V86IntBase" },
		{ 0x00df,	"Add_Global_V86_Data_Area" },
		{ 0x00e0,	"GetSetDetailedVMError" },
		{ 0x00e1,	"Is_Debug_Chr"	},
		{ 0x00e2,	"Clear_Mono_Screen"	},
		{ 0x00e3,	"Out_Mono_Chr"	},
		{ 0x00e4,	"Out_Mono_String" },
		{ 0x00e5,	"Set_Mono_Cur_Pos" },
		{ 0x00e6,	"Get_Mono_Cur_Pos" },
		{ 0x00e7,	"Get_Mono_Chr"	},
		{ 0x00e8,	"Locate_Byte_In_ROM" },
		{ 0x00e9,	"Hook_Invalid_Page_Fault" },
		{ 0x00ea,	"Unhook_Invalid_Page_Fault" },
		{ 0x00eb,	"Set_Delete_On_Exit_File" },
		{ 0x00ec,	"Close_VM" },
		{ 0x00ed,	"Enable_Touch_1st_Meg" },
		{ 0x00ee,	"Disable_Touch_1st_Meg" },
		{ 0x00ef,	"Install_Exception_Handler" },
		{ 0x00f0,	"Remove_Exception_Handler" },
		{ 0x00f1,	"Get_Crit_Status_No_Block" },
		{ 0x00f2,	"GetLastUpdatedThreadExecTime" },
		{ 0x00f3,	"Trace_Out_Service"	},
		{ 0x00f4,	"Debug_Out_Service"	},
		{ 0x00f5,	"Debug_Flags_Service" },
		{ 0x00f6,	"VMMAddImportModuleName"	},
		{ 0x00f7,	"VMM_Add_DDB" },
		{ 0x00f8,	"VMM_Remove_DDB" },
		{ 0x00f9,	"Test_VM_Ints_Enabled" },
		{ 0x00fa,	"BlockOnID" },
		{ 0x00fb,	"Schedule_Thread_Event" },
		{ 0x00fc,	"Cancel_Thread_Event" },
		{ 0x00fd,	"Set_Thread_Time_Out" },
		{ 0x00fe,	"Set_Async_Time_Out" },
		{ 0x00ff,	"AllocateThreadDataSlot"	},
		{ 0x0100,	"FreeThreadDataSlot" },
		{ 0x0101,	"CreateMutex" },
		{ 0x0102,	"DestroyMutex"	},
		{ 0x0103,	"GetMutexOwner" },
		{ 0x0104,	"Call_When_Thread_Switched" },
		{ 0x0105,	"VMMCreateThread" },
		{ 0x0106,	"GetThreadExecTime"	},
		{ 0x0107,	"VMMTerminateThread" },
		{ 0x0108,	"Get_Cur_Thread_Handle" },
		{ 0x0109,	"Test_Cur_Thread_Handle"	},
		{ 0x010a,	"Get_Sys_Thread_Handle" },
		{ 0x010b,	"Test_Sys_Thread_Handle"	},
		{ 0x010c,	"Validate_Thread_Handle"	},
		{ 0x010d,	"Get_Initial_Thread_Handle" },
		{ 0x010e,	"Test_Initial_Thread_Handle" },
		{ 0x010f,	"Debug_Test_Valid_Thread_Handle" },
		{ 0x0110,	"Debug_Test_Cur_Thread" },
		{ 0x0111,	"VMM_GetSystemInitState"	},
		{ 0x0112,	"Cancel_Call_When_Thread_Switched"	},
		{ 0x0113,	"Get_Next_Thread_Handle"	},
		{ 0x0114,	"Adjust_Thread_Exec_Priority"	},
		{ 0x0115,	"Deallocate_Device_CB_Area" },
		{ 0x0116,	"Remove_IO_Handler"	},
		{ 0x0117,	"Remove_Mult_IO_Handlers" },
		{ 0x0118,	"Unhook_V86_Int_Chain" },
		{ 0x0119,	"Unhook_V86_Fault" },
		{ 0x011a,	"Unhook_PM_Fault" },
		{ 0x011b,	"Unhook_VMM_Fault" },
		{ 0x011c,	"Unhook_Device_Service" },
		{ 0x011d,	"PageReserve" },
		{ 0x011e,	"PageCommit" },
		{ 0x011f,	"PageDecommit"	},
		{ 0x0120,	"PagerRegister" },
		{ 0x0121,	"PagerQuery" },
		{ 0x0122,	"PagerDeregister" },
		{ 0x0123,	"ContextCreate" },
		{ 0x0124,	"ContextDestroy" },
		{ 0x0125,	"PageAttach" },
		{ 0x0126,	"PageFlush" },
		{ 0x0127,	"SignalID" },
		{ 0x0128,	"PageCommitPhys" },
		{ 0x0129,	"Register_Win32_Services" },
		{ 0x012a,	"Cancel_Call_When_Not_Critical" },
		{ 0x012b,	"Cancel_Call_When_Idle" },
		{ 0x012c,	"Cancel_Call_When_Task_Switched" },
		{ 0x012d,	"Debug_Printf_Service" },
		{ 0x012e,	"EnterMutex" },
		{ 0x012f,	"LeaveMutex" },
		{ 0x0130,	"Simulate_VM_IO" },
		{ 0x0131,	"Signal_Semaphore_No_Switch" },
		{ 0x0132,	"ContextSwitch" },
		{ 0x0133,	"PageModifyPermissions" },
		{ 0x0134,	"PageQuery" },
		{ 0x0135,	"EnterMustComplete"	},
		{ 0x0136,	"LeaveMustComplete"	},
		{ 0x0137,	"ResumeExecMustComplete"	},
		{ 0x0138,	"GetThreadTerminationStatus" },
		{ 0x0139,	"GetInstanceInfo" },
		{ 0x013a,	"ExecIntMustComplete" },
		{ 0x013b,	"ExecVxDIntMustComplete"	},
		{ 0x013c,	"Begin_V86_Serialization" },
		{ 0x013d,	"Unhook_V86_Page" },
		{ 0x013e,	"VMM_GetVxDLocationList"	},
		{ 0x013f,	"VMM_GetDDBList" },
		{ 0x0140,	"Unhook_NMI_Event" },
		{ 0x0141,	"Get_Instanced_V86_Int_Vector" },
		{ 0x0142,	"Get_Set_Real_DOS_PSP" },
		{ 0x0143,	"Call_Priority_Thread_Event" },
		{ 0x0144,	"Get_System_Time_Address" },
		{ 0x0145,	"Get_Crit_Status_Thread"	},
		{ 0x0146,	"Get_DDB"	},
		{ 0x0147,	"Directed_Sys_Control" },
		{ 0x0148,	"RegOpenKey" },
		{ 0x0149,	"RegCloseKey" },
		{ 0x014a,	"RegCreateKey"	},
		{ 0x014b,	"RegDeleteKey"	},
		{ 0x014c,	"RegEnumKey" },
		{ 0x014d,	"RegQueryValue" },
		{ 0x014e,	"RegSetValue" },
		{ 0x014f,	"RegDeleteValue" },
		{ 0x0150,	"RegEnumValue"	},
		{ 0x0151,	"RegQueryValueEx" },
		{ 0x0152,	"RegSetValueEx" },
		{ 0x0153,	"CallRing3" },
		{ 0x0154,	"Exec_PM_Int" },
		{ 0x0155,	"RegFlushKey" },
		{ 0x0156,	"PageCommitContig" },
		{ 0x0157,	"GetCurrentContext"	},
		{ 0x0158,	"LocalizeSprintf" },
		{ 0x0159,	"LocalizeStackSprintf" },
		{ 0x015a,	"Call_Restricted_Event" },
		{ 0x015b,	"Cancel_Restricted_Event" },
		{ 0x015c,	"Register_PEF_Provider" },
		{ 0x015d,	"GetPhysPageInfo" },
		{ 0x015e,	"RegQueryInfoKey" },
		{ 0x015f,	"MemArb_Reserve_Pages" },
		{ 0x0160,	"Time_Slice_Sys_VM_Idle"	},
		{ 0x0161,	"Time_Slice_Sleep" },
		{ 0x0162,	"Boost_With_Decay" },
		{ 0x0163,	"Set_Inversion_Pri"	},
		{ 0x0164,	"Reset_Inversion_Pri" },
		{ 0x0165,	"Release_Inversion_Pri" },
		{ 0x0166,	"Get_Thread_Win32_Pri" },
		{ 0x0167,	"Set_Thread_Win32_Pri" },
		{ 0x0168,	"Set_Thread_Static_Boost" },
		{ 0x0169,	"Set_VM_Static_Boost" },
		{ 0x016a,	"Release_Inversion_Pri_ID" },
		{ 0x016b,	"Attach_Thread_To_Group"	},
		{ 0x016c,	"Detach_Thread_From_Group" },
		{ 0x016d,	"Set_Group_Static_Boost"	},
		{ 0x016e,	"GetRegistryPath" },
		{ 0x016f,	"GetRegistryKey" },
		{ 0x0170,	"Cleanup_Thread_State" },
		{ 0x0171,	"RegRemapPreDefKey"	},
		{ 0x0172,	"End_V86_Serialization" },
		{ 0x0173,	"Assert_Range"	},
		{ 0x0174,	"Sprintf"	},
		{ 0x0175,	"PageChangePager" },
		{ 0x0176,	"RegCreateDynKey" },
		{ 0x0177,	"RegQMulti" },
		{ 0x0178,	"Boost_Thread_With_VM" },
		{ 0x0179,	"Get_Boot_Flags" },
		{ 0x017a,	"Set_Boot_Flags" },
		{ 0x017b,	"lstrcpyn" },
		{ 0x017c,	"lstrlen"	},
		{ 0x017d,	"lmemcpy"	},
		{ 0x017e,	"GetVxDName" },
		{ 0x017f,	"Force_Mutexes_Free" },
		{ 0x0180,	"Restore_Forced_Mutexes"	},
		{ 0x0181,	"AddReclaimableItem" },
		{ 0x0182,	"SetReclaimableItem" },
		{ 0x0183,	"EnumReclaimableItem" },
		{ 0x0184,	"Time_Slice_Wake_Sys_VM"	},
		{ 0x0185,	"VMM_Replace_Global_Environment" },
		{ 0x0186,	"Begin_Non_Serial_Nest_V86_Exec" },
		{ 0x0187,	"Get_Nest_Exec_Status" },
		{ 0x0188,	"Open_Boot_Log" },
		{ 0x0189,	"Write_Boot_Log" },
		{ 0x018a,	"Close_Boot_Log" },
		{ 0x018b,	"EnableDisable_Boot_Log"	},
		{ 0x018c,	"Call_On_My_Stack" },
		{ 0x018d,	"Get_Inst_V86_Int_Vec_Base" },
		{ 0x018e,	"lstrcmpi" },
		{ 0x018f,	"strupr" },
		{ 0x0190,	"Log_Fault_Call_Out" },
		{ 0x0191,	"AtEventTime" },
		{ 0x0192,	"PageOutPages"	},
		{ 0x0193,	"Call_On_My_Not_Flat_Stack" },
		{ 0x0194,	"LinRegionLock" },
		{ 0x0195,	"LinRegionUnLock" },
		{ 0x0196,	"AttemptingSomethingDangerous" },
		{ 0x0197,	"Vsprintf" },
		{ 0x0198,	"Vsprintfw" },
		{ 0x0199,	"Load_FS_Service" },
		{ 0x019a,	"Assert_FS_Service"	},
		{ 0x019b,	"ObsoleteRtlUnwind"	},
		{ 0x019c,	"ObsoleteRtlRaiseException" },
		{ 0x019d,	"ObsoleteRtlRaiseStatus"	},
		{ 0x019e,	"ObsoleteKeGetCurrentIrql" },
		{ 0x019f,	"ObsoleteKfRaiseIrql" },
		{ 0x01a0,	"ObsoleteKfLowerIrql" },
		{ 0x01a1,	"Begin_Preemptable_Code"	},
		{ 0x01a2,	"End_Preemptable_Code" },
		{ 0x01a3,	"Set_Preemptable_Count" },
		{ 0x01a4,	"ObsoleteKeInitializeDpc" },
		{ 0x01a5,	"ObsoleteKeInsertQueueDpc" },
		{ 0x01a6,	"ObsoleteKeRemoveQueueDpc" },
		{ 0x01a7,	"HeapAllocateEx" },
		{ 0x01a8,	"HeapReAllocateEx" },
		{ 0x01a9,	"HeapGetSizeEx" },
		{ 0x01aa,	"HeapFreeEx" },
		{ 0x01ab,	"Get_CPUID_Flags" },
		{ 0x01ac,	"KeCheckDivideByZeroTrap" },
		{ 0x01ad,	"RegisterGARTHandler" },
		{ 0x01ae,	"GARTReserve" },
		{ 0x01af,	"GARTCommit" },
		{ 0x01b0,	"GARTUnCommit"	},
		{ 0x01b1,	"GARTFree" },
		{ 0x01b2,	"GARTMemAttributes"	},
		{ 0x01b3,	"KfRaiseIrqlToDpcLevel" },
		{ 0x01b4,	"VMMCreateThreadEx"	},
		{ 0x01b5,	"FlushCaches" },
		{ 0x01b6,	"Set_Thread_Win32_Pri_NoYield" },
		{ 0x01b7,	"FlushMappedCacheBlock" },
		{ 0x01b8,	"ReleaseMappedCacheBlock" },
		{ 0x01b9,	"Run_Preemptable_Events"	},
		{ 0x01ba,	"MMPreSystemExit" },
		{ 0x01bb,	"MMPageFileShutDown" },
		{ 0x01bc,	"Set_Global_Time_Out_Ex"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_debug_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Fault" },
		{ 0x0002,	"CheckFault" },
		{ 0x0003,	"LoadSyms" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vpicd_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Virtualize_IRQ" },
		{ 0x0002,	"Set_Int_Request" },
		{ 0x0003,	"Clear_Int_Request"	},
		{ 0x0004,	"Phys_EOI" },
		{ 0x0005,	"Get_Complete_Status" },
		{ 0x0006,	"Get_Status" },
		{ 0x0007,	"Test_Phys_Request"	},
		{ 0x0008,	"Physically_Mask" },
		{ 0x0009,	"Physically_Unmask"	},
		{ 0x000a,	"Set_Auto_Masking" },
		{ 0x000b,	"Get_IRQ_Complete_Status" },
		{ 0x000c,	"Convert_Handle_To_IRQ" },
		{ 0x000d,	"Convert_IRQ_To_Int" },
		{ 0x000e,	"Convert_Int_To_IRQ" },
		{ 0x000f,	"Call_When_Hw_Int" },
		{ 0x0010,	"Force_Default_Owner" },
		{ 0x0011,	"Force_Default_Behavior"	},
		{ 0x0012,	"Auto_Mask_At_Inst_Swap"	},
		{ 0x0013,	"Begin_Inst_Page_Swap" },
		{ 0x0014,	"End_Inst_Page_Swap" },
		{ 0x0015,	"Virtual_EOI" },
		{ 0x0016,	"Get_Virtualization_Count" },
		{ 0x0017,	"Post_Sys_Critical_Init"	},
		{ 0x0018,	"VM_SlavePIC_Mask_Change" },
		{ 0x0019,	"Clear_IR_Bits" },
		{ 0x001a,	"Get_Level_Mask" },
		{ 0x001b,	"Set_Level_Mask" },
		{ 0x001c,	"Set_Irql_Mask" },
		{ 0x001d,	"Set_Channel_Irql" },
		{ 0x001e,	"Prepare_For_Shutdown" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vdmad_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Virtualize_Channel" },
		{ 0x0002,	"Get_Region_Info" },
		{ 0x0003,	"Set_Region_Info" },
		{ 0x0004,	"Get_Virt_State" },
		{ 0x0005,	"Set_Virt_State" },
		{ 0x0006,	"Set_Phys_State" },
		{ 0x0007,	"Mask_Channel"	},
		{ 0x0008,	"UnMask_Channel" },
		{ 0x0009,	"Lock_DMA_Region" },
		{ 0x000a,	"Unlock_DMA_Region"	},
		{ 0x000b,	"Scatter_Lock"	},
		{ 0x000c,	"Scatter_Unlock" },
		{ 0x000d,	"Reserve_Buffer_Space" },
		{ 0x000e,	"Request_Buffer" },
		{ 0x000f,	"Release_Buffer" },
		{ 0x0010,	"Copy_To_Buffer" },
		{ 0x0011,	"Copy_From_Buffer" },
		{ 0x0012,	"Default_Handler" },
		{ 0x0013,	"Disable_Translation" },
		{ 0x0014,	"Enable_Translation" },
		{ 0x0015,	"Get_EISA_Adr_Mode"	},
		{ 0x0016,	"Set_EISA_Adr_Mode"	},
		{ 0x0017,	"Unlock_DMA_Region_No_Dirty" },
		{ 0x0018,	"Phys_Mask_Channel"	},
		{ 0x0019,	"Phys_Unmask_Channel" },
		{ 0x001a,	"Unvirtualize_Channel" },
		{ 0x001b,	"Set_IO_Address" },
		{ 0x001c,	"Get_Phys_Count" },
		{ 0x001d,	"Get_Phys_Status" },
		{ 0x001e,	"Get_Max_Phys_Page"	},
		{ 0x001f,	"Set_Channel_Callbacks" },
		{ 0x0020,	"Get_Virt_Count" },
		{ 0x0021,	"Set_Virt_Count" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vtd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Update_System_Clock" },
		{ 0x0002,	"Get_Interrupt_Period" },
		{ 0x0003,	"Begin_Min_Int_Period" },
		{ 0x0004,	"End_Min_Int_Period" },
		{ 0x0005,	"Disable_Trapping" },
		{ 0x0006,	"Enable_Trapping" },
		{ 0x0007,	"Get_Real_Time" },
		{ 0x0008,	"Get_Date_And_Time"	},
		{ 0x0009,	"Adjust_VM_Count" },
		{ 0x000a,	"Delay" },
		{ 0x000b,	"GetTimeZoneBias" },
		{ 0x000c,	"ObsoleteKeQueryPerformanceCounter" },
		{ 0x000d,	"ObsoleteKeQuerySystemTime" },
		{ 0x000e,	"Install_IO_Handle"	},
		{ 0x000f,	"Remove_IO_Handle" },
		{ 0x0010,	"Delay_Ex" },
		{ 0x0011,	"Init_Timer" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_v86mmgr_services[]	= {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Allocate_V86_Pages" },
		{ 0x0002,	"Set_EMS_XMS_Limits" },
		{ 0x0003,	"Get_EMS_XMS_Limits" },
		{ 0x0004,	"Set_Mapping_Info" },
		{ 0x0005,	"Get_Mapping_Info" },
		{ 0x0006,	"Xlat_API" },
		{ 0x0007,	"Load_Client_Ptr" },
		{ 0x0008,	"Allocate_Buffer" },
		{ 0x0009,	"Free_Buffer" },
		{ 0x000a,	"Get_Xlat_Buff_State" },
		{ 0x000b,	"Set_Xlat_Buff_State" },
		{ 0x000c,	"Get_VM_Flat_Sel" },
		{ 0x000d,	"Map_Pages" },
		{ 0x000e,	"Free_Page_Map_Region" },
		{ 0x000f,	"LocalGlobalReg" },
		{ 0x0010,	"GetPgStatus" },
		{ 0x0011,	"SetLocalA20" },
		{ 0x0012,	"ResetBasePages" },
		{ 0x0013,	"SetAvailMapPgs" },
		{ 0x0014,	"NoUMBInitCalls" },
		{ 0x0015,	"Get_EMS_XMS_Avail"	},
		{ 0x0016,	"Toggle_HMA" },
		{ 0x0017,	"Dev_Init" },
		{ 0x0018,	"Alloc_UM_Page" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_pageswap_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0006,	"Test_IO_Valid" },
		{ 0x0007,	"Read_Or_Write" },
		{ 0x0008,	"Grow_File" },
		{ 0x0009,	"Init_File" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vdd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"PIF_State" },
		{ 0x0002,	"Get_GrabRtn" },
		{ 0x0003,	"Hide_Cursor" },
		{ 0x0004,	"Set_VMType" },
		{ 0x0005,	"Get_ModTime" },
		{ 0x0006,	"Set_HCurTrk" },
		{ 0x0007,	"Msg_ClrScrn" },
		{ 0x0008,	"Msg_ForColor"	},
		{ 0x0009,	"Msg_BakColor"	},
		{ 0x000a,	"Msg_TextOut" },
		{ 0x000b,	"Msg_SetCursPos" },
		{ 0x000c,	"Query_Access"	},
		{ 0x000d,	"Check_Update_Soon"	},
		{ 0x000e,	"Get_Mini_Dispatch_Table" },
		{ 0x000f,	"Register_Virtual_Port" },
		{ 0x0010,	"Get_VM_Info" },
		{ 0x0011,	"Get_Special_VM_IDs" },
		{ 0x0012,	"Register_Extra_Screen_Selector" },
		{ 0x0013,	"Takeover_VGA_Port"	},
		{ 0x0014,	"Get_DISPLAYINFO" },
		{ 0x0015,	"Do_Physical_IO" },
		{ 0x0016,	"Set_Sleep_Flag_Addr" },
		{ 0x0017,	"EnableDevice"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vsd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Bell" },
		{ 0x0002,	"SoundOn"	},
		{ 0x0003,	"TakeSoundPort" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vmd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Set_Mouse_Type" },
		{ 0x0002,	"Get_Mouse_Owner" },
		{ 0x0003,	"Post_Pointer_Message" },
		{ 0x0004,	"Set_Cursor_Proc" },
		{ 0x0005,	"Call_Cursor_Proc" },
		{ 0x0006,	"Set_Mouse_Data" },
		{ 0x0007,	"Get_Mouse_Data" },
		{ 0x0008,	"Manipulate_Pointer_Message" },
		{ 0x0009,	"Set_Middle_Button"	},
		{ 0x000a,	"Enable_Disable_Mouse_Events"	},
		{ 0x000b,	"Post_Absolute_Pointer_Message" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vkd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Define_Hot_Key" },
		{ 0x0002,	"Remove_Hot_Key" },
		{ 0x0003,	"Local_Enable_Hot_Key" },
		{ 0x0004,	"Local_Disable_Hot_Key" },
		{ 0x0005,	"Reflect_Hot_Key" },
		{ 0x0006,	"Cancel_Hot_Key_State" },
		{ 0x0007,	"Force_Keys" },
		{ 0x0008,	"Get_Kbd_Owner" },
		{ 0x0009,	"Define_Paste_Mode"	},
		{ 0x000a,	"Start_Paste" },
		{ 0x000b,	"Cancel_Paste"	},
		{ 0x000c,	"Get_Msg_Key" },
		{ 0x000d,	"Peek_Msg_Key"	},
		{ 0x000e,	"Flush_Msg_Key_Queue" },
		{ 0x000f,	"Enable_Keyboard" },
		{ 0x0010,	"Disable_KeyBoard" },
		{ 0x0011,	"Get_Shift_State" },
		{ 0x0012,	"Filter_Keyboard_Input" },
		{ 0x0013,	"Put_Byte" },
		{ 0x0014,	"Set_Shift_State" },
		{ 0x0015,	"Send_Data" },
		{ 0x0016,	"Set_LEDs" },
		{ 0x0017,	"Set_Key_Rate"	},
		{ 0x0018,	"Get_Key_Rate"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vcd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Set_Port_Global" },
		{ 0x0002,	"Get_Focus" },
		{ 0x0003,	"Virtualize_Port" },
		{ 0x0004,	"Acquire_Port"	},
		{ 0x0005,	"Free_Port" },
		{ 0x0006,	"Acquire_Port_Windows_Style" },
		{ 0x0007,	"Free_Port_Windows_Style" },
		{ 0x0008,	"Steal_Port_Windows_Style" },
		{ 0x0009,	"Find_COM_Index" },
		{ 0x000a,	"Set_Port_Global_Special" },
		{ 0x000b,	"Virtualize_Port_Dynamic" },
		{ 0x000c,	"Unvirtualize_Port_Dynamic" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vpd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Acquire"	},
		{ 0x0002,	"Release"	},
		{ 0x0003,	"Jumbo_Acquire" },
		{ 0x0004,	"Jumbo_Release" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_ios_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"BD_Register_Device" },
		{ 0x0002,	"Find_Int13_Drive" },
		{ 0x0003,	"Get_Device_List" },
		{ 0x0004,	"SendCommand" },
		{ 0x0005,	"BD_Command_Complete" },
		{ 0x0006,	"Synchronous_Command" },
		{ 0x0007,	"Register" },
		{ 0x0008,	"Requestor_Service"	},
		{ 0x0009,	"Exclusive_Access" },
		{ 0x000a,	"Send_Next_Command"	},
		{ 0x000b,	"Set_Async_Time_Out" },
		{ 0x000c,	"Signal_Semaphore_No_Switch" },
		{ 0x000d,	"IdleStatus" },
		{ 0x000e,	"MapIORSToI24"	},
		{ 0x000f,	"MapIORSToI21"	},
		{ 0x0010,	"PrintLog" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vmcpd_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Get_Virt_State" },
		{ 0x0002,	"Set_Virt_State" },
		{ 0x0003,	"Get_CR0_State" },
		{ 0x0004,	"Set_CR0_State" },
		{ 0x0005,	"Get_Thread_State" },
		{ 0x0006,	"Set_Thread_State" },
		{ 0x0007,	"Get_FP_Instruction_Size" },
		{ 0x0008,	"Set_Thread_Precision" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_ebios_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Get_Unused_Mem" },
		{ -1, 0 }		  /* Terminator */
};

vxd_service_desc vxd_vnetbios_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Register" },
		{ 0x0002,	"Submit" },
		{ 0x0003,	"Enum" },
		{ 0x0004,	"Deregister" },
		{ 0x0005,	"Register2" },
		{ 0x0006,	"Map" },
		{ 0x0007,	"Enum2" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_dosmgr_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Set_Exec_VM_Data" },
		{ 0x0002,	"Copy_VM_Drive_State" },
		{ 0x0003,	"Exec_VM"	},
		{ 0x0004,	"Get_IndosPtr"	},
		{ 0x0005,	"Add_Device" },
		{ 0x0006,	"Remove_Device" },
		{ 0x0007,	"Instance_Device" },
		{ 0x0008,	"Get_DOS_Crit_Status" },
		{ 0x0009,	"Enable_Indos_Polling" },
		{ 0x000a,	"BackFill_Allowed" },
		{ 0x000b,	"LocalGlobalReg" },
		{ 0x000c,	"Init_UMB_Area" },
		{ 0x000d,	"Begin_V86_App" },
		{ 0x000e,	"End_V86_App" },
		{ 0x000f,	"Alloc_Local_Sys_VM_Mem"	},
		{ 0x0010,	"Grow_CDSs" },
		{ 0x0011,	"Translate_Server_DOS_Call" },
		{ 0x0012,	"MMGR_PSP_Change_Notifier" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_shell_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Resolve_Contention" },
		{ 0x0002,	"Event" },
		{ 0x0003,	"SYSMODAL_Message" },
		{ 0x0004,	"Message"	},
		{ 0x0005,	"GetVMInfo" },
		{ 0x0006,	"PostMessage" },
		{ 0x0007,	"ShellExecute"	},
		{ 0x0008,	"PostShellMessage" },
		{ 0x0009,	"DispatchRing0AppyEvents" },
		{ 0x000a,	"Hook_Properties" },
		{ 0x000b,	"Unhook_Properties"	},
		{ 0x000c,	"Update_User_Activity" },
		{ 0x000d,	"QueryAppyTimeAvailable"	},
		{ 0x000e,	"CallAtAppyTime" },
		{ 0x000f,	"CancelAppyTimeEvent" },
		{ 0x0010,	"BroadcastSystemMessage"	},
		{ 0x0011,	"HookSystemBroadcast" },
		{ 0x0012,	"UnhookSystemBroadcast" },
		{ 0x0013,	"LocalAllocEx"	},
		{ 0x0014,	"LocalFree" },
		{ 0x0015,	"LoadLibrary" },
		{ 0x0016,	"FreeLibrary" },
		{ 0x0017,	"GetProcAddress" },
		{ 0x0018,	"CallDll"	},
		{ 0x0019,	"SuggestSingleMSDOSMode"	},
		{ 0x001a,	"CheckHotkeyAllowed" },
		{ 0x001b,	"GetDOSAppInfo" },
		{ 0x001c,	"Update_User_Activity_Ex" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vmpool_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Enable_Disable" },
		{ 0x0002,	"Reset_Detection" },
		{ 0x0003,	"Check_Idle" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_dosnet_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Send_FILESYSCHANGE" },
		{ 0x0002,	"Do_PSP_Adjust" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_int13_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Device_Registered"	},
		{ 0x0002,	"Translate_VM_Int" },
		{ 0x0003,	"Hooking_BIOS_Int" },
		{ 0x0004,	"Unhooking_BIOS_Int" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_pagefile_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Init_File" },
		{ 0x0002,	"Clean_Up" },
		{ 0x0003,	"Grow_File" },
		{ 0x0004,	"Read_Or_Write" },
		{ 0x0005,	"Cancel" },
		{ 0x0006,	"Test_IO_Valid" },
		{ 0x0007,	"Get_Size_Info" },
		{ 0x0008,	"Set_Async_Manager"	},
		{ 0x0009,	"Call_Async_Manager" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vpowerd_services[]	= {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Get_APM_BIOS_Version" },
		{ 0x0002,	"Get_Power_Management_Level" },
		{ 0x0003,	"Set_Power_Management_Level" },
		{ 0x0004,	"Set_Device_Power_State"	},
		{ 0x0005,	"Set_System_Power_State"	},
		{ 0x0006,	"Restore_Power_On_Defaults" },
		{ 0x0007,	"Get_Power_Status" },
		{ 0x0008,	"Get_Power_State" },
		{ 0x0009,	"OEM_APM_Function" },
		{ 0x000a,	"Register_Power_Handler"	},
		{ 0x000b,	"Deregister_Power_Handler" },
		{ 0x000c,	"W32_Get_System_Power_Status"	},
		{ 0x000d,	"W32_Set_System_Power_State" },
		{ 0x000e,	"Get_Capabilities" },
		{ 0x000f,	"Enable_Resume_On_Ring" },
		{ 0x0010,	"Disable_Resume_On_Ring"	},
		{ 0x0011,	"Set_Resume_Timer" },
		{ 0x0012,	"Get_Resume_Timer" },
		{ 0x0013,	"Disable_Resume_Timer" },
		{ 0x0014,	"Enable_Timer_Based_Requests"	},
		{ 0x0015,	"Disable_Timer_Based_Requests" },
		{ 0x0016,	"W32_Get_Power_Status" },
		{ 0x0017,	"Get_Timer_Based_Requests_Status" },
		{ 0x0018,	"Get_Ring_Resume_Status"	},
		{ 0x0019,	"Transfer_Control" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vxdldr_services[] = {
		{ 0x0000,	"GetVersion" },
		{ 0x0001,	"LoadDevice" },
		{ 0x0002,	"UnloadDevice"	},
		{ 0x0003,	"DevInitSucceeded" },
		{ 0x0004,	"DevInitFailed" },
		{ 0x0005,	"GetDeviceList" },
		{ 0x0006,	"UnloadMe" },
		{ 0x0007,	"PELDR_LoadModule" },
		{ 0x0008,	"PELDR_GetModuleHandle" },
		{ 0x0009,	"PELDR_GetModuleUsage" },
		{ 0x000a,	"PELDR_GetEntryPoint" },
		{ 0x000b,	"PELDR_GetProcAddress" },
		{ 0x000c,	"PELDR_AddExportTable" },
		{ 0x000d,	"PELDR_RemoveExportTable" },
		{ 0x000e,	"PELDR_FreeModule" },
		{ 0x000f,	"Notify" },
		{ 0x0010,	"PELDR_InitCompleted" },
		{ 0x0011,	"PELDR_LoadModuleEx" },
		{ 0x0012,	"PELDR_LoadModule2"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_ndis_services[] = {
		{ 0x0000,	"GetVersion" },
		{ 0x0001,	"AllocateSpinLock" },
		{ 0x0002,	"FreeSpinLock"	},
		{ 0x0003,	"AcquireSpinLock" },
		{ 0x0004,	"ReleaseSpinLock" },
		{ 0x0005,	"OpenConfiguration"	},
		{ 0x0006,	"ReadConfiguration"	},
		{ 0x0007,	"CloseConfiguration" },
		{ 0x0008,	"ReadEisaSlotInformation" },
		{ 0x0009,	"ReadMcaPosInformation" },
		{ 0x000a,	"AllocateMemory" },
		{ 0x000b,	"FreeMemory" },
		{ 0x000c,	"SetTimer" },
		{ 0x000d,	"CancelTimer" },
		{ 0x000e,	"StallExecution" },
		{ 0x000f,	"InitializeInterrupt" },
		{ 0x0010,	"RemoveInterrupt" },
		{ 0x0011,	"SynchronizeWithInterrupt" },
		{ 0x0012,	"OpenFile" },
		{ 0x0013,	"MapFile"	},
		{ 0x0014,	"UnmapFile" },
		{ 0x0015,	"CloseFile" },
		{ 0x0016,	"AllocatePacketPool" },
		{ 0x0017,	"FreePacketPool" },
		{ 0x0018,	"AllocatePacket" },
		{ 0x0019,	"ReinitializePacket" },
		{ 0x001a,	"FreePacket" },
		{ 0x001b,	"QueryPacket" },
		{ 0x001c,	"AllocateBufferPool" },
		{ 0x001d,	"FreeBufferPool" },
		{ 0x001e,	"AllocateBuffer" },
		{ 0x001f,	"CopyBuffer" },
		{ 0x0020,	"FreeBuffer" },
		{ 0x0021,	"QueryBuffer" },
		{ 0x0022,	"GetBufferPhysicalAddress" },
		{ 0x0023,	"ChainBufferAtFront" },
		{ 0x0024,	"ChainBufferAtBack"	},
		{ 0x0025,	"UnchainBufferAtFront" },
		{ 0x0026,	"UnchainBufferAtBack" },
		{ 0x0027,	"GetNextBuffer" },
		{ 0x0028,	"CopyFromPacketToPacket"	},
		{ 0x0029,	"RegisterProtocol" },
		{ 0x002a,	"DeregisterProtocol" },
		{ 0x002b,	"OpenAdapter" },
		{ 0x002c,	"CloseAdapter"	},
		{ 0x002d,	"Send" },
		{ 0x002e,	"TransferData"	},
		{ 0x002f,	"Reset" },
		{ 0x0030,	"Request"	},
		{ 0x0031,	"InitializeWrapper"	},
		{ 0x0032,	"TerminateWrapper" },
		{ 0x0033,	"RegisterMac" },
		{ 0x0034,	"DeregisterMac" },
		{ 0x0035,	"RegisterAdapter" },
		{ 0x0036,	"DeregisterAdapter"	},
		{ 0x0037,	"CompleteOpenAdapter" },
		{ 0x0038,	"CompleteCloseAdapter" },
		{ 0x0039,	"CompleteSend"	},
		{ 0x003a,	"CompleteTransferData" },
		{ 0x003b,	"CompleteReset" },
		{ 0x003c,	"CompleteRequest" },
		{ 0x003d,	"IndicateReceive" },
		{ 0x003e,	"IndicateReceiveComplete" },
		{ 0x003f,	"IndicateStatus" },
		{ 0x0040,	"IndicateStatusComplete"	},
		{ 0x0041,	"CompleteQueryStatistics" },
		{ 0x0042,	"EqualString" },
		{ 0x0043,	"RegAdaptShutdown" },
		{ 0x0044,	"ReadNetworkAddress" },
		{ 0x0045,	"WriteErrorLogEntry" },
		{ 0x0046,	"MapIoSpace" },
		{ 0x0047,	"DeregAdaptShutdown" },
		{ 0x0048,	"AllocateSharedMemory" },
		{ 0x0049,	"FreeSharedMemory" },
		{ 0x004a,	"AllocateDmaChannel" },
		{ 0x004b,	"SetupDmaTransfer" },
		{ 0x004c,	"CompleteDmaTransfer" },
		{ 0x004d,	"ReadDmaCounter" },
		{ 0x004e,	"FreeDmaChannel" },
		{ 0x004f,	"ReleaseAdapterResources" },
		{ 0x0050,	"QueryGlobalStatistics" },
		{ 0x0051,	"OpenProtocolConfiguration" },
		{ 0x0052,	"CompleteBindAdapter" },
		{ 0x0053,	"CompleteUnbindAdapter" },
		{ 0x0054,	"WrapperStartNet" },
		{ 0x0055,	"WrapperGetComponentList" },
		{ 0x0056,	"WrapperQueryAdapterResources" },
		{ 0x0057,	"WrapperDelayBinding" },
		{ 0x0058,	"WrapperResumeBinding" },
		{ 0x0059,	"WrapperRemoveChildren" },
		{ 0x005a,	"ImmediateReadPciSlotInformation" },
		{ 0x005b,	"ImmediateWritePciSlotInformation"	},
		{ 0x005c,	"ReadPciSlotInformation"	},
		{ 0x005d,	"WritePciSlotInformation" },
		{ 0x005e,	"PciAssignResources" },
		{ 0x005f,	"QueryBufferOffset"	},
		{ 0x0062,	"InitializeEvent" },
		{ 0x0063,	"SetEvent" },
		{ 0x0064,	"ResetEvent" },
		{ 0x0065,	"WaitEvent" },
		{ 0x0066,	"ReturnPackets" },
		{ 0x0067,	"QueryReceiveInformation" },
		{ 0x0068,	"CmRegisterAddressFamily" },
		{ 0x0069,	"ClOpenAddressFamily" },
		{ 0x006a,	"CmOpenAddressFamilyComplete"	},
		{ 0x006b,	"ClCloseAddressFamily" },
		{ 0x006c,	"CmCloseAddressFamilyComplete" },
		{ 0x006d,	"ClRegisterSap" },
		{ 0x006e,	"CmRegisterSapComplete" },
		{ 0x006f,	"ClDeregisterSap" },
		{ 0x0070,	"CmDeregisterSapComplete" },
		{ 0x0071,	"ClMakeCall" },
		{ 0x0072,	"CmMakeCallComplete" },
		{ 0x0073,	"CmDispatchIncomingCall"	},
		{ 0x0074,	"ClIncomingCallComplete"	},
		{ 0x0075,	"CmDispatchCallConnected" },
		{ 0x0076,	"ClModifyCallQoS" },
		{ 0x0077,	"CmModifyCallQoSComplete" },
		{ 0x0078,	"CmDispatchIncomingCallQoSChange" },
		{ 0x0079,	"ClCloseCall" },
		{ 0x007a,	"CmCloseCallComplete" },
		{ 0x007b,	"CmDispatchIncomingCloseCall"	},
		{ 0x007c,	"ClAddParty" },
		{ 0x007d,	"CmAddPartyComplete" },
		{ 0x007e,	"ClDropParty" },
		{ 0x007f,	"CmDropPartyComplete" },
		{ 0x0080,	"CmDispatchIncomingDropParty"	},
		{ 0x0081,	"CoCreateVc" },
		{ 0x0082,	"CoDeleteVc" },
		{ 0x0083,	"CmActivateVc"	},
		{ 0x0084,	"CmDeactivateVc" },
		{ 0x0085,	"CoRequest" },
		{ 0x0086,	"CoRequestComplete"	},
		{ 0x0087,	"CoSendPackets" },
		{ 0x0088,	"InitAnsiString" },
		{ 0x0089,	"InitUnicodeString"	},
		{ 0x008a,	"AnsiStringToUnicodeString" },
		{ 0x008b,	"UnicodeStringToAnsiString" },
		{ 0x008c,	"WriteConfiguration" },
		{ 0x008d,	"OpenConfigurationKeyByName" },
		{ 0x008e,	"OpenConfigurationKeyByIndex"	},
		{ 0x008f,	"ConvertStringToAtmAddress" },
		{ 0x0090,	"AllocateMemoryWithTag" },
		{ 0x0091,	"OpenGlobalConfiguration" },
		{ 0x0092,	"InterlockedIncrement" },
		{ 0x0093,	"InterlockedDecrement" },
		{ 0x0094,	"InterlockedAddUlong" },
		{ 0x0095,	"InterlockedInsertHeadList" },
		{ 0x0096,	"InterlockedInsertTailList" },
		{ 0x0097,	"InterlockedRemoveHeadList" },
		{ 0x0098,	"InterlockedPopEntryList" },
		{ 0x0099,	"InterlockedPushEntryList" },
		{ 0x009a,	"WriteEventLogEntry" },
		{ 0x009b,	"GetFirstBufferFromPacket" },
		{ 0x009c,	"SendPackets" },
		{ 0x009e,	"GetSystemUpTime" },
		{ 0x009f,	"ScheduleWorkItem" },
		{ 0x00a0,	"QueryAdapterInstanceName" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vwin32_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"DIOCCompletionRoutine" },
		{ 0x0002,	"QueueUserApc"	},
		{ 0x0003,	"GetThreadContext" },
		{ 0x0004,	"SetThreadContext" },
		{ 0x0005,	"CopyMem"	},
		{ 0x0006,	"NpxException"	},
		{ 0x0007,	"EmulateNpx" },
		{ 0x0008,	"CheckDelayedNpxTrap" },
		{ 0x0009,	"EnterCrstR0" },
		{ 0x000a,	"LeaveCrstR0" },
		{ 0x000b,	"FaultPopup" },
		{ 0x000c,	"GetContextHandle" },
		{ 0x000d,	"GetCurrentProcessHandle" },
		{ 0x000e,	"SetWin32Event" },
		{ 0x000f,	"PulseWin32Event" },
		{ 0x0010,	"ResetWin32Event" },
		{ 0x0011,	"WaitSingleObject" },
		{ 0x0012,	"WaitMultipleObjects" },
		{ 0x0013,	"CreateRing0Thread"	},
		{ 0x0014,	"CloseVxDHandle" },
		{ 0x0015,	"ActiveTimeBiasSet"	},
		{ 0x0016,	"GetCurrentDirectory" },
		{ 0x0017,	"BlueScreenPopup" },
		{ 0x0018,	"TerminateApp"	},
		{ 0x0019,	"QueueKernelAPC" },
		{ 0x001a,	"SysErrorBox" },
		{ 0x001b,	"IsClientWin32" },
		{ 0x001c,	"IFSRIPWhenLev2Taken" },
		{ 0x001d,	"InitWin32Event" },
		{ 0x001e,	"InitWin32Mutex" },
		{ 0x001f,	"ReleaseWin32Mutex"	},
		{ 0x0020,	"BlockThreadEx" },
		{ 0x0021,	"GetProcessHandle" },
		{ 0x0022,	"InitWin32Semaphore" },
		{ 0x0023,	"SignalWin32Sem" },
		{ 0x0024,	"QueueUserApcEx" },
		{ 0x0025,	"OpenVxDHandle" },
		{ 0x0026,	"CloseWin32Handle" },
		{ 0x0027,	"AllocExternalHandle" },
		{ 0x0028,	"UseExternalHandle"	},
		{ 0x0029,	"UnuseExternalHandle" },
		{ 0x002a,	"KeInitializeTimer"	},
		{ 0x002b,	"KeSetTimer" },
		{ 0x002c,	"KeCancelTimer" },
		{ 0x002d,	"KeReadStateTimer" },
		{ 0x002e,	"ReferenceObject" },
		{ 0x002f,	"GetExternalHandle"	},
		{ 0x0030,	"ConvertNtTimeout" },
		{ 0x0031,	"SetWin32EventBoostPriority" },
		{ 0x0032,	"GetRing3Flat32Selectors" },
		{ 0x0033,	"GetCurThreadCondition" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vcomm_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Register_Port_Driver" },
		{ 0x0002,	"Acquire_Port"	},
		{ 0x0003,	"Release_Port"	},
		{ 0x0004,	"OpenComm" },
		{ 0x0005,	"SetCommState"	},
		{ 0x0006,	"GetCommState"	},
		{ 0x0007,	"SetupComm" },
		{ 0x0008,	"TransmitCommChar" },
		{ 0x0009,	"CloseComm" },
		{ 0x000a,	"GetCommQueueStatus" },
		{ 0x000b,	"ClearCommError" },
		{ 0x000c,	"GetModemStatus" },
		{ 0x000d,	"GetCommProperties"	},
		{ 0x000e,	"EscapeCommFunction" },
		{ 0x000f,	"PurgeComm" },
		{ 0x0010,	"SetCommEventMask" },
		{ 0x0011,	"GetCommEventMask" },
		{ 0x0012,	"WriteComm" },
		{ 0x0013,	"ReadComm" },
		{ 0x0014,	"EnableCommNotification"	},
		{ 0x0015,	"GetLastError"	},
		{ 0x0016,	"Steal_Port" },
		{ 0x0017,	"SetReadCallBack" },
		{ 0x0018,	"SetWriteCallBack" },
		{ 0x0019,	"Add_Port" },
		{ 0x001a,	"GetSetCommTimeouts" },
		{ 0x001b,	"SetWriteRequest" },
		{ 0x001c,	"SetReadRequest" },
		{ 0x001d,	"Dequeue_Request" },
		{ 0x001e,	"Enumerate_DevNodes" },
		{ 0x001f,	"Map_Win32DCB_To_Ring0" },
		{ 0x0020,	"Map_Ring0DCB_To_Win32" },
		{ 0x0021,	"Get_Contention_Handler"	},
		{ 0x0022,	"Map_Name_To_Resource" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_configmg_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Initialize" },
		{ 0x0002,	"Locate_DevNode" },
		{ 0x0003,	"Get_Parent" },
		{ 0x0004,	"Get_Child" },
		{ 0x0005,	"Get_Sibling" },
		{ 0x0006,	"Get_Device_ID_Size" },
		{ 0x0007,	"Get_Device_ID" },
		{ 0x0008,	"Get_Depth" },
		{ 0x0009,	"Get_Private_DWord"	},
		{ 0x000a,	"Set_Private_DWord"	},
		{ 0x000b,	"Create_DevNode" },
		{ 0x000c,	"Query_Remove_SubTree" },
		{ 0x000d,	"Remove_SubTree" },
		{ 0x000e,	"Register_Device_Driver"	},
		{ 0x000f,	"Register_Enumerator" },
		{ 0x0010,	"Register_Arbitrator" },
		{ 0x0011,	"Deregister_Arbitrator" },
		{ 0x0012,	"Query_Arbitrator_Free_Size" },
		{ 0x0013,	"Query_Arbitrator_Free_Data" },
		{ 0x0014,	"Sort_NodeList" },
		{ 0x0015,	"Yield" },
		{ 0x0016,	"Lock" },
		{ 0x0017,	"Unlock" },
		{ 0x0018,	"Add_Empty_Log_Conf" },
		{ 0x0019,	"Free_Log_Conf" },
		{ 0x001a,	"Get_First_Log_Conf" },
		{ 0x001b,	"Get_Next_Log_Conf"	},
		{ 0x001c,	"Add_Res_Des" },
		{ 0x001d,	"Modify_Res_Des" },
		{ 0x001e,	"Free_Res_Des"	},
		{ 0x001f,	"Get_Next_Res_Des" },
		{ 0x0020,	"Get_Performance_Info" },
		{ 0x0021,	"Get_Res_Des_Data_Size" },
		{ 0x0022,	"Get_Res_Des_Data" },
		{ 0x0023,	"Process_Events_Now" },
		{ 0x0024,	"Create_Range_List"	},
		{ 0x0025,	"Add_Range" },
		{ 0x0026,	"Delete_Range"	},
		{ 0x0027,	"Test_Range_Available" },
		{ 0x0028,	"Dup_Range_List" },
		{ 0x0029,	"Free_Range_List" },
		{ 0x002a,	"Invert_Range_List"	},
		{ 0x002b,	"Intersect_Range_List" },
		{ 0x002c,	"First_Range" },
		{ 0x002d,	"Next_Range" },
		{ 0x002e,	"Dump_Range_List" },
		{ 0x002f,	"Load_DLVxDs" },
		{ 0x0030,	"Get_DDBs" },
		{ 0x0031,	"Get_CRC_CheckSum" },
		{ 0x0032,	"Register_DevLoader" },
		{ 0x0033,	"Reenumerate_DevNode" },
		{ 0x0034,	"Setup_DevNode" },
		{ 0x0035,	"Reset_Children_Marks" },
		{ 0x0036,	"Get_DevNode_Status" },
		{ 0x0037,	"Remove_Unmarked_Children" },
		{ 0x0038,	"ISAPNP_To_CM"	},
		{ 0x0039,	"CallBack_Device_Driver"	},
		{ 0x003a,	"CallBack_Enumerator" },
		{ 0x003b,	"Get_Alloc_Config" },
		{ 0x003c,	"Get_DevNode_Key_Size" },
		{ 0x003d,	"Get_DevNode_Key" },
		{ 0x003e,	"Read_Registry_Value" },
		{ 0x003f,	"Write_Registry_Value" },
		{ 0x0040,	"Disable_DevNode" },
		{ 0x0041,	"Enable_DevNode" },
		{ 0x0042,	"Move_DevNode"	},
		{ 0x0043,	"Set_Bus_Info"	},
		{ 0x0044,	"Get_Bus_Info"	},
		{ 0x0045,	"Set_HW_Prof" },
		{ 0x0046,	"Recompute_HW_Prof"	},
		{ 0x0047,	"Query_Change_HW_Prof" },
		{ 0x0048,	"Get_Device_Driver_Private_DWord" },
		{ 0x0049,	"Set_Device_Driver_Private_DWord" },
		{ 0x004a,	"Get_HW_Prof_Flags"	},
		{ 0x004b,	"Set_HW_Prof_Flags"	},
		{ 0x004c,	"Read_Registry_Log_Confs" },
		{ 0x004d,	"Run_Detection" },
		{ 0x004e,	"Call_At_Appy_Time"	},
		{ 0x004f,	"Fail_Change_HW_Prof" },
		{ 0x0050,	"Set_Private_Problem" },
		{ 0x0051,	"Debug_DevNode" },
		{ 0x0052,	"Get_Hardware_Profile_Info" },
		{ 0x0053,	"Register_Enumerator_Function" },
		{ 0x0054,	"Call_Enumerator_Function" },
		{ 0x0055,	"Add_ID" },
		{ 0x0056,	"Find_Range" },
		{ 0x0057,	"Get_Global_State" },
		{ 0x0058,	"Broadcast_Device_Change_Message" },
		{ 0x0059,	"Call_DevNode_Handler" },
		{ 0x005a,	"Remove_Reinsert_All" },
		{ 0x005b,	"Change_DevNode_Status" },
		{ 0x005c,	"Reprocess_DevNode"	},
		{ 0x005d,	"Assert_Structure" },
		{ 0x005e,	"Discard_Boot_Log_Conf" },
		{ 0x005f,	"Set_Dependent_DevNode" },
		{ 0x0060,	"Get_Dependent_DevNode" },
		{ 0x0061,	"Refilter_DevNode" },
		{ 0x0062,	"Merge_Range_List" },
		{ 0x0063,	"Substract_Range_List" },
		{ 0x0064,	"Set_DevNode_PowerState"	},
		{ 0x0065,	"Get_DevNode_PowerState"	},
		{ 0x0066,	"Set_DevNode_PowerCapabilities" },
		{ 0x0067,	"Get_DevNode_PowerCapabilities" },
		{ 0x0068,	"Read_Range_List" },
		{ 0x0069,	"Write_Range_List" },
		{ 0x006a,	"Get_Log_Conf_Priority" },
		{ 0x006b,	"Support_Share_Irq"	},
		{ 0x006c,	"Get_Parent_Structure" },
		{ 0x006d,	"Register_DevNode_For_Idle_Detection" },
		{ 0x006e,	"CM_To_ISAPNP"	},
		{ 0x006f,	"Get_DevNode_Handler" },
		{ 0x0070,	"Detect_Resource_Conflict" },
		{ 0x0071,	"Get_Device_Interface_List" },
		{ 0x0072,	"Get_Device_Interface_List_Size" },
		{ 0x0073,	"Get_Conflict_Info"	},
		{ 0x0074,	"Add_Remove_DevNode_Property"	},
		{ 0x0075,	"CallBack_At_Appy_Time" },
		{ 0x0076,	"Register_Device_Interface" },
		{ 0x0077,	"System_Device_Power_State_Mapping" },
		{ 0x0078,	"Get_Arbitrator_Info" },
		{ 0x0079,	"Waking_Up_From_DevNode"	},
		{ 0x007a,	"Set_DevNode_Problem" },
		{ 0x007b,	"Get_Device_Interface_Alias" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_cm_services[]	= {
		{ 0x0000,	"GetVersion" },
		{ 0x0001,	"GetConfig" },
		{ 0x0002,	"LockConfig" },
		{ 0x0003,	"UnlockConfig"	},
		{ 0x0004,	"CME_QueryResources" },
		{ 0x0005,	"CME_AllocResources" },
		{ 0x0006,	"CME_DeallocResources" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vfbackup_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Lock_NEC" },
		{ 0x0002,	"UnLock_NEC" },
		{ 0x0003,	"Register_NEC"	},
		{ 0x0004,	"Register_VFD"	},
		{ 0x0005,	"Lock_All_Ports" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vmini_services[] =	{
		{ 0x0000,	"GetVersion" },
		{ 0x0001,	"Update" },
		{ 0x0002,	"Status" },
		{ 0x0003,	"DisplayError"	},
		{ 0x0004,	"SetTimeStamp"	},
		{ 0x0005,	"Siren" },
		{ 0x0006,	"RegisterAccess" },
		{ 0x0007,	"GetData"	},
		{ 0x0008,	"ShutDownItem"	},
		{ 0x0009,	"RegisterSK" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vcond_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Launch_ConApp_Inherited" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_wsock_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Register" },
		{ 0x0002,	"Deregister" },
		{ 0x0003,	"SignalNotify"	},
		{ 0x0004,	"SignalAllNotify" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_ifsmgr_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"RegisterMount" },
		{ 0x0002,	"RegisterNet" },
		{ 0x0003,	"RegisterMailSlot" },
		{ 0x0004,	"Attach" },
		{ 0x0005,	"Detach" },
		{ 0x0006,	"Get_NetTime" },
		{ 0x0007,	"Get_DOSTime" },
		{ 0x0008,	"SetupConnection" },
		{ 0x0009,	"DerefConnection" },
		{ 0x000a,	"ServerDOSCall" },
		{ 0x000b,	"CompleteAsync" },
		{ 0x000c,	"RegisterHeap"	},
		{ 0x000d,	"GetHeap"	},
		{ 0x000e,	"RetHeap"	},
		{ 0x000f,	"CheckHeap" },
		{ 0x0010,	"CheckHeapItem" },
		{ 0x0011,	"FillHeapSpare" },
		{ 0x0012,	"Block" },
		{ 0x0013,	"Wakeup" },
		{ 0x0014,	"Yield" },
		{ 0x0015,	"SchedEvent" },
		{ 0x0016,	"QueueEvent" },
		{ 0x0017,	"KillEvent" },
		{ 0x0018,	"FreeIOReq" },
		{ 0x0019,	"MakeMailSlot"	},
		{ 0x001a,	"DeleteMailSlot" },
		{ 0x001b,	"WriteMailSlot" },
		{ 0x001c,	"PopUp" },
		{ 0x001d,	"printf" },
		{ 0x001e,	"AssertFailed"	},
		{ 0x001f,	"LogEntry" },
		{ 0x0020,	"DebugMenu" },
		{ 0x0021,	"DebugVars" },
		{ 0x0022,	"GetDebugString" },
		{ 0x0023,	"GetDebugHexNum" },
		{ 0x0024,	"NetFunction" },
		{ 0x0025,	"DoDelAllUses"	},
		{ 0x0026,	"SetErrString"	},
		{ 0x0027,	"GetErrString"	},
		{ 0x0028,	"SetReqHook" },
		{ 0x0029,	"SetPathHook" },
		{ 0x002a,	"UseAdd" },
		{ 0x002b,	"UseDel" },
		{ 0x002c,	"InitUseAdd" },
		{ 0x002d,	"ChangeDir" },
		{ 0x002e,	"DelAllUses" },
		{ 0x002f,	"CDROM_Attach"	},
		{ 0x0030,	"CDROM_Detach"	},
		{ 0x0031,	"Win32DupHandle" },
		{ 0x0032,	"Ring0_FileIO"	},
		{ 0x0033,	"Toggle_Extended_File_Handles" },
		{ 0x0034,	"Get_Drive_Info" },
		{ 0x0035,	"Ring0GetDriveInfo"	},
		{ 0x0036,	"BlockNoEvents" },
		{ 0x0037,	"NetToDosTime"	},
		{ 0x0038,	"DosToNetTime"	},
		{ 0x0039,	"DosToWin32Time" },
		{ 0x003a,	"Win32ToDosTime" },
		{ 0x003b,	"NetToWin32Time" },
		{ 0x003c,	"Win32ToNetTime" },
		{ 0x003d,	"MetaMatch" },
		{ 0x003e,	"TransMatch" },
		{ 0x003f,	"CallProvider"	},
		{ 0x0040,	"UniToBCS" },
		{ 0x0041,	"UniToBCSPath"	},
		{ 0x0042,	"BCSToUni" },
		{ 0x0043,	"UniToUpper" },
		{ 0x0044,	"UniCharToOEM"	},
		{ 0x0045,	"CreateBasis" },
		{ 0x0046,	"MatchBasisName" },
		{ 0x0047,	"AppendBasisTail" },
		{ 0x0048,	"FcbToShort" },
		{ 0x0049,	"ShortToFcb" },
		{ 0x004a,	"ParsePath" },
		{ 0x004b,	"Query_PhysLock" },
		{ 0x004c,	"VolFlush" },
		{ 0x004d,	"NotifyVolumeArrival" },
		{ 0x004e,	"NotifyVolumeRemoval" },
		{ 0x004f,	"QueryVolumeRemoval" },
		{ 0x0050,	"FSDUnmountCFSD" },
		{ 0x0051,	"GetConversionTablePtrs"	},
		{ 0x0052,	"CheckAccessConflict" },
		{ 0x0053,	"LockFile" },
		{ 0x0054,	"UnlockFile" },
		{ 0x0055,	"RemoveLocks" },
		{ 0x0056,	"CheckLocks" },
		{ 0x0057,	"CountLocks" },
		{ 0x0058,	"ReassignLockFileInst" },
		{ 0x0059,	"UnassignLockList" },
		{ 0x005a,	"MountChildVolume" },
		{ 0x005b,	"UnmountChildVolume" },
		{ 0x005c,	"SwapDrives" },
		{ 0x005d,	"FSDMapFHtoIOREQ" },
		{ 0x005e,	"FSDParsePath"	},
		{ 0x005f,	"FSDAttachSFT"	},
		{ 0x0060,	"GetTimeZoneBias" },
		{ 0x0061,	"PNPEvent" },
		{ 0x0062,	"RegisterCFSD"	},
		{ 0x0063,	"Win32MapExtendedHandleToSFT"	},
		{ 0x0064,	"DbgSetFileHandleLimit" },
		{ 0x0065,	"Win32MapSFTToExtendedHandle"	},
		{ 0x0066,	"FSDGetCurrentDrive" },
		{ 0x0067,	"InstallFileSystemApiHook" },
		{ 0x0068,	"RemoveFileSystemApiHook" },
		{ 0x0069,	"RunScheduledEvents" },
		{ 0x006a,	"CheckDelResource" },
		{ 0x006b,	"Win32GetVMCurdir" },
		{ 0x006c,	"SetupFailedConnection" },
		{ 0x006d,	"GetMappedErr"	},
		{ 0x006e,	"ShortToLossyFcb" },
		{ 0x006f,	"GetLockState"	},
		{ 0x0070,	"BcsToBcs" },
		{ 0x0071,	"SetLoopback" },
		{ 0x0072,	"ClearLoopback" },
		{ 0x0073,	"ParseOneElement" },
		{ 0x0074,	"BcsToBcsUpper" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_pci_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Read_Config" },
		{ 0x0002,	"Write_Config"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_perf_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Server_Register" },
		{ 0x0002,	"Server_Deregister"	},
		{ 0x0003,	"Server_Add_Stat" },
		{ 0x0004,	"Server_Remove_Stat" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_mtrr_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"SetPhysicalCacheTypeRange" },
		{ 0x0002,	"IsPatSupported" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_ntkern_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"CreateFile" },
		{ 0x0002,	"Close" },
		{ 0x0003,	"ReadFile" },
		{ 0x0004,	"WriteFile" },
		{ 0x0005,	"DeviceIoControl" },
		{ 0x0006,	"GetWorkerThread" },
		{ 0x0007,	"LoadDriver" },
		{ 0x0008,	"QueueWorkItem" },
		{ 0x0009,	"PhysicalDeviceObjectToDevNode" },
		{ 0x000a,	"SetPhysicalCacheTypeRange" },
		{ 0x000b,	"Win9XLoadDriver" },
		{ 0x000c,	"CancelIoFile"	},
		{ 0x000d,	"GetVPICDHandleFromInterruptObj" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_acpi_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"SetSystemPowerState" },
		{ 0x0002,	"SetTimingMode" },
		{ 0x0003,	"RegisterOpRegionCookedHandler" },
		{ 0x0004,	"Set_RTC"	},
		{ 0x0005,	"GetTimingMode" },
		{ 0x0006,	"GetTaskFile" },
		{ 0x0007,	"WalkNameSpace" },
		{ 0x0008,	"GetObject" },
		{ 0x0009,	"NameSpaceToDevNode" },
		{ 0x000a,	"DevNodeToNameSpace" },
		{ 0x000b,	"RunControlMethod" },
		{ 0x000f,	"EvalPackageElement" },
		{ 0x0010,	"EvalPkgDataElement" },
		{ 0x0011,	"FreeDataBuffs" },
		{ 0x0014,	"GetNameSpaceObject" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_smclib_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"SmartcardCreateLink" },
		{ 0x0002,	"SmartcardDeleteLink" },
		{ 0x0003,	"SmartcardDeviceControl"	},
		{ 0x0004,	"SmartcardExit" },
		{ 0x0005,	"SmartcardInitialize" },
		{ 0x0006,	"SmartcardLogError"	},
		{ 0x0007,	"SmartcardRawReply"	},
		{ 0x0008,	"SmartcardRawRequest" },
		{ 0x0009,	"SmartcardT0Reply" },
		{ 0x000a,	"SmartcardT0Request" },
		{ 0x000b,	"SmartcardT1Reply" },
		{ 0x000c,	"SmartcardT1Request" },
		{ 0x000d,	"SmartcardUpdateCardCapabilities" },
		{ 0x000e,	"SmartcardGetDebugLevel"	},
		{ 0x000f,	"SmartcardSetDebugLevel"	},
		{ 0x0010,	"MapNtStatusToWinError" },
		{ 0x0011,	"Assert" },
		{ 0x0012,	"VxD_CreateDevice" },
		{ 0x0013,	"VxD_DeleteDevice" },
		{ 0x0014,	"SmartcardCompleteCardTracking" },
		{ 0x0015,	"SmartcardCompleteRequest" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vflatd_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Unmap_Flat_Selector" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vjoyd_services[] =	{
		{ 0x0000,	"Register_Device_Driver"	},
		{ 0x0001,	"GetPosEx_Service" },
		{ 0x0002,	"GetInitParams_Service" },
		{ 0x0003,	"Poll_Service"	},
		{ 0x0004,	"Escape_Service" },
		{ 0x0005,	"CtrlMsg_Service" },
		{ 0x0006,	"SetGain_Service" },
		{ 0x0007,	"SendFFCommand_Service" },
		{ 0x0008,	"GetFFState_Service" },
		{ 0x0009,	"DownloadEffect_Service"	},
		{ 0x000a,	"DestroyEffect_Service" },
		{ 0x000b,	"StartEffect_Service" },
		{ 0x000c,	"StopEffect_Service" },
		{ 0x000d,	"GetEffectStatus_Service" },
		{ 0x000e,	"DeviceUpdateNotify_Service" },
		{ 0x000f,	"JoystickActivity_Service" },
		{ 0x0010,	"OpenTypeKey_Service" },
		{ 0x0011,	"OpenConfigKey_Service" },
		{ 0x0012,	"NewGameportDevNode" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_mmdevldr_services[] = {
		{ 0x0000,	"Register_Device_Driver"	},
		{ 0x0001,	"SetDevicePresence"	},
		{ 0x0002,	"SetEnvironmentString" },
		{ 0x0003,	"GetEnvironmentString" },
		{ 0x0004,	"RemoveEnvironmentString" },
		{ 0x0005,	"AddEnvironmentString" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vnetsup_services[]	= {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"GetVars"	},
		{ 0x0002,	"RegisterTerm"	},
		{ 0x0003,	"SetInfo"	},
		{ 0x0004,	"ServerHook" },
		{ 0x0005,	"PassEncrypt" },
		{ 0x0006,	"PassEncryptNT" },
		{ 0x0007,	"PassEncrypt2"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vredir_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"BcnSetWfWVersion" },
		{ 0x0002,	"BcnSetWfWBits" },
		{ 0x0003,	"BcnIncWfWCount" },
		{ 0x0004,	"BcnTriggerPulse" },
		{ 0x0005,	"BcnWfWBrowser" },
		{ 0x0006,	"BcnSetMaster"	},
		{ 0x0007,	"SendMessage" },
		{ 0x0008,	"SetRemoteDebug" },
		{ 0x0009,	"ValidateUser"	},
		{ 0x000a,	"ConnectServer" },
		{ 0x000b,	"DisconnectServer" },
		{ 0x000c,	"RemoteMailSlotWrite" },
		{ 0x000d,	"NetInfo"	},
		{ 0x000e,	"BcnSetHook" },
		{ 0x000f,	"UserGetGroups" },
		{ 0x0010,	"SetIPXError" },
		{ 0x0011,	"NetGetDfsReferrals" },
		{ 0x0012,	"AddPathElement" },
		{ 0x0013,	"MakeResourceDfs" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vshare_services[] = {
		{ 0x0000,	"Get_Version" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vtdi_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Start_Timer" },
		{ 0x0002,	"Stop_Timer" },
		{ 0x0003,	"Schedule_Event" },
		{ 0x0004,	"Cancel_Event"	},
		{ 0x0005,	"Block" },
		{ 0x0006,	"Signal" },
		{ 0x0007,	"Register" },
		{ 0x0008,	"Get_Info" },
		{ 0x0009,	"Unload" },
		{ 0x000a,	"Initialize" },
		{ 0x000b,	"Register_UnloadProc" },
		{ 0x000c,	"Register_LoadProc"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vip_services[] = {
		{ 0x0000,	"VIP_Get_Version" },
		{ 0x0001,	"VIP_Get_Net_Info" },
		{ 0x0002,	"VIP_Register_Protocol" },
		{ 0x0003,	"VIP_Register_Driver" },
		{ 0x0004,	"VIP_Set_Addr"	},
		{ 0x0005,	"VIP_ICMP_Echo" },
		{ 0x0006,	"VIP_Register_Addr_Change" },
		{ 0x0007,	"VIP_Set_DCHP_Interface"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_mstcp_services[] =	{
		{ 0x0000,	"Get_Version" },
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_vcache_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Register" },
		{ 0x0002,	"GetSize"	},
		{ 0x0003,	"CheckAvail" },
		{ 0x0004,	"FindBlock" },
		{ 0x0005,	"FreeBlock" },
		{ 0x0006,	"MakeMRU"	},
		{ 0x0007,	"Hold" },
		{ 0x0008,	"Unhold" },
		{ 0x0009,	"Enum" },
		{ 0x000a,	"TestHandle" },
		{ 0x000b,	"VerifySums" },
		{ 0x000c,	"RecalcSums" },
		{ 0x000d,	"TestHold" },
		{ 0x000e,	"GetStats" },
		{ 0x000f,	"Deregister" },
		{ 0x0010,	"AdjustMinimum" },
		{ 0x0011,	"SwapBuffers" },
		{ 0x0012,	"RelinquishPage" },
		{ 0x0013,	"UseThisPage" },
		{ 0x0014,	"CreateLookupCache"	},
		{ 0x0015,	"CloseLookupCache" },
		{ 0x0016,	"DeleteLookupCache"	},
		{ 0x0017,	"Lookup" },
		{ 0x0018,	"UpdateLookup"	},
		{ -1 }			/* Terminator */
};

vxd_service_desc vxd_pccard_services[] = {
		{ 0x0000,	"Get_Version" },
		{ 0x0001,	"Card_Services" },
		{ 0x0002,	"Access_CIS_Memory"	},
		{ -1 }			/* Terminator */
};
