/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: macroot.h,v 1.2.34.1 2004/07/09 01:58:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MACROOT_H_
#define _MACROOT_H_

#include "baseroot.h"

#ifdef _MAC_MACHO
#include <QuickTime/QuickTime.h>
#else
#include <ImageCompression.h>
#include <Components.h>
#include <ImageCodec.h>
#endif

// xxxbobclark enable this for creating and using YUV
// pixmaps without going through the surface's overlay
// code path. This should allow us to use hardware
// acceleration under Carbon.
//#define USE_LOW_LEVEL_QT_API

class CMacRootSurface : public CBaseRootSurface
{
public:
	friend class CMacSurface;
	friend class CHXMacSite;
	
		CMacRootSurface(IUnknown* pContext, CHXBaseSite* pSite);
	virtual	~CMacRootSurface();
	
    virtual void _GetYUVScratchWidthHeight(UINT32* pWidth, UINT32* pHeight);
    virtual void _CreateYUVScratchSurface(UINT32 width, UINT32 height);
    virtual void _GetYUVScratchSurfacePointer(UCHAR** pYUVBits, INT32* YUVPitch);
    virtual HX_RESULT CreateScratchSurface( int nCompositionSurfaceCID,
                                            HXxSize* pSize);
    virtual HX_RESULT ScratchLock(UCHAR** pBits, INT32* pPitch);
    virtual HX_RESULT ScratchUnlock(UCHAR* pBits);
    virtual void _BltFromScratchToComposition(HXxRect& rDestRect, HXxRect& rSrcRect);
    virtual HX_RESULT _DebugBlt( UCHAR*               pImageData,
                        HXBitmapInfoHeader* pBitmapInfo,
                        REF(HXxRect)         rDestRect,
                        REF(HXxRect)         rSrcRect);
    virtual HX_RESULT _MinimalUnlock(HXxWindow* pWindow);
    virtual HX_RESULT _LockComposition(UCHAR** pBits, INT32* pPitch);
    virtual HX_RESULT _CreateCompositionSurface();
    virtual HX_RESULT _DestroyCompositionSurface();
    virtual void      _MinimalBlt(HXxRect& src, HXxRect& dst);
    virtual void      _PreFlightBlt(HXxRect& dst);
    virtual UINT32    _GetNumberOfMonitors();
    virtual BOOL      _RectOnNthMonitor(HXxRect rect, UINT32 uMonitor, HXxRect& intersectRect);
    

private:
    enum {
	kEightBitDepth = 0,
	kSixteenBitDepth,
	kThirtyTwoBitDepth,
#ifdef USE_LOW_LEVEL_QT_API
	kYUVDepth,
#endif
	kNumberOfDepths
    };
    GWorldPtr m_RootSurfaceGWorld[kNumberOfDepths];
    PixMapHandle m_RootGWorldPixMap[kNumberOfDepths];
    BOOL m_bItsOKToDoAnInterruptBlit;
    CHXSimpleList* m_pVisRgnRects;
    RgnHandle m_LastVisRgn;
    BOOL m_bNeedToForceVisRgnUpdate;
    Point m_LocalToGlobalCoords;
    int m_nBlitDepthEnum;
    BOOL m_bInBlueBox;
    BOOL m_bAllowedToITBInBlueBox;
    
    enum {
	kMaxMonitors = 10
	// XXXbobclark Make the assumption that they won't have more
	// than ten monitors hooked up simultaneously (!)
    };
    static UINT32 zm_uNumberOfAttachedDevices;
    static GDHandle zm_AttachedDevice[kMaxMonitors];
    static CHXSimpleList zm_RootSurfaceList;
    
    struct BDCTextureDRP {
	ByteCount dataSize;
	SInt16 width;
	SInt16 height;
    };
    struct OverlayInfoStruct {
	BOOL b_OverlayExists;
	BOOL b_OverlayInitialized;
	ComponentInstanceRecord* zYUV;
	CodecDecompressParams decompParams;
	ImageSubCodecDecompressRecord drp;
    };
    
    static OverlayInfoStruct zm_OverlayInfo[kMaxMonitors];
    
    void PotentiallyAddRect(CHXSimpleList* theList, Rect originalVisRect, short left, short top, short right, short bottom);
    unsigned long _GetScreenPixelValue(long globX, long globY);
    unsigned long _GetGWorldPixelValue(int whichDepth, long x, long y);
    void InternalReflectRect(Rect theRectToBlit);
    void InternalReflectRectInVisRegion(Rect theRectToBlit);
    void ReflectRectToScreen(Rect theRectToBlit);
    void ReflectRectToFullScreen(Rect theOriginalRectToBlit);
    
    static int	DepthToDepthEnum(short depth);
    
    static pascal void MenuRestoreCallback(Rect* theRectToRestore);
    static pascal void VisRgnChangedCallback(void);
    
    void CheckRectRgn( Rect r, RgnHandle rgn, Point globalOffset );
    void UpdateRegionIfNecessary(Rect boundingRect, Point globalOffset, BOOL bForceItToUpdate = FALSE);
};

#endif
