/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: contextmenu.cpp,v 1.2.2.2 2004/07/13 03:41:44 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "contextmenu.h"

/* right-click context menu */
typedef struct _HXContextMenu
{
    GladeXML* xml;

    GtkWidget* menu;

    GtkWidget* play_menu_item;
    GtkWidget* pause_menu_item;
    GtkWidget* stop_menu_item;

    GtkWidget* zoom_separator;

    GtkWidget* fullscreen_menu_item;
    GtkWidget* zoom_menu_item;
    GtkWidget* normal_size_menu_item;
    GtkWidget* double_size_menu_item;
        
    GtkWidget* show_separator;
    
    GtkWidget* show_menu_and_caption_menu_item;
    GtkWidget* show_controls_menu_item;
    GtkWidget* show_status_bar_menu_item;

    HXMainWindow* main_window;
    HXPlayer* player;

    GtkWidget* main_window_controls;
    GtkWidget* main_window_menu_bar;
    GtkWidget* main_window_status_bar;
    
} HXContextMenu;


static void
hcm_play(HXContextMenu* menu)
{
    hx_player_play(menu->player);
}

static void
hcm_pause(HXContextMenu* menu)
{
    hx_player_pause(menu->player);
}

static void
hcm_stop(HXContextMenu* menu)
{
    hx_player_stop(menu->player);
}

static void
hcm_fullscreen(HXContextMenu* menu)
{
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->fullscreen_menu_item));
        if(active)
        {
            hxwindow_fullscreen(menu->main_window);
        }
        else
        {
            hxwindow_unfullscreen(menu->main_window);
        }
    }
}

static void
hcm_normal_size(HXContextMenu* menu)
{
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->normal_size_menu_item));
        if(active)
        {
            hxwindow_set_zoom(menu->main_window, NORMAL_SIZE);
        }
    }
}

static void
hcm_double_size(HXContextMenu* menu)
{
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->double_size_menu_item));
        if(active)
        {
            hxwindow_set_zoom(menu->main_window, DOUBLE_SIZE);
        }
    }
}

static void
hcm_show_menu_and_caption(HXContextMenu* menu)
{    
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->show_menu_and_caption_menu_item));
        hxwindow_show_menu_and_caption (menu->main_window, active);
    }
}

static void
hcm_show_controls(HXContextMenu* menu)
{
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->show_controls_menu_item));
        hxwindow_show_controls (menu->main_window, active);
    }
}

static void
hcm_show_status_bar(HXContextMenu* menu)
{
    if(menu->main_window)
    {
        gboolean active = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menu->show_status_bar_menu_item));
        hxwindow_show_status_bar (menu->main_window, active);
    }
}

static HXContextMenu*
hx_context_menu_new_common(HXPlayer* player)
{
    gchar* filename;
    HXContextMenu* menu;
    GladeXML* xml;
            
    filename = hxcommon_locate_file("contextmenu.glade");
    g_return_val_if_fail(filename != NULL, NULL);

    xml = glade_xml_new (filename, NULL, NULL);    
    g_free(filename);

    g_return_val_if_fail(xml != NULL, NULL);

    menu = g_new0(HXContextMenu, 1);        
    menu->xml = xml;

    menu->menu                            = glade_xml_get_widget(xml, "hxplayer_context_menu");
    
    menu->play_menu_item                  = glade_xml_get_widget(xml, "hcm_play_menu_item");
    menu->pause_menu_item                 = glade_xml_get_widget(xml, "hcm_pause_menu_item");
    menu->stop_menu_item                  = glade_xml_get_widget(xml, "hcm_stop_menu_item");
    
    menu->zoom_separator                  = glade_xml_get_widget(xml, "hcm_zoom_separator");

    menu->fullscreen_menu_item            = glade_xml_get_widget(xml, "hcm_fullscreen_menu_item");
    menu->zoom_menu_item                  = glade_xml_get_widget(xml, "hcm_zoom_menu_item");
    menu->normal_size_menu_item           = glade_xml_get_widget(xml, "hcm_normal_size_menu_item");
    menu->double_size_menu_item           = glade_xml_get_widget(xml, "hcm_double_size_menu_item");

    menu->show_separator                  = glade_xml_get_widget(xml, "hcm_show_separator");
    
    menu->show_menu_and_caption_menu_item = glade_xml_get_widget(xml, "hcm_show_menu_and_caption_menu_item");
    menu->show_controls_menu_item         = glade_xml_get_widget(xml, "hcm_show_controls_menu_item");
    menu->show_status_bar_menu_item       = glade_xml_get_widget(xml, "hcm_show_status_bar_menu_item");

    menu->player = player;
    g_object_ref(player);

    g_signal_connect_swapped(G_OBJECT(menu->play_menu_item), "activate",
                             G_CALLBACK(hcm_play), menu);

    g_signal_connect_swapped(G_OBJECT(menu->pause_menu_item), "activate",
                             G_CALLBACK(hcm_pause), menu);

    g_signal_connect_swapped(G_OBJECT(menu->stop_menu_item), "activate",
                             G_CALLBACK(hcm_stop), menu);

    return menu;
}

HXContextMenu*
hx_context_menu_new_with_main_window(HXMainWindow* window)
{
    HXContextMenu* menu;
    GtkWidget* player;

    g_return_val_if_fail(window != NULL, NULL);

    player = hxwindow_get_player(window);
    
    menu = hx_context_menu_new_common(HX_PLAYER(player));
    g_return_val_if_fail(menu != NULL, NULL);

    menu->main_window = window;

    GladeXML* xml = hxwindow_get_glade_xml(menu->main_window);
    menu->main_window_controls = glade_xml_get_widget(xml, "hmw_controls_hbox");
    menu->main_window_menu_bar = glade_xml_get_widget(xml, "hmw_menu_bar");
    menu->main_window_status_bar = glade_xml_get_widget(xml, "hmw_status_area");

    g_signal_connect_swapped(G_OBJECT(menu->fullscreen_menu_item), "activate",
                             G_CALLBACK(hcm_fullscreen), menu);

    g_signal_connect_swapped(G_OBJECT(menu->normal_size_menu_item), "activate",
                             G_CALLBACK(hcm_normal_size), menu);

    g_signal_connect_swapped(G_OBJECT(menu->double_size_menu_item), "activate",
                             G_CALLBACK(hcm_double_size), menu);

    g_signal_connect_swapped(G_OBJECT(menu->show_menu_and_caption_menu_item), "activate",
                             G_CALLBACK(hcm_show_menu_and_caption), menu);

    g_signal_connect_swapped(G_OBJECT(menu->show_controls_menu_item), "activate",
                             G_CALLBACK(hcm_show_controls), menu);

    g_signal_connect_swapped(G_OBJECT(menu->show_status_bar_menu_item), "activate",
                             G_CALLBACK(hcm_show_status_bar), menu);

    return menu;
}
    
HXContextMenu*
hx_context_menu_new_with_player(HXPlayer* player)
{
    HXContextMenu* menu;

    g_return_val_if_fail(player != NULL, NULL);

    menu = hx_context_menu_new_common(player);
    g_return_val_if_fail(menu != NULL, NULL);

    /* Hide parts that depend on information from a HXMainWindow */
    gtk_widget_hide(menu->zoom_separator);
    gtk_widget_hide(menu->fullscreen_menu_item);
    gtk_widget_hide(menu->zoom_menu_item);
    gtk_widget_hide(menu->normal_size_menu_item);
    gtk_widget_hide(menu->double_size_menu_item);
    gtk_widget_hide(menu->show_separator);
    gtk_widget_hide(menu->show_menu_and_caption_menu_item);
    gtk_widget_hide(menu->show_controls_menu_item);
    gtk_widget_hide(menu->show_status_bar_menu_item);
    
    return menu;
}

void
hx_context_menu_popup(HXContextMenu* menu, GdkEventButton* event_button)
{
    HXContentStateType state;
    
    /* Disable play/pause/stop as appropriate */
    state = hx_player_get_content_state(HX_PLAYER(menu->player));
    switch(state)
    {
        case HX_CONTENT_STATE_NOT_LOADED:
            gtk_widget_set_sensitive(menu->play_menu_item, FALSE);
            gtk_widget_set_sensitive(menu->stop_menu_item, FALSE);
            gtk_widget_set_sensitive(menu->pause_menu_item, FALSE);
            break;
            
        case HX_CONTENT_STATE_STOPPED:
            gtk_widget_set_sensitive(menu->play_menu_item, TRUE);
            gtk_widget_set_sensitive(menu->stop_menu_item, FALSE);
            gtk_widget_set_sensitive(menu->pause_menu_item, FALSE);
            break;

        case HX_CONTENT_STATE_PAUSED:
            gtk_widget_set_sensitive(menu->play_menu_item, TRUE);
            gtk_widget_set_sensitive(menu->stop_menu_item, TRUE);
            gtk_widget_set_sensitive(menu->pause_menu_item, FALSE);
            break;

        case HX_CONTENT_STATE_CONTACTING:
        case HX_CONTENT_STATE_BUFFERING:
        case HX_CONTENT_STATE_PLAYING:
            gtk_widget_set_sensitive(menu->play_menu_item, FALSE);
            gtk_widget_set_sensitive(menu->stop_menu_item, TRUE);
            gtk_widget_set_sensitive(menu->pause_menu_item, TRUE);
            break;

        default:
            g_assert_not_reached();
    }

    if(menu->main_window)
    {
        gboolean is_fullscreened = hxwindow_is_fullscreened (menu->main_window);
        HXMainWindowZoomSize zoom = hxwindow_get_zoom (menu->main_window);
            
        /* Update zoom */
        switch(zoom)
        {
            case NORMAL_SIZE:
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->normal_size_menu_item), TRUE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->double_size_menu_item), FALSE);
                break;

            case DOUBLE_SIZE:
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->normal_size_menu_item), FALSE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->double_size_menu_item), TRUE);
                break;

            case CUSTOM_SIZE:
            default:
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->normal_size_menu_item), FALSE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->double_size_menu_item), FALSE);
                break;
        }

        
        /* Toggle fullscreen check as appropriate */
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->fullscreen_menu_item),
                                       is_fullscreened);

        /* Hide show/hide controls if in fullscreen, otherwise set them as appropriate. */
        if(is_fullscreened)
        {
            gtk_widget_hide(menu->show_separator);
            gtk_widget_hide(menu->show_menu_and_caption_menu_item);
            gtk_widget_hide(menu->show_controls_menu_item);
            gtk_widget_hide(menu->show_status_bar_menu_item);
        }
        else
        {
            gtk_widget_show(menu->show_separator);
            gtk_widget_show(menu->show_menu_and_caption_menu_item);
            gtk_widget_show(menu->show_controls_menu_item);
            gtk_widget_show(menu->show_status_bar_menu_item);

            /* Enable/disable as appropriate */

            if(menu->main_window_controls)
            {
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->show_controls_menu_item),
                                               GTK_WIDGET_VISIBLE(menu->main_window_controls));
            }

            if(menu->main_window_menu_bar)
            {
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->show_menu_and_caption_menu_item),
                                               GTK_WIDGET_VISIBLE(menu->main_window_menu_bar));
            }

            if(menu->main_window_status_bar)
            {
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu->show_status_bar_menu_item),
                                               GTK_WIDGET_VISIBLE(menu->main_window_status_bar));
            }
        }
    }
                
    gtk_menu_popup (GTK_MENU(menu->menu), NULL, NULL, NULL, NULL, 
                    event_button->button, event_button->time);
}

void
hx_context_menu_destroy(HXContextMenu* menu)
{
    glade_xml_destroy(menu->xml);
    g_object_unref(menu->player);
    g_free(menu);
}

