/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rtffplin.h,v 1.1.2.1 2004/07/09 01:50:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#ifndef _RTFFPLIN_H_
#define _RTFFPLIN_H_

/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//  	CRealTextFileFormat
//
//  Purpose:
//
//  	RealText implementation of a basic file format.
//

class RealTextHeader;
class TextParser; //Added this as base class for parsing.

class CRealTextFileFormat :	public IHXPlugin, 
				public IHXFileFormatObject, 
				public IHXFileResponse,
				public IHXInterruptSafe,
				public RealTextHeader,
				public IHXPendingStatus,
				public TextParser
				, public IHXFileStatResponse
				, public IHXThreadSafeMethods
                                ,public IHXFileMimeMapperResponse
{
private:

    //This object will help keep track of what's going on:
    TextWindow			m_txtWin;

    //This is ptr to the first TextLine in the next packet
    // and can only be assumed to be valid right after :
    TextLine*			m_pCurTextLine;

    //This var keeps track of whether or not the current, ready-to-send
    // packet contains text that was between a <REQUIRED> and a </REQUIRED>,
    // i.e., whether or not the packet needs to be sent with priority 10:
    BOOL m_bCurPacketHasREQUIREDContents;

    //XXXEH- for now, this is not ALL of the unsent data of
    // the last read, just the parsed part (and the residual will be re-
    // read!!- this needs to be changed so file ptr doesn't have to be
    // reset with each GetPacket()'s read:
    //This is the already-parsed but not-yet-sent part from the last
    // ReadDone:
    IHXBuffer*			m_pSavedDataFromLastRead;

    LONG32			m_lRefCount;
    IUnknown*			m_pContext;
    IHXRegistry*		m_pRegistry;
    IHXErrorMessages*		m_pErrorMessages;
    BOOL			m_bRealTextLicensed;
    IHXFileObject*		m_pFileObject;
    IHXFormatResponse*		m_pFFResponse;
    BOOL			m_bHeaderSent;
    ULONG32			m_ulCurrentTime;
    IHXRequest*		m_pRequest;

    IHXFileStat*               m_pFileStatObj; //for getting the file size.

    //This is the amount that should be Read() following
    // a ::Seek() (the Seek() code sets this val and it should only be used
    // following a Seek() ):
    ULONG32			m_ulSizeOfNextReadAfterSeek;

    //This tells us what we've already read and *parsed*
    // so we don't re-parse any data:
    ULONG32			m_ulLastByteParsedInFile;

    //This is where the next SEEK should be done
    //for the next packet:
    ULONG32			m_ulNextPacketSeekPoint;
    //Since header size varies, this helps seek
    ///where to look for the next packet, offset by
    ///HEADER_OFFSET + m_pHeaderSize:
    ULONG32			m_ulHeaderSize;

    //Since packet size varies, this helps seek
    ///where to look for the next packet, offset by
    ///HEADER_OFFSET + m_ulNextPacketSeekPoint:
    ULONG32			m_ulCurPacketSize;

    ULONG32			m_ulSequenceNum;

    //This is the start time of the first text in the last packet that
    // was sent, which is NOT necessarily equal to that packet's time stamp:
    ULONG32			m_ulStartTimeOfTextOfPriorPacket;

    ULONG32			m_ulTotalFileSizeInBytes;

    char*                       m_pszFileMimeType;

    BOOL			m_bIsTextPlainStreamMimeType;

    typedef enum
    {
	Ready, InitPending,
	GetStreamHeaderSeekPending, GetStreamHeaderReadPending, 
	GetPacketSeekPending, GetPacketReadPending,
	SeekSeekPending,
	SeekSeekTooFarFwdPending, GetPacketStillBackedUpSeekPending,
	GetPacketSeekBackReadPending, GetPacketSeekTooFarFwdReadPending
	, GetFileHeaderSeekPending, GetFileHeaderReadPending
    }
    RealTextState;

    RealTextState		m_state;

    typedef enum
    {
	invalid_extension, rtx_extension, txt_extension, html_extension
    }RTSourceFileExtension;

    RTSourceFileExtension	m_RTSourceFileExtension;    

    static const char*		zm_pDescription;
    static const char*		zm_pCopyright;
    static const char*		zm_pMoreInfoURL;

    static const char*		zm_pFileMimeTypes[];
    static const char*		zm_pFileExtensions[];
    static const char*		zm_pFileOpenNames[];

#define RT_OUTPUT_LOGFILE
#if !defined(RT_FF_DEBUG_FLAGS_MASK)
#define RT_FF_DEBUG_FLAGS_MASK	    0xFFFF0000
#endif

#ifdef _DEBUG
#if defined(RT_OUTPUT_LOGFILE)
    FILE* m_logfile;
#endif
#endif

    ~CRealTextFileFormat();

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    void      ReportError(UINT32 ulErrorID, HX_RESULT retVal);
    HX_RESULT GetResourceErrorString(UINT32 ulErrorID, CHXString& rErrorStr);

    HX_RESULT DealWithFileHeader(char*	szLoppedHdr,
	    ULONG32 bufSize);

public:
    CRealTextFileFormat();

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)	 /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IHXFileFormatObject methods ***

    /************************************************************************
     *	Method:
     *	    IHXFileFormatObject::GetFileFormatInfo
     *	Purpose:
     *	    Returns information vital to the instantiation of file format 
     *	    plugins.
     */
    STDMETHOD(GetFileFormatInfo)    
				(THIS_
				REF(const char**) /*OUT*/ pFileMimeTypes,
				REF(const char**) /*OUT*/ pFileExtensions,
				REF(const char**) /*OUT*/ pFileOpenNames);

    /************************************************************************
     *	Method:
     *	    IHXFileFormatObject::InitFileFormat
     *	Purpose:
     *	    Initializes the File Format aspects of the plugin.
     *	    plugins.
     */
    STDMETHOD(InitFileFormat)	
			(THIS_
			IHXRequest*		/*IN*/	pRequest, 
			IHXFormatResponse*	/*IN*/	pFormatResponse,
			IHXFileObject*	/*IN*/  pFileObject);

    STDMETHOD(Close)		(THIS);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetFileHeader
    //  Purpose:
    //  	Called by controller to ask the file format for the number of
    //  	headers in the file. The file format should call the 
    //  	IHXFileFormatSession::StreamCountReady() for the IHXFileFormat-
    //  	Session object that was passed in during initialization, when the
    //  	header count is available.
    //
    STDMETHOD(GetFileHeader)	(THIS);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetStreamHeader
    //  Purpose:
    //  	Called by controller to ask the file format for the header for
    //  	a particular stream in the file. The file format should call 
    //  	IHXFileFormatSession::StreamHeaderReady() for the IHXFileFormatSession
    //  	object that was passed in during initialization, when the header
    //  	is available.
    //
    STDMETHOD(GetStreamHeader)	(THIS_
				UINT16		unStreamNumber);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetPacket
    //  Purpose:
    //  	Called by controller to ask the file format for the next packet
    //  	for a particular stream in the file. The file format should call 
    //  	IHXFileFormatSession::PacketReady() for the IHXFileFormatSession
    //  	object that was passed in during initialization, when the packet
    //  	is available.
    //
    STDMETHOD(GetPacket)	(THIS_
				UINT16		unStreamNumber);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::Seek
    //  Purpose:
    //  	Called by controller to tell the file format to seek to the 
    //  	nearest packet to the requested offset. The file format should 
    //  	call IHXFileFormatSession::SeekDone() for the IHXFileFormat-
    //  	Session object that was passed in during initialization, when 
    //  	the seek has completed.
    //
    STDMETHOD(Seek)		(THIS_
				ULONG32		ulOffset);

    // *** IHXFileResponse methods ***

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //    IHXFileResponse::InitDone
    //  Purpose:
    //    Notification interface provided by users of the IHXFileObject
    //    interface. This method is called by the IHXFileObject when the
    //    initialization of the file is complete, and the Mime type is
    //    available for the request file. If the URL is not valid for the
    //    file system, the status HXR_FAILED should be returned,
    //    with a mime type of NULL. If the URL is valid but the mime type
    //    is unknown, then the status HXR_OK should be returned with
    //    a mime type of NULL.
    //
    STDMETHOD(InitDone)	    (THIS_
			    HX_RESULT	    status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::CloseDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	close of the file is complete.
    //
    STDMETHOD(CloseDone)	(THIS_
				HX_RESULT	status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::ReadDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last read from the file is complete and a buffer is available.
    //
    STDMETHOD(ReadDone)		(THIS_ 
				HX_RESULT	    status,
				IHXBuffer*	    pBuffer);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::WriteDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last write to the file is complete.
    //
    STDMETHOD(WriteDone)	(THIS_ 
				HX_RESULT	    status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::SeekDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last seek in the file is complete.
    //
    STDMETHOD(SeekDone)		(THIS_ 
				HX_RESULT	    status);

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::FileObjectReady
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    requested FileObject is ready. It may return NULL with 
     *	    HX_RESULT_FAIL if the requested filename did not exist in the 
     *	    same pool.
     */
    STDMETHOD(FileObjectReady)		(THIS_
					HX_RESULT status,
					IHXFileObject* pFileObject);

    // IHXPendingStatus methods

    /************************************************************************
     *	Method:
     *	    IHXPendingStatus::GetStatus
     *	Purpose:
     *	    Called by the user to get the current pending status from an object
     */
    STDMETHOD(GetStatus)	(THIS_
				REF(UINT16) uStatusCode, 
				REF(IHXBuffer*) pStatusDesc, 
				REF(UINT16) ulPercentDone);

    // IHXFileStatResponse Methods
    STDMETHOD(StatDone)	    (THIS_ HX_RESULT status, UINT32 ulSize,
	    ULONG32 ulCreationTime, UINT32 ulAccessTime,
	    UINT32 ulModificationTime, UINT32 ulMode);


    void HandleGetSeekBackReadPending(  HX_RESULT	status,
    					IHXBuffer*	pBuffer);
    					
   /*
     *	IHXInterruptSafe methods
     */

    /************************************************************************
     *	Method:
     *	    IHXInterruptSafe::IsInterruptSafe
     *	Purpose:
     *	    This is the function that will be called to determine if
     *	    interrupt time execution is supported.
     */
    STDMETHOD_(BOOL,IsInterruptSafe)	(THIS) 
    					{ return TRUE; };
    /************************************************************************
     *	Method:
     *	    IHXThreadSafeMethods::IsThreadSafe
     */
    STDMETHOD_(UINT32,IsThreadSafe)	(THIS);

    // IHXFileMimeMapperResponse methods
    STDMETHOD(MimeTypeFound) (THIS_ HX_RESULT status, const char* pMimeType);
};


#endif // ndef _RTFFPLIN_H_

