/* $Id: site.h,v 1.9 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.9 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef SITE_H
#define SITE_H

#include "common/Geometry.h"
#include "common/freelist.h"

namespace Voronoi {

struct Site {
	Coord coord;
	int sitenbr;
	int refcnt;
	Site() : sitenbr(-1),refcnt(0) {}
};

struct Sites {
	Freelist<Site> fsites;
	int nvertices;
	Site *getsite();
	void makevertex(Site*);     /* Transform a site into a vertex */
	void deref(Site*);        
	void ref(Site*);            

	Sites(int N) : fsites(ROUND(sqrt((double)N))), nvertices(0) {}

};

} // namespace Voronoi
#endif // SITE_H
