/* $Id: Search.h,v 1.9 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.9 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "graphsearch/Pattern.h"

namespace GSearch {

enum InquiryType {
	UnionInquiry,
	IntersectionInquiry,
	PatternInquiry,
	PathInquiry
};
struct SearchStage {
	InquiryType type;
	Pattern *pattern; // only if PatternInquiry
	StrGraph result;
	bool done;
	SearchStage(StrGraph *parent) : pattern(0),result(parent),done(false)	 {}
	SearchStage(const SearchStage &o) : type(o.type),pattern(o.pattern),result(o.result),done(false) {}
};
// edge names match pattern's start state name(s) or "a" or "b" for PathInquiry
// node names match runSearch input names 
struct NamedStage : Name,SearchStage {
	NamedStage(const NamedStage &o) : Name(o),SearchStage(o) {}
	NamedStage(StrGraph *parent,DString name) : Name(name),SearchStage(parent) {}
};
typedef std::map<DString,StrGraph*> Inputs;
struct Search : LGraph<Nothing,NamedStage,Name> {
	StrGraph &source;
	std::map<DString,Node*> dict;
	Search(const Search &copy) : Graph(copy),source(copy.source) { // don't let them copy dict!
		for(node_iter ni = nodes().begin(); ni!=nodes().end(); ++ni)
			dict[gd<Name>(*ni)] = *ni;
	}
	Search(StrGraph &source);
	void readStrGraph(Patterns &patterns,StrGraph &desc);
	void Run(const Inputs &inputs);

	Node *create_node(DString name) {
		Node *n = Graph::create_node(NamedStage(&source,name));
		dict[name] = n;
		return n;
	}
	void reset() {
		for(node_iter ni = nodes().begin(); ni!=nodes().end(); ++ni) {
			Node *n = *ni;
			SearchStage &stage = gd<SearchStage>(n);
			stage.done = false;
			stage.result.clear();
		}
	}
};
// exceptions
struct StageNotFound : DGException {
  DString name; 
  StageNotFound(DString name) : DGException("search stage not found (impossible!)"),
       name(name) {} 
};
struct PatternNotThere : DGException {
  PatternNotThere() : DGException("search stage is supposed to execute a pattern, but the pattern wasn't specified") {}
};
struct PatternStateNotFound : DGException {
  DString name; 
  PatternStateNotFound(DString name) : DGException("input state of pattern not found"),
       name(name) {} 
};
struct UnknownAction : DGException {
  DString name; UnknownAction(DString name) : DGException("stage's action type not recognized"),
       name(name) {} 
};
struct UndefinedPattern : DGException {
  DString name; 
  UndefinedPattern(DString name) : DGException("pattern not defined"),
       name(name) {} 
};

}
