/*
 *  PGGraphvizFileDocument.m
 *  graphviz
 *
 *  Created by Glen Low on Sat Apr 24 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "PGGraphvizFileDocument.h"
#import "PGFileNotificationCenter.h"

@implementation PGGraphvizFileDocument

- (BOOL) readFromFile: (NSString*) fileName ofType: (NSString*) docType
	{
		[[PGFileNotificationCenter defaultCenter] addObserver: self selector: @selector (pathDidChange:) path: fileName];
		return YES;
	}

- (NSMutableArray*) arguments
	{
		NSMutableArray* arguments = [super arguments];
		[arguments addObject: [self fileName]];
		return arguments;
	}

- (NSString*) currentDirectoryPath
	{
		return [[self fileName] stringByDeletingLastPathComponent];
	}

- (void) windowControllerDidLoadNib: (NSWindowController*) aController
	{
		// as soon as the nib loads, start rendering!
		[super windowControllerDidLoadNib:aController];
		[self queueRender];		
	}

- (void) editWithApplication: (NSString*) application
	{
		[[NSWorkspace sharedWorkspace] openFile: [self fileName] withApplication: application];
	}
		
- (void) pathDidChange: (NSString*) path
	{
		[self queueRender];
	}
	
- (void) dealloc
	{
		[[PGFileNotificationCenter defaultCenter] removeObserver: self path: [self fileName]];
		
		[super dealloc];
	}
		
	
@end
