/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* utils.h
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include "servmgr.h"
#include "servent.h"

#include <glib.h>
#include <glade/glade.h>

#define gdk_color_hex_string(c, s, l) \
	g_snprintf(s, l, "#%02x%02x%02x", c.red >> 8, c.green >> 8, c.blue >> 8)

typedef enum {
	FW_TYPE_UNKNOWN,
	FW_TYPE_ON,
	FW_TYPE_PUSH,
	FW_TYPE_OFF
} FW_TYPE;

void debug_print (gint level, const gchar *fmt, ...);

void make_time_str (gchar *str, size_t len, guint t);
FW_TYPE servent_firewall_type (Servent *s);
Servent *servent_find_by_index (gint index);
void parse_peercast_url (const gchar *url, bool keep);
GladeXML *load_glade_xml (const gchar *file, const gchar *root);

/* malloced */
gchar *get_local_ip (void);
gchar *get_global_ip (void);
gchar *gen_local_url (ChanInfo, gboolean pls);
gchar *gen_global_url (ChanInfo, gboolean pls);
gchar *gen_peercast_url (ChanInfo);

void play_channel_open_url (Channel *ch, gboolean pls);
void play_channel (Channel *);

#endif
