/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gnome-peercast.h
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifndef __GNOME_PEERCAST_H__
#define __GNOME_PEERCAST_H__

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "version2.h"
#include "peercast.h"
#include "channel.h"
#include "logview.h"
#include "channel-list.h"
#include "connection-list.h"

#include "trayicon.h"

#define CONF_PREFIX "/apps/gnome-peercast"
#define CONF_GLOBAL_PREFIX CONF_PREFIX"/global"
#define CONF_NETWORK_PREFIX CONF_PREFIX"/network"
#define CONF_GUI_PREFIX CONF_PREFIX"/gui"

class GnomePeercastApp : public PeercastApplication
{
public:
	GnomePeercastApp (void) { gui = FALSE; timeout_source = 0; ticon = NULL; }
	~GnomePeercastApp (void) {
		if (timeout_source) g_source_remove (timeout_source);
		g_object_unref (G_OBJECT (xml));
		g_object_unref (G_OBJECT (client));
		delete cl;
		delete conlist;
		delete logview;
	}

	virtual const char * APICALL getHTMLPath() { return DATADIR"/gnome-peercast/"; }
	virtual const char * APICALL getIniFilename();
	virtual const char * APICALL getClientTypeOS() { return PCX_OS_LINUX; }
	virtual void APICALL printLog(LogBuffer::TYPE, const char *);

	virtual void APICALL channelStart(ChanInfo *);
	virtual void APICALL delChannel(ChanInfo *);

	void guiInit (void);
	void infoInit (void);
	void gconfInit (void);

	/* GConf functions */
	gchar *getConfigString (const gchar *);
	gint getConfigInt (const gchar *);
	gboolean getConfigBool (const gchar *);
	void setConfigString (const gchar *, gchar *);
	void setConfigInt (const gchar *, gint);
	void setConfigBool (const gchar *, gboolean);

	GtkWidget *getWidget (const gchar *);
	void signalConnect (const gchar *handler,
			    GCallback callback, gpointer data) {
		glade_xml_signal_connect_data (xml, handler, callback, data);
	};

	gboolean hasTrayIcon (void) {
		return (ticon->getCount() > 0) ? TRUE : FALSE;
	};
	
	GtkWidget *window;
	ChannelList *cl;
	ConnectionList *conlist;
	GnomeAppBar *appbar;
	GtkTooltips *tips;

private:
	TrayIcon *ticon;
	gint timeout_source;
	gboolean gui;
	GladeXML *xml;
	LogView *logview;
	GConfClient *client;
};

#endif
