/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 2000
 */

/*
 * 
 */

#ifndef UCVSAPP_H
#define UCVSAPP_H

#include "uwidget.h"
#include "cvsgui_process.h"

class UCvsFolders;
class UCvsFiles;

class UCvsApp : public UWidget
{
	UDECLARE_DYNAMIC(UCvsApp)
public:
	UCvsApp(int argc, char **argv);
	virtual ~UCvsApp();

	static UCvsApp *gApp;
		// a pointer on the pseudo application

	static CvsProcess *gCurCvs;
		// the running process (if any)

	void SayWelcome(void);
		// make the greetings and ask for the CVSROOT if necessary

	void SetCvsRunning(bool state);
	inline bool IsCvsRunning(void) { return gCvsRunning; }
		// when the cvs processus (or thread) is running

	void SetCvsStopping(bool state);
	inline bool IsCvsStopping(void) { return gCvsStopping; }
		// when the cvs processus is stopping (it may take a while)

	UCvsFolders *GetBrowserView(void);
		// get the left pane browser tree

	UCvsFiles *GetFilesView(void);
		// get the right pane file list

	const char *GetAppName(void) const;
	const char *GetAppLibFolder(void) const;
	const char *GetAppVersion(void) const;

	void Execute(int argc, char * const *argv);

	enum
	{
		kProcessTimer = EV_COMMAND_START
	};

protected:
	bool gCvsRunning;
	bool gCvsStopping;

	ev_msg void OnMainTimer(long time);

	UDECLARE_MESSAGE_MAP()
};

#endif
