/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * Authen.cpp --- class to manage CVS authentication kind
 */

#include "stdafx.h"

#include <string.h>
#include "Authen.h"
#include "CvsPrefs.h"
#include "AppConsole.h"

static CPersistentT<AuthenKind> gAuthenKind("P_Authen",
#ifdef macintosh
	rhosts,
#else /* !macintosh */
	local,
#endif /* !macintosh */
	kNoClass);
static CPersistentBool gRsaIdentity("P_RsaIdentity", false, kAddSettings);
static CMString gRsaIdentityFile(10, "P_RsaIdentityFiles");
static PCStr gCurRsaIdentity("P_CurrentRsaIdentity", 0L, kAddSettings);

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

Authen gAuthen;

// authentication class
AuthenKind Authen::kind(void)
{
	return gAuthenKind;
}

bool Authen::RsaIdentity(void) const
{
	return gRsaIdentity;
}

void Authen::setkind(AuthenKind newkind)
{
	gAuthenKind = newkind;
}

const char * Authen::RsaIdentityFile(void) const
{
	return gCurRsaIdentity.empty() ? 0L : (const char *)gCurRsaIdentity;
}

void Authen::SetRsaIdentity(bool newState)
{
	gRsaIdentity = newState;
}

void Authen::SetRsaIdentityFile(const char *newrsaidentityfile) 
{
	gRsaIdentityFile.Insert(newrsaidentityfile);
	gCurRsaIdentity = newrsaidentityfile;
}

CMString & Authen::get_rsaidentity_list()
{
	return gRsaIdentityFile;
}

const char * Authen::kindstr(void)
{
	static CStr res;
	bool canProxy = false;

	switch(kind())
	{
		case pserver : canProxy = true; res = "password authentication"; break;
		case kserver : res = "kerberos authentication"; break;
		case ssh : res = "ssh authentication"; break;
		case local : res = "local mounted directory"; break;
		case ntserver : res = "NT server services"; break;
		default :
		case rhosts : res = ".rhosts authentication"; break;
	}

	if(canProxy && gCvsPrefs.UseProxy())
	{
		res << " using a proxy";
	}

	return res;
}

const char * Authen::token(void)
{
	static CStr res;

	switch(kind())
	{
		case local : return ":local:"; break;
		default :
		case rhosts : return ""; break;
		case kserver : return ":kserver:"; break;
		case ssh : return ":ext:"; break;
		case ntserver : return ":ntserver:"; break;

		case pserver : res = ":pserver"; break;
	}

	if(gCvsPrefs.UseProxy())
	{
		res << ";proxy=";
		res << gCvsPrefs.ProxyHost();
		res << ";proxyport=";
		res << gCvsPrefs.ProxyPort();
	}
	res << ':';
	return res;
}

const char * Authen::skiptoken(const char *cvsroot)
{
	const char *secondColon;
	if(cvsroot[0] != ':' || (secondColon = strchr(cvsroot + 1, ':')) == NULL)
		return cvsroot;
	return secondColon + 1;
}

const char *Authen::kindToToken(AuthenKind k)
{
	switch(k)
	{
	case rhosts:
	default:
		return "rhosts";
	case pserver:
		return "pserver";
	case kserver:
		return "kserver";
	case local:
		return "local";
	case ssh:
		return "ssh";
	case ntserver:
		return "ntserver";
	}
	cvs_err("Unknown authentication kind %d\n", k);
	return "rhosts";
}

AuthenKind Authen::tokenToKind(const char *t)
{
	if(strcmp(t, "rhosts") == 0)
		return rhosts;
	else if(strcmp(t, "pserver") == 0)
		return pserver;
	else if(strcmp(t, "kserver") == 0)
		return kserver;
	else if(strcmp(t, "local") == 0)
		return local;
	else if(strcmp(t, "ssh") == 0)
		return ssh;
	else if(strcmp(t, "ntserver") == 0)
		return ntserver;

	cvs_err("Unknown authentication kind '%s'\n", t);
	return rhosts;
}
