/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.dependency.TextResult;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.util.StringPattern;

public class CheckSetStatement
implements Statement {
    private final StringPattern _set;
    private final SetDefinitionRepository _repository;

    public CheckSetStatement(StringPattern set, SetDefinitionRepository repository) {
        this._set = set;
        this._repository = repository;
    }

    @Override
    public Result execute(AtomicVertex[] graph) {
        int size = 0;
        for (int i = 0; i < graph.length; ++i) {
            if (!this._set.matches(((NameAttributes)graph[i].getAttributes()).getName())) continue;
            ++size;
        }
        StringBuffer buffer = new StringBuffer("Set ");
        buffer.append(this._repository.toString(this._set));
        if (size == 0) {
            buffer.append(" is empty.");
        } else if (size == 1) {
            buffer.append(" has one class.");
        } else {
            buffer.append(" has ").append(size).append(" classes.");
        }
        return new TextResult(new String(buffer.append('\n')), size > 0);
    }

    public String toString() {
        return "check set " + this._repository.toString(this._set);
    }
}

