/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#undef	PACKAGE
#undef	VERSION
#include	"config.h"
#endif
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<signal.h>
#include	<ctype.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"waitlib/waitlib.h"
#include	"authlib/authmod.h"
#include	"authlib/authsasl.h"

extern void pop3dcapa();

static char *authresp(const char *s)
{
char	*p;
char	buf[BUFSIZ];

	printf("+ %s\r\n", s);
	fflush(stdout);

	if (fgets(buf, sizeof(buf), stdin) == 0)	return (0);
	if ((p=strchr(buf, '\n')) == 0)	return (0);
	if (p > buf && p[-1] == '\r')	--p;
	*p=0;

	p=strdup(buf);
	if (!p)
	{
		perror("malloc");
		return (0);
	}
	return (p);
}

int main(int argc, char **argv)
{
char	*user=0;
char	*p;
char	buf[BUFSIZ];
int	c;
const	char *ip=getenv("TCPREMOTEIP");

	if (!ip || !*ip)
	{
		fprintf(stderr, "ERR: No IP address\n");
		fflush(stderr);
		exit(1);
	}

	if (authmoduser(argc, argv, 60, 5))
	{
		fprintf(stderr, "INFO: Connection, ip=[%s]\n", ip);
		printf("+OK Hello there.\r\n");
	}
	else
	{
		fprintf(stderr, "ERR: LOGIN FAILED, ip=[%s]\n", ip);
		printf("-ERR Login failed.\r\n");
	}

	fflush(stdout);
	fflush(stderr);
	while (fgets(buf, sizeof(buf), stdin))
	{
		c=1;
		for (p=buf; *p; p++)
		{
			if (*p == '\n')
				break;

			if (*p == ' ' || *p == '\t')	c=0;
			if (c)
				*p=toupper((int)(unsigned char)*p);
		}

		if (*p)
			*p=0;
		else while ((c=getchar()) != EOF && c != '\n')
			;
		p=strtok(buf, " \t\r");
		if (p)
		{
			if ( strcmp(p, "QUIT") == 0)
			{
				fprintf(stderr, "INFO: Disconnected, ip=[%s]\n",
					ip);
				fflush(stderr);
				printf("+OK Better luck next time.\r\n");
				fflush(stdout);
				break;
			}

			if ( strcmp(p, "USER") == 0)
			{
				p=strtok(0, " \t\r");
				if (p)
				{
					if (user)	free(user);
					if ((user=malloc(strlen(p)+1)) == 0)
					{
						printf("-ERR Server out of memory, aborting connection.\r\n");
						fflush(stdout);
						perror("malloc");
						exit(1);
					}
					strcpy(user, p);
					printf("+OK Password required.\r\n");
					fflush(stdout);
					continue;
				}
			} else if (strcmp(p, "CAPA") == 0)
			{
				pop3dcapa();
				continue;
			} else if (strcmp(p, "AUTH") == 0)
			{
			char *authtype, *authdata;
			char	*method=strtok(0, " \t\r");

				if (method)
				{
				char *initreply=strtok(0, " \t\r");
				int	rc=authsasl(method, initreply,
						authresp, &authtype, &authdata);

					if (rc == 0)
					{
						authmod(argc-1, argv+1,
							"pop3",
							authtype,
							authdata);
					}

					if (rc == AUTHSASL_ABORTED)
					    printf("-ERR Authentication aborted.\r\n");
					else
					    printf("-ERR Authentication failed.\r\n");

					fflush(stdout);
					continue;
				}
			} else if (strcmp(p, "PASS") == 0)
			{
				p=strtok(0, "\t\r");

				if (!user || p == 0)
				{
					printf("-ERR USER/PASS required.\r\n");
					fflush(stdout);
					continue;
				}

				authmod_login(argc-1, argv+1, "pop3", user, p);
			}
		}
		printf("-ERR Invalid command.\r\n");
		fflush(stdout);
	}
	exit(0);
	return (0);
}
