# $Id: courier.spec.in,v 1.72 2002/02/13 01:07:27 mrsam Exp $
#
# Copyright 1998 - 2002 Double Precision, Inc.  See COPYING for
# distribution information.
#
#  Need to version-upgrade RH builds due to different directory locations.
#

%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; echo "$release")

%define __libtoolize /bin/true

Summary: Courier 0.37.3 mail server
Name: courier
Version: 0.37.3
Release: 1%{courier_release}
Copyright: GPL
Group: Applications/Mail
Source: http://download.sourceforge.net/courier/courier-0.37.3.tar.gz
Packager: %{PACKAGER}
BuildRoot: /var/tmp/courier-install
Provides: smtpdaemon
AutoProv: no
Requires: /sbin/chkconfig fileutils
BuildPreReq: rpm >= 4.0.2 fileutils binutils sed perl make openssl gdbm-devel openssl-perl openssl-devel pam-devel gnupg >= 1.0.5 expect

#
#  RH custom locations.
#
#                <7.X               7.x
#  manpages      /usr/man           /usr/share/man
#  httpd         /home/httpd        /var/www
#  initscripts   /etc/rc.d/init.d   /etc/init.d

%{expand:%%define manpagedir %(if test -d %{_prefix}/share/man ; then echo %{_prefix}/share/man ; else echo %{_prefix}/man ; fi)}

%define apachedir %(if test -d /var/www ; then echo /var/www ; else echo /home/httpd ; fi)

%define	_prefix				/usr/lib/courier
%define _localstatedir			/var/spool/courier
%define	_sysconfdir			/etc/courier
%define	_mandir				%{manpagedir}

%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)

# Change the following if your DocumentRoot and cgibindir differ.  This is
# the default redhat build:

%define	_cgibindir			%{apachedir}/cgi-bin
%define _documentrootdir		%{apachedir}/html
%define _imageurl			/webmail

%package sendmail-wrapper
Summary: Courier 0.37.3 soft links for sendmail
Group: Applications/Mail

%package pop3d
Summary: Courier 0.37.3 Integrated POP3 server
Group: Applications/Mail
Requires: courier = 0.37.3 fileutils
Obsoletes: courier-imap courier-imap-ldap courier-imap-mysql courier-imap-pgsql

%package imapd
Summary: Courier 0.37.3 Integrated IMAP server
Group: Applications/Mail
Requires: courier = 0.37.3 fileutils
Obsoletes: courier-imap courier-imap-ldap courier-imap-mysql courier-imap-pgsql

%package webmail
Summary: Courier 0.37.3 Integrated HTTP (webmail) server
Group: Applications/Mail
Requires: courier = 0.37.3 %{_cgibindir} %{_documentrootdir} vixie-cron gnupg >= 1.0.5 expect fileutils
Obsoletes: sqwebmail

%package webadmin
Summary: Courier 0.37.3 web-based administration tool
Group: Applications/Mail
Requires: courier = 0.37.3 %{_cgibindir} %{_documentrootdir}

%package mlm
Summary: Courier 0.37.3 Integrated Mailing List Manager
Group: Applications/Mail
Requires: courier = 0.37.3

%package maildrop
Summary: Courier 0.37.3 Integrated mail filter
Group: Applications/Mail
Requires: courier = 0.37.3

%package maildrop-wrapper
Summary: Courier 0.37.3 soft links for maildrop
Group: Applications/Mail
Requires: courier-maildrop = 0.37.3

%package smtpauth
Summary: Courier 0.37.3 mail server authenticated ESMTP module
Group: Applications/Mail
Requires: courier = 0.37.3 fileutils

%package ldap
Summary: Courier 0.37.3 mail server LDAP authentication module
Group: Applications/Mail
Requires: courier = 0.37.3

%package mysql
Summary: Courier 0.37.3 mail server MySQL authentication module
Group: Applications/Mail
Requires: courier = 0.37.3

%package pgsql
Summary: Courier 0.37.3 mail server PostgreSQL authentication module
Group: Applications/Mail
Requires: courier = 0.37.3

Summary: Courier
%description
The Courier mail transfer agent (MTA) is an integrated mail/groupware
server based on open commodity protocols, such as ESMTP, IMAP, POP3, LDAP,
SSL, and HTTP. Courier provides ESMTP, IMAP, POP3, webmail, and mailing list
services within a single, consistent, framework.  Individual components can
be enabled or disabled at will. Courier now implements basic web-based
calendaring and scheduling services integrated in the webmail module.
Advanced groupware calendaring services will follow soon.

After installing this RPM, additional information regarding configuring
and using courier can be found in %{_defaultdocdir}.

Particularly, README.REDHAT describes where everything is installed, and
install.html contains the regular installation instructions, which includes
configuration information.  In particular, the courier-webadmin package
will contain the web-based configuration tool, webadmin.  After installing
apache and courier-webadmin, and using the webadmin password
in %{_sysconfdir}/webadmin/password (which is initialized to a random string
by default), you will be able to configure Courier using any web browser.

%description sendmail-wrapper
This package contains two soft links from /usr/sbin/sendmail and
/usr/lib/sendmail to %{_bindir}/sendmail.  This allows application
that use sendmail to transparently use Courier for sending mail.

%description pop3d
This package adds POP3 server access to the Courier mail server.
Courier's POP3 server can only be used to access maildir mailboxes.
This server does not support mailbox files.  If you do not need the
ability to download mail with a POP3 client, you do not need to install
this package.

%description imapd
This package adds IMAP server access to the Courier mail server.
Courier's IMAP server can only be used to access maildir mailboxes.
This server does not support mailbox files.  If you do not need the
ability to access mail with an IMAP client, you do not need to install
this package.

This is a different package than the standalone version of the
Courier IMAP server.  You cannot install both this package, and the
standalone version, called "Courier-IMAP".  If you have the standalone
version already installed, installing this package will automatically
remove the standalone version.

%description webmail
This package adds webmail access to the Courier mail server.  Webmail
access is provided via a CGI module that is installed in the apache's
cgi-bin directory.  You must have apache installed.

%description webadmin
This package install the web-based administration tool for the Courier
mail server.  The webadmin tool allows the most common administrative
tasks to be done from any web browser.

After installing this tool, initialize %{_sysconfdir}/webadmin/password
to contain the administrative password.
The default configuration permits non-SSL access only from the same server,
and all external logins must use SSL.  See the installation notes
for information on enabling external non-SSL access.

%description maildrop
This package adds mail filtering abilities to Courier.  Mail filtering
is provided via a customized version of the maildrop mail filter.

You need to install this package if you want the ability to filter
incoming mail.
%description mlm
This package installs couriermlm - a mailing list manager for the
Courier mail server.  If you do not need the ability to manage
mailing lists, you do not need to install this package.

couriermlm is used to set up, maintain, and run a mailing list.
couriermlm automatically processes subscription and unsubscription
requests, and removes undeliverable addresses from the subscription
rolls.  Mailing lists managed by couriermlm require zero human
administrative oversight. couriermlm supports digests, write-only
posting aliases, and moderated mailing lists.

%description maildrop-wrapper
This package installs several soft links from the /usr/local/bin
directory to Courier's integrated maildrop mail filter.  Maildrop is
available as a standalone package, which installs in /usr/local/bin.
If you have applications that expect to find maildrop in /usr/local/bin
you can install this package to create soft links that point to
Courier's integrated maildrop version instead, in order to continue
to use those applications, without needing to reconfigure them.

%description smtpauth
Authenticated ESMTP allows roaming clients to authenticate themselves
and be able to relay outbound mail through the Courier mail server.

Install this package if you need to provide authenticated ESMTP relaying.

%description ldap
This is an add-on package to the Courier mail server, that adds the
ability to authenticate and manage mail accounts using an LDAP-based
directory.

Install this package if you want to be able to manage and authenticate
mail accounts using an LDAP directory.

%description mysql
This is an add-on package to the Courier mail server, that adds the
ability to authenticate and manage mail accounts using a MySQL
database.

Install this package if you want to be able to manage and authenticate
mail accounts using a MySQL database.

%description pgsql
This is an add-on package to the Courier mail server, that adds the
ability to authenticate and manage mail accounts using a PostgreSQL
database.

Install this package if you want to be able to manage and authenticate
mail accounts using a PostgreSQL database.

%prep
%setup -q

%{configure} \
 --localstatedir=%{_localstatedir} \
 --sysconfdir=%{_sysconfdir} \
 --mandir=%{_mandir} \
 --enable-imageurl=%{_imageurl} \
 %{?xflags: %{xflags}}

%{__cat} >README.REDHAT <<EOF

This installation of Courier is configured as follows:

Installation directory:          %{_prefix}
Binary installation directory:   %{_exec_prefix}
Binaries:                        %{_bindir}
Superuser binaries:              %{_sbindir}
Program executables:             %{_libexecdir}
Configuration files:             %{_sysconfdir}
Scripts, other non-binaries:     %{_datadir}
Mail queue, temporary files:     %{_localstatedir}
Manual pages:                    %{_mandir}

EOF

%build
%{__make}
%{__make} check
%install

umask 022
test "$RPM_BUILD_ROOT" != "" && rm -rf $RPM_BUILD_ROOT
%{__mkdir_p} $RPM_BUILD_ROOT%{_prefix}
%{__mkdir_p} $RPM_BUILD_ROOT/etc/pam.d

%{__make} install DESTDIR=$RPM_BUILD_ROOT

%{__ln_s} %{_sysconfdir}/pop3d.authpam $RPM_BUILD_ROOT/etc/pam.d/pop3
%{__ln_s} %{_sysconfdir}/esmtp.authpam $RPM_BUILD_ROOT/etc/pam.d/esmtp
%{__ln_s} %{_sysconfdir}/imapd.authpam $RPM_BUILD_ROOT/etc/pam.d/imap
%{__ln_s} %{_sysconfdir}/webmail.authpam $RPM_BUILD_ROOT/etc/pam.d/webmail

# Create permissions.dat

%{__make} install-perms

#
# We're going to create some more config files later, so let's just make
# sure they're processed as all other Courier config files
#

echo '/etc/pam.d/esmtp 644 root root' >>permissions.dat
echo '/etc/profile.d/courier.sh 755 bin bin config' >>permissions.dat
echo '/etc/profile.d/courier.csh 755 bin bin config' >>permissions.dat
echo '%{initdir}/courier 755 bin bin config' >>permissions.dat

#
#  Translate permissions.dat to spec file format
#

%{__perl} -e '
$buildroot=$ENV{"RPM_BUILD_ROOT"};
$prefix="%{_prefix}";
$exec_prefix="%{_exec_prefix}";

while (<>)
{
	chop if /\n$/;
	($file,$mode,$uid,$gid,$special)=split(/ +/);
	$file=$prefix if $file eq "$prefix/.";

	next if $special eq "doc";
	next if $file eq "$prefix/doc";

	# Ignore dir/. entries

	next if $file =~ /\/\.$/;

	# Ignore man directories

	next if $file eq "%{_mandir}";
	next if substr($file, 0, length("%{_mandir}")) eq "%{_mandir}"
		&& substr($file, length("%{_mandir}")) =~ /^\/man[1-9]$/;

	$mode = "-" if $special eq "%doc";
	$special="%config" if $special eq "config";
	$special="%dir" if ! -l "$buildroot/$file" && -d "$buildroot/$file";

	$file .= "*" if $special eq "man";	# For brp-compress

	$special="" unless $special =~ /%/;

	$special="%attr($mode, $uid, $gid) $special";
	print "$special $file\n";
}

' <permissions.dat >filelist1 || exit 1

############################################################################
#
# Break up a single filelist into multiple packages right here.  This is
# going to be ugly.
#

%{__sed} -n '/imap[\.a-z0-9]*$/p;/imapd-ssl/p' <filelist1 >filelist.imap
%{__sed} -n '/pop3[\.a-z0-9]*$/p;/pop3d-ssl/p' <filelist1 >filelist.pop3
%{__sed} -n '/couriermlm/p' <filelist1 >filelist.mlm
%{__sed} -n '/authstart$/p;/authend$/p' <filelist1 >filelist.auth
%{__sed} -n '/maildrop[^/]*$/p;/mailbot/p;/reformail[^/]*$/p' <filelist1 >filelist.maildrop

%{__sed} -n '/15ldap/p;/authdaemond.ldap/p;/courierldapalias/p' <filelist1 >filelist.ldap

if test -d /etc/openldap
then
	%{__mkdir_p} $RPM_BUILD_ROOT/etc/openldap/schema
	cp authlib/authldap.schema $RPM_BUILD_ROOT/etc/openldap/schema/courier.schema
	echo '%attr(644, root, root) %config(noreplace) /etc/openldap/schema/courier.schema' >>filelist.ldap
fi

%{__sed} -n '/15mysql/p;/authdaemond.mysql/p' <filelist1 >filelist.mysql

%{__sed} -n '/15pgsql/p;/authdaemond.pgsql/p' <filelist1 >filelist.pgsql

# Delete all of the above, AND ldapaddressbook+webmail from the filelist.

%{__sed} '/imap[\.a-z0-9]*$/d;/imapd-ssl/d;/pop3[\.a-z0-9]*$/d;/pop3d-ssl/d;/couriermlm/d;/webmail/d;/authsystem\.passwd/d;/authlib\/changepwd/d;/ldapaddressbook.dist$/d;/pcpd/d;/calendar/d;/maildrop[^/]*$/d;/mailbot/d;/reformail[^/]*$/d;/authstart$/d;/authend$/d;/15ldap/d;/47webmail/d;/authdaemond.ldap/d;/courierldapalias/d;/15mysql/d;/15pgsql/d;/authdaemond.mysql/d;/authdaemond.pgsql/d' <filelist1 >filelist

# authsystem.passwd goes into webmail, but it's picked up by
# authlib/changepwd too, hence we sort.

%{__sed} -n '/47webmail/p;/sqwebmail/p;/authsystem\.passwd/p;/authlib\/changepwd/p;/webmail.authpam/p;/webmail-logincache/p;/ldapaddressbook.dist$/p;/pcpd/p;/calendar/p' <filelist1 | sed '/images/d' | sort | uniq >filelist.webmail

# Note that we delete all 'webmail's, but extract only 'sqwebmail's.
# This removes all webmail-related stuff from the main filelist,
# and adds everything except the executable, webmail, to filelist.webmail.
# Here's why, we move the webmail binary directly into the cgibindir.

%{__mkdir_p} $RPM_BUILD_ROOT%{_cgibindir}
%{__cp} $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail/webmail \
	$RPM_BUILD_ROOT%{_cgibindir}/webmail
%{__cp} $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail/webadmin \
	$RPM_BUILD_ROOT%{_cgibindir}/webadmin

# Remove the webadmin wrapper from filelist (but keep all html and pl files
# there.

%{__sed} '/courier\/webmail\/webadmin /d' <filelist >filelist.tmp
%{__mv} filelist.tmp filelist

# For the same reason we delete all images from filelist.webmail:

%{__mkdir_p} $RPM_BUILD_ROOT%{_documentrootdir}
%{__mv} $RPM_BUILD_ROOT%{_datadir}/sqwebmail/images $RPM_BUILD_ROOT%{_documentrootdir}/webmail

# Do we need to install a cron job to clean out webmail's cache?

if test -f webmail/cron.cmd
then
	%{__mkdir_p} $RPM_BUILD_ROOT/etc/cron.hourly
	%{__cat} >$RPM_BUILD_ROOT/etc/cron.hourly/courier-webmail-cleancache <<EOF
#!/bin/sh

su - bin -s /bin/sh -c %{_datadir}/sqwebmail/cleancache.pl
EOF

	echo "%attr(555, root, bin) /etc/cron.hourly/courier-webmail-cleancache" >>filelist.webmail
fi

#
# Move .html documentation back to build dir, so that RPM will move it to
# the appropriate docdir
#

%{__rm} -rf htmldoc
%{__mkdir} htmldoc
%{__chmod} 755 htmldoc
%{__cp} $RPM_BUILD_ROOT%{_datadir}/htmldoc/* htmldoc
%{__chmod} a-wx htmldoc/*

#
# Update /etc/skel

%{__mkdir_p} $RPM_BUILD_ROOT/etc/skel
maildir/maildirmake $RPM_BUILD_ROOT/etc/skel/Maildir

############################################################################
#
# Some configuration file tweaking.
#
# Manually set POP3DSTART and IMAPDSTART to yes, they'll go into a separate
# package, so after it's installed they should be runnable.

%{__sed} 's/^POP3DSTART.*/POP3DSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist >$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.new $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist

%{__sed} 's/^POP3DSSLSTART.*/POP3DSSLSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist >$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.new $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

%{__sed} 's/^IMAPDSTART.*/IMAPDSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist >$RPM_BUILD_ROOT%{_sysconfdir}/imapd.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.new $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist

%{__sed} 's/^IMAPDSSLSTART.*/IMAPDSSLSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist >$RPM_BUILD_ROOT%{_sysconfdir}/imapd.new-ssl
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.new-ssl $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

# Convenient init file.

%{__mkdir_p} $RPM_BUILD_ROOT%{initdir}

%{__cp} courier.sysvinit $RPM_BUILD_ROOT%{initdir}/courier

#
# Make up some /etc/profile.d scripts
#

%{__mkdir_p} $RPM_BUILD_ROOT/etc/profile.d
%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier.sh <<EOF
case :\${PATH}: in
	*:%{_bindir}:*)
		;;
	*)
		if test -w /etc
		then
			PATH="%{_sbindir}:\$PATH"
		fi
		PATH="%{_bindir}:\$PATH"
		export PATH
		;;
esac
EOF

%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier.csh <<EOF
switch (:\${PATH}:)
	case *:%{_bindir}:*:
		breaksw
	default:
		test -w /etc
		if ( \$? == 0 ) then
			setenv PATH "%{_sbindir}:\$PATH"
		endif
		setenv PATH "%{_bindir}:\$PATH"
		breaksw
endsw
EOF

#
# Create sendmail soft links manually.
#

%{__mkdir_p} $RPM_BUILD_ROOT/usr/sbin
%{__mkdir_p} $RPM_BUILD_ROOT/usr/lib
%{__mkdir_p} $RPM_BUILD_ROOT/usr/bin

%{__ln_s} %{_bindir}/sendmail $RPM_BUILD_ROOT/usr/sbin/sendmail
%{__ln_s} %{_bindir}/sendmail $RPM_BUILD_ROOT/usr/lib/sendmail
%{__ln_s} %{_bindir}/sendmail $RPM_BUILD_ROOT/usr/bin/sendmail

#
# maildrop wrapper soft links (value added for the RPM)
#

%{__mkdir_p} $RPM_BUILD_ROOT/usr/local/bin

for f in dotlock maildirmake maildrop makedat reformail reformime mimegpg deliverquota
do
	%{__ln_s} %{_bindir}/$f $RPM_BUILD_ROOT/usr/local/bin/$f
done

for f in makeuserdb pw2userdb userdb userdbpw vchkpw2userdb
do
	%{__ln_s} %{_sbindir}/$f $RPM_BUILD_ROOT/usr/local/bin/$f
done

#
# The following directories are not created by default, but I want them here.
#

%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/userdb

. courier/uidgid || exit 1

echo "%attr(700, $mailuser, $mailgroup) %dir %{_sysconfdir}/userdb" >>filelist

#####################
##
## sysconftool support.  Instead of doing make install-configure, grab all
## the %config .dists from the filelists, and arrange to run sysconftool in
## the postinstallation scripts.  This is done by saving the .dists into
## a file that's included in the installation package.  sysconftool is also
## added to the installation package, and we run the whole thing from
## %post-s.

for f in filelist filelist.pop3 filelist.imap filelist.webmail
do
	ff=`echo $f | %{__sed} 's/filelist/configlist/'`

	%{__perl} -e '
		while (<>)
		{
			chop;
			next unless /\%config.* (.*\.dist)$/;
			print "$1\n";
		} ' < $f >$RPM_BUILD_ROOT/%{_datadir}/$ff
done

%{__cp} sysconftool $RPM_BUILD_ROOT%{_datadir}/sysconftool

######
##
## Ok, upgrades are going to get ugly.  Because we install $filename.dist
## instead of $filename, and the old package has $filename listed as a config,
## RPM will back up $filename to $filename.rpmsave.  This will happen AFTER
## we will run the post scripts, effectively blowing away our configurations.
## PUT THEM BACK BY RUNNING THE FOLLOWING SCRIPT FROM A TRIGGER.

%{__cat} >$RPM_BUILD_ROOT%{_datadir}/sysconftool-rpmupgrade <<EOF
#!/bin/sh

for f in \$* "."
do
	if test \$f = "."
	then
		continue
	fi

	base=\`echo \$f | sed 's/\\.dist\$//'\`
	if test -f \$base.dist -a ! -f \$base
	then
		%{__cp} -pr \$base.dist \$base
	fi
done
EOF

%post
/sbin/chkconfig --del courier
/sbin/chkconfig --add courier
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist` >/dev/null

%preun
%{_sbindir}/esmtpd stop
%{_sbindir}/esmtpd-msa stop
%{initdir}/courier stop >/dev/null

if test -x %{_libexecdir}/authlib/authdaemond
then
        %{_libexecdir}/authlib/authdaemond stop >/dev/null 2>&1 || /bin/true
fi

if test "$1" = "0"
then
        /sbin/chkconfig --del courier
fi

%preun ldap
if test -x %{_sbindir}/courierldapaliasd
then
	%{_sbindir}/courierldapaliasd stop >/dev/null 2>&1 || /bin/true
fi
if test -x %{_libexecdir}/authlib/authdaemond.ldap
then
        %{_libexecdir}/authlib/authdaemond.ldap stop >/dev/null 2>&1 || /bin/true
fi

%preun mysql
if test -x %{_libexecdir}/authlib/authdaemond.mysql
then
        %{_libexecdir}/authlib/authdaemond.mysql stop >/dev/null 2>&1 || /bin/true
fi

%preun pgsql
if test -x %{_libexecdir}/authlib/authdaemond.pgsql
then
        %{_libexecdir}/authlib/authdaemond.pgsql stop >/dev/null 2>&1 || /bin/true
fi

%post imapd
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.imap` >/dev/null

%preun imapd
%{_sbindir}/imapd stop
%{_sbindir}/imapd-ssl stop

%post pop3d
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.pop3` >/dev/null

%preun pop3d
%{_sbindir}/pop3d stop
%{_sbindir}/pop3d-ssl stop

%post smtpauth
%{_sbindir}/esmtpd stop
test -f %{_sbindir}/esmtpd-msa && %{_sbindir}/esmtpd-msa stop

. %{_sysconfdir}/esmtpd

if test "$ESMTPDSTART" = "YES"
then
     %{_sbindir}/esmtpd start
fi

if test -f %{_sysconfdir}/esmtpd-msa
then
	. %{_sysconfdir}/esmtpd-msa

	if test "$ESMTPDSTART" = "YES"
	then
	     %{_sbindir}/esmtpd-msa start
	fi
fi

%postun smtpauth
if test "$1" = "0"
then
	%{_sbindir}/esmtpd stop
	test -f %{_sbindir}/esmtpd-msa && %{_sbindir}/esmtpd-msa stop
fi

%preun webmail
test ! -x %{_libexecdir}/courier/pcpd || %{_libexecdir}/courier/pcpd stop

%post webmail
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.webmail` >/dev/null

%post webadmin
if test ! -f %{_sysconfdir}/webadmin/password
then
	dd if=/dev/urandom 2>/dev/null | tr -d -c '[A-Za-z0-9]' | dd bs=16 count=1 2>/dev/null >%{_sysconfdir}/webadmin/password
	chmod 400 %{_sysconfdir}/webadmin/password
	chown --reference=%{_sysconfdir}/webadmin %{_sysconfdir}/webadmin/password
fi

%triggerpostun -- courier < 0.35
test -x %{_sbindir}/makeuserdb && %{_sbindir}/makeuserdb

%triggerpostun -- courier
test ! -f %{_datadir}/configlist || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist` >/dev/null

%triggerpostun imapd -- courier-imapd
test ! -f %{_datadir}/configlist.imap || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist.imap` >/dev/null

%triggerpostun pop3d -- courier-pop3d
test ! -f %{_datadir}/configlist.pop3 || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist.pop3` >/dev/null

%triggerpostun webmail -- courier-webmail
test ! -f %{_datadir}/configlist.webmail || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist.webmail` >/dev/null

%files -f filelist

%attr(555, bin, bin) %doc README.REDHAT AUTHORS COPYING
%attr(-, bin, bin) %doc htmldoc/*
%attr(555, bin, bin) %{_datadir}/sysconftool
%attr(555, bin, bin) %{_datadir}/sysconftool-rpmupgrade
%attr(444, bin, bin) %{_datadir}/configlist

%attr(-, root, root) /etc/skel/Maildir

%files sendmail-wrapper
%attr(-, bin, bin) /usr/sbin/sendmail
%attr(-, bin, bin) /usr/bin/sendmail
%attr(-, bin, bin) /usr/lib/sendmail

%files maildrop-wrapper

%attr(-, bin, bin) /usr/local/bin/*

%files pop3d -f filelist.pop3
%attr(644, root, bin) /etc/pam.d/pop3
%attr(444, bin, bin) %{_datadir}/configlist.pop3

%files imapd -f filelist.imap
%attr(644, root, bin) /etc/pam.d/imap
%attr(444, bin, bin) %{_datadir}/configlist.imap

%files webmail -f filelist.webmail
%attr(4511, root, bin) %{_cgibindir}/webmail
%attr(644, root, bin) /etc/pam.d/webmail
%attr(755, bin, bin) %dir %{_documentrootdir}/webmail
%attr(444, bin, bin) %{_documentrootdir}/webmail/*
%attr(444, bin, bin) %{_datadir}/configlist.webmail

%files webadmin
%attr(4511, root, bin) %{_cgibindir}/webadmin

%files maildrop -f filelist.maildrop

%files mlm -f filelist.mlm

%files smtpauth -f filelist.auth

%files ldap -f filelist.ldap

%files mysql -f filelist.mysql

%files pgsql -f filelist.pgsql

%clean
%{__rm} -rf $RPM_BUILD_ROOT
